/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Chmod {
    private static final boolean CHMOD_API_AVAILABLE;
    private static final Method setWritable;
    private static final Method setReadable;
    private static final Method setExecutable;
    private static final Method canExecute;

    public static boolean chmod(File file, String mode) {
        if (CHMOD_API_AVAILABLE) {
            char other = mode.charAt(mode.length() - 1);
            char group = mode.charAt(mode.length() - 2);
            char user = mode.charAt(mode.length() - 3);
            char setuidgid = mode.charAt(mode.length() - 3);
            if (!Chmod.setPermissions(file, other, false)) {
                return false;
            }
            if (!Chmod.setPermissions(file, user, true)) {
                return false;
            }
        } else {
            try {
                Process chmod = Runtime.getRuntime().exec("/bin/chmod " + mode + " " + file.getAbsolutePath());
                chmod.waitFor();
                return chmod.exitValue() == 0;
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean setPermissions(File file, char permChar, boolean userOnly) {
        int permValue = Character.digit(permChar, 8);
        try {
            if ((permValue & 1) != 0) {
                setExecutable.invoke((Object)file, Boolean.TRUE, userOnly);
            } else {
                setExecutable.invoke((Object)file, Boolean.FALSE, userOnly);
            }
            if ((permValue & 2) != 0) {
                setWritable.invoke((Object)file, Boolean.TRUE, userOnly);
            } else {
                setWritable.invoke((Object)file, Boolean.FALSE, userOnly);
            }
            if ((permValue & 4) != 0) {
                setReadable.invoke((Object)file, Boolean.TRUE, userOnly);
            } else {
                setReadable.invoke((Object)file, Boolean.FALSE, userOnly);
            }
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    static {
        boolean apiAvailable = false;
        Method setWritableVar = null;
        Method setReadableVar = null;
        Method setExecutableVar = null;
        Method canExecuteVar = null;
        try {
            setWritableVar = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            setReadableVar = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            setExecutableVar = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            canExecuteVar = File.class.getMethod("canExecute", new Class[0]);
            apiAvailable = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        setWritable = setWritableVar;
        setReadable = setReadableVar;
        setExecutable = setExecutableVar;
        canExecute = canExecuteVar;
        CHMOD_API_AVAILABLE = apiAvailable;
    }
}

