/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class Frame {
    private RubyModule klazz;
    private IRubyObject self;
    private String name;
    private IRubyObject[] args;
    private int requiredArgCount;
    private final Block block;
    private boolean isBindingFrame = false;
    private Visibility visibility = Visibility.PUBLIC;
    private Object jumpTarget;
    private final ISourcePosition position;

    public Object getJumpTarget() {
        return this.jumpTarget;
    }

    public void setJumpTarget(Object jumpTarget) {
        this.jumpTarget = jumpTarget;
    }

    public Frame(ISourcePosition position) {
        this(null, null, null, IRubyObject.NULL_ARRAY, 0, Block.NULL_BLOCK, position, null);
    }

    public Frame(RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, int requiredArgCount, Block block, ISourcePosition position, Object jumpTarget) {
        assert (block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = self;
        this.args = args;
        this.requiredArgCount = requiredArgCount;
        this.name = name;
        this.klazz = klazz;
        this.position = position;
        this.block = block;
        this.jumpTarget = jumpTarget;
    }

    IRubyObject[] getArgs() {
        return this.args;
    }

    void setArgs(IRubyObject[] args) {
        this.args = args;
    }

    public int getRequiredArgCount() {
        return this.requiredArgCount;
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public RubyModule getKlazz() {
        return this.klazz;
    }

    public void setKlazz(RubyModule klazz) {
        this.klazz = klazz;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    IRubyObject getSelf() {
        return this.self;
    }

    void setSelf(IRubyObject self) {
        this.self = self;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isBindingFrame() {
        return this.isBindingFrame;
    }

    public void setIsBindingFrame(boolean isBindingFrame) {
        this.isBindingFrame = isBindingFrame;
    }

    public Block getBlock() {
        return this.block;
    }

    public Frame duplicate() {
        IRubyObject[] newArgs;
        if (this.args.length != 0) {
            newArgs = new IRubyObject[this.args.length];
            System.arraycopy(this.args, 0, newArgs, 0, this.args.length);
        } else {
            newArgs = this.args;
        }
        return new Frame(this.klazz, this.self, this.name, newArgs, this.requiredArgCount, this.block, this.position, this.jumpTarget);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.position != null ? this.position.toString() : "-1");
        sb.append(':');
        sb.append(this.klazz + " " + this.name);
        if (this.name != null) {
            sb.append("in ");
            sb.append(this.name);
        }
        return sb.toString();
    }
}

