/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.executable.ISeqPosition;
import org.jruby.ast.executable.YARVMachine;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class YARVMethod
extends DynamicMethod {
    private SinglyLinkedList cref;
    private YARVMachine.InstructionSequence iseq;
    private StaticScope staticScope;
    private Arity arity;

    public YARVMethod(RubyModule implementationClass, YARVMachine.InstructionSequence iseq, StaticScope staticScope, Visibility visibility, SinglyLinkedList cref) {
        super(implementationClass, visibility);
        boolean req;
        this.staticScope = staticScope;
        this.iseq = iseq;
        this.cref = cref;
        boolean opts = iseq.args_arg_opts > 0 || iseq.args_rest > 0;
        boolean bl = req = iseq.args_argc > 0;
        this.arity = !req && !opts ? Arity.noArguments() : (req && !opts ? Arity.fixed(iseq.args_argc) : (opts && !req ? Arity.optional() : Arity.required(iseq.args_argc)));
    }

    @Override
    public void preMethod(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preDefMethodInternalCall(clazz, name, self, args, this.arity.required(), block, noSuper, this.cref, this.staticScope, this);
    }

    @Override
    public void postMethod(ThreadContext context) {
        context.postDefMethodInternalCall();
    }

    @Override
    public IRubyObject internalCall(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        assert (args != null);
        Ruby runtime = context.getRuntime();
        try {
            this.prepareArguments(context, runtime, args);
            this.getArity().checkArity(runtime, args);
            if (runtime.hasEventHooks()) {
                this.traceCall(context, runtime, name);
            }
            DynamicScope sc = new DynamicScope(this.staticScope);
            for (int i = 0; i < args.length; ++i) {
                sc.setValue(i, args[i], 0);
            }
            IRubyObject iRubyObject = YARVMachine.INSTANCE.exec(context, self, sc, this.iseq.body);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump && je.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)je.getValue();
                return iRubyObject;
            }
            throw je;
        }
        finally {
            if (runtime.hasEventHooks()) {
                this.traceReturn(context, runtime, name);
            }
        }
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        boolean hasOptArgs;
        context.setPosition(new ISeqPosition(this.iseq));
        int expectedArgsCount = this.iseq.args_argc;
        int restArg = this.iseq.args_rest;
        boolean bl = hasOptArgs = this.iseq.args_arg_opts > 0;
        if (expectedArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + expectedArgsCount + ")");
        }
        if (hasOptArgs || restArg != -1) {
            args = this.prepareOptOrRestArgs(context, runtime, args, expectedArgsCount, restArg, hasOptArgs);
        }
        context.setFrameArgs(args);
    }

    private IRubyObject[] prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject[] args, int expectedArgsCount, int restArg, boolean hasOptArgs) {
        int i;
        int opt;
        if (restArg == 0 && hasOptArgs && (opt = expectedArgsCount + this.iseq.args_arg_opts) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + opt + ")");
        }
        int count = expectedArgsCount + this.iseq.args_arg_opts + this.iseq.args_rest;
        ArrayList<IRubyObject> allArgs = new ArrayList<IRubyObject>();
        for (i = 0; i < count && i < args.length; ++i) {
            allArgs.add(args[i]);
        }
        if (restArg != 0) {
            for (i = expectedArgsCount; i < args.length; ++i) {
                allArgs.add(args[i]);
            }
            if (restArg >= 0) {
                RubyArray array = runtime.newArray(args.length - expectedArgsCount);
                for (int i2 = expectedArgsCount; i2 < args.length; ++i2) {
                    array.append(args[i2]);
                }
                context.getCurrentScope().setValue(restArg, array, 0);
            }
        }
        args = allArgs.toArray(new IRubyObject[allArgs.size()]);
        return args;
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callEventHooks(context, 4, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        ISourcePosition position = context.getPosition();
        runtime.callEventHooks(context, 3, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    @Override
    public DynamicMethod dup() {
        return new YARVMethod(this.getImplementationClass(), this.iseq, this.staticScope, this.getVisibility(), this.cref);
    }
}

