/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerNio;

public class RubyBasicSocket
extends RubyIO {
    private static ObjectAllocator BASICSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyBasicSocket(runtime, klass);
        }
    };
    protected Channel socketChannel;

    static void createBasicSocket(Ruby runtime) {
        RubyClass rb_cBasicSocket = runtime.defineClass("BasicSocket", runtime.getClass("IO"), BASICSOCKET_ALLOCATOR);
        CallbackFactory cfact = runtime.callbackFactory(RubyBasicSocket.class);
        rb_cBasicSocket.defineFastMethod("send", cfact.getFastOptMethod("write_send"));
        rb_cBasicSocket.defineFastMethod("recv", cfact.getFastOptMethod("recv"));
        rb_cBasicSocket.defineFastMethod("shutdown", cfact.getFastOptMethod("shutdown"));
        rb_cBasicSocket.defineFastMethod("__getsockname", cfact.getFastMethod("getsockname"));
        rb_cBasicSocket.defineFastMethod("__getpeername", cfact.getFastMethod("getpeername"));
        rb_cBasicSocket.defineFastMethod("getsockname", cfact.getFastMethod("getsockname"));
        rb_cBasicSocket.defineFastMethod("getpeername", cfact.getFastMethod("getpeername"));
        rb_cBasicSocket.getMetaClass().defineFastMethod("do_not_reverse_lookup", cfact.getFastSingletonMethod("do_not_reverse_lookup"));
        rb_cBasicSocket.getMetaClass().defineFastMethod("do_not_reverse_lookup=", cfact.getFastSingletonMethod("set_do_not_reverse_lookup", IRubyObject.class));
    }

    public RubyBasicSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    protected void setChannel(Channel c) {
        this.socketChannel = c;
        try {
            this.handler = new IOHandlerNio(this.getRuntime(), this.socketChannel);
            this.handler.setIsSync(true);
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        this.registerIOHandler(this.handler);
        this.modes = this.handler.getModes();
    }

    public IRubyObject close_write() {
        try {
            ((SocketChannel)this.socketChannel).socket().shutdownOutput();
            this.handler.closeWrite();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject write_send(IRubyObject[] args) {
        return this.syswrite(args[0]);
    }

    public IRubyObject recv(IRubyObject[] args) {
        try {
            return RubyString.newString(this.getRuntime(), ((IOHandlerNio)this.handler).recv(RubyNumeric.fix2int(args[0])));
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            if ("Socket not open".equals(e.getMessage())) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
    }

    protected InetSocketAddress getLocalSocket() {
        if (this.socketChannel instanceof SocketChannel) {
            return (InetSocketAddress)((SocketChannel)this.socketChannel).socket().getLocalSocketAddress();
        }
        if (this.socketChannel instanceof ServerSocketChannel) {
            return (InetSocketAddress)((ServerSocketChannel)this.socketChannel).socket().getLocalSocketAddress();
        }
        return null;
    }

    protected InetSocketAddress getRemoteSocket() {
        if (this.socketChannel instanceof SocketChannel) {
            return (InetSocketAddress)((SocketChannel)this.socketChannel).socket().getRemoteSocketAddress();
        }
        return null;
    }

    public IRubyObject getsockname() {
        InetSocketAddress sock = this.getLocalSocket();
        if (null == sock) {
            throw this.getRuntime().newIOError("Not Supported");
        }
        return this.getRuntime().newString(((Object)sock).toString());
    }

    public IRubyObject getpeername() {
        InetSocketAddress sock = this.getRemoteSocket();
        if (null == sock) {
            throw this.getRuntime().newIOError("Not Supported");
        }
        return this.getRuntime().newString(((Object)sock).toString());
    }

    public IRubyObject shutdown(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && this.tainted().isFalse()) {
            throw this.getRuntime().newSecurityError("Insecure: can't shutdown socket");
        }
        int how = 2;
        if (args.length > 0) {
            how = RubyNumeric.fix2int(args[0]);
        }
        if (how < 0 || 2 < how) {
            throw this.getRuntime().newArgumentError("`how' should be either 0, 1, 2");
        }
        if (how != 2) {
            throw this.getRuntime().newNotImplementedError("Shutdown currently only works with how=2");
        }
        return this.close();
    }

    public static IRubyObject do_not_reverse_lookup(IRubyObject recv) {
        return recv.getRuntime().isDoNotReverseLookupEnabled() ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static IRubyObject set_do_not_reverse_lookup(IRubyObject recv, IRubyObject flag) {
        recv.getRuntime().setDoNotReverseLookupEnabled(flag.isTrue());
        return recv.getRuntime().isDoNotReverseLookupEnabled() ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }
}

