/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.demo.TextAreaReadline;
import org.jruby.internal.runtime.ValueAccessor;

public class IRBConsole
extends JFrame {
    private static final long serialVersionUID = 3746242973444417387L;

    public IRBConsole(String title) {
        super(title);
    }

    public static void main(final String[] args) {
        final IRBConsole console = new IRBConsole("JRuby IRB Console");
        final PipedInputStream pipeIn = new PipedInputStream();
        console.getContentPane().setLayout(new BorderLayout());
        console.setSize(700, 600);
        JTextPane text = new JTextPane();
        text.setMargin(new Insets(8, 8, 8, 8));
        text.setCaretColor(new Color(164, 0, 0));
        text.setBackground(new Color(242, 242, 242));
        text.setForeground(new Color(164, 0, 0));
        Font font = console.findFont("Monospaced", 0, 14, new String[]{"Monaco", "Andale Mono"});
        text.setFont(font);
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(text);
        pane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        console.getContentPane().add(pane);
        console.validate();
        final TextAreaReadline tar = new TextAreaReadline(text, " Welcome to the JRuby IRB Console \n\n");
        RubyInstanceConfig config = new RubyInstanceConfig(){
            {
                this.setInput(pipeIn);
                this.setOutput(new PrintStream(tar));
                this.setError(new PrintStream(tar));
                this.setObjectSpaceEnabled(false);
                this.setArgv(args);
            }
        };
        final Ruby runtime = Ruby.newInstance(config);
        runtime.getGlobalVariables().defineReadonly("$$", new ValueAccessor(runtime.newFixnum(System.identityHashCode(runtime))));
        runtime.getLoadService().init(new ArrayList());
        tar.hookIntoRuntime(runtime);
        Thread t2 = new Thread(){

            @Override
            public void run() {
                console.setVisible(true);
                runtime.evalScript("require 'irb'; require 'irb/completion'; IRB.start");
            }
        };
        t2.start();
        try {
            t2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    private Font findFont(String otherwise, int style, int size, String[] families) {
        Object[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(fonts);
        Font font = null;
        for (int i = 0; i < families.length; ++i) {
            if (Arrays.binarySearch(fonts, families[i]) < 0) continue;
            font = new Font(families[i], style, size);
            break;
        }
        if (font == null) {
            font = new Font(otherwise, style, size);
        }
        return font;
    }
}

