/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.compiler.AssignmentCompiler;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.runtime.Arity;

public class IterNodeCompiler
implements NodeCompiler {
    @Override
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        final IterNode iterNode = (IterNode)node;
        ClosureCallback closureBody = new ClosureCallback(){

            @Override
            public void compile(Compiler context) {
                if (iterNode.getBodyNode() != null) {
                    NodeCompilerFactory.getCompiler(iterNode.getBodyNode()).compile(iterNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        ClosureCallback closureArgs = new ClosureCallback(){

            @Override
            public void compile(Compiler context) {
                if (iterNode.getVarNode() != null) {
                    AssignmentCompiler.assign(iterNode.getVarNode(), 0, context);
                }
            }
        };
        context.createNewClosure(iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody, closureArgs);
    }
}

