/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.ArgsNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.compiler.NotCompilableException;
import org.jruby.runtime.Arity;

public class DefnNodeCompiler
implements NodeCompiler {
    @Override
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        final DefnNode defnNode = (DefnNode)node;
        final ArgsNode argsNode = defnNode.getArgsNode();
        NodeCompilerFactory.confirmNodeIsSafe(argsNode);
        ClosureCallback body = new ClosureCallback(){

            @Override
            public void compile(Compiler context) {
                if (defnNode.getBodyNode() != null) {
                    NodeCompilerFactory.getCompiler(defnNode.getBodyNode()).compile(defnNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        final ArrayCallback evalOptionalValue = new ArrayCallback(){

            @Override
            public void nextValue(Compiler context, Object object, int index) {
                ListNode optArgs = (ListNode)object;
                Node node = optArgs.get(index);
                NodeCompilerFactory.getCompiler(node).compile(node, context);
            }
        };
        ClosureCallback args = new ClosureCallback(){

            @Override
            public void compile(Compiler context) {
                int expectedArgsCount = argsNode.getArgsCount();
                int restArg = argsNode.getRestArg();
                boolean hasOptArgs = argsNode.getOptArgs() != null;
                Arity arity = argsNode.getArity();
                if (hasOptArgs) {
                    if (restArg > -1) {
                        throw new NotCompilableException("Can't compile def with rest arg at: " + defnNode.getPosition());
                    }
                    int opt = expectedArgsCount + argsNode.getOptArgs().size();
                    context.processRequiredArgs(arity, opt);
                    ListNode optArgs = argsNode.getOptArgs();
                    context.assignOptionalArgs(optArgs, expectedArgsCount, optArgs.size(), evalOptionalValue);
                } else {
                    if (restArg > -1) {
                        throw new NotCompilableException("Can't compile def with rest arg at: " + defnNode.getPosition());
                    }
                    context.processRequiredArgs(arity, expectedArgsCount);
                }
            }
        };
        context.defineNewMethod(defnNode.getName(), defnNode.getScope(), body, args);
    }
}

