/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;

public class ArgsNode
extends Node {
    static final long serialVersionUID = 3709437716296564785L;
    private final ListNode arguments;
    private final ListNode optArgs;
    private final ArgumentNode restArgNode;
    private final int restArg;
    private final BlockArgNode blockArgNode;
    private final Arity arity;

    public ArgsNode(ISourcePosition position, ListNode arguments, ListNode optionalArguments, int restArguments, ArgumentNode restArgNode, BlockArgNode blockArgNode) {
        super(position, 3);
        this.arguments = arguments;
        this.optArgs = optionalArguments;
        this.restArg = restArguments;
        this.restArgNode = restArgNode;
        this.blockArgNode = blockArgNode;
        this.arity = this.getRestArg() == -2 ? Arity.optional() : (this.getOptArgs() != null || this.getRestArg() >= 0 ? Arity.required(this.getArgsCount()) : Arity.createArity(this.getArgsCount()));
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public ListNode getArgs() {
        return this.arguments;
    }

    public Arity getArity() {
        return this.arity;
    }

    public int getArgsCount() {
        return this.arguments == null ? 0 : this.arguments.size();
    }

    public ListNode getOptArgs() {
        return this.optArgs;
    }

    public int getRestArg() {
        return this.restArg;
    }

    public ArgumentNode getRestArgNode() {
        return this.restArgNode;
    }

    public BlockArgNode getBlockArgNode() {
        return this.blockArgNode;
    }

    @Override
    public List childNodes() {
        return Node.createList(this.arguments, this.optArgs, this.restArgNode, this.blockArgNode);
    }
}

