/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyProc
extends RubyObject {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private static ObjectAllocator PROC_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyProc instance = RubyProc.newProc(runtime, Block.Type.PROC);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type) {
        super(runtime, rubyClass);
        this.type = type;
    }

    public static RubyClass createProcClass(Ruby runtime) {
        RubyClass procClass = runtime.defineClass("Proc", runtime.getObject(), PROC_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyProc.class);
        procClass.defineFastMethod("arity", callbackFactory.getFastMethod("arity"));
        procClass.defineFastMethod("binding", callbackFactory.getFastMethod("binding"));
        procClass.defineMethod("call", callbackFactory.getOptMethod("call"));
        procClass.defineAlias("[]", "call");
        procClass.defineFastMethod("to_proc", callbackFactory.getFastMethod("to_proc"));
        procClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        procClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    public static RubyProc newProc(Ruby runtime, Block.Type type) {
        return new RubyProc(runtime, runtime.getClass("Proc"), type);
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type) {
        RubyProc proc = new RubyProc(runtime, runtime.getClass("Proc"), type);
        proc.callInit(NULL_ARRAY, block);
        return proc;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args, Block procBlock) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 0);
        if (procBlock == null) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (this.type != Block.Type.LAMBDA || procBlock == null) {
            // empty if block
        }
        this.block = procBlock.cloneBlock();
        this.block.type = this.type;
        this.block.setProcObject(this);
        return this;
    }

    @Override
    protected IRubyObject doClone() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getClass("Proc"), this.type);
        newProc.block = this.getBlock();
        return newProc;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        IRubyObject obj = ((RubyClass)recv).allocate();
        if (!block.isGiven()) {
            block = runtime.getCurrentContext().getPreviousFrame().getBlock();
        }
        obj.callMethod(runtime.getCurrentContext(), "initialize", args, block);
        return obj;
    }

    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block);
    }

    public IRubyObject call(IRubyObject[] args) {
        return this.call(args, null, Block.NULL_BLOCK);
    }

    public IRubyObject call(IRubyObject[] args, Block unusedBlock) {
        return this.call(args, null, Block.NULL_BLOCK);
    }

    public IRubyObject call(IRubyObject[] args, IRubyObject self, Block unusedBlock) {
        assert (args != null);
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            Block newBlock = this.block.cloneBlock();
            if (self != null) {
                newBlock.setSelf(self);
            }
            if (newBlock.type == Block.Type.LAMBDA) {
                newBlock.getFrame().setJumpTarget(this);
            }
            return newBlock.call(context, args);
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                if (this.block.type == Block.Type.LAMBDA) {
                    return (IRubyObject)je.getValue();
                }
                throw runtime.newLocalJumpError("break", (IRubyObject)je.getValue(), "break from proc-closure");
            }
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                Object target = je.getTarget();
                if (target == this || this.block.type == Block.Type.LAMBDA) {
                    return (IRubyObject)je.getValue();
                }
                if (target == null) {
                    throw runtime.newLocalJumpError("return", (IRubyObject)je.getValue(), "unexpected return");
                }
                throw je;
            }
            throw je;
        }
    }

    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    public RubyProc to_proc() {
        return this;
    }
}

