/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.net.URL;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyClassPathVariable
extends RubyObject {
    public static void createClassPathVariable(Ruby runtime) {
        RubyClassPathVariable self = new RubyClassPathVariable(runtime);
        runtime.getModule("Enumerable").extend_object(self);
        runtime.defineReadonlyVariable("$CLASSPATH", self);
        CallbackFactory cf = runtime.callbackFactory(RubyClassPathVariable.class);
        self.getMetaClass().defineFastMethod("<<", cf.getFastMethod("append", IRubyObject.class));
        self.getMetaClass().defineFastMethod("append", cf.getFastMethod("append", IRubyObject.class));
        self.getMetaClass().defineFastMethod("size", cf.getFastMethod("size"));
        self.getMetaClass().defineFastMethod("length", cf.getFastMethod("size"));
        self.getMetaClass().defineMethod("each", cf.getMethod("each"));
        self.getMetaClass().defineFastMethod("to_s", cf.getFastMethod("to_s"));
        self.getMetaClass().defineFastMethod("inspect", cf.getFastMethod("inspect"));
    }

    private RubyClassPathVariable(Ruby runtime) {
        super(runtime, runtime.getObject());
    }

    public IRubyObject append(IRubyObject obj) throws Exception {
        String ss = obj.convertToString().toString();
        if (ss.indexOf("://") == -1) {
            ss = "file://" + ss;
        }
        this.getRuntime().getJRubyClassLoader().addURL(new URL(ss));
        return this;
    }

    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.getRuntime().getJRubyClassLoader().getURLs().length);
    }

    public IRubyObject each(Block block) {
        URL[] urls = this.getRuntime().getJRubyClassLoader().getURLs();
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        int j = urls.length;
        for (int i = 0; i < j; ++i) {
            block.yield(ctx, this.getRuntime().newString(urls[i].toString()));
        }
        return this.getRuntime().getNil();
    }

    @Override
    public IRubyObject to_s() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "to_s");
    }

    @Override
    public IRubyObject inspect() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "inspect");
    }
}

