/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyBignum
extends RubyInteger {
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final byte OP_PLUS_SWITCHVALUE = 1;
    public static final byte OP_MINUS_SWITCHVALUE = 2;
    public static final byte OP_LT_SWITCHVALUE = 3;
    public static final byte TO_S_SWITCHVALUE = 4;
    public static final byte TO_I_SWITCHVALUE = 5;
    public static final byte HASH_SWITCHVALUE = 6;
    public static final byte OP_TIMES_SWITCHVALUE = 7;
    public static final byte EQUALEQUAL_SWITCHVALUE = 8;
    public static final byte OP_SPACESHIP_SWITCHVALUE = 9;
    public static final byte INSPECT_SWITCHVALUE = 10;
    private final BigInteger value;

    public static RubyClass createBignumClass(Ruby runtime) {
        RubyClass bignum = runtime.defineClass("Bignum", runtime.getClass("Integer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        bignum.index = 2;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyBignum.class);
        bignum.defineFastMethod("to_s", callbackFactory.getFastOptMethod("to_s"));
        bignum.defineFastMethod("coerce", callbackFactory.getFastMethod("coerce", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("-@", callbackFactory.getFastMethod("uminus"));
        bignum.defineFastMethod("+", callbackFactory.getFastMethod("plus", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("-", callbackFactory.getFastMethod("minus", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("*", callbackFactory.getFastMethod("mul", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("/", callbackFactory.getFastMethod("div", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("%", callbackFactory.getFastMethod("mod", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("div", callbackFactory.getFastMethod("div", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("divmod", callbackFactory.getFastMethod("divmod", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("modulo", callbackFactory.getFastMethod("mod", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("remainder", callbackFactory.getFastMethod("remainder", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("quo", callbackFactory.getFastMethod("quo", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("**", callbackFactory.getFastMethod("pow", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("&", callbackFactory.getFastMethod("and", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("|", callbackFactory.getFastMethod("or", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("^", callbackFactory.getFastMethod("xor", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("~", callbackFactory.getFastMethod("neg"));
        bignum.defineFastMethod("<<", callbackFactory.getFastMethod("lshift", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod(">>", callbackFactory.getFastMethod("rshift", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("[]", callbackFactory.getFastMethod("aref", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("<=>", callbackFactory.getFastMethod("cmp", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("==", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("eql?", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        bignum.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        bignum.defineFastMethod("to_f", callbackFactory.getFastMethod("to_f"));
        bignum.defineFastMethod("abs", callbackFactory.getFastMethod("abs"));
        bignum.defineFastMethod("size", callbackFactory.getFastMethod("size"));
        return bignum;
    }

    public RubyBignum(Ruby runtime, BigInteger value) {
        super(runtime, runtime.getClass("Bignum"));
        this.value = value;
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().hasEventHooks()) {
            return super.callMethod(context, rubyclass, name, args, callType, block);
        }
        switch (this.getRuntime().getSelectorTable().table[rubyclass.index][methodIndex]) {
            case 1: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.plus(args[0]);
            }
            case 2: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.minus(args[0]);
            }
            case 4: {
                return this.to_s(args);
            }
            case 5: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_i();
            }
            case 6: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.hash();
            }
            case 7: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.mul(args[0]);
            }
            case 8: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.equal(args[0]);
            }
            case 9: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.cmp(args[0]);
            }
            case 10: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.inspect();
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    @Override
    public int getNativeTypeIndex() {
        return 2;
    }

    public static RubyBignum newBignum(Ruby runtime, long value) {
        return RubyBignum.newBignum(runtime, BigInteger.valueOf(value));
    }

    public static RubyBignum newBignum(Ruby runtime, double value) {
        return RubyBignum.newBignum(runtime, new BigDecimal(value).toBigInteger());
    }

    public static RubyBignum newBignum(Ruby runtime, BigInteger value) {
        return new RubyBignum(runtime, value);
    }

    public static RubyBignum newBignum(Ruby runtime, String value) {
        return new RubyBignum(runtime, new BigInteger(value));
    }

    @Override
    public double getDoubleValue() {
        return RubyBignum.big2dbl(this);
    }

    @Override
    public long getLongValue() {
        return RubyBignum.big2long(this);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static RubyInteger bignorm(Ruby runtime, BigInteger bi) {
        if (bi.compareTo(LONG_MIN) < 0 || bi.compareTo(LONG_MAX) > 0) {
            return RubyBignum.newBignum(runtime, bi);
        }
        return runtime.newFixnum(bi.longValue());
    }

    public static long big2long(RubyBignum value) {
        BigInteger big = value.getValue();
        if (big.compareTo(LONG_MIN) < 0 || big.compareTo(LONG_MAX) > 0) {
            throw value.getRuntime().newRangeError("bignum too big to convert into `long'");
        }
        return big.longValue();
    }

    public static double big2dbl(RubyBignum value) {
        BigInteger big = value.getValue();
        double dbl = big.doubleValue();
        if (dbl == Double.NEGATIVE_INFINITY || dbl == Double.POSITIVE_INFINITY) {
            value.getRuntime().getWarnings().warn("Bignum out of Float range");
        }
        return dbl;
    }

    public static BigInteger fix2big(RubyFixnum arg) {
        return BigInteger.valueOf(arg.getLongValue());
    }

    public IRubyObject to_s(IRubyObject[] args) {
        int base;
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        int n = base = args.length == 0 ? 10 : RubyBignum.num2int(args[0]);
        if (base < 2 || base > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return this.getRuntime().newString(this.getValue().toString(base));
    }

    @Override
    public IRubyObject coerce(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.getRuntime().newArray(RubyBignum.newBignum(this.getRuntime(), ((RubyFixnum)other).getLongValue()), this);
        }
        if (other instanceof RubyBignum) {
            return this.getRuntime().newArray(RubyBignum.newBignum(this.getRuntime(), ((RubyBignum)other).getValue()), this);
        }
        throw this.getRuntime().newTypeError("Can't coerce " + other.getMetaClass().getName() + " to Bignum");
    }

    @Override
    public IRubyObject uminus() {
        return RubyBignum.bignorm(this.getRuntime(), this.value.negate());
    }

    public IRubyObject plus(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.add(RubyBignum.fix2big((RubyFixnum)other)));
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.add(((RubyBignum)other).value));
        }
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) + ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("+", other);
    }

    public IRubyObject minus(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.subtract(RubyBignum.fix2big((RubyFixnum)other)));
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.subtract(((RubyBignum)other).value));
        }
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) - ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("-", other);
    }

    public IRubyObject mul(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.multiply(RubyBignum.fix2big((RubyFixnum)other)));
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.multiply(((RubyBignum)other).value));
        }
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) * ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("*", other);
    }

    @Override
    public IRubyObject div(IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) / ((RubyFloat)other).getDoubleValue());
            }
            return this.coerceBin("/", other);
        }
        if (otherValue.equals(BigInteger.ZERO)) {
            throw this.getRuntime().newZeroDivisionError();
        }
        BigInteger[] results = this.value.divideAndRemainder(otherValue);
        if (results[0].signum() == -1 && results[1].signum() != 0) {
            return RubyBignum.bignorm(this.getRuntime(), results[0].subtract(BigInteger.ONE));
        }
        return RubyBignum.bignorm(this.getRuntime(), results[0]);
    }

    @Override
    public IRubyObject divmod(IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            return this.coerceBin("divmod", other);
        }
        if (otherValue.equals(BigInteger.ZERO)) {
            throw this.getRuntime().newZeroDivisionError();
        }
        BigInteger[] results = this.value.divideAndRemainder(otherValue);
        if (results[0].signum() == -1 && results[1].signum() != 0) {
            return RubyBignum.bignorm(this.getRuntime(), results[0].subtract(BigInteger.ONE));
        }
        Ruby runtime = this.getRuntime();
        return RubyArray.newArray(this.getRuntime(), RubyBignum.bignorm(runtime, results[0]), RubyBignum.bignorm(runtime, results[1]));
    }

    public IRubyObject mod(IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            return this.coerceBin("%", other);
        }
        if (otherValue.equals(BigInteger.ZERO)) {
            throw this.getRuntime().newZeroDivisionError();
        }
        BigInteger result = this.value.mod(otherValue.abs());
        if (otherValue.signum() == -1) {
            result = otherValue.add(result);
        }
        return RubyBignum.bignorm(this.getRuntime(), result);
    }

    @Override
    public IRubyObject remainder(IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            return this.coerceBin("remainder", other);
        }
        if (otherValue.equals(BigInteger.ZERO)) {
            throw this.getRuntime().newZeroDivisionError();
        }
        return RubyBignum.bignorm(this.getRuntime(), this.value.remainder(otherValue));
    }

    @Override
    public IRubyObject quo(IRubyObject other) {
        if (other instanceof RubyNumeric) {
            return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) / ((RubyNumeric)other).getDoubleValue());
        }
        return this.coerceBin("quo", other);
    }

    public IRubyObject pow(IRubyObject other) {
        double d;
        if (other instanceof RubyFixnum) {
            RubyFixnum fix = (RubyFixnum)other;
            long fixValue = fix.getLongValue();
            if ((long)((this.value.bitLength() + 7) / 8 * 4) * Math.abs(fixValue) > 0x100000L) {
                this.getRuntime().getWarnings().warn("in a**b, b may be too big");
            }
            if (fixValue >= 0L) {
                return RubyBignum.bignorm(this.getRuntime(), this.value.pow((int)fixValue));
            }
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(RubyBignum.big2dbl(this), fixValue));
        }
        if (other instanceof RubyBignum) {
            this.getRuntime().getWarnings().warn("in a**b, b may be too big");
            d = ((RubyBignum)other).getDoubleValue();
        } else if (other instanceof RubyFloat) {
            d = ((RubyFloat)other).getDoubleValue();
        } else {
            return this.coerceBin("**", other);
        }
        return RubyFloat.newFloat(this.getRuntime(), Math.pow(RubyBignum.big2dbl(this), d));
    }

    public IRubyObject and(IRubyObject other) {
        if ((other = other.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.and(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.and(RubyBignum.fix2big((RubyFixnum)other)));
        }
        return this.coerceBin("&", other);
    }

    public IRubyObject or(IRubyObject other) {
        if ((other = other.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.or(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.or(RubyBignum.fix2big((RubyFixnum)other)));
        }
        return this.coerceBin("|", other);
    }

    public IRubyObject xor(IRubyObject other) {
        if ((other = other.convertToInteger()) instanceof RubyBignum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.xor(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.xor(BigInteger.valueOf(((RubyFixnum)other).getLongValue())));
        }
        return this.coerceBin("^", other);
    }

    public IRubyObject neg() {
        return RubyBignum.newBignum(this.getRuntime(), this.value.not());
    }

    public IRubyObject lshift(IRubyObject other) {
        int width = RubyBignum.num2int(other);
        if (width < 0) {
            return this.rshift(RubyFixnum.newFixnum(this.getRuntime(), -width));
        }
        return RubyBignum.bignorm(this.getRuntime(), this.value.shiftLeft(width));
    }

    public IRubyObject rshift(IRubyObject other) {
        int width = RubyBignum.num2int(other);
        if (width < 0) {
            return this.lshift(RubyFixnum.newFixnum(this.getRuntime(), -width));
        }
        return RubyBignum.bignorm(this.getRuntime(), this.value.shiftRight(width));
    }

    public RubyFixnum aref(IRubyObject other) {
        if (other instanceof RubyBignum) {
            if (((RubyBignum)other).value.signum() >= 0 || this.value.signum() == -1) {
                return RubyFixnum.zero(this.getRuntime());
            }
            return RubyFixnum.one(this.getRuntime());
        }
        int position = RubyBignum.num2int(other);
        if (position < 0) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.value.testBit(RubyBignum.num2int(other)) ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public IRubyObject cmp(IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                return RubyBignum.dbl_cmp(this.getRuntime(), RubyBignum.big2dbl(this), ((RubyFloat)other).getDoubleValue());
            }
            return this.coerceCmp("<=>", other);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value.compareTo(otherValue));
    }

    @Override
    public IRubyObject equal(IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat) {
                double a = ((RubyFloat)other).getDoubleValue();
                if (Double.isNaN(a)) {
                    return this.getRuntime().getFalse();
                }
                return RubyBoolean.newBoolean(this.getRuntime(), a == RubyBignum.big2dbl(this));
            }
            return super.equal(other);
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this.value.compareTo(otherValue) == 0);
    }

    @Override
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return this.value.compareTo(((RubyBignum)other).value) == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    @Override
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @Override
    public IRubyObject abs() {
        return RubyBignum.newBignum(this.getRuntime(), this.value.abs());
    }

    public RubyFixnum size() {
        return this.getRuntime().newFixnum((this.value.bitLength() + 7) / 8);
    }

    public static void marshalTo(RubyBignum bignum, MarshalStream output) throws IOException {
        output.write(bignum.value.signum() >= 0 ? 43 : 45);
        BigInteger absValue = bignum.value.abs();
        byte[] digits = absValue.toByteArray();
        boolean oddLengthNonzeroStart = digits.length % 2 != 0 && digits[0] != 0;
        int shortLength = digits.length / 2;
        if (oddLengthNonzeroStart) {
            ++shortLength;
        }
        output.writeInt(shortLength);
        for (int i = 1; i <= shortLength * 2 && i <= digits.length; ++i) {
            output.write(digits[digits.length - i]);
        }
        if (oddLengthNonzeroStart) {
            output.write(0);
        }
    }

    public static RubyNumeric unmarshalFrom(UnmarshalStream input) throws IOException {
        boolean positive = input.readUnsignedByte() == 43;
        int shortLength = input.unmarshalInt();
        byte[] digits = new byte[shortLength * 2 + 1];
        for (int i = digits.length - 1; i >= 1; --i) {
            digits[i] = input.readSignedByte();
        }
        BigInteger value = new BigInteger(digits);
        if (!positive) {
            value = value.negate();
        }
        RubyInteger result = RubyBignum.bignorm(input.getRuntime(), value);
        input.registerLinkTarget(result);
        return result;
    }
}

