/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.BlockStaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class Block {
    public static final Block NULL_BLOCK = new Block(){

        public boolean isGiven() {
            return false;
        }

        public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
            throw context.getRuntime().newLocalJumpError("noreason", value, "yield called out of block");
        }

        public Block cloneBlock() {
            return this;
        }
    };
    protected IRubyObject self;
    private IterNode iterNode;
    protected Frame frame;
    protected SinglyLinkedList cref;
    protected Visibility visibility;
    protected RubyModule klass;
    protected DynamicScope dynamicScope;
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    protected Arity arity;

    public static Block createBlock(ThreadContext context, IterNode iterNode, DynamicScope dynamicScope, IRubyObject self) {
        return new Block(iterNode, self, context.getCurrentFrame(), context.peekCRef(), context.getCurrentFrame().getVisibility(), context.getRubyClass(), dynamicScope);
    }

    protected Block() {
        this(null, null, null, null, null, null, null);
    }

    public Block(IterNode iterNode, IRubyObject self, Frame frame, SinglyLinkedList cref, Visibility visibility, RubyModule klass, DynamicScope dynamicScope) {
        this.iterNode = iterNode;
        this.self = self;
        this.frame = frame;
        this.visibility = visibility;
        this.klass = klass;
        this.cref = cref;
        this.dynamicScope = dynamicScope;
        this.arity = iterNode == null ? null : Arity.procArityOf(iterNode.getVarNode());
    }

    public static Block createBinding(Frame frame, DynamicScope dynamicScope) {
        ThreadContext context = frame.getSelf().getRuntime().getCurrentContext();
        DynamicScope extraScope = dynamicScope.getBindingScope();
        if (extraScope == null) {
            DynamicScope parent = dynamicScope.getNextCapturedScope();
            if (parent != null && parent.getBindingScope() == dynamicScope) {
                extraScope = dynamicScope;
            } else {
                extraScope = new DynamicScope(new BlockStaticScope(dynamicScope.getStaticScope()), dynamicScope);
                dynamicScope.setBindingScope(extraScope);
            }
        }
        return new Block(null, frame.getSelf(), frame, context.peekCRef(), frame.getVisibility(), context.getBindingRubyClass(), extraScope);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        switch (this.type.value) {
            case 1: {
                Node vNode;
                if (args.length != 1 || !(args[0] instanceof RubyArray) || this.iterNode == null || (vNode = this.iterNode.getVarNode()) == null || vNode.nodeId != 58) break;
                args = ((RubyArray)args[0]).toJavaArray();
                break;
            }
            case 2: {
                if (args.length != 1 || !(args[0] instanceof RubyArray) || this.iterNode == null) break;
                Node vNode = this.iterNode.getVarNode();
                if (vNode.nodeId != 58 || ((MultipleAsgnNode)vNode).getArgsNode() != null) break;
                args = ((RubyArray)args[0]).toJavaArray();
                break;
            }
            case 3: {
                this.arity().checkArity(context.getRuntime(), args);
            }
        }
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true);
    }

    protected void pre(ThreadContext context, RubyModule klass) {
        context.preYieldSpecificBlock(this, klass);
    }

    protected void post(ThreadContext context) {
        context.postYield();
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value) {
        return this.yield(context, value, null, null, false);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        if (klass == null) {
            self = this.self;
            this.frame.setSelf(self);
        }
        this.pre(context, klass);
        try {
            if (this.iterNode.getVarNode() != null) {
                if (aValue) {
                    this.setupBlockArgs(context, this.iterNode.getVarNode(), value, self);
                } else {
                    this.setupBlockArg(context, this.iterNode.getVarNode(), value, self);
                }
            }
            while (true) {
                try {
                    IRubyObject iRubyObject = EvaluationState.eval(context.getRuntime(), context, this.iterNode.getBodyNode(), self, NULL_BLOCK);
                    return iRubyObject;
                }
                catch (JumpException je) {
                    try {
                        if (je.getJumpType() == JumpException.JumpType.RedoJump) {
                            context.pollThreadEvents();
                            continue;
                        }
                        if (je.getJumpType() == JumpException.JumpType.BreakJump && je.getTarget() == null) {
                            je.setTarget(this);
                        }
                        throw je;
                    }
                    catch (JumpException je2) {
                        if (je2.getJumpType() == JumpException.JumpType.NextJump) {
                            IRubyObject iRubyObject = (IRubyObject)je2.getValue();
                            return iRubyObject;
                        }
                        throw je2;
                    }
                }
                break;
            }
        }
        finally {
            this.post(context);
        }
    }

    private void setupBlockArgs(ThreadContext context, Node varNode, IRubyObject value, IRubyObject self) {
        Ruby runtime = self.getRuntime();
        switch (varNode.nodeId) {
            case 98: {
                break;
            }
            case 58: {
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)varNode, (RubyArray)value, false);
                break;
            }
            default: {
                int length = this.arrayLength(value);
                switch (length) {
                    case 0: {
                        value = runtime.getNil();
                        break;
                    }
                    case 1: {
                        value = ((RubyArray)value).eltInternal(0);
                        break;
                    }
                    default: {
                        runtime.getWarnings().warn("multiple values for a block parameter (" + length + " for 1)");
                    }
                }
                AssignmentVisitor.assign(runtime, context, self, varNode, value, NULL_BLOCK, false);
            }
        }
    }

    private void setupBlockArg(ThreadContext context, Node varNode, IRubyObject value, IRubyObject self) {
        Ruby runtime = self.getRuntime();
        switch (varNode.nodeId) {
            case 98: {
                return;
            }
            case 58: {
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)varNode, ArgsUtil.convertToRubyArray(runtime, value, ((MultipleAsgnNode)varNode).getHeadNode() != null), false);
                break;
            }
            default: {
                if (value == null) {
                    runtime.getWarnings().warn("multiple values for a block parameter (0 for 1)");
                }
                AssignmentVisitor.assign(runtime, context, self, varNode, value, NULL_BLOCK, false);
            }
        }
    }

    private int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public Block cloneBlock() {
        Block newBlock = new Block(this.iterNode, this.self, this.frame.duplicate(), this.cref, this.visibility, this.klass, this.dynamicScope.cloneScope());
        newBlock.type = this.type;
        return newBlock;
    }

    public Arity arity() {
        return this.arity;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public SinglyLinkedList getCRef() {
        return this.cref;
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public boolean isGiven() {
        return true;
    }

    public static class Type {
        public static final int NORMAL_VALUE = 1;
        public static final int PROC_VALUE = 2;
        public static final int LAMBDA_VALUE = 3;
        public static final Type NORMAL = new Type(1);
        public static final Type PROC = new Type(2);
        public static final Type LAMBDA = new Type(3);
        public final int value;

        public Type(int value) {
            this.value = value;
        }
    }
}

