/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.EvaluateCallable;
import org.jruby.parser.BlockStaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class Block {
    public static final Block NULL_BLOCK = new Block(){

        @Override
        public boolean isGiven() {
            return false;
        }

        @Override
        public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
            throw context.getRuntime().newLocalJumpError("yield called out of block");
        }

        @Override
        public Block cloneBlock() {
            return this;
        }
    };
    private IRubyObject self;
    private ICallable method;
    private Node varNode;
    private Frame frame;
    private SinglyLinkedList cref;
    private Visibility visibility;
    private RubyModule klass;
    private DynamicScope dynamicScope;
    private RubyProc proc = null;
    public boolean isLambda = false;

    public static Block createBlock(ThreadContext context, Node varNode, DynamicScope dynamicScope, ICallable method, IRubyObject self) {
        return new Block(varNode, method, self, context.getCurrentFrame(), context.peekCRef(), context.getCurrentFrame().getVisibility(), context.getRubyClass(), dynamicScope);
    }

    protected Block() {
        this(null, null, null, null, null, null, null, null);
    }

    public Block(Node varNode, ICallable method, IRubyObject self, Frame frame, SinglyLinkedList cref, Visibility visibility, RubyModule klass, DynamicScope dynamicScope) {
        this.varNode = varNode;
        this.method = method;
        this.self = self;
        this.frame = frame;
        this.visibility = visibility;
        this.klass = klass;
        this.cref = cref;
        this.dynamicScope = dynamicScope;
    }

    public static Block createBinding(Frame frame, DynamicScope dynamicScope) {
        ThreadContext context = frame.getSelf().getRuntime().getCurrentContext();
        DynamicScope extraScope = dynamicScope.getBindingScope();
        if (extraScope == null) {
            DynamicScope parent = dynamicScope.getNextCapturedScope();
            if (parent != null && parent.getBindingScope() == dynamicScope) {
                extraScope = dynamicScope;
            } else {
                extraScope = new DynamicScope(new BlockStaticScope(dynamicScope.getStaticScope()), dynamicScope);
                dynamicScope.setBindingScope(extraScope);
            }
        }
        return new Block(null, null, frame.getSelf(), frame, context.peekCRef(), frame.getVisibility(), context.getBindingRubyClass(), extraScope);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true);
    }

    protected void pre(ThreadContext context, RubyModule klass) {
        context.preYieldSpecificBlock(this, klass);
    }

    protected void post(ThreadContext context) {
        context.postYield();
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value) {
        return this.yield(context, value, null, null, false);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        if (klass == null) {
            self = this.self;
            this.frame.setSelf(self);
        }
        this.pre(context, klass);
        try {
            IRubyObject[] args = this.method instanceof EvaluateCallable ? this.getBlockArgsEvaluate(context, value, self, aValue) : this.getBlockArgs(context, value, self, aValue);
            while (true) {
                try {
                    IRubyObject iRubyObject = this.method.call(context, self, args, NULL_BLOCK);
                    return iRubyObject;
                }
                catch (JumpException je) {
                    try {
                        if (je.getJumpType() == JumpException.JumpType.RedoJump) {
                            context.pollThreadEvents();
                            continue;
                        }
                        if (je.getJumpType() == JumpException.JumpType.BreakJump && je.getTarget() == null) {
                            je.setTarget(this);
                        }
                        throw je;
                    }
                    catch (JumpException je2) {
                        if (je2.getJumpType() == JumpException.JumpType.NextJump) {
                            IRubyObject iRubyObject = (IRubyObject)je2.getValue();
                            return iRubyObject;
                        }
                        throw je2;
                    }
                }
                break;
            }
        }
        finally {
            this.post(context);
        }
    }

    private IRubyObject[] getBlockArgs(ThreadContext context, IRubyObject value, IRubyObject self, boolean valueIsArray) {
        if (this.varNode == null) {
            return new IRubyObject[]{value};
        }
        Ruby runtime = self.getRuntime();
        switch (this.varNode.nodeId) {
            case 98: {
                break;
            }
            case 58: {
                if (!valueIsArray) {
                    value = ArgsUtil.convertToRubyArray(runtime, value, ((MultipleAsgnNode)this.varNode).getHeadNode() != null);
                }
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)this.varNode, (RubyArray)value, false);
                break;
            }
            default: {
                if (valueIsArray) {
                    int length = this.arrayLength(value);
                    switch (length) {
                        case 0: {
                            value = runtime.getNil();
                            break;
                        }
                        case 1: {
                            value = ((RubyArray)value).eltInternal(0);
                            break;
                        }
                        default: {
                            runtime.getWarnings().warn("multiple values for a block parameter (" + length + " for 1)");
                            break;
                        }
                    }
                } else if (value == null) {
                    runtime.getWarnings().warn("multiple values for a block parameter (0 for 1)");
                }
                AssignmentVisitor.assign(runtime, context, self, this.varNode, value, NULL_BLOCK, false);
            }
        }
        return ArgsUtil.convertToJavaArray(value);
    }

    private IRubyObject[] getBlockArgsEvaluate(ThreadContext context, IRubyObject value, IRubyObject self, boolean valueIsArray) {
        if (this.varNode == null) {
            return IRubyObject.NULL_ARRAY;
        }
        Ruby runtime = self.getRuntime();
        if (valueIsArray) {
            switch (this.varNode.nodeId) {
                case 98: {
                    break;
                }
                case 58: {
                    value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)this.varNode, (RubyArray)value, false);
                    break;
                }
                default: {
                    int length = this.arrayLength(value);
                    switch (length) {
                        case 0: {
                            value = runtime.getNil();
                            break;
                        }
                        case 1: {
                            value = ((RubyArray)value).eltInternal(0);
                            break;
                        }
                        default: {
                            runtime.getWarnings().warn("multiple values for a block parameter (" + length + " for 1)");
                        }
                    }
                    AssignmentVisitor.assign(runtime, context, self, this.varNode, value, NULL_BLOCK, false);
                    break;
                }
            }
        } else {
            switch (this.varNode.nodeId) {
                case 98: {
                    return IRubyObject.NULL_ARRAY;
                }
                case 58: {
                    value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)this.varNode, ArgsUtil.convertToRubyArray(runtime, value, ((MultipleAsgnNode)this.varNode).getHeadNode() != null), false);
                    break;
                }
                default: {
                    if (value == null) {
                        runtime.getWarnings().warn("multiple values for a block parameter (0 for 1)");
                    }
                    AssignmentVisitor.assign(runtime, context, self, this.varNode, value, NULL_BLOCK, false);
                }
            }
        }
        return IRubyObject.NULL_ARRAY;
    }

    private int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public Block cloneBlock() {
        Block newBlock = new Block(this.varNode, this.method, this.self, this.frame.duplicate(), this.cref, this.visibility, this.klass, this.dynamicScope.cloneScope());
        newBlock.isLambda = this.isLambda;
        return newBlock;
    }

    public Arity arity() {
        return this.method.getArity();
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public SinglyLinkedList getCRef() {
        return this.cref;
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public boolean isGiven() {
        return true;
    }
}

