/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyConstructor
extends JavaProxyReflectionObject {
    private final Constructor proxyConstructor;
    private final Class[] parameterTypes;
    private final JavaProxyClass declaringProxyClass;

    JavaProxyConstructor(Ruby runtime, JavaProxyClass pClass, Constructor constructor) {
        super(runtime, runtime.getModule("Java").getClass("JavaProxyConstructor"));
        this.declaringProxyClass = pClass;
        this.proxyConstructor = constructor;
        this.parameterTypes = this.proxyConstructor.getParameterTypes();
    }

    public Class[] getParameterTypes() {
        Class[] result = new Class[this.parameterTypes.length - 1];
        System.arraycopy(this.parameterTypes, 0, result, 0, result.length);
        return result;
    }

    public JavaProxyClass getDeclaringClass() {
        return this.declaringProxyClass;
    }

    public Object newInstance(Object[] args, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (args.length + 1 != this.parameterTypes.length) {
            throw new IllegalArgumentException("wrong number of parameters");
        }
        Object[] realArgs = new Object[args.length + 1];
        System.arraycopy(args, 0, realArgs, 0, args.length);
        realArgs[args.length] = handler;
        return this.proxyConstructor.newInstance(realArgs);
    }

    public static RubyClass createJavaProxyConstructorClass(Ruby runtime, RubyModule javaProxyModule) {
        RubyClass result = javaProxyModule.defineClassUnder("JavaProxyConstructor", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaProxyConstructor.class);
        JavaProxyReflectionObject.registerRubyMethods(runtime, result);
        result.defineFastMethod("argument_types", callbackFactory.getFastMethod("argument_types"));
        result.defineFastMethod("declaring_class", callbackFactory.getFastMethod("getDeclaringClass"));
        result.defineMethod("new_instance", callbackFactory.getOptMethod("new_instance"));
        result.defineFastMethod("arity", callbackFactory.getFastMethod("arity"));
        return result;
    }

    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getParameterTypes().length);
    }

    protected String nameOnInspection() {
        return this.getDeclaringClass().nameOnInspection();
    }

    @Override
    public IRubyObject inspect() {
        StringBuffer result = new StringBuffer();
        result.append(this.nameOnInspection());
        Class[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(parameterTypes[i].getName());
            if (i >= parameterTypes.length - 1) continue;
            result.append(',');
        }
        result.append(")>");
        return this.getRuntime().newString(result.toString());
    }

    public RubyArray argument_types() {
        return this.buildRubyArray(this.getParameterTypes());
    }

    public RubyObject new_instance(IRubyObject[] args, Block block) {
        Object result;
        RubyProc proc;
        int size = Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) - 1;
        if (args[size] instanceof RubyProc) {
            proc = (RubyProc)args[size];
        } else {
            proc = this.getRuntime().newProc(false, block);
            ++size;
        }
        RubyArray constructor_args = (RubyArray)args[0];
        Class[] parameterTypes = this.getParameterTypes();
        int count = (int)constructor_args.length().getLongValue();
        Object[] converted = new Object[count];
        for (int i = 0; i < count; ++i) {
            IRubyObject ith = constructor_args.aref(new IRubyObject[]{this.getRuntime().newFixnum(i)});
            converted[i] = JavaUtil.convertArgument(Java.ruby_to_java(this, ith, Block.NULL_BLOCK), parameterTypes[i]);
        }
        final JavaProxyConstructor recv = this;
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            @Override
            public Object invoke(Object proxy, JavaProxyMethod method, Object[] nargs) throws Throwable {
                int length = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length + 2];
                rubyArgs[0] = JavaObject.wrap(recv.getRuntime(), proxy);
                rubyArgs[1] = method;
                for (int i = 0; i < length; ++i) {
                    rubyArgs[i + 2] = JavaUtil.convertJavaToRuby(JavaProxyConstructor.this.getRuntime(), nargs[i]);
                }
                IRubyObject call_result = proc.call(rubyArgs);
                Object converted_result = JavaUtil.convertRubyToJava(call_result, method.getReturnType());
                return converted_result;
            }
        };
        try {
            result = this.newInstance(converted, handler);
        }
        catch (Exception e) {
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }
}

