/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.FieldVisitor;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.Type;
import jruby.objectweb.asm.commons.GeneratorAdapter;
import jruby.objectweb.asm.commons.Method;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.InternalJavaProxyHelper;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;

public class JavaProxyClassFactory {
    private static final Type JAVA_LANG_CLASS_TYPE = Type.getType(Class.class);
    private static final Type[] EMPTY_TYPE_ARR = new Type[0];
    private static final Method HELPER_GET_PROXY_CLASS_METHOD = Method.getMethod(JavaProxyClass.class.getName() + " initProxyClass(java.lang.Class)");
    private static final Method CLASS_FORNAME_METHOD = Method.getMethod("java.lang.Class forName(java.lang.String)");
    private static final String INVOCATION_HANDLER_FIELD_NAME = "__handler";
    private static final String PROXY_CLASS_FIELD_NAME = "__proxy_class";
    private static final Class[] EMPTY_CLASS_ARR = new Class[0];
    private static final Type INVOCATION_HANDLER_TYPE = Type.getType(JavaProxyInvocationHandler.class);
    private static final Type PROXY_METHOD_TYPE = Type.getType(JavaProxyMethod.class);
    private static final Type PROXY_CLASS_TYPE = Type.getType(JavaProxyClass.class);
    private static final Method INVOCATION_HANDLER_INVOKE_METHOD = Method.getMethod("java.lang.Object invoke(java.lang.Object, " + PROXY_METHOD_TYPE.getClassName() + ", java.lang.Object[])");
    private static final Type PROXY_HELPER_TYPE = Type.getType(InternalJavaProxyHelper.class);
    private static final Method PROXY_HELPER_GET_METHOD = Method.getMethod(PROXY_METHOD_TYPE.getClassName() + " initProxyMethod(" + JavaProxyClass.class.getName() + ",java.lang.String,java.lang.String,boolean)");
    private static final Type JAVA_PROXY_TYPE = Type.getType(InternalJavaProxy.class);
    private static int counter;
    private static Map proxies;
    private static java.lang.reflect.Method defineClass_method;

    static JavaProxyClass newProxyClass(ClassLoader loader, String targetClassName, Class superClass, Class[] interfaces) throws InvocationTargetException {
        if (loader == null) {
            loader = JavaProxyClassFactory.class.getClassLoader();
        }
        if (superClass == null) {
            superClass = Object.class;
        }
        if (interfaces == null) {
            interfaces = EMPTY_CLASS_ARR;
        }
        if (targetClassName == null) {
            String pkg = JavaProxyClassFactory.packageName(superClass);
            String fullName = superClass.getName();
            int ix = fullName.lastIndexOf(46);
            String cName = fullName;
            if (ix != -1) {
                cName = fullName.substring(ix + 1);
            }
            if (pkg.startsWith("java.") || pkg.startsWith("javax.")) {
                pkg = JavaProxyClassFactory.packageName(JavaProxyClassFactory.class) + ".gen";
            }
            targetClassName = ix == -1 ? cName + "$Proxy" + counter++ : pkg + "." + cName + "$Proxy" + counter++;
        }
        HashSet<Class> key = new HashSet<Class>();
        key.add(superClass);
        for (int i = 0; i < interfaces.length; ++i) {
            key.add(interfaces[i]);
        }
        JavaProxyClass proxyClass = (JavaProxyClass)proxies.get(key);
        if (proxyClass == null) {
            JavaProxyClassFactory.validateArgs(targetClassName, superClass);
            HashMap methods = new HashMap();
            JavaProxyClassFactory.collectMethods(superClass, interfaces, methods);
            Type selfType = Type.getType("L" + JavaProxyClassFactory.toInternalClassName(targetClassName) + ";");
            proxyClass = JavaProxyClassFactory.generate(loader, targetClassName, superClass, interfaces, methods, selfType);
            proxies.put(key, proxyClass);
        }
        return proxyClass;
    }

    private static JavaProxyClass generate(ClassLoader loader, String targetClassName, Class superClass, Class[] interfaces, Map methods, Type selfType) {
        ClassWriter cw = JavaProxyClassFactory.beginProxyClass(targetClassName, superClass, interfaces);
        GeneratorAdapter clazzInit = JavaProxyClassFactory.createClassInitializer(selfType, cw);
        JavaProxyClassFactory.generateConstructors(superClass, selfType, cw);
        JavaProxyClassFactory.generateGetProxyClass(selfType, cw);
        JavaProxyClassFactory.generateGetInvocationHandler(selfType, cw);
        JavaProxyClassFactory.generateProxyMethods(superClass, methods, selfType, cw, clazzInit);
        clazzInit.returnValue();
        clazzInit.endMethod();
        cw.visitEnd();
        byte[] data = cw.toByteArray();
        Class clazz = JavaProxyClassFactory.invokeDefineClass(loader, selfType.getClassName(), data);
        try {
            Field proxy_class = clazz.getDeclaredField(PROXY_CLASS_FIELD_NAME);
            proxy_class.setAccessible(true);
            return (JavaProxyClass)proxy_class.get(clazz);
        }
        catch (Exception ex) {
            InternalError ie = new InternalError();
            ie.initCause(ex);
            throw ie;
        }
    }

    private static Class invokeDefineClass(ClassLoader loader, String className, byte[] data) {
        try {
            return (Class)defineClass_method.invoke((Object)loader, className, data, new Integer(0), new Integer(data.length));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ClassWriter beginProxyClass(String targetClassName, Class superClass, Class[] interfaces) {
        ClassWriter cw = new ClassWriter(true);
        int access = 25;
        String name = JavaProxyClassFactory.toInternalClassName(targetClassName);
        String signature = null;
        String supername = JavaProxyClassFactory.toInternalClassName(superClass);
        String[] interfaceNames = new String[interfaces.length + 1];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = JavaProxyClassFactory.toInternalClassName(interfaces[i]);
        }
        interfaceNames[interfaces.length] = JavaProxyClassFactory.toInternalClassName(InternalJavaProxy.class);
        cw.visit(47, access, name, signature, supername, interfaceNames);
        cw.visitField(2, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE.getDescriptor(), null, null).visitEnd();
        cw.visitField(10, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE.getDescriptor(), null, null).visitEnd();
        return cw;
    }

    private static void generateProxyMethods(Class superClass, Map methods, Type selfType, ClassVisitor cw, GeneratorAdapter clazzInit) {
        for (MethodData md : methods.values()) {
            Type superClassType = Type.getType(superClass);
            JavaProxyClassFactory.generateProxyMethod(selfType, superClassType, cw, clazzInit, md);
        }
    }

    private static void generateGetInvocationHandler(Type selfType, ClassVisitor cw) {
        GeneratorAdapter gh = new GeneratorAdapter(1, new Method("___getInvocationHandler", INVOCATION_HANDLER_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, cw);
        gh.loadThis();
        gh.getField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        gh.returnValue();
        gh.endMethod();
    }

    private static void generateGetProxyClass(Type selfType, ClassVisitor cw) {
        GeneratorAdapter gpc = new GeneratorAdapter(1, new Method("___getProxyClass", PROXY_CLASS_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, cw);
        gpc.getStatic(selfType, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE);
        gpc.returnValue();
        gpc.endMethod();
    }

    private static void generateConstructors(Class superClass, Type selfType, ClassVisitor cw) {
        Constructor<?>[] cons = superClass.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> constructor = cons[i];
            int acc = constructor.getModifiers();
            if (!Modifier.isProtected(acc) && !Modifier.isPublic(acc) && (Modifier.isPrivate(acc) || !JavaProxyClassFactory.packageName(constructor.getDeclaringClass()).equals(JavaProxyClassFactory.packageName(selfType.getClassName())))) continue;
            JavaProxyClassFactory.generateConstructor(selfType, constructor, cw);
        }
    }

    private static GeneratorAdapter createClassInitializer(Type selfType, ClassVisitor cw) {
        GeneratorAdapter clazzInit = new GeneratorAdapter(10, new Method("<clinit>", Type.VOID_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, cw);
        clazzInit.visitLdcInsn(selfType.getClassName());
        clazzInit.invokeStatic(JAVA_LANG_CLASS_TYPE, CLASS_FORNAME_METHOD);
        clazzInit.invokeStatic(PROXY_HELPER_TYPE, HELPER_GET_PROXY_CLASS_METHOD);
        clazzInit.dup();
        clazzInit.putStatic(selfType, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE);
        return clazzInit;
    }

    private static void generateProxyMethod(Type selfType, Type superType, ClassVisitor cw, GeneratorAdapter clazzInit, MethodData md) {
        if (!md.generateProxyMethod()) {
            return;
        }
        Method m = md.getMethod();
        Type[] ex = JavaProxyClassFactory.toType(md.getExceptions());
        String field_name = "__mth$" + md.getName() + md.scrabmledSignature();
        FieldVisitor fv = cw.visitField(10, field_name, PROXY_METHOD_TYPE.getDescriptor(), null, null);
        fv.visitEnd();
        clazzInit.dup();
        clazzInit.push(m.getName());
        clazzInit.push(m.getDescriptor());
        clazzInit.push(md.isImplemented());
        clazzInit.invokeStatic(PROXY_HELPER_TYPE, PROXY_HELPER_GET_METHOD);
        clazzInit.putStatic(selfType, field_name, PROXY_METHOD_TYPE);
        Method sm = new Method("__super$" + m.getName(), m.getReturnType(), m.getArgumentTypes());
        GeneratorAdapter ga = new GeneratorAdapter(1, m, null, ex, cw);
        ga.loadThis();
        ga.getField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        if (md.isImplemented()) {
            ga.dup();
            Label ok = ga.newLabel();
            ga.ifNonNull(ok);
            ga.loadThis();
            ga.loadArgs();
            ga.invokeConstructor(superType, m);
            ga.returnValue();
            ga.mark(ok);
        }
        ga.loadThis();
        ga.getStatic(selfType, field_name, PROXY_METHOD_TYPE);
        if (m.getArgumentTypes().length == 0) {
            ga.getStatic(JAVA_PROXY_TYPE, "NO_ARGS", Type.getType(Object[].class));
        } else {
            ga.loadArgArray();
        }
        Label before = ga.mark();
        ga.invokeInterface(INVOCATION_HANDLER_TYPE, INVOCATION_HANDLER_INVOKE_METHOD);
        Label after = ga.mark();
        ga.unbox(m.getReturnType());
        ga.returnValue();
        Label rethrow = ga.mark();
        ga.visitInsn(191);
        for (int i = 0; i < ex.length; ++i) {
            ga.visitTryCatchBlock(before, after, rethrow, ex[i].getInternalName());
        }
        ga.visitTryCatchBlock(before, after, rethrow, "java/lang/Error");
        ga.visitTryCatchBlock(before, after, rethrow, "java/lang/RuntimeException");
        Type thr = Type.getType(Throwable.class);
        Label handler = ga.mark();
        Type udt = Type.getType(UndeclaredThrowableException.class);
        int loc = ga.newLocal(thr);
        ga.storeLocal(loc, thr);
        ga.newInstance(udt);
        ga.dup();
        ga.loadLocal(loc, thr);
        ga.invokeConstructor(udt, Method.getMethod("void <init>(java.lang.Throwable)"));
        ga.throwException();
        ga.visitTryCatchBlock(before, after, handler, "java/lang/Throwable");
        ga.endMethod();
        if (md.isImplemented()) {
            GeneratorAdapter ga2 = new GeneratorAdapter(1, sm, null, ex, cw);
            ga2.loadThis();
            ga2.loadArgs();
            ga2.invokeConstructor(superType, m);
            ga2.returnValue();
            ga2.endMethod();
        }
    }

    private static Class[] generateConstructor(Type selfType, Constructor constructor, ClassVisitor cw) {
        Class[] superConstructorParameterTypes = constructor.getParameterTypes();
        Class[] newConstructorParameterTypes = new Class[superConstructorParameterTypes.length + 1];
        System.arraycopy(superConstructorParameterTypes, 0, newConstructorParameterTypes, 0, superConstructorParameterTypes.length);
        newConstructorParameterTypes[superConstructorParameterTypes.length] = JavaProxyInvocationHandler.class;
        int access = 1;
        String name1 = "<init>";
        String signature = null;
        Class[] superConstructorExceptions = constructor.getExceptionTypes();
        Method super_m = new Method(name1, Type.VOID_TYPE, JavaProxyClassFactory.toType(superConstructorParameterTypes));
        Method m = new Method(name1, Type.VOID_TYPE, JavaProxyClassFactory.toType(newConstructorParameterTypes));
        GeneratorAdapter ga = new GeneratorAdapter(access, m, signature, JavaProxyClassFactory.toType(superConstructorExceptions), cw);
        ga.loadThis();
        ga.loadArgs(0, superConstructorParameterTypes.length);
        ga.invokeConstructor(Type.getType(constructor.getDeclaringClass()), super_m);
        ga.loadThis();
        ga.loadArg(superConstructorParameterTypes.length);
        ga.putField(selfType, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        ga.returnValue();
        ga.endMethod();
        return newConstructorParameterTypes;
    }

    private static String toInternalClassName(Class clazz) {
        return JavaProxyClassFactory.toInternalClassName(clazz.getName());
    }

    private static String toInternalClassName(String name) {
        return name.replace('.', '/');
    }

    private static Type[] toType(Class[] parameterTypes) {
        Type[] result = new Type[parameterTypes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Type.getType(parameterTypes[i]);
        }
        return result;
    }

    private static void collectMethods(Class superClass, Class[] interfaces, Map methods) {
        HashSet allClasses = new HashSet();
        JavaProxyClassFactory.addClass(allClasses, methods, superClass);
        JavaProxyClassFactory.addInterfaces(allClasses, methods, interfaces);
    }

    private static void addInterfaces(Set allClasses, Map methods, Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            JavaProxyClassFactory.addInterface(allClasses, methods, interfaces[i]);
        }
    }

    private static void addInterface(Set allClasses, Map methods, Class interfaze) {
        if (allClasses.add(interfaze)) {
            JavaProxyClassFactory.addMethods(methods, interfaze);
            JavaProxyClassFactory.addInterfaces(allClasses, methods, interfaze.getInterfaces());
        }
    }

    private static void addMethods(Map methods, Class classOrInterface) {
        java.lang.reflect.Method[] mths = classOrInterface.getDeclaredMethods();
        for (int i = 0; i < mths.length; ++i) {
            JavaProxyClassFactory.addMethod(methods, mths[i]);
        }
    }

    private static void addMethod(Map methods, java.lang.reflect.Method method) {
        int acc = method.getModifiers();
        if (Modifier.isStatic(acc) || Modifier.isPrivate(acc)) {
            return;
        }
        MethodKey mk = new MethodKey(method);
        MethodData md = (MethodData)methods.get(mk);
        if (md == null) {
            md = new MethodData(method);
            methods.put(mk, md);
        }
        md.add(method);
    }

    private static void addClass(Set allClasses, Map methods, Class clazz) {
        if (allClasses.add(clazz)) {
            JavaProxyClassFactory.addMethods(methods, clazz);
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                JavaProxyClassFactory.addClass(allClasses, methods, superClass);
            }
            JavaProxyClassFactory.addInterfaces(allClasses, methods, clazz.getInterfaces());
        }
    }

    private static void validateArgs(String targetClassName, Class superClass) {
        if (Modifier.isFinal(superClass.getModifiers())) {
            throw new IllegalArgumentException("cannot extend final class");
        }
        String targetPackage = JavaProxyClassFactory.packageName(targetClassName);
        String pkg = targetPackage.replace('.', '/');
        if (pkg.startsWith("java")) {
            throw new IllegalArgumentException("cannor add classes to package " + pkg);
        }
        Package p = Package.getPackage(pkg);
        if (p != null && p.isSealed()) {
            throw new IllegalArgumentException("package " + p + " is sealed");
        }
    }

    private static String packageName(Class clazz) {
        String clazzName = clazz.getName();
        return JavaProxyClassFactory.packageName(clazzName);
    }

    private static String packageName(String clazzName) {
        int idx = clazzName.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return clazzName.substring(0, idx);
    }

    static {
        proxies = new HashMap();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    defineClass_method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                defineClass_method.setAccessible(true);
                return null;
            }
        });
    }

    static class MethodKey {
        private String name;
        private Class[] arguments;

        MethodKey(java.lang.reflect.Method m) {
            this.name = m.getName();
            this.arguments = m.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey key = (MethodKey)obj;
                return this.name.equals(key.name) && Arrays.equals(this.arguments, key.arguments);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    static class MethodData {
        Set methods = new HashSet();
        final java.lang.reflect.Method mostSpecificMethod;
        final Class[] mostSpecificParameterTypes;
        boolean hasPublicDecl = false;

        MethodData(java.lang.reflect.Method method) {
            this.mostSpecificMethod = method;
            this.mostSpecificParameterTypes = this.mostSpecificMethod.getParameterTypes();
            this.hasPublicDecl = method.getDeclaringClass().isInterface() || Modifier.isPublic(method.getModifiers());
        }

        public String scrabmledSignature() {
            StringBuffer sb = new StringBuffer();
            Class[] parms = this.getParameterTypes();
            for (int i = 0; i < parms.length; ++i) {
                sb.append('$');
                String name = parms[i].getName();
                name = name.replace('[', '1');
                name = name.replace('.', '_');
                name = name.replace(';', '2');
                sb.append(name);
            }
            return sb.toString();
        }

        public Class getDeclaringClass() {
            return this.mostSpecificMethod.getDeclaringClass();
        }

        public Method getMethod() {
            return new Method(this.getName(), Type.getType(this.getReturnType()), this.getType(this.getParameterTypes()));
        }

        private Type[] getType(Class[] parameterTypes) {
            Type[] result = new Type[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                result[i] = Type.getType(parameterTypes[i]);
            }
            return result;
        }

        private String getName() {
            return this.mostSpecificMethod.getName();
        }

        private Class[] getParameterTypes() {
            return this.mostSpecificParameterTypes;
        }

        public Class[] getExceptions() {
            HashSet all = new HashSet();
            for (java.lang.reflect.Method m : this.methods) {
                Class<?>[] ex = m.getExceptionTypes();
                for (int i = 0; i < ex.length; ++i) {
                    Class<?> exx = ex[i];
                    if (all.contains(exx)) continue;
                    boolean add = true;
                    Iterator it2 = all.iterator();
                    while (it2.hasNext()) {
                        Class de = (Class)it2.next();
                        if (de.isAssignableFrom(exx)) {
                            add = false;
                            break;
                        }
                        if (!exx.isAssignableFrom(de)) continue;
                        it2.remove();
                        add = true;
                    }
                    if (!add) continue;
                    all.add(exx);
                }
            }
            return all.toArray(new Class[all.size()]);
        }

        public boolean generateProxyMethod() {
            return !this.isFinal() && this.hasPublicDecl;
        }

        public void add(java.lang.reflect.Method method) {
            this.methods.add(method);
            this.hasPublicDecl |= Modifier.isPublic(method.getModifiers());
        }

        Class getReturnType() {
            return this.mostSpecificMethod.getReturnType();
        }

        boolean isFinal() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            int mod = this.mostSpecificMethod.getModifiers();
            return Modifier.isFinal(mod);
        }

        boolean isImplemented() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            int mod = this.mostSpecificMethod.getModifiers();
            return !Modifier.isAbstract(mod);
        }
    }
}

