/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.ByteList;
import org.jruby.util.collections.IntHashMap;

public class Java {
    public static RubyModule createJavaModule(Ruby runtime) {
        RubyModule javaModule = runtime.defineModule("Java");
        CallbackFactory callbackFactory = runtime.callbackFactory(Java.class);
        javaModule.defineModuleFunction("define_exception_handler", callbackFactory.getOptSingletonMethod("define_exception_handler"));
        javaModule.defineModuleFunction("primitive_to_java", callbackFactory.getSingletonMethod("primitive_to_java", IRubyObject.class));
        javaModule.defineModuleFunction("java_to_primitive", callbackFactory.getSingletonMethod("java_to_primitive", IRubyObject.class));
        javaModule.defineModuleFunction("java_to_ruby", callbackFactory.getSingletonMethod("java_to_ruby", IRubyObject.class));
        javaModule.defineModuleFunction("ruby_to_java", callbackFactory.getSingletonMethod("ruby_to_java", IRubyObject.class));
        javaModule.defineModuleFunction("new_proxy_instance", callbackFactory.getOptSingletonMethod("new_proxy_instance"));
        JavaObject.createJavaObjectClass(runtime, javaModule);
        JavaArray.createJavaArrayClass(runtime, javaModule);
        JavaClass.createJavaClassClass(runtime, javaModule);
        JavaMethod.createJavaMethodClass(runtime, javaModule);
        JavaConstructor.createJavaConstructorClass(runtime, javaModule);
        JavaField.createJavaFieldClass(runtime, javaModule);
        JavaProxyClass.createJavaProxyModule(runtime);
        RubyModule javaUtils = runtime.defineModule("JavaUtilities");
        javaUtils.defineFastModuleFunction("wrap", callbackFactory.getFastSingletonMethod("wrap", IRubyObject.class));
        javaUtils.defineFastModuleFunction("valid_constant_name?", callbackFactory.getFastSingletonMethod("valid_constant_name_p", IRubyObject.class));
        javaUtils.defineFastModuleFunction("primitive_match", callbackFactory.getFastSingletonMethod("primitive_match", IRubyObject.class, IRubyObject.class));
        javaUtils.defineFastModuleFunction("access", callbackFactory.getFastSingletonMethod("access", IRubyObject.class));
        javaUtils.defineFastModuleFunction("matching_method", callbackFactory.getFastSingletonMethod("matching_method", IRubyObject.class, IRubyObject.class));
        javaUtils.defineFastModuleFunction("get_proxy_class", callbackFactory.getFastSingletonMethod("get_proxy_class", IRubyObject.class));
        javaUtils.defineFastModuleFunction("add_proxy_extender", callbackFactory.getFastSingletonMethod("add_proxy_extender", IRubyObject.class));
        javaUtils.dataWrapStruct(new ProxyData(callbackFactory.getFastSingletonMethod("concrete_proxy_inherited", IRubyObject.class)));
        RubyClass javaProxy = runtime.defineClass("JavaProxy", runtime.getObject(), runtime.getObject().getAllocator());
        javaProxy.getMetaClass().defineFastMethod("new_instance_for", callbackFactory.getFastSingletonMethod("new_instance_for", IRubyObject.class));
        javaProxy.getMetaClass().defineFastMethod("to_java_object", callbackFactory.getFastSingletonMethod("to_java_object"));
        return javaModule;
    }

    public static IRubyObject new_instance_for(IRubyObject recv, IRubyObject java_object) {
        IRubyObject new_instance = ((RubyClass)recv).allocate();
        new_instance.setInstanceVariable("@java_object", java_object);
        return new_instance;
    }

    public static IRubyObject to_java_object(IRubyObject recv) {
        return recv.getInstanceVariable("@java_class");
    }

    public static IRubyObject add_proxy_extender(IRubyObject recv, IRubyObject extender) {
        ProxyData pdata = (ProxyData)recv.dataGetStruct();
        pdata.extenders.add(extender);
        ThreadContext tc = recv.getRuntime().getCurrentContext();
        Iterator iter = pdata.classes.values().iterator();
        while (iter.hasNext()) {
            extender.callMethod(tc, "extend_proxy", (IRubyObject)iter.next());
        }
        return recv.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject get_proxy_class(IRubyObject recv, IRubyObject java_class) {
        if (java_class instanceof RubyString) {
            java_class = JavaClass.for_name(recv, java_class);
        }
        int class_id = RubyNumeric.fix2int(java_class.id());
        Ruby runtime = recv.getRuntime();
        ProxyData pdata = (ProxyData)recv.dataGetStruct();
        IntHashMap proxy_classes = pdata.classes;
        IRubyObject iRubyObject = java_class;
        synchronized (iRubyObject) {
            if (proxy_classes.get(class_id) == null) {
                RubyClass base_type;
                Class c = ((JavaClass)java_class).javaClass();
                boolean concrete = false;
                boolean invokeInherited = true;
                if (c.isInterface()) {
                    base_type = runtime.getClass("InterfaceJavaProxy");
                } else if (c.isArray()) {
                    base_type = runtime.getClass("ArrayJavaProxy");
                } else {
                    concrete = true;
                    if (Object.class.equals((Object)c) || c.isPrimitive()) {
                        base_type = runtime.getClass("ConcreteJavaProxy");
                    } else {
                        base_type = (RubyClass)Java.get_proxy_class(recv, runtime.newString(c.getSuperclass().getName()));
                        invokeInherited = false;
                    }
                }
                RubyClass proxy_class = RubyClass.newClass(recv, new IRubyObject[]{base_type}, Block.NULL_BLOCK, invokeInherited);
                proxy_class.callMethod(runtime.getCurrentContext(), "java_class=", java_class);
                if (concrete && invokeInherited) {
                    proxy_class.getMetaClass().defineFastMethod("inherited", pdata.callback);
                }
                proxy_classes.put(class_id, proxy_class);
                ((JavaClass)java_class).setupProxy(proxy_class);
                Iterator iter = pdata.extenders.iterator();
                while (iter.hasNext()) {
                    ((IRubyObject)iter.next()).callMethod(runtime.getCurrentContext(), "extend_proxy", proxy_class);
                }
            }
        }
        return (IRubyObject)proxy_classes.get(class_id);
    }

    public static IRubyObject concrete_proxy_inherited(IRubyObject recv, IRubyObject subclass) {
        Ruby runtime = recv.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        RubyClass javaProxyClass = runtime.getClass("JavaProxy").getMetaClass();
        recv.callMethod(tc, javaProxyClass, "inherited", new IRubyObject[]{subclass}, CallType.SUPER, Block.NULL_BLOCK);
        return runtime.getModule("JavaUtilities").callMethod(tc, "setup_java_subclass", new IRubyObject[]{subclass, recv.callMethod(tc, "java_class")});
    }

    public static boolean useJavaPackageModules(Ruby runtime) {
        RubyString javaModuleVar = runtime.newString("JRUBY_JAVA_MODULES");
        RubyHash h = (RubyHash)runtime.getObject().getConstant("ENV");
        IRubyObject useMods = h.aref(javaModuleVar);
        return useMods == null || !(useMods instanceof RubyString) || !"false".equals(useMods.toString());
    }

    private static void addToJavaPackageModule(RubyClass proxyClass, JavaClass javaClass) {
        int endPackage;
        Class clazz = javaClass.javaClass();
        String fullName = clazz.getName();
        if (fullName == null || (endPackage = fullName.lastIndexOf(46)) == -1 || fullName.indexOf(36) != -1 || !Character.isUpperCase(fullName.charAt(endPackage + 1))) {
            return;
        }
        Ruby runtime = proxyClass.getRuntime();
        RubyModule parent = runtime.getModule("Java");
        int start = 0;
        int offset = 0;
        while (start < endPackage) {
            offset = fullName.indexOf(46, start);
            String moduleName = fullName.substring(start, offset).toUpperCase();
            IRubyObject child = parent.getConstantAt(moduleName);
            if (child == null) {
                child = parent.defineModuleUnder(moduleName);
            } else if (!(child instanceof RubyModule)) {
                return;
            }
            parent = (RubyModule)child;
            start = offset + 1;
        }
        String className = fullName.substring(endPackage + 1);
        if (parent.getConstantAt(className) == null) {
            parent.const_set(runtime.newSymbol(className), proxyClass);
        }
    }

    public static IRubyObject matching_method(IRubyObject recv, IRubyObject methods, IRubyObject args) {
        Map matchCache = ((ProxyData)recv.dataGetStruct()).matchCache;
        ArrayList<Object> arg_types = new ArrayList<Object>();
        int alen = ((RubyArray)args).getLength();
        IRubyObject[] aargs = ((RubyArray)args).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < alen; ++i) {
            arg_types.add(((JavaClass)((JavaObject)aargs[i]).java_class()).getValue());
        }
        HashMap<ArrayList<Object>, IRubyObject> ms = (HashMap<ArrayList<Object>, IRubyObject>)matchCache.get(methods);
        if (ms == null) {
            ms = new HashMap<ArrayList<Object>, IRubyObject>();
            matchCache.put(methods, ms);
        } else {
            IRubyObject method = (IRubyObject)ms.get(arg_types);
            if (method != null) {
                return method;
            }
        }
        int mlen = ((RubyArray)methods).getLength();
        IRubyObject[] margs = ((RubyArray)methods).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < mlen; ++k) {
                List<Class> types = null;
                IRubyObject method = margs[k];
                if (method instanceof JavaCallable) {
                    types = Arrays.asList(((JavaCallable)method).parameterTypes());
                } else if (method instanceof JavaProxyMethod) {
                    types = Arrays.asList(((JavaProxyMethod)method).getParameterTypes());
                } else if (method instanceof JavaProxyConstructor) {
                    types = Arrays.asList(((JavaProxyConstructor)method).getParameterTypes());
                }
                if (arg_types.size() != types.size()) continue;
                if (types.equals(arg_types)) {
                    ms.put(arg_types, method);
                    return method;
                }
                boolean match = true;
                for (int j = 0; j < types.size(); ++j) {
                    if (JavaClass.assignable(types.get(j), (Class)arg_types.get(j)) && (i > 0 || Java.primitive_match(types.get(j), arg_types.get(j)))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                ms.put(arg_types, method);
                return method;
            }
        }
        IRubyObject o1 = margs[0];
        if (o1 instanceof JavaConstructor || o1 instanceof JavaProxyConstructor) {
            throw recv.getRuntime().newNameError("no constructor with arguments matching " + arg_types, null);
        }
        throw recv.getRuntime().newNameError("no " + ((JavaMethod)o1).name() + " with arguments matching " + arg_types, null);
    }

    public static IRubyObject matching_method_internal(IRubyObject recv, IRubyObject methods, IRubyObject[] args, int start, int len) {
        IRubyObject method;
        Class[] types;
        int k;
        Map matchCache = ((ProxyData)recv.dataGetStruct()).matchCache;
        ArrayList<Object> arg_types = new ArrayList<Object>();
        int aend = start + len;
        for (int i = start; i < aend; ++i) {
            arg_types.add(((JavaClass)((JavaObject)args[i]).java_class()).getValue());
        }
        HashMap<ArrayList<Object>, IRubyObject> ms = (HashMap<ArrayList<Object>, IRubyObject>)matchCache.get(methods);
        if (ms == null) {
            ms = new HashMap<ArrayList<Object>, IRubyObject>();
            matchCache.put(methods, ms);
        } else {
            IRubyObject method2 = (IRubyObject)ms.get(arg_types);
            if (method2 != null) {
                return method2;
            }
        }
        int mlen = ((RubyArray)methods).getLength();
        IRubyObject[] margs = ((RubyArray)methods).toJavaArrayMaybeUnsafe();
        block1: for (k = 0; k < mlen; ++k) {
            types = null;
            method = margs[k];
            if (method instanceof JavaCallable) {
                types = ((JavaCallable)method).parameterTypes();
            } else if (method instanceof JavaProxyMethod) {
                types = ((JavaProxyMethod)method).getParameterTypes();
            } else if (method instanceof JavaProxyConstructor) {
                types = ((JavaProxyConstructor)method).getParameterTypes();
            }
            if (len != types.length) continue;
            boolean same = true;
            int y = len;
            for (int x = 0; x < y; ++x) {
                if (types[x].equals(arg_types.get(x))) continue;
                same = false;
                break;
            }
            if (same) {
                ms.put(arg_types, method);
                return method;
            }
            int m = len;
            for (int j = 0; j < m; ++j) {
                if (!JavaClass.assignable(types[j], (Class)arg_types.get(j)) || !Java.primitive_match(types[j], arg_types.get(j))) continue block1;
            }
            ms.put(arg_types, method);
            return method;
        }
        block4: for (k = 0; k < mlen; ++k) {
            types = null;
            method = margs[k];
            if (method instanceof JavaCallable) {
                types = ((JavaCallable)method).parameterTypes();
            } else if (method instanceof JavaProxyMethod) {
                types = ((JavaProxyMethod)method).getParameterTypes();
            } else if (method instanceof JavaProxyConstructor) {
                types = ((JavaProxyConstructor)method).getParameterTypes();
            }
            if (len != types.length) continue;
            int m = len;
            for (int j = 0; j < m; ++j) {
                if (!JavaClass.assignable(types[j], (Class)arg_types.get(j))) continue block4;
            }
            ms.put(arg_types, method);
            return method;
        }
        IRubyObject o1 = margs[0];
        if (o1 instanceof JavaConstructor || o1 instanceof JavaProxyConstructor) {
            throw recv.getRuntime().newNameError("no constructor with arguments matching " + arg_types, null);
        }
        throw recv.getRuntime().newNameError("no " + ((JavaMethod)o1).name() + " with arguments matching " + arg_types, null);
    }

    public static IRubyObject access(IRubyObject recv, IRubyObject java_type) {
        int modifiers = ((JavaClass)java_type).javaClass().getModifiers();
        return recv.getRuntime().newString(Modifier.isPublic(modifiers) ? "public" : (Modifier.isProtected(modifiers) ? "protected" : "private"));
    }

    public static IRubyObject valid_constant_name_p(IRubyObject recv, IRubyObject name) {
        RubyString sname = name.convertToString();
        if (sname.getByteList().length() == 0) {
            return recv.getRuntime().getFalse();
        }
        return Character.isUpperCase(sname.getByteList().charAt(0)) ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static boolean primitive_match(Object v1, Object v2) {
        if (((Class)v1).isPrimitive()) {
            if (v1 == Integer.TYPE || v1 == Long.TYPE || v1 == Short.TYPE || v1 == Character.TYPE) {
                return v2 == Integer.class || v2 == Long.class || v2 == Short.class || v2 == Character.class;
            }
            if (v1 == Float.TYPE || v1 == Double.TYPE) {
                return v2 == Float.class || v2 == Double.class;
            }
            if (v1 == Boolean.TYPE) {
                return v2 == Boolean.class;
            }
            return false;
        }
        return true;
    }

    public static IRubyObject primitive_match(IRubyObject recv, IRubyObject t1, IRubyObject t2) {
        if (((JavaClass)t1).primitive_p().isTrue()) {
            Object v2;
            Object v1 = ((JavaObject)t1).getValue();
            return Java.primitive_match(v1, v2 = ((JavaObject)t2).getValue()) ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
        }
        return recv.getRuntime().getTrue();
    }

    public static IRubyObject wrap(IRubyObject recv, IRubyObject java_object) {
        return Java.new_instance_for(Java.get_proxy_class(recv, ((JavaObject)java_object).java_class()), java_object);
    }

    public static IRubyObject define_exception_handler(IRubyObject recv, IRubyObject[] args, Block block) {
        String name = args[0].toString();
        RubyProc handler = null;
        handler = args.length > 1 ? (RubyProc)args[1] : recv.getRuntime().newProc(false, block);
        recv.getRuntime().getJavaSupport().defineExceptionHandler(name, handler);
        return recv;
    }

    public static IRubyObject primitive_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        Object javaObject;
        if (object instanceof JavaObject) {
            return object;
        }
        Ruby runtime = recv.getRuntime();
        switch (object.getMetaClass().index) {
            case 5: {
                javaObject = null;
                break;
            }
            case 1: {
                javaObject = new Long(((RubyFixnum)object).getLongValue());
                break;
            }
            case 2: {
                javaObject = ((RubyBignum)object).getValue();
                break;
            }
            case 11: {
                javaObject = new Double(((RubyFloat)object).getValue());
                break;
            }
            case 4: {
                try {
                    ByteList bytes = ((RubyString)object).getByteList();
                    javaObject = new String(bytes.unsafeBytes(), bytes.begin(), bytes.length(), "UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    javaObject = object.toString();
                }
                break;
            }
            case 6: {
                javaObject = Boolean.TRUE;
                break;
            }
            case 7: {
                javaObject = Boolean.FALSE;
                break;
            }
            default: {
                javaObject = object instanceof RubyTime ? ((RubyTime)object).getJavaDate() : object;
            }
        }
        return JavaObject.wrap(runtime, javaObject);
    }

    public static IRubyObject java_to_ruby(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject && (object = JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue())) instanceof JavaObject) {
            return Java.wrap(recv.getRuntime().getModule("JavaUtilities"), object);
        }
        return object;
    }

    public static IRubyObject ruby_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object.respondsTo("to_java_object")) {
            IRubyObject result = object.getInstanceVariable("@java_object");
            if (result == null) {
                result = object.callMethod(recv.getRuntime().getCurrentContext(), "to_java_object");
            }
            return result;
        }
        return Java.primitive_to_java(recv, object, unusedBlock);
    }

    public static IRubyObject java_to_primitive(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    public static IRubyObject new_proxy_instance(final IRubyObject recv, IRubyObject[] args, Block block) {
        RubyProc proc;
        int size = Arity.checkArgumentCount(recv.getRuntime(), args, 1, -1) - 1;
        if (args[size] instanceof RubyProc) {
            proc = (RubyProc)args[size];
        } else {
            proc = recv.getRuntime().newProc(false, block);
            ++size;
        }
        Class[] interfaces = new Class[size];
        for (int i = 0; i < size; ++i) {
            if (!(args[i] instanceof JavaClass) || !((JavaClass)args[i]).interface_p().isTrue()) {
                throw recv.getRuntime().newArgumentError("Java interface expected.");
            }
            interfaces[i] = ((JavaClass)args[i]).javaClass();
        }
        return JavaObject.wrap(recv.getRuntime(), Proxy.newProxyInstance(recv.getRuntime().getJavaSupport().getJavaClassLoader(), interfaces, new InvocationHandler(){
            private Map parameterTypeCache = new HashMap();

            @Override
            public Object invoke(Object proxy, Method method, Object[] nargs) throws Throwable {
                Class[] parameterTypes = (Class[])this.parameterTypeCache.get(method);
                if (parameterTypes == null) {
                    parameterTypes = method.getParameterTypes();
                    this.parameterTypeCache.put(method, parameterTypes);
                }
                int methodArgsLength = parameterTypes.length;
                String methodName = method.getName();
                if (methodName.equals("toString") && methodArgsLength == 0) {
                    return proxy.getClass().getName();
                }
                if (methodName.equals("hashCode") && methodArgsLength == 0) {
                    return new Integer(proxy.getClass().hashCode());
                }
                if (methodName.equals("equals") && methodArgsLength == 1 && parameterTypes[0].equals(Object.class)) {
                    return proxy == nargs[0];
                }
                int length = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length + 2];
                rubyArgs[0] = JavaObject.wrap(recv.getRuntime(), proxy);
                rubyArgs[1] = new JavaMethod(recv.getRuntime(), method);
                for (int i = 0; i < length; ++i) {
                    rubyArgs[i + 2] = JavaObject.wrap(recv.getRuntime(), nargs[i]);
                }
                return JavaUtil.convertArgument(proc.call(rubyArgs), method.getReturnType());
            }
        }));
    }

    private static final class ProxyData {
        public final IntHashMap classes = new IntHashMap();
        public final List extenders = new ArrayList();
        public final Map matchCache = new HashMap();
        public final Callback callback;

        public ProxyData(Callback c) {
            this.callback = c;
        }
    }
}

