/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import jregex.Pattern;
import jregex.PatternSyntaxException;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.Opcodes;
import org.jruby.MetaClass;
import org.jruby.RegexpTranslator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.collections.SinglyLinkedList;

public class StandardASMCompiler
implements Compiler,
Opcodes {
    private static final CodegenUtils cg = CodegenUtils.instance;
    private static final String THREADCONTEXT = CodegenUtils.p(ThreadContext.class);
    private static final String RUBY = CodegenUtils.p(Ruby.class);
    private static final String IRUBYOBJECT = CodegenUtils.p(IRubyObject.class);
    private static final String METHOD_SIGNATURE = CodegenUtils.sig(IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class});
    private static final String CLOSURE_SIGNATURE = CodegenUtils.sig(IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class, IRubyObject[][].class});
    private static final int THREADCONTEXT_INDEX = 0;
    private static final int SELF_INDEX = 1;
    private static final int ARGS_INDEX = 2;
    private static final int CLOSURE_INDEX = 3;
    private static final int SCOPE_INDEX = 4;
    private static final int RUNTIME_INDEX = 5;
    private static final int LOCAL_VARS_INDEX = 6;
    private Stack SkinnyMethodAdapters = new Stack();
    private Stack arities = new Stack();
    private Stack scopeStarts = new Stack();
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    ClassWriter currentMultiStub = null;
    int methodIndex = -1;
    int multiStubCount = -1;
    int innerIndex = -1;
    int lastLine = -1;
    boolean isCompilingClosure;
    private int constants = 0;
    private static final RegexpTranslator TRANS = new RegexpTranslator();

    public StandardASMCompiler(String classname, String sourcename) {
        this.classname = classname;
        this.sourcename = sourcename;
    }

    public StandardASMCompiler(Node node) {
        this.classname = "EVAL" + this.hashCode();
        this.sourcename = "EVAL" + this.hashCode();
    }

    public Class loadClass(Ruby runtime) throws ClassNotFoundException {
        JRubyClassLoader jcl = runtime.getJRubyClassLoader();
        jcl.defineClass(CodegenUtils.c(this.classname), this.classWriter.toByteArray());
        return jcl.loadClass(CodegenUtils.c(this.classname));
    }

    public void writeClass(File destination) throws IOException {
        this.writeClass(this.classname, destination, this.classWriter);
    }

    private void writeClass(String classname, File destination, ClassWriter writer) throws IOException {
        String fullname = classname + ".class";
        String filename = null;
        String path = null;
        if (fullname.lastIndexOf("/") == -1) {
            filename = fullname;
            path = "";
        } else {
            filename = fullname.substring(fullname.lastIndexOf("/") + 1);
            path = fullname.substring(0, fullname.lastIndexOf("/"));
        }
        File pathfile = new File(destination, path);
        pathfile.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(pathfile, filename));
        out.write(writer.toByteArray());
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    public SkinnyMethodAdapter getMethodAdapter() {
        return (SkinnyMethodAdapter)this.SkinnyMethodAdapters.peek();
    }

    public SkinnyMethodAdapter popMethodAdapter() {
        return (SkinnyMethodAdapter)this.SkinnyMethodAdapters.pop();
    }

    public void pushMethodAdapter(SkinnyMethodAdapter mv) {
        this.SkinnyMethodAdapters.push(mv);
    }

    public int getArity() {
        return (Integer)this.arities.peek();
    }

    public void pushArity(int arity) {
        this.arities.push(new Integer(arity));
    }

    public int popArity() {
        return (Integer)this.arities.pop();
    }

    public void pushScopeStart(Label start) {
        this.scopeStarts.push(start);
    }

    public Label popScopeStart() {
        return (Label)this.scopeStarts.pop();
    }

    @Override
    public void startScript() {
        this.classWriter = new ClassWriter(true);
        String[] stringArray = new String[1];
        stringArray[0] = CodegenUtils.p(Script.class);
        this.classWriter.visit(48, 33, this.classname, null, CodegenUtils.p(Object.class), stringArray);
        this.classWriter.visitSource(this.sourcename, null);
        this.createConstructor();
    }

    @Override
    public void endScript() {
        String methodName = "__file__";
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "run", METHOD_SIGNATURE, null, null));
        mv.start();
        mv.aload(1);
        mv.aload(2);
        mv.aload(3);
        mv.aload(4);
        mv.invokestatic(this.classname, methodName, METHOD_SIGNATURE);
        mv.areturn();
        mv.end();
        mv = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, "main", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String[].class)), null, null));
        mv.start();
        mv.newobj(this.classname);
        mv.dup();
        mv.invokespecial(this.classname, "<init>", CodegenUtils.sig(Void.TYPE));
        mv.invokestatic(CodegenUtils.p(Ruby.class), "getDefaultInstance", CodegenUtils.sig(Ruby.class));
        mv.dup();
        mv.invokevirtual(RUBY, "getCurrentContext", CodegenUtils.sig(ThreadContext.class));
        mv.swap();
        mv.invokevirtual(RUBY, "getTopSelf", CodegenUtils.sig(IRubyObject.class));
        mv.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        mv.invokevirtual(this.classname, "run", METHOD_SIGNATURE);
        mv.voidreturn();
        mv.end();
    }

    private void createConstructor() {
        ClassVisitor cv = this.getClassVisitor();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE), null, null));
        mv.start();
        mv.aload(0);
        mv.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE));
        mv.voidreturn();
        mv.end();
    }

    @Override
    public Object beginMethod(String friendlyName, int arity, int localVarCount) {
        SkinnyMethodAdapter newMethod = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, friendlyName, METHOD_SIGNATURE, null, null));
        this.pushMethodAdapter(newMethod);
        newMethod.start();
        newMethod.aload(0);
        this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
        newMethod.astore(5);
        newMethod.ldc(new Integer(arity));
        newMethod.invokestatic(CodegenUtils.p(Arity.class), "createArity", CodegenUtils.sig(Arity.class, CodegenUtils.params(Integer.TYPE)));
        this.loadRuntime();
        newMethod.aload(2);
        newMethod.invokevirtual(CodegenUtils.p(Arity.class), "checkArity", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
        newMethod.ldc(new Integer(localVarCount));
        newMethod.anewarray(CodegenUtils.p(IRubyObject.class));
        newMethod.astore(6);
        newMethod.aload(2);
        newMethod.iconst_0();
        newMethod.aload(6);
        newMethod.iconst_2();
        newMethod.ldc(new Integer(arity));
        newMethod.invokestatic(CodegenUtils.p(System.class), "arraycopy", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE)));
        newMethod.aconst_null();
        newMethod.astore(4);
        Label start = new Label();
        newMethod.label(start);
        this.pushScopeStart(start);
        this.pushArity(arity);
        return newMethod;
    }

    @Override
    public void endMethod(Object token) {
        assert (token instanceof SkinnyMethodAdapter);
        SkinnyMethodAdapter mv = (SkinnyMethodAdapter)token;
        mv.areturn();
        Label end = new Label();
        mv.label(end);
        mv.visitLocalVariable("lvars", CodegenUtils.ci(IRubyObject[].class), null, this.popScopeStart(), end, 6);
        mv.end();
        this.popMethodAdapter();
        this.popArity();
    }

    @Override
    public void lineNumber(ISourcePosition position) {
        this.lastLine = position.getEndLine();
        if (this.lastLine == this.lastLine) {
            return;
        }
        Label l = new Label();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.label(l);
        mv.visitLineNumber(position.getStartLine() + 1, l);
    }

    @Override
    public void invokeAttrAssign(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.iconst_0();
        mv.arrayload();
        mv.dup_x2();
        mv.pop();
        this.invokeDynamic(name, true, true, CallType.NORMAL, null);
        mv.pop();
    }

    public static IRubyObject doInvokeDynamic(IRubyObject receiver, IRubyObject[] args, ThreadContext context, String name, IRubyObject caller, CallType callType, Block block) {
        if (receiver == caller) {
            callType = CallType.VARIABLE;
        }
        return receiver.compilerCallMethod(context, name, args, caller, callType, block);
    }

    public static IRubyObject doInvokeDynamicIndexed(IRubyObject receiver, IRubyObject[] args, ThreadContext context, byte methodIndex, String name, IRubyObject caller, CallType callType, Block block) {
        if (receiver == caller) {
            callType = CallType.VARIABLE;
        }
        return receiver.compilerCallMethodWithIndex(context, methodIndex, name, args, caller, callType, block);
    }

    @Override
    public void invokeDynamic(String name, boolean hasReceiver, boolean hasArgs, CallType callType, ClosureCallback closureArg) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        String callSig = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, IRubyObject[].class, ThreadContext.class, String.class, IRubyObject.class, CallType.class, Block.class));
        String callSigIndexed = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, IRubyObject[].class, ThreadContext.class, Byte.TYPE, String.class, IRubyObject.class, CallType.class, Block.class));
        int index = MethodIndex.getIndex(name);
        if (hasArgs) {
            if (!hasReceiver) {
                this.loadSelf();
                mv.swap();
            }
        } else if (hasReceiver) {
            mv.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        } else {
            this.loadSelf();
            mv.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        }
        this.loadThreadContext();
        if (index != 0) {
            mv.ldc(new Integer(index));
        }
        mv.ldc(name);
        this.loadSelf();
        mv.getstatic(CodegenUtils.p(CallType.class), callType.toString(), CodegenUtils.ci(CallType.class));
        if (closureArg == null) {
            mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        } else {
            closureArg.compile(this);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label tryCatch = new Label();
        if (closureArg != null) {
            mv.label(tryBegin);
        }
        if (index != 0) {
            this.invokeUtilityMethod("doInvokeDynamicIndexed", callSigIndexed);
        } else {
            this.invokeUtilityMethod("doInvokeDynamic", callSig);
        }
        if (closureArg != null) {
            mv.label(tryEnd);
            Label normalEnd = new Label();
            mv.go_to(normalEnd);
            mv.label(tryCatch);
            this.loadClosure();
            this.invokeUtilityMethod("handleJumpException", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(JumpException.class, Block.class)));
            mv.label(normalEnd);
        }
    }

    public static IRubyObject handleJumpException(JumpException je, Block block) {
        if (je.isBreakInKernelLoop()) {
            if (block == je.getTarget()) {
                je.setBreakInKernelLoop(false);
            }
            throw je;
        }
        return (IRubyObject)je.getValue();
    }

    @Override
    public void yield(boolean hasArgs) {
        this.loadClosure();
        SkinnyMethodAdapter method = this.getMethodAdapter();
        if (hasArgs) {
            method.swap();
            this.loadThreadContext();
            method.swap();
        } else {
            this.loadThreadContext();
            method.aconst_null();
        }
        this.loadSelf();
        this.getRubyClass();
        method.ldc(Boolean.FALSE);
        method.invokevirtual(CodegenUtils.p(Block.class), "yield", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class, Boolean.TYPE)));
    }

    private void invokeIRubyObject(String methodName, String signature) {
        this.getMethodAdapter().invokeinterface(IRUBYOBJECT, methodName, signature);
    }

    public void loadThreadContext() {
        this.getMethodAdapter().aload(0);
    }

    public void loadClosure() {
        this.getMethodAdapter().aload(3);
    }

    public void loadSelf() {
        this.getMethodAdapter().aload(1);
    }

    public void loadRuntime() {
        this.getMethodAdapter().aload(5);
    }

    @Override
    public void loadNil() {
        this.loadRuntime();
        this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class));
    }

    @Override
    public void loadSymbol(String symbol) {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(symbol);
        this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
    }

    @Override
    public void consumeCurrentValue() {
        this.getMethodAdapter().pop();
    }

    @Override
    public void duplicateCurrentValue() {
        this.getMethodAdapter().dup();
    }

    @Override
    public void swapValues() {
        this.getMethodAdapter().swap();
    }

    @Override
    public void retrieveSelf() {
        this.loadSelf();
    }

    @Override
    public void retrieveSelfClass() {
        this.loadSelf();
        this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class));
    }

    @Override
    public void assignLocalVariable(int index) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.aload(6);
        mv.swap();
        mv.ldc(new Integer(index));
        mv.swap();
        mv.arraystore();
    }

    @Override
    public void assignLocalVariableBlockArg(int argIndex, int varIndex) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aload(6);
        mv.ldc(new Integer(varIndex));
        mv.aload(2);
        mv.ldc(new Integer(argIndex));
        mv.arrayload();
        mv.arraystore();
    }

    @Override
    public void retrieveLocalVariable(int index) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aload(6);
        mv.ldc(new Integer(index));
        mv.arrayload();
    }

    @Override
    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
            return;
        }
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        this.loadScope(depth);
        mv.swap();
        mv.ldc(new Integer(index));
        mv.swap();
        mv.arraystore();
    }

    @Override
    public void assignLocalVariableBlockArg(int argIndex, int varIndex, int depth) {
        if (depth == 0) {
            this.assignLocalVariableBlockArg(argIndex, varIndex);
            return;
        }
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadScope(depth);
        mv.ldc(new Integer(varIndex));
        mv.aload(2);
        mv.ldc(new Integer(argIndex));
        mv.arrayload();
        mv.arraystore();
    }

    @Override
    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
            return;
        }
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadScope(depth);
        mv.ldc(new Integer(index));
        mv.arrayload();
    }

    @Override
    public void assignConstantInCurrent(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadThreadContext();
        mv.ldc(name);
        mv.dup2_x1();
        mv.pop2();
        this.invokeThreadContext("setConstantInCurrent", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
    }

    @Override
    public void assignConstantInModule(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadThreadContext();
        mv.ldc(name);
        mv.swap2();
        this.invokeThreadContext("setConstantInCurrent", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, RubyModule.class, IRubyObject.class)));
    }

    @Override
    public void assignConstantInObject(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, cg.params()));
        mv.swap();
        this.assignConstantInModule(name);
    }

    @Override
    public void retrieveConstant(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadThreadContext();
        mv.ldc(name);
        this.invokeThreadContext("getConstant", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
    }

    private void loadScope(int depth) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aload(4);
        mv.ldc(new Integer(depth - 1));
        mv.arrayload();
    }

    @Override
    public void createNewFloat(double value) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.ldc(new Double(value));
        this.invokeIRuby("newFloat", CodegenUtils.sig(RubyFloat.class, CodegenUtils.params(Double.TYPE)));
    }

    @Override
    public void createNewFixnum(long value) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.ldc(new Long(value));
        this.invokeIRuby("newFixnum", CodegenUtils.sig(RubyFixnum.class, CodegenUtils.params(Long.TYPE)));
    }

    @Override
    public void createNewBignum(BigInteger value) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.ldc(value.toString());
        mv.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, CodegenUtils.params(Ruby.class, String.class)));
    }

    @Override
    public void createNewString(ArrayCallback callback, int count) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, cg.params()));
        for (int i = 0; i < count; ++i) {
            callback.nextValue(this, null, i);
            mv.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
        }
    }

    @Override
    public void createNewString(ByteList value) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.ldc(value.toString());
        this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(String.class)));
    }

    @Override
    public void createNewSymbol(String name) {
        this.loadRuntime();
        this.getMethodAdapter().ldc(name);
        this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
    }

    @Override
    public void createNewArray() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.swap();
        this.invokeIRuby("newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject[].class)));
    }

    @Override
    public void createEmptyArray() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        this.invokeIRuby("newArray", CodegenUtils.sig(RubyArray.class, cg.params()));
    }

    @Override
    public void createObjectArray(Object[] sourceArray, ArrayCallback callback) {
        this.buildObjectArray(IRUBYOBJECT, sourceArray, callback);
    }

    private void buildObjectArray(String type, Object[] sourceArray, ArrayCallback callback) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(new Integer(sourceArray.length));
        mv.anewarray(type);
        for (int i = 0; i < sourceArray.length; ++i) {
            mv.dup();
            mv.ldc(new Integer(i));
            callback.nextValue(this, sourceArray, i);
            mv.arraystore();
        }
    }

    @Override
    public void createEmptyHash() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
    }

    @Override
    public void createNewHash(Object elements, ArrayCallback callback, int keyCount) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.newobj(CodegenUtils.p(HashMap.class));
        mv.dup();
        mv.invokespecial(CodegenUtils.p(HashMap.class), "<init>", CodegenUtils.sig(Void.TYPE));
        for (int i = 0; i < keyCount; ++i) {
            mv.dup();
            callback.nextValue(this, elements, i);
            mv.invokevirtual(CodegenUtils.p(HashMap.class), "put", CodegenUtils.sig(Object.class, CodegenUtils.params(Object.class, Object.class)));
            mv.pop();
        }
        this.loadNil();
        mv.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class, Map.class, IRubyObject.class)));
    }

    @Override
    public void createNewRange(boolean isExclusive) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadRuntime();
        mv.dup_x2();
        mv.pop();
        mv.ldc(new Boolean(isExclusive));
        mv.invokestatic(CodegenUtils.p(RubyRange.class), "newRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, IRubyObject.class, IRubyObject.class, Boolean.TYPE)));
    }

    private void isTrue() {
        this.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
    }

    @Override
    public void performBooleanBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.isTrue();
        mv.ifeq(falseJmp);
        trueBranch.branch(this);
        mv.go_to(afterJmp);
        mv.label(falseJmp);
        falseBranch.branch(this);
        mv.label(afterJmp);
    }

    @Override
    public void performLogicalAnd(BranchCallback longBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        this.isTrue();
        mv.ifeq(falseJmp);
        mv.pop();
        longBranch.branch(this);
        mv.label(falseJmp);
    }

    @Override
    public void performLogicalOr(BranchCallback longBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        this.isTrue();
        mv.ifne(falseJmp);
        mv.pop();
        longBranch.branch(this);
        mv.label(falseJmp);
    }

    @Override
    public void performBooleanLoop(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label tryCatch = new Label();
        mv.trycatch(tryBegin, tryEnd, tryCatch, CodegenUtils.p(JumpException.class));
        mv.label(tryBegin);
        Label endJmp = new Label();
        if (checkFirst) {
            condition.branch(this);
            this.isTrue();
            mv.ifeq(endJmp);
        }
        Label topJmp = new Label();
        mv.label(topJmp);
        body.branch(this);
        mv.pop();
        condition.branch(this);
        this.isTrue();
        mv.ifne(topJmp);
        if (checkFirst) {
            mv.label(endJmp);
        }
        mv.label(tryEnd);
        Label normalBreak = new Label();
        mv.go_to(normalBreak);
        mv.label(tryCatch);
        mv.dup();
        mv.invokevirtual(CodegenUtils.p(JumpException.class), "getJumpType", CodegenUtils.sig(JumpException.JumpType.class));
        mv.invokevirtual(CodegenUtils.p(JumpException.JumpType.class), "getTypeId", CodegenUtils.sig(Integer.TYPE));
        Label tryDefault = new Label();
        Label breakLabel = new Label();
        mv.lookupswitch(tryDefault, new int[]{0}, new Label[]{breakLabel});
        mv.label(tryDefault);
        mv.athrow();
        mv.label(breakLabel);
        mv.dup();
        mv.invokevirtual(CodegenUtils.p(JumpException.class), "getTarget", CodegenUtils.sig(Object.class));
        this.loadClosure();
        Label notBlockBreak = new Label();
        mv.if_acmpne(notBlockBreak);
        mv.dup();
        mv.aconst_null();
        mv.invokevirtual(CodegenUtils.p(JumpException.class), "setTarget", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
        mv.athrow();
        mv.label(notBlockBreak);
        mv.pop();
        mv.label(normalBreak);
        this.loadNil();
    }

    @Override
    public void performReturn() {
        if (this.isCompilingClosure) {
            throw new NotCompilableException("Can't compile non-local return");
        }
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.areturn();
    }

    public static CompiledBlock createBlock(ThreadContext context, IRubyObject self, int arity, IRubyObject[][] scopes, Block block, CompiledBlockCallback callback) {
        return new CompiledBlock(context, self, Arity.createArity(arity), scopes, block, callback);
    }

    @Override
    public void createNewClosure(StaticScope scope, int arity, ClosureCallback body, ClosureCallback args) {
        ClassVisitor cv = this.getClassVisitor();
        String closureMethodName = "closure" + ++this.innerIndex;
        String closureFieldName = "_" + closureMethodName;
        cv.visitField(10, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class), null, null);
        SkinnyMethodAdapter method = new SkinnyMethodAdapter(cv.visitMethod(9, closureMethodName, CLOSURE_SIGNATURE, null, null));
        boolean previousIsCompilingClosure = this.isCompilingClosure;
        this.isCompilingClosure = true;
        this.pushMethodAdapter(method);
        method.start();
        method.ldc(new Integer(scope.getNumberOfVariables()));
        method.anewarray(CodegenUtils.p(IRubyObject.class));
        method.astore(6);
        method.aload(0);
        this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
        method.astore(5);
        args.compile(this);
        Label start = new Label();
        method.label(start);
        body.compile(this);
        method.areturn();
        Label end = new Label();
        method.label(end);
        method.end();
        this.popMethodAdapter();
        this.isCompilingClosure = previousIsCompilingClosure;
        method = this.getMethodAdapter();
        method.getstatic(this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        Label alreadyCreated = new Label();
        method.ifnonnull(alreadyCreated);
        this.getCallbackFactory();
        method.ldc(closureMethodName);
        method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class)));
        method.putstatic(this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        method.label(alreadyCreated);
        this.loadThreadContext();
        this.loadSelf();
        method.ldc(new Integer(arity));
        method.aload(4);
        Label noScopes = new Label();
        Label copyLocals = new Label();
        method.ifnull(noScopes);
        method.aload(4);
        method.arraylength();
        method.iconst_1();
        method.iadd();
        method.anewarray(CodegenUtils.p(IRubyObject[].class));
        method.dup();
        method.aload(4);
        method.swap();
        method.iconst_0();
        method.swap();
        method.iconst_1();
        method.aload(4);
        method.arraylength();
        method.invokestatic(CodegenUtils.p(System.class), "arraycopy", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE)));
        method.go_to(copyLocals);
        method.label(noScopes);
        method.iconst_1();
        method.anewarray(CodegenUtils.p(IRubyObject[].class));
        method.label(copyLocals);
        method.dup();
        method.iconst_0();
        method.aload(6);
        method.arraystore();
        this.loadClosure();
        method.getstatic(this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        this.invokeUtilityMethod("createBlock", CodegenUtils.sig(CompiledBlock.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, IRubyObject[][].class, Block.class, CompiledBlockCallback.class)));
    }

    private void invokeUtilityMethod(String methodName, String signature) {
        this.getMethodAdapter().invokestatic(CodegenUtils.p(StandardASMCompiler.class), methodName, signature);
    }

    private void invokeThreadContext(String methodName, String signature) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokevirtual(THREADCONTEXT, methodName, signature);
    }

    private void invokeIRuby(String methodName, String signature) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokevirtual(RUBY, methodName, signature);
    }

    private void getCallbackFactory() {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(this.classname);
        mv.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        this.invokeIRuby("callbackFactory", CodegenUtils.sig(CallbackFactory.class, CodegenUtils.params(Class.class)));
    }

    private void getRubyClass() {
        this.loadSelf();
        this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class));
    }

    private void getCRef() {
        this.loadThreadContext();
        this.invokeThreadContext("peekCRef", CodegenUtils.sig(SinglyLinkedList.class));
    }

    private void newTypeError(String error) {
        this.loadRuntime();
        this.getMethodAdapter().ldc(error);
        this.invokeIRuby("newTypeError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
    }

    private void getCurrentVisibility() {
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentVisibility", CodegenUtils.sig(Visibility.class));
    }

    private void println() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
        mv.swap();
        mv.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
    }

    @Override
    public void defineAlias(String newName, String oldName) {
        this.getRubyClass();
        this.getMethodAdapter().ldc(newName);
        this.getMethodAdapter().ldc(oldName);
        this.getMethodAdapter().invokevirtual(CodegenUtils.p(RubyModule.class), "defineAlias", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class, String.class)));
        this.loadNil();
    }

    public static IRubyObject def(ThreadContext context, IRubyObject self, Class compiledClass, String name, String javaName, int arity) {
        Ruby runtime = context.getRuntime();
        RubyClass containingClass = self.getMetaClass();
        if (containingClass == null) {
            throw runtime.newTypeError("No class to add method.");
        }
        if (containingClass == runtime.getObject() && name == "initialize") {
            runtime.getWarnings().warn("redefining Object#initialize may cause infinite loop");
        }
        Visibility visibility = context.getCurrentVisibility();
        if (name == "initialize" || visibility.isModuleFunction() || context.isTopLevel()) {
            visibility = Visibility.PRIVATE;
        }
        SinglyLinkedList cref = context.peekCRef();
        MethodFactory factory = MethodFactory.createFactory();
        DynamicMethod method = factory.getCompiledMethod(containingClass, compiledClass, javaName, Arity.createArity(arity), visibility, cref);
        containingClass.addMethod(name, method);
        if (context.getCurrentVisibility().isModuleFunction()) {
            containingClass.getSingletonClass().addMethod(name, new WrapperMethod(containingClass.getSingletonClass(), method, Visibility.PUBLIC));
            containingClass.callMethod(context, "singleton_method_added", runtime.newSymbol(name));
        }
        if (((RubyModule)containingClass).isSingleton()) {
            ((MetaClass)containingClass).getAttachedObject().callMethod(context, "singleton_method_added", runtime.newSymbol(name));
        } else {
            containingClass.callMethod(context, "method_added", runtime.newSymbol(name));
        }
        return runtime.getNil();
    }

    @Override
    public void defineNewMethod(String name, int arity, int localVarCount, ClosureCallback body) {
        ++this.methodIndex;
        String methodName = CodegenUtils.cleanJavaIdentifier(name) + "__" + this.methodIndex;
        this.beginMethod(methodName, arity, localVarCount);
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.aconst_null();
        mv.astore(4);
        body.compile(this);
        this.endMethod(mv);
        mv = this.getMethodAdapter();
        this.loadThreadContext();
        this.loadSelf();
        mv.ldc(this.classname.replace('/', '.'));
        mv.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        mv.ldc(name);
        mv.ldc(methodName);
        mv.ldc(new Integer(arity));
        mv.invokestatic(CodegenUtils.p(StandardASMCompiler.class), "def", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Class.class, String.class, String.class, Integer.TYPE)));
    }

    @Override
    public void loadFalse() {
        this.loadRuntime();
        this.invokeIRuby("getFalse", CodegenUtils.sig(RubyBoolean.class));
    }

    @Override
    public void loadTrue() {
        this.loadRuntime();
        this.invokeIRuby("getTrue", CodegenUtils.sig(RubyBoolean.class));
    }

    @Override
    public void retrieveInstanceVariable(String name) {
        this.loadSelf();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(name);
        this.invokeIRubyObject("getInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        mv.dup();
        Label notNull = new Label();
        mv.ifnonnull(notNull);
        mv.pop();
        this.loadNil();
        mv.label(notNull);
    }

    @Override
    public void assignInstanceVariable(String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadSelf();
        mv.swap();
        mv.ldc(name);
        mv.swap();
        this.invokeIRubyObject("setInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
    }

    @Override
    public void assignInstanceVariableBlockArg(int argIndex, String name) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.loadSelf();
        mv.ldc(name);
        mv.aload(2);
        mv.ldc(new Integer(argIndex));
        mv.arrayload();
        this.invokeIRubyObject("setInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
    }

    @Override
    public void retrieveGlobalVariable(String name) {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
        mv.ldc(name);
        mv.invokevirtual(CodegenUtils.p(GlobalVariables.class), "get", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
    }

    @Override
    public void assignGlobalVariable(String name) {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
        mv.swap();
        mv.ldc(name);
        mv.swap();
        mv.invokevirtual(CodegenUtils.p(GlobalVariables.class), "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
    }

    @Override
    public void assignGlobalVariableBlockArg(int argIndex, String name) {
        this.loadRuntime();
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
        mv.ldc(name);
        mv.aload(2);
        mv.ldc(new Integer(argIndex));
        mv.arrayload();
        mv.invokevirtual(CodegenUtils.p(GlobalVariables.class), "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
    }

    @Override
    public void negateCurrentValue() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        this.isTrue();
        Label isTrue = new Label();
        Label end = new Label();
        mv.ifne(isTrue);
        this.loadTrue();
        mv.go_to(end);
        mv.label(isTrue);
        this.loadFalse();
        mv.label(end);
    }

    @Override
    public void splatCurrentValue() {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        method.invokestatic(CodegenUtils.p(EvaluationState.class), "splatValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void singlifySplattedValue() {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        method.invokestatic(CodegenUtils.p(EvaluationState.class), "aValueSplat", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void ensureRubyArray() {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        method.invokestatic(CodegenUtils.p(StandardASMCompiler.class), "ensureRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    public static RubyArray ensureRubyArray(IRubyObject value) {
        if (!(value instanceof RubyArray)) {
            value = RubyArray.newArray(value.getRuntime(), value);
        }
        return (RubyArray)value;
    }

    @Override
    public void forEachInValueArray(int start, int count, Object source, ArrayCallback callback) {
        SkinnyMethodAdapter method = this.getMethodAdapter();
        Label noMoreArrayElements = new Label();
        while (start < count) {
            method.dup();
            method.invokevirtual(CodegenUtils.p(RubyArray.class), "getLength", CodegenUtils.sig(Integer.TYPE, cg.params()));
            method.ldc(new Integer(start));
            method.ifle(noMoreArrayElements);
            method.dup();
            method.ldc(new Integer(start));
            method.invokevirtual(CodegenUtils.p(RubyArray.class), "entry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Long.TYPE)));
            callback.nextValue(this, source, start);
            ++start;
        }
        method.label(noMoreArrayElements);
    }

    @Override
    public void loadInteger(int value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void performGEBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void performGTBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void performLEBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void performLTBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void loadRubyArraySize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void issueBreakEvent() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.newobj(CodegenUtils.p(JumpException.class));
        mv.dup();
        mv.getstatic(CodegenUtils.p(JumpException.JumpType.class), "BreakJump", CodegenUtils.ci(JumpException.JumpType.class));
        mv.invokespecial(CodegenUtils.p(JumpException.class), "<init>", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(JumpException.JumpType.class)));
        mv.dup_x1();
        mv.swap();
        mv.invokevirtual(CodegenUtils.p(JumpException.class), "setValue", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
        mv.athrow();
    }

    @Override
    public void asString() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, cg.params()));
    }

    @Override
    public void nthRef(int match) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.ldc(new Integer(match));
        this.loadThreadContext();
        this.invokeThreadContext("getBackref", CodegenUtils.sig(IRubyObject.class, cg.params()));
        mv.invokestatic(CodegenUtils.p(RubyRegexp.class), "nth_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
    }

    @Override
    public void match() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokevirtual(CodegenUtils.p(RubyRegexp.class), "match2", CodegenUtils.sig(IRubyObject.class, cg.params()));
    }

    @Override
    public void match2() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.invokevirtual(CodegenUtils.p(RubyRegexp.class), "match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    @Override
    public void match3() {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        mv.dup();
        mv.visitTypeInsn(193, CodegenUtils.p(RubyString.class));
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.invokevirtual(CodegenUtils.p(RubyRegexp.class), "match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.swap();
        this.loadThreadContext();
        mv.swap();
        mv.ldc("=~");
        mv.swap();
        mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "callMethod", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, IRubyObject.class)));
        mv.visitLabel(l1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewConstant(String type, String name_prefix) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = name_prefix + this.constants++;
        }
        cv.visitField(10, realName, type, null, null).visitEnd();
        return realName;
    }

    public static int regexpLiteralFlags(int options) {
        return TRANS.flagsFor(options, 0);
    }

    public static Pattern regexpLiteral(Ruby runtime, String ptr, int options) {
        try {
            return TRANS.translate(ptr, options, 0);
        }
        catch (PatternSyntaxException e) {
            throw runtime.newRegexpError(e.getMessage());
        }
    }

    @Override
    public void createNewRegexp(ByteList value, int options, String lang) {
        SkinnyMethodAdapter mv = this.getMethodAdapter();
        String name = this.getNewConstant(CodegenUtils.ci(Pattern.class), "literal_re_");
        String name_flags = this.getNewConstant(CodegenUtils.ci(Integer.TYPE), "literal_re_flags_");
        this.loadRuntime();
        mv.ldc(value.toString());
        mv.visitFieldInsn(178, this.classname, name, CodegenUtils.ci(Pattern.class));
        mv.dup();
        Label alreadyCreated = new Label();
        mv.ifnonnull(alreadyCreated);
        mv.pop();
        mv.ldc(new Integer(options));
        this.invokeUtilityMethod("regexpLiteralFlags", CodegenUtils.sig(Integer.TYPE, CodegenUtils.params(Integer.TYPE)));
        mv.visitFieldInsn(179, this.classname, name_flags, CodegenUtils.ci(Integer.TYPE));
        this.loadRuntime();
        mv.ldc(value.toString());
        mv.ldc(new Integer(options));
        this.invokeUtilityMethod("regexpLiteral", CodegenUtils.sig(Pattern.class, CodegenUtils.params(Ruby.class, String.class, Integer.TYPE)));
        mv.dup();
        mv.visitFieldInsn(179, this.classname, name, CodegenUtils.ci(Pattern.class));
        mv.label(alreadyCreated);
        mv.visitFieldInsn(178, this.classname, name_flags, CodegenUtils.ci(Integer.TYPE));
        if (null == lang) {
            mv.aconst_null();
        } else {
            mv.ldc(lang);
        }
        mv.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, String.class, Pattern.class, Integer.TYPE, String.class)));
    }
}

