/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.Node;
import org.jruby.ast.WhileNode;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;

public class WhileNodeCompiler
implements NodeCompiler {
    @Override
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        final WhileNode whileNode = (WhileNode)node;
        BranchCallback condition = new BranchCallback(){

            @Override
            public void branch(Compiler context) {
                NodeCompilerFactory.getCompiler(whileNode.getConditionNode()).compile(whileNode.getConditionNode(), context);
            }
        };
        BranchCallback body = new BranchCallback(){

            @Override
            public void branch(Compiler context) {
                if (whileNode.getBodyNode() == null) {
                    context.loadNil();
                    return;
                }
                NodeCompilerFactory.getCompiler(whileNode.getBodyNode()).compile(whileNode.getBodyNode(), context);
            }
        };
        context.performBooleanLoop(condition, body, whileNode.evaluateAtStart());
    }
}

