/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.Node;
import org.jruby.ast.OpAsgnNode;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.runtime.CallType;

public class OpAsgnNodeCompiler
implements NodeCompiler {
    @Override
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        final OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        NodeCompilerFactory.getCompiler(opAsgnNode.getReceiverNode()).compile(opAsgnNode.getReceiverNode(), context);
        context.duplicateCurrentValue();
        context.invokeDynamic(opAsgnNode.getVariableName(), true, false, CallType.FUNCTIONAL, null);
        BranchCallback doneBranch = new BranchCallback(){

            @Override
            public void branch(Compiler context) {
                context.swapValues();
                context.consumeCurrentValue();
            }
        };
        final ArrayCallback justEvalValue = new ArrayCallback(){

            @Override
            public void nextValue(Compiler context, Object sourceArray, int index) {
                NodeCompilerFactory.getCompiler(((Node[])sourceArray)[index]).compile(((Node[])sourceArray)[index], context);
            }
        };
        final ArrayCallback evalAndCallOperator = new ArrayCallback(){

            @Override
            public void nextValue(Compiler context, Object sourceArray, int index) {
                context.createObjectArray(new Node[]{opAsgnNode.getValueNode()}, justEvalValue);
                context.invokeDynamic(opAsgnNode.getOperatorName(), true, true, CallType.FUNCTIONAL, null);
            }
        };
        BranchCallback assignBranch = new BranchCallback(){

            @Override
            public void branch(Compiler context) {
                context.consumeCurrentValue();
                context.createObjectArray(new Node[]{opAsgnNode.getValueNode()}, justEvalValue);
                context.invokeAttrAssign(opAsgnNode.getVariableNameAsgn());
            }
        };
        BranchCallback operateAndAssignBranch = new BranchCallback(){

            @Override
            public void branch(Compiler context) {
                context.createObjectArray(new Node[]{opAsgnNode.getValueNode()}, evalAndCallOperator);
                context.invokeAttrAssign(opAsgnNode.getVariableNameAsgn());
            }
        };
        if (opAsgnNode.getOperatorName() == "||") {
            context.duplicateCurrentValue();
            context.performBooleanBranch(doneBranch, assignBranch);
        } else if (opAsgnNode.getOperatorName() == "&&") {
            context.duplicateCurrentValue();
            context.performBooleanBranch(assignBranch, doneBranch);
        } else {
            operateAndAssignBranch.branch(context);
        }
    }
}

