/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.ArgsNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.compiler.NotCompilableException;

public class DefnNodeCompiler
implements NodeCompiler {
    @Override
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        final DefnNode defnNode = (DefnNode)node;
        ClosureCallback body = new ClosureCallback(){

            @Override
            public void compile(Compiler context) {
                if (defnNode.getBodyNode() != null) {
                    NodeCompilerFactory.getCompiler(defnNode.getBodyNode()).compile(defnNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        int arity = 0;
        if (NodeCompilerFactory.SAFE) {
            ArgsNode argsNode = defnNode.getArgsNode();
            if (argsNode.getBlockArgNode() != null) {
                throw new NotCompilableException("Can't compile def with block arg at: " + node.getPosition());
            }
            if (argsNode.getOptArgs() != null) {
                throw new NotCompilableException("Can't compile def with optional params at: " + node.getPosition());
            }
            if (argsNode.getRestArg() != -1) {
                throw new NotCompilableException("Can't compile def with rest arg at: " + node.getPosition());
            }
        }
        arity = defnNode.getArgsNode().getArgsCount();
        context.defineNewMethod(defnNode.getName(), arity, defnNode.getScope().getNumberOfVariables(), body);
    }
}

