/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.internal.runtime.methods.EvaluateCallable;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.NilCallable;

public class IterNode
extends Node {
    static final long serialVersionUID = -9181965000180892184L;
    private final Node varNode;
    private final Node bodyNode;
    private StaticScope scope;
    private transient ICallable callable;

    public IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode) {
        this(position, varNode, scope, bodyNode, 50);
    }

    public IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode, int id) {
        super(position, id);
        this.varNode = varNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
        if (bodyNode == null && varNode == null) {
            this.callable = NilCallable.NIL_CALLABLE;
        }
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    @Override
    public List childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }

    public ICallable getCallable() {
        if (this.callable == null) {
            this.callable = new EvaluateCallable(this.bodyNode, this.varNode);
        }
        return this.callable;
    }
}

