/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.NormalizedFile;

public class RubyDir
extends RubyObject {
    private RubyString path;
    protected JRubyFile dir;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private static ObjectAllocator DIR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyDir(runtime, klass);
        }
    };

    public RubyDir(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static RubyClass createDirClass(Ruby runtime) {
        RubyClass dirClass = runtime.defineClass("Dir", runtime.getObject(), DIR_ALLOCATOR);
        dirClass.includeModule(runtime.getModule("Enumerable"));
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyDir.class);
        dirClass.getMetaClass().defineMethod("glob", callbackFactory.getOptSingletonMethod("glob"));
        dirClass.getMetaClass().defineFastMethod("entries", callbackFactory.getFastSingletonMethod("entries", RubyKernel.IRUBY_OBJECT));
        dirClass.getMetaClass().defineMethod("[]", callbackFactory.getOptSingletonMethod("glob"));
        dirClass.getMetaClass().defineMethod("chdir", callbackFactory.getOptSingletonMethod("chdir"));
        dirClass.getMetaClass().defineFastMethod("chroot", callbackFactory.getFastSingletonMethod("chroot", RubyKernel.IRUBY_OBJECT));
        dirClass.getMetaClass().defineMethod("foreach", callbackFactory.getSingletonMethod("foreach", RubyKernel.IRUBY_OBJECT));
        dirClass.getMetaClass().defineFastMethod("getwd", callbackFactory.getFastSingletonMethod("getwd"));
        dirClass.getMetaClass().defineFastMethod("pwd", callbackFactory.getFastSingletonMethod("getwd"));
        dirClass.getMetaClass().defineFastMethod("mkdir", callbackFactory.getFastOptSingletonMethod("mkdir"));
        dirClass.getMetaClass().defineMethod("open", callbackFactory.getSingletonMethod("open", RubyKernel.IRUBY_OBJECT));
        dirClass.getMetaClass().defineFastMethod("rmdir", callbackFactory.getFastSingletonMethod("rmdir", RubyKernel.IRUBY_OBJECT));
        dirClass.getMetaClass().defineFastMethod("unlink", callbackFactory.getFastSingletonMethod("rmdir", RubyKernel.IRUBY_OBJECT));
        dirClass.getMetaClass().defineFastMethod("delete", callbackFactory.getFastSingletonMethod("rmdir", RubyKernel.IRUBY_OBJECT));
        dirClass.defineFastMethod("close", callbackFactory.getFastMethod("close"));
        dirClass.defineMethod("each", callbackFactory.getMethod("each"));
        dirClass.defineFastMethod("entries", callbackFactory.getFastMethod("entries"));
        dirClass.defineFastMethod("path", callbackFactory.getFastMethod("path"));
        dirClass.defineFastMethod("tell", callbackFactory.getFastMethod("tell"));
        dirClass.defineAlias("pos", "tell");
        dirClass.defineFastMethod("seek", callbackFactory.getFastMethod("seek", RubyKernel.IRUBY_OBJECT));
        dirClass.defineFastMethod("pos=", callbackFactory.getFastMethod("setPos", RubyKernel.IRUBY_OBJECT));
        dirClass.defineFastMethod("read", callbackFactory.getFastMethod("read"));
        dirClass.defineFastMethod("rewind", callbackFactory.getFastMethod("rewind"));
        dirClass.defineMethod("initialize", callbackFactory.getMethod("initialize", RubyKernel.IRUBY_OBJECT));
        return dirClass;
    }

    public IRubyObject initialize(IRubyObject _newPath, Block unusedBlock) {
        RubyString newPath = _newPath.convertToString();
        this.getRuntime().checkSafeString(newPath);
        this.dir = JRubyFile.create(this.getRuntime().getCurrentDirectory(), newPath.toString());
        if (!this.dir.isDirectory()) {
            this.dir = null;
            throw this.getRuntime().newErrnoENOENTError(newPath.toString() + " is not a directory");
        }
        this.path = newPath;
        ArrayList<String> snapshotList = new ArrayList<String>();
        snapshotList.add(".");
        snapshotList.add("..");
        snapshotList.addAll(RubyDir.getContents(this.dir));
        this.snapshot = snapshotList.toArray(new String[snapshotList.size()]);
        this.pos = 0;
        return this;
    }

    public static IRubyObject glob(IRubyObject recv, IRubyObject[] args, Block block) {
        String cwd2;
        String cwd = recv.getRuntime().getCurrentDirectory();
        int flags = 0;
        if (Arity.checkArgumentCount(recv.getRuntime(), args, 1, 2) == 2) {
            flags = RubyNumeric.num2int(args[1]);
        }
        ByteList pt = args[0].convertToString().getByteList();
        try {
            cwd2 = new NormalizedFile(cwd).getCanonicalPath();
        }
        catch (Exception e) {
            cwd2 = cwd;
        }
        List l = Dir.push_glob(cwd2, pt.bytes, 0, pt.realSize, flags);
        if (block.isGiven()) {
            ThreadContext context = recv.getRuntime().getCurrentContext();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                block.yield(context, RubyString.newString(recv.getRuntime(), (ByteList)iter.next()));
            }
            return recv.getRuntime().getNil();
        }
        IRubyObject[] l2 = new IRubyObject[l.size()];
        int i = 0;
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            l2[i] = RubyString.newString(recv.getRuntime(), (ByteList)iter.next());
            ++i;
        }
        return recv.getRuntime().newArrayNoCopy(l2);
    }

    public RubyArray entries() {
        return this.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(this.getRuntime(), this.snapshot));
    }

    public static RubyArray entries(IRubyObject recv, IRubyObject path) {
        JRubyFile directory = JRubyFile.create(recv.getRuntime().getCurrentDirectory(), path.convertToString().toString());
        if (!directory.isDirectory()) {
            throw recv.getRuntime().newErrnoENOENTError("No such directory");
        }
        List fileList = RubyDir.getContents(directory);
        fileList.add(0, ".");
        fileList.add(1, "..");
        Object[] files = fileList.toArray();
        return recv.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(recv.getRuntime(), files));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject chdir(IRubyObject recv, IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(recv.getRuntime(), args, 0, 1);
        RubyString path = args.length == 1 ? args[0].convertToString() : RubyDir.getHomeDirectoryPath(recv);
        JRubyFile dir = RubyDir.getDir(recv.getRuntime(), path.toString(), true);
        String realPath = null;
        String oldCwd = recv.getRuntime().getCurrentDirectory();
        try {
            realPath = dir.getCanonicalPath();
        }
        catch (IOException e) {
            realPath = dir.getAbsolutePath();
        }
        IRubyObject result = null;
        if (block.isGiven()) {
            recv.getRuntime().setCurrentDirectory(realPath);
            try {
                result = block.yield(recv.getRuntime().getCurrentContext(), path);
            }
            finally {
                recv.getRuntime().setCurrentDirectory(oldCwd);
            }
        } else {
            recv.getRuntime().setCurrentDirectory(realPath);
            result = recv.getRuntime().newFixnum(0L);
        }
        return result;
    }

    public static IRubyObject chroot(IRubyObject recv, IRubyObject path) {
        throw recv.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    public static IRubyObject rmdir(IRubyObject recv, IRubyObject path) {
        JRubyFile directory = RubyDir.getDir(recv.getRuntime(), path.convertToString().toString(), true);
        if (!directory.delete()) {
            throw recv.getRuntime().newSystemCallError("No such directory");
        }
        return recv.getRuntime().newFixnum(0L);
    }

    public static IRubyObject foreach(IRubyObject recv, IRubyObject _path, Block block) {
        RubyString path = _path.convertToString();
        recv.getRuntime().checkSafeString(path);
        RubyClass dirClass = recv.getRuntime().getClass("Dir");
        RubyDir dir = (RubyDir)dirClass.newInstance(new IRubyObject[]{path}, block);
        dir.each(block);
        return recv.getRuntime().getNil();
    }

    public static RubyString getwd(IRubyObject recv) {
        return recv.getRuntime().newString(recv.getRuntime().getCurrentDirectory());
    }

    public static IRubyObject mkdir(IRubyObject recv, IRubyObject[] args) {
        if (args.length < 1) {
            throw recv.getRuntime().newArgumentError(args.length, 1);
        }
        if (args.length > 2) {
            throw recv.getRuntime().newArgumentError(args.length, 2);
        }
        recv.getRuntime().checkSafeString(args[0]);
        String path = args[0].toString();
        File newDir = RubyDir.getDir(recv.getRuntime(), path, false);
        if (File.separatorChar == '\\') {
            newDir = new File(((File)newDir).getPath());
        }
        return newDir.mkdirs() ? RubyFixnum.zero(recv.getRuntime()) : RubyFixnum.one(recv.getRuntime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject path, Block block) {
        RubyDir directory = (RubyDir)recv.getRuntime().getClass("Dir").newInstance(new IRubyObject[]{path}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            block.yield(recv.getRuntime().getCurrentContext(), directory);
        }
        finally {
            directory.close();
        }
        return recv.getRuntime().getNil();
    }

    public IRubyObject close() {
        this.isOpen = false;
        return this.getRuntime().getNil();
    }

    public IRubyObject each(Block block) {
        String[] contents = this.snapshot;
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < contents.length; ++i) {
            block.yield(context, this.getRuntime().newString(contents[i]));
        }
        return this;
    }

    public RubyInteger tell() {
        return this.getRuntime().newFixnum(this.pos);
    }

    public IRubyObject seek(IRubyObject newPos) {
        this.setPos(newPos);
        return this;
    }

    public IRubyObject setPos(IRubyObject newPos) {
        this.pos = RubyNumeric.fix2int(newPos);
        return newPos;
    }

    public IRubyObject path() {
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
        return this.path;
    }

    public IRubyObject read() {
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("Directory already closed");
        }
        if (this.pos >= this.snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString result = this.getRuntime().newString(this.snapshot[this.pos]);
        ++this.pos;
        return result;
    }

    public IRubyObject rewind() {
        this.pos = 0;
        return this.getRuntime().newFixnum(this.pos);
    }

    protected static JRubyFile getDir(Ruby runtime, String path, boolean mustExist) {
        JRubyFile result = JRubyFile.create(runtime.getCurrentDirectory(), path);
        boolean isDirectory = result.isDirectory();
        if (mustExist && !isDirectory) {
            throw runtime.newErrnoENOENTError(path + " is not a directory");
        }
        if (!mustExist && isDirectory) {
            throw runtime.newErrnoEEXISTError("File exists - " + path);
        }
        return result;
    }

    protected static List getContents(File directory) {
        String[] contents = directory.list();
        ArrayList<String> result = new ArrayList<String>();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                result.add(contents[i]);
            }
        }
        return result;
    }

    protected static List getContents(File directory, Ruby runtime) {
        ArrayList<RubyString> result = new ArrayList<RubyString>();
        String[] contents = directory.list();
        for (int i = 0; i < contents.length; ++i) {
            result.add(runtime.newString(contents[i]));
        }
        return result;
    }

    public static IRubyObject getHomeDirectoryPath(IRubyObject recv, String user) {
        return recv.getRuntime().evalScript("File.open('/etc/passwd') do |f| f.readlines.each do|l| f = l.split(':'); return f[5] if f[0] == '" + user + "'; end; end; nil");
    }

    public static RubyString getHomeDirectoryPath(IRubyObject recv) {
        RubyHash hash = (RubyHash)recv.getRuntime().getObject().getConstant("ENV_JAVA");
        IRubyObject home = hash.aref(recv.getRuntime().newString("user.home"));
        if (home == null || home.isNil()) {
            home = hash.aref(recv.getRuntime().newString("LOGDIR"));
        }
        if (home == null || home.isNil()) {
            throw recv.getRuntime().newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)home;
    }
}

