/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.util.ByteList;
import org.jvyamlb.BaseConstructorImpl;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.Constructor;
import org.jvyamlb.ConstructorException;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAMLException;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.util.Base64Coder;

public class SafeConstructorImpl
extends BaseConstructorImpl {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private static final Map BOOL_VALUES = new HashMap();
    private static final Pattern TIMESTAMP_REGEXP;
    private static final Pattern YMD_REGEXP;
    private static final Double INF_VALUE_POS;
    private static final Double INF_VALUE_NEG;
    private static final Double NAN_VALUE;

    public Constructor.YamlConstructor getYamlConstructor(Object key) {
        Constructor.YamlConstructor mine = (Constructor.YamlConstructor)yamlConstructors.get(key);
        if (mine == null) {
            mine = super.getYamlConstructor(key);
        }
        return mine;
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object key) {
        Constructor.YamlMultiConstructor mine = (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(key);
        if (mine == null) {
            mine = super.getYamlMultiConstructor(key);
        }
        return mine;
    }

    public Pattern getYamlMultiRegexp(Object key) {
        Pattern mine = (Pattern)yamlMultiRegexps.get(key);
        if (mine == null) {
            mine = super.getYamlMultiRegexp(key);
        }
        return mine;
    }

    public Set getYamlMultiRegexps() {
        HashSet all = new HashSet(super.getYamlMultiRegexps());
        all.addAll(yamlMultiRegexps.keySet());
        return all;
    }

    public static void addConstructor(String tag, Constructor.YamlConstructor ctor) {
        yamlConstructors.put(tag, ctor);
    }

    public static void addMultiConstructor(String tagPrefix, Constructor.YamlMultiConstructor ctor) {
        yamlMultiConstructors.put(tagPrefix, ctor);
        yamlMultiRegexps.put(tagPrefix, Pattern.compile("^" + tagPrefix));
    }

    public SafeConstructorImpl(Composer composer) {
        super(composer);
    }

    private static ByteList into(String v) {
        return new ByteList(v.getBytes(), false);
    }

    public static Object constructYamlNull(Constructor ctor, Node node) {
        return null;
    }

    public static Object constructYamlBool(Constructor ctor, Node node) {
        Object val = ctor.constructScalar(node);
        return BOOL_VALUES.get(val);
    }

    public static Object constructYamlOmap(Constructor ctor, Node node) {
        return ctor.constructPairs(node);
    }

    public static Object constructYamlPairs(Constructor ctor, Node node) {
        return SafeConstructorImpl.constructYamlOmap(ctor, node);
    }

    public static Object constructYamlSet(Constructor ctor, Node node) {
        return ((Map)ctor.constructMapping(node)).keySet();
    }

    public static Object constructYamlStr(Constructor ctor, Node node) {
        ByteList value = (ByteList)ctor.constructScalar(node);
        return value.length() == 0 ? (ByteList)null : value;
    }

    public static Object constructYamlSeq(Constructor ctor, Node node) {
        return ctor.constructSequence(node);
    }

    public static Object constructYamlMap(Constructor ctor, Node node) {
        return ctor.constructMapping(node);
    }

    public static Object constructUndefined(Constructor ctor, Node node) {
        throw new ConstructorException(null, "could not determine a constructor for the tag " + node.getTag(), null);
    }

    public static Object constructYamlTimestamp(Constructor ctor, Node node) {
        Matcher match = YMD_REGEXP.matcher(node.getValue().toString());
        if (match.matches()) {
            String year_s = match.group(1);
            String month_s = match.group(2);
            String day_s = match.group(3);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            if (year_s != null) {
                cal.set(1, Integer.parseInt(year_s));
            }
            if (month_s != null) {
                cal.set(2, Integer.parseInt(month_s) - 1);
            }
            if (day_s != null) {
                cal.set(5, Integer.parseInt(day_s));
            }
            return cal.getTime();
        }
        match = TIMESTAMP_REGEXP.matcher(node.getValue().toString());
        if (!match.matches()) {
            return ctor.constructPrivateType(node);
        }
        String year_s = match.group(1);
        String month_s = match.group(2);
        String day_s = match.group(3);
        String hour_s = match.group(4);
        String min_s = match.group(5);
        String sec_s = match.group(6);
        String fract_s = match.group(7);
        String utc = match.group(8);
        String timezoneh_s = match.group(9);
        String timezonem_s = match.group(10);
        int usec = 0;
        if (fract_s != null && (usec = Integer.parseInt(fract_s)) != 0) {
            while (10 * usec < 1000) {
                usec *= 10;
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        if ("Z".equalsIgnoreCase(utc)) {
            cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        } else if (timezoneh_s != null || timezonem_s != null) {
            int zone = 0;
            int sign = 1;
            if (timezoneh_s != null) {
                if (timezoneh_s.startsWith("-")) {
                    sign = -1;
                }
                zone += Integer.parseInt(timezoneh_s.substring(1)) * 3600000;
            }
            if (timezonem_s != null) {
                zone += Integer.parseInt(timezonem_s) * 60000;
            }
            cal.set(15, sign * zone);
        }
        if (year_s != null) {
            cal.set(1, Integer.parseInt(year_s));
        }
        if (month_s != null) {
            cal.set(2, Integer.parseInt(month_s) - 1);
        }
        if (day_s != null) {
            cal.set(5, Integer.parseInt(day_s));
        }
        if (hour_s != null) {
            cal.set(11, Integer.parseInt(hour_s));
        }
        if (min_s != null) {
            cal.set(12, Integer.parseInt(min_s));
        }
        if (sec_s != null) {
            cal.set(13, Integer.parseInt(sec_s));
        }
        cal.set(14, usec);
        return cal.getTime();
    }

    public static Object constructYamlInt(Constructor ctor, Node node) {
        String value = ctor.constructScalar(node).toString().replaceAll("_", "");
        int sign = 1;
        char first = value.charAt(0);
        if (first == '-') {
            sign = -1;
            value = value.substring(1);
        } else if (first == '+') {
            value = value.substring(1);
        }
        int base = 10;
        if (value.equals("0")) {
            return new Long(0L);
        }
        if (value.startsWith("0b")) {
            value = value.substring(2);
            base = 2;
        } else if (value.startsWith("0x")) {
            value = value.substring(2);
            base = 16;
        } else if (value.startsWith("0")) {
            value = value.substring(1);
            base = 8;
        } else {
            if (value.indexOf(58) != -1) {
                String[] digits = value.split(":");
                int bes = 1;
                int val = 0;
                int j = digits.length;
                for (int i = 0; i < j; ++i) {
                    val = (int)((long)val + Long.parseLong(digits[j - i - 1]) * (long)bes);
                    bes *= 60;
                }
                return new Integer(sign * val);
            }
            return new Long((long)sign * Long.parseLong(value));
        }
        return new Long((long)sign * Long.parseLong(value, base));
    }

    public static Object constructYamlFloat(Constructor ctor, Node node) {
        String value = ctor.constructScalar(node).toString().replaceAll("_", "");
        int sign = 1;
        char first = value.charAt(0);
        if (first == '-') {
            sign = -1;
            value = value.substring(1);
        } else if (first == '+') {
            value = value.substring(1);
        }
        String valLower = value.toLowerCase();
        if (valLower.equals(".inf")) {
            return sign == -1 ? INF_VALUE_NEG : INF_VALUE_POS;
        }
        if (valLower.equals(".nan")) {
            return NAN_VALUE;
        }
        if (value.indexOf(58) != -1) {
            String[] digits = value.split(":");
            int bes = 1;
            double val = 0.0;
            int j = digits.length;
            for (int i = 0; i < j; ++i) {
                val += Double.parseDouble(digits[j - i - 1]) * (double)bes;
                bes *= 60;
            }
            return new Double((double)sign * val);
        }
        return Double.valueOf(value);
    }

    public static Object constructYamlBinary(Constructor ctor, Node node) {
        String[] values = ctor.constructScalar(node).toString().split("[\n\u0085]|(?:\r[^\n])");
        StringBuffer vals = new StringBuffer();
        int j = values.length;
        for (int i = 0; i < j; ++i) {
            vals.append(values[i].trim());
        }
        return Base64Coder.decode(ByteList.plain(vals));
    }

    public static Object constructSpecializedSequence(Constructor ctor, String pref, Node node) {
        List outp = null;
        try {
            Class<?> seqClass = Class.forName(pref);
            outp = (List)seqClass.newInstance();
        }
        catch (Exception e) {
            throw new YAMLException("Can't construct a sequence from class " + pref + ": " + e.toString());
        }
        outp.addAll((List)ctor.constructSequence(node));
        return outp;
    }

    public static Object constructSpecializedMap(Constructor ctor, String pref, Node node) {
        Map outp = null;
        try {
            Class<?> mapClass = Class.forName(pref);
            outp = (Map)mapClass.newInstance();
        }
        catch (Exception e) {
            throw new YAMLException("Can't construct a mapping from class " + pref + ": " + e.toString());
        }
        outp.putAll((Map)ctor.constructMapping(node));
        return outp;
    }

    private static Object fixValue(Object inp, Class outp) {
        if (inp == null) {
            return null;
        }
        Class<?> inClass = inp.getClass();
        if (outp.isAssignableFrom(inClass)) {
            return inp;
        }
        if (inClass == Long.class && (outp == Integer.class || outp == Integer.TYPE)) {
            return new Integer(((Long)inp).intValue());
        }
        if (inClass == Long.class && (outp == Short.class || outp == Short.TYPE)) {
            return new Short((short)((Long)inp).intValue());
        }
        if (inClass == Long.class && (outp == Character.class || outp == Character.TYPE)) {
            return new Character((char)((Long)inp).intValue());
        }
        if (inClass == Double.class && (outp == Float.class || outp == Float.TYPE)) {
            return new Float(((Double)inp).floatValue());
        }
        return inp;
    }

    public static Object constructJava(Constructor ctor, String pref, Node node) {
        Object outp = null;
        try {
            Class<?> cl = Class.forName(pref);
            outp = cl.newInstance();
            Map values = (Map)ctor.constructMapping(node);
            Method[] ems = cl.getMethods();
            block2: for (Object key : values.keySet()) {
                Object value = values.get(key);
                String keyName = key.toString();
                String mName = "set" + Character.toUpperCase(keyName.charAt(0)) + keyName.substring(1);
                int j = ems.length;
                for (int i = 0; i < j; ++i) {
                    if (!ems[i].getName().equals(mName) || ems[i].getParameterTypes().length != 1) continue;
                    ems[i].invoke(outp, SafeConstructorImpl.fixValue(value, ems[i].getParameterTypes()[0]));
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw new YAMLException("Can't construct a java object from class " + pref + ": " + e.toString());
        }
        return outp;
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        ByteList input = new ByteList(1024);
        FileInputStream reader = new FileInputStream(filename);
        byte[] buff = new byte[1024];
        int read = 0;
        do {
            read = ((InputStream)reader).read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((InputStream)reader).close();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            SafeConstructorImpl ctor = new SafeConstructorImpl(new ComposerImpl(new ParserImpl(new ScannerImpl(input)), new ResolverImpl()));
            Iterator iter = ctor.eachDocument();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + filename + " took " + time + "ms, or " + timeS + " seconds");
    }

    static {
        BOOL_VALUES.put(SafeConstructorImpl.into("yes"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("Yes"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("YES"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("no"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("No"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("NO"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("true"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("True"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("TRUE"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("false"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("False"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("FALSE"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("on"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("On"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("ON"), Boolean.TRUE);
        BOOL_VALUES.put(SafeConstructorImpl.into("off"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("Off"), Boolean.FALSE);
        BOOL_VALUES.put(SafeConstructorImpl.into("OFF"), Boolean.FALSE);
        TIMESTAMP_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");
        YMD_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");
        INF_VALUE_POS = new Double(Double.POSITIVE_INFINITY);
        INF_VALUE_NEG = new Double(Double.NEGATIVE_INFINITY);
        NAN_VALUE = new Double(Double.NaN);
        BaseConstructorImpl.addConstructor("tag:yaml.org,2002:null", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlNull(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:bool", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlBool(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:omap", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlOmap(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:pairs", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlPairs(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:set", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlSet(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:int", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlInt(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:float", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlFloat(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:timestamp", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlTimestamp(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:timestamp#ymd", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlTimestamp(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:str", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlStr(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:binary", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlBinary(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:seq", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlSeq(self, node);
            }
        });
        SafeConstructorImpl.addConstructor("tag:yaml.org,2002:map", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return SafeConstructorImpl.constructYamlMap(self, node);
            }
        });
        SafeConstructorImpl.addConstructor(null, new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return self.constructPrivateType(node);
            }
        });
        SafeConstructorImpl.addMultiConstructor("tag:yaml.org,2002:seq:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return SafeConstructorImpl.constructSpecializedSequence(self, pref, node);
            }
        });
        SafeConstructorImpl.addMultiConstructor("tag:yaml.org,2002:map:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return SafeConstructorImpl.constructSpecializedMap(self, pref, node);
            }
        });
        SafeConstructorImpl.addMultiConstructor("!java/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return SafeConstructorImpl.constructJava(self, pref, node);
            }
        });
    }
}

