/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.yaml;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.Constructor;
import org.jvyamlb.ConstructorException;
import org.jvyamlb.ConstructorImpl;
import org.jvyamlb.SafeConstructorImpl;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;

public class JRubyConstructor
extends ConstructorImpl {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private final Ruby runtime;

    public Constructor.YamlConstructor getYamlConstructor(Object key) {
        return (Constructor.YamlConstructor)yamlConstructors.get(key);
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object key) {
        return (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(key);
    }

    public Pattern getYamlMultiRegexp(Object key) {
        return (Pattern)yamlMultiRegexps.get(key);
    }

    public Set getYamlMultiRegexps() {
        return yamlMultiRegexps.keySet();
    }

    public static void addConstructor(String tag, Constructor.YamlConstructor ctor) {
        yamlConstructors.put(tag, ctor);
    }

    public static void addMultiConstructor(String tagPrefix, Constructor.YamlMultiConstructor ctor) {
        yamlMultiConstructors.put(tagPrefix, ctor);
        yamlMultiRegexps.put(tagPrefix, Pattern.compile("^" + tagPrefix));
    }

    public JRubyConstructor(IRubyObject receiver, Composer composer) {
        super(composer);
        this.runtime = receiver.getRuntime();
    }

    public Object constructRubyScalar(Node node) {
        return RubyString.newString(this.runtime, (ByteList)super.constructScalar(node));
    }

    public Object constructRubySequence(Node node) {
        return this.runtime.newArray((List)super.constructSequence(node));
    }

    public Object constructRubyMapping(Node node) {
        return RubyHash.newHash(this.runtime, (Map)super.constructMapping(node), this.runtime.getNil());
    }

    public Object constructRubyPairs(Node node) {
        return this.runtime.newArray((List)super.constructPairs(node));
    }

    public static Object constructYamlNull(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.getNil();
    }

    public static Object constructYamlBool(Constructor ctor, Node node) {
        return SafeConstructorImpl.constructYamlBool(ctor, node) == Boolean.TRUE ? ((JRubyConstructor)ctor).runtime.getTrue() : ((JRubyConstructor)ctor).runtime.getFalse();
    }

    public static Object constructYamlOmap(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubyPairs(node);
    }

    public static Object constructYamlPairs(Constructor ctor, Node node) {
        return JRubyConstructor.constructYamlOmap(ctor, node);
    }

    public static Object constructYamlSet(Constructor ctor, Node node) {
        return SafeConstructorImpl.constructYamlSet(ctor, node);
    }

    public static Object constructYamlStr(Constructor ctor, Node node) {
        RubyString str = (RubyString)((JRubyConstructor)ctor).constructRubyScalar(node);
        return str.getValue().length() == 0 && ((ScalarNode)node).getStyle() == '\u0000' ? str.getRuntime().getNil() : str;
    }

    public static Object constructYamlSeq(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubySequence(node);
    }

    public static Object constructYamlMap(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubyMapping(node);
    }

    public static Object constructUndefined(Constructor ctor, Node node) {
        throw new ConstructorException(null, "could not determine a constructor for the tag " + node.getTag(), null);
    }

    public static Object constructYamlTimestamp(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.newTime(((Date)SafeConstructorImpl.constructYamlTimestamp(ctor, node)).getTime()).callMethod(((JRubyConstructor)ctor).runtime.getCurrentContext(), "utc");
    }

    public static Object constructYamlTimestampYMD(Constructor ctor, Node node) {
        Date d = (Date)SafeConstructorImpl.constructYamlTimestamp(ctor, node);
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        return runtime.getClass("Date").callMethod(runtime.getCurrentContext(), "new", new IRubyObject[]{runtime.newFixnum(c.get(1)), runtime.newFixnum(c.get(2) + 1), runtime.newFixnum(c.get(5))});
    }

    public static Object constructYamlInt(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.newFixnum((Long)SafeConstructorImpl.constructYamlInt(ctor, node));
    }

    public static Object constructYamlFloat(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.newFloat((Double)SafeConstructorImpl.constructYamlFloat(ctor, node));
    }

    public static Object constructYamlBinary(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.newString((String)SafeConstructorImpl.constructYamlBinary(ctor, node));
    }

    public static Object constructJava(Constructor ctor, String pref, Node node) {
        return SafeConstructorImpl.constructJava(ctor, pref, node);
    }

    public static Object constructRuby(Constructor ctor, String tag, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime.getModule("Object");
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = (RubyClass)objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime, theCls);
        Map vars = (Map)ctor.constructMapping(node);
        for (IRubyObject key : vars.keySet()) {
            oo.setInstanceVariable("@" + key.toString(), (IRubyObject)vars.get(key));
        }
        return oo;
    }

    public static Object constructRubyMap(Constructor ctor, String tag, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime.getModule("Object");
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = (RubyClass)objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime, theCls);
        Map vars = (Map)ctor.constructMapping(node);
        for (IRubyObject key : vars.keySet()) {
            oo.callMethod(oo.getRuntime().getCurrentContext(), "[]=", new IRubyObject[]{key, (IRubyObject)vars.get(key)});
        }
        return oo;
    }

    public static Object constructRubySequence(Constructor ctor, String tag, Node node) {
        Ruby runtime = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime.getModule("Object");
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = (RubyClass)objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime, theCls);
        List vars = (List)ctor.constructSequence(node);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            oo.callMethod(oo.getRuntime().getCurrentContext(), "<<", new IRubyObject[]{(IRubyObject)iter.next()});
        }
        return oo;
    }

    static {
        JRubyConstructor.addConstructor("tag:yaml.org,2002:null", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlNull(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:bool", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlBool(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:omap", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlOmap(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:pairs", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlPairs(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:set", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlSet(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:int", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlInt(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:float", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlFloat(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:timestamp", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlTimestamp(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:timestamp#ymd", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlTimestampYMD(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:str", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlStr(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:binary", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlBinary(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:seq", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlSeq(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:map", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlMap(self, node);
            }
        });
        JRubyConstructor.addConstructor(null, new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return self.constructPrivateType(node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:map:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyMap(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:seq:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubySequence(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:ruby/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRuby(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:java/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructJava(self, pref, node);
            }
        });
    }
}

