/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyDir;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.IOMetaClass;
import org.jruby.util.IOModes;
import org.jruby.util.JRubyFile;
import org.jruby.util.PrintfFormat;
import org.jruby.util.collections.SinglyLinkedList;

public class FileMetaClass
extends IOMetaClass {
    private static final int FNM_NOESCAPE = 1;
    private static final int FNM_PATHNAME = 2;
    private static final int FNM_DOTMATCH = 4;
    private static final int FNM_CASEFOLD = 8;
    public static final PrintfFormat OCTAL_FORMATTER = new PrintfFormat("%o");
    private static ObjectAllocator FILE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyFile instance = new RubyFile(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public FileMetaClass(Ruby runtime) {
        super("File", RubyFile.class, runtime.getClass("IO"), FILE_ALLOCATOR);
    }

    public FileMetaClass(String name, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        super(name, RubyFile.class, superClass, allocator, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new FileMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new FileMetaClass(name, (RubyClass)this, FILE_ALLOCATOR, parentCRef);
    }

    public IRubyObject basename(IRubyObject[] args) {
        int index;
        char c;
        this.checkArgumentCount(args, 1, 2);
        String name = RubyString.stringValue(args[0]).toString();
        if (name.length() > 1 && name.charAt(name.length() - 1) == '/') {
            name = name.substring(0, name.length() - 1);
        }
        int slashCount = 0;
        int length = name.length();
        for (int i = length - 1; i >= 0 && ((c = name.charAt(i)) == '/' || c == '\\'); --i) {
            ++slashCount;
        }
        if (slashCount > 0 && length > 1) {
            name = name.substring(0, name.length() - slashCount);
        }
        if ((index = name.lastIndexOf(47)) == -1) {
            index = name.lastIndexOf(92);
        }
        if (!name.equals("/") && index != -1) {
            name = name.substring(index + 1);
        }
        if (args.length == 2) {
            String ext = RubyString.stringValue(args[1]).toString();
            if (".*".equals(ext)) {
                index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
            } else if (name.endsWith(ext)) {
                name = name.substring(0, name.length() - ext.length());
            }
        }
        return this.getRuntime().newString(name).infectBy(args[0]);
    }

    public IRubyObject chmod(IRubyObject[] args) {
        this.checkArgumentCount(args, 2, -1);
        int count = 0;
        RubyInteger mode = args[0].convertToInteger();
        for (int i = 1; i < args.length; ++i) {
            IRubyObject filename = args[i];
            if (!RubyFileTest.exist_p(filename, filename.convertToString()).isTrue()) {
                throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + filename);
            }
            try {
                Process chmod = Runtime.getRuntime().exec("chmod " + OCTAL_FORMATTER.sprintf(mode.getLongValue()) + " " + filename);
                chmod.waitFor();
                int result = chmod.exitValue();
                if (result != 0) continue;
                ++count;
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getRuntime().newFixnum(count);
    }

    public IRubyObject chown(IRubyObject[] args) {
        this.checkArgumentCount(args, 2, -1);
        int count = 0;
        RubyInteger owner = args[0].convertToInteger();
        for (int i = 1; i < args.length; ++i) {
            IRubyObject filename = args[i];
            if (!RubyFileTest.exist_p(filename, filename.convertToString()).isTrue()) {
                throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + filename);
            }
            try {
                Process chown = Runtime.getRuntime().exec("chown " + owner + " " + filename);
                chown.waitFor();
                int result = chown.exitValue();
                if (result != 0) continue;
                ++count;
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getRuntime().newFixnum(count);
    }

    public IRubyObject dirname(IRubyObject arg) {
        int index;
        RubyString filename = RubyString.stringValue(arg);
        String name = filename.toString().replace('\\', '/');
        if (name.length() > 1 && name.charAt(name.length() - 1) == '/') {
            name = name.substring(0, name.length() - 1);
        }
        if ((index = name.lastIndexOf(47)) == -1) {
            return this.getRuntime().newString(".");
        }
        if (index == 0) {
            return this.getRuntime().newString("/");
        }
        return this.getRuntime().newString(name.substring(0, index)).infectBy(filename);
    }

    public IRubyObject extname(IRubyObject arg) {
        int ix;
        RubyString filename = RubyString.stringValue(arg);
        String name = filename.toString();
        int index = name.lastIndexOf(47);
        if (index == -1) {
            index = name.lastIndexOf(92);
        }
        if ((ix = (name = name.substring(index + 1)).lastIndexOf(".")) == -1) {
            return this.getRuntime().newString("");
        }
        return this.getRuntime().newString(name.substring(ix));
    }

    public IRubyObject expand_path(IRubyObject[] args) {
        String extractedPath;
        this.checkArgumentCount(args, 1, 2);
        String relativePath = RubyString.stringValue(args[0]).toString();
        int pathLength = relativePath.length();
        if (pathLength >= 1 && relativePath.charAt(0) == '~') {
            int userEnd = relativePath.indexOf(47);
            if (userEnd == -1) {
                if (pathLength == 1) {
                    relativePath = RubyDir.getHomeDirectoryPath(this).toString();
                } else {
                    userEnd = pathLength;
                }
            }
            if (userEnd == 1) {
                relativePath = RubyDir.getHomeDirectoryPath(this).toString() + relativePath.substring(1);
            } else if (userEnd > 1) {
                String user = relativePath.substring(1, userEnd);
                IRubyObject dir = RubyDir.getHomeDirectoryPath(this, user);
                if (dir.isNil()) {
                    throw this.getRuntime().newArgumentError("user " + user + " does not exist");
                }
                relativePath = "" + dir + (pathLength == userEnd ? "" : relativePath.substring(userEnd));
            }
        }
        if (new File(relativePath).isAbsolute()) {
            try {
                return this.getRuntime().newString(JRubyFile.create(relativePath, "").getCanonicalPath());
            }
            catch (IOException e) {
                return this.getRuntime().newString(relativePath);
            }
        }
        String cwd = this.getRuntime().getCurrentDirectory();
        if (args.length == 2 && !args[1].isNil()) {
            cwd = RubyString.stringValue(args[1]).toString();
        }
        if (cwd == null) {
            return this.getRuntime().getNil();
        }
        JRubyFile path = JRubyFile.create(cwd, relativePath);
        try {
            extractedPath = path.getCanonicalPath();
        }
        catch (IOException e) {
            extractedPath = path.getAbsolutePath();
        }
        return this.getRuntime().newString(extractedPath);
    }

    public IRubyObject fnmatch(IRubyObject[] args) {
        this.checkArgumentCount(args, 2, -1);
        String pattern = args[0].convertToString().toString();
        RubyString path = args[1].convertToString();
        int opts = (int)(args.length > 2 ? args[2].convertToInteger().getLongValue() : 0L);
        boolean dot = pattern.startsWith(".");
        pattern = pattern.replaceAll("(\\.)", "\\\\$1");
        pattern = pattern.replaceAll("(?<=[^\\\\])\\*", ".*");
        pattern = pattern.replaceAll("^\\*", ".*");
        pattern = pattern.replaceAll("(?<=[^\\\\])\\?", ".");
        pattern = pattern.replaceAll("^\\?", ".");
        if ((opts & 1) != 1) {
            pattern = pattern.replaceAll("\\\\([^\\\\*\\\\?])", "$1");
        }
        pattern = pattern.replaceAll("\\{", "\\\\{");
        pattern = pattern.replaceAll("\\}", "\\\\}");
        pattern = "^" + pattern + "$";
        if (path.toString().startsWith(".") && !dot) {
            return this.getRuntime().newBoolean(false);
        }
        return this.getRuntime().newBoolean(Pattern.matches(pattern, path.toString()));
    }

    public RubyString join(IRubyObject[] args) {
        boolean isTainted = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isTaint()) {
                isTainted = true;
            }
            String element = args[i] instanceof RubyString ? args[i].toString() : (args[i] instanceof RubyArray ? this.join(((RubyArray)args[i]).toJavaArray()).toString() : args[i].convertToString().toString());
            this.chomp(buffer);
            if (i > 0 && !element.startsWith("/") && !element.startsWith("\\")) {
                buffer.append("/");
            }
            buffer.append(element);
        }
        RubyString fixedStr = RubyString.newString(this.getRuntime(), buffer.toString());
        fixedStr.setTaint(isTainted);
        return fixedStr;
    }

    private void chomp(StringBuffer buffer) {
        for (int lastIndex = buffer.length() - 1; lastIndex >= 0 && (buffer.lastIndexOf("/") == lastIndex || buffer.lastIndexOf("\\") == lastIndex); --lastIndex) {
            buffer.setLength(lastIndex);
        }
    }

    public IRubyObject lstat(IRubyObject filename) {
        RubyString name = RubyString.stringValue(filename);
        return this.getRuntime().newRubyFileStat(name.toString());
    }

    public IRubyObject ctime(IRubyObject filename) {
        RubyString name = RubyString.stringValue(filename);
        return this.getRuntime().newTime(JRubyFile.create(this.getRuntime().getCurrentDirectory(), name.toString()).getParentFile().lastModified());
    }

    public IRubyObject mtime(IRubyObject filename) {
        RubyString name = RubyString.stringValue(filename);
        return this.getRuntime().newTime(JRubyFile.create(this.getRuntime().getCurrentDirectory(), name.toString()).lastModified());
    }

    public IRubyObject open(IRubyObject[] args, Block block) {
        return this.open(args, true, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject open(IRubyObject[] args, boolean tryToYield, Block block) {
        this.checkArgumentCount(args, 1, -1);
        Ruby runtime = this.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        RubyString pathString = RubyString.stringValue(args[0]);
        pathString.checkSafeString();
        String path = pathString.toString();
        IOModes modes = args.length >= 2 ? this.getModes(args[1]) : new IOModes(runtime, 0L);
        RubyFile file = new RubyFile(runtime, this);
        RubyInteger fileMode = args.length >= 3 ? args[2].convertToInteger() : null;
        file.openInternal(path, modes);
        if (fileMode != null) {
            this.chmod(new IRubyObject[]{fileMode, pathString});
        }
        if (tryToYield && block.isGiven()) {
            try {
                IRubyObject iRubyObject = tc.yield(file, block);
                return iRubyObject;
            }
            finally {
                file.close();
            }
        }
        return file;
    }

    public IRubyObject rename(IRubyObject oldName, IRubyObject newName) {
        RubyString oldNameString = RubyString.stringValue(oldName);
        RubyString newNameString = RubyString.stringValue(newName);
        oldNameString.checkSafeString();
        newNameString.checkSafeString();
        JRubyFile oldFile = JRubyFile.create(this.getRuntime().getCurrentDirectory(), oldNameString.toString());
        JRubyFile newFile = JRubyFile.create(this.getRuntime().getCurrentDirectory(), newNameString.toString());
        if (!oldFile.exists() || !newFile.getParentFile().exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + oldNameString + " or " + newNameString);
        }
        oldFile.renameTo(JRubyFile.create(this.getRuntime().getCurrentDirectory(), newNameString.toString()));
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject size_p(IRubyObject filename) {
        long size = 0L;
        try {
            FileInputStream fis = new FileInputStream(new File(filename.toString()));
            FileChannel chan = fis.getChannel();
            size = chan.size();
            chan.close();
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (size == 0L) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(size);
    }

    public RubyArray split(IRubyObject arg) {
        RubyString filename = RubyString.stringValue(arg);
        return filename.getRuntime().newArray(this.dirname(filename), this.basename(new IRubyObject[]{filename}));
    }

    public IRubyObject symlink_p(IRubyObject arg1) {
        RubyString filename = RubyString.stringValue(arg1);
        JRubyFile file = JRubyFile.create(this.getRuntime().getCurrentDirectory(), filename.toString());
        try {
            File absoluteParent = file.getAbsoluteFile().getParentFile();
            File canonicalParent = file.getAbsoluteFile().getParentFile().getCanonicalFile();
            if (canonicalParent.getAbsolutePath().equals(absoluteParent.getAbsolutePath())) {
                return file.getAbsolutePath().equals(file.getCanonicalPath()) ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
            }
            file = JRubyFile.create(this.getRuntime().getCurrentDirectory(), canonicalParent.getAbsolutePath() + "/" + file.getName());
            return file.getAbsolutePath().equals(file.getCanonicalPath()) ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
        }
        catch (IOException ioe) {
            return this.getRuntime().getFalse();
        }
    }

    public IRubyObject truncate(IRubyObject arg1, IRubyObject arg2) {
        RubyString filename = RubyString.stringValue(arg1);
        RubyFixnum newLength = (RubyFixnum)arg2.convertToType("Fixnum", "to_int", true);
        IRubyObject[] args = new IRubyObject[]{filename, this.getRuntime().newString("w+")};
        RubyFile file = (RubyFile)this.open(args, false, null);
        file.truncate(newLength);
        file.close();
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject utime(IRubyObject[] args) {
        this.checkArgumentCount(args, 2, -1);
        long mtime = args[1] instanceof RubyTime ? ((RubyTime)args[1]).getJavaDate().getTime() : (args[1] instanceof RubyNumeric ? RubyNumeric.num2long(args[1]) : 0L);
        int j = args.length;
        for (int i = 2; i < j; ++i) {
            RubyString filename = RubyString.stringValue(args[i]);
            filename.checkSafeString();
            JRubyFile fileToTouch = JRubyFile.create(this.getRuntime().getCurrentDirectory(), filename.toString());
            if (!fileToTouch.exists()) {
                throw this.getRuntime().newErrnoENOENTError(" No such file or directory - \"" + filename + "\"");
            }
            fileToTouch.setLastModified(mtime);
        }
        return this.getRuntime().newFixnum(args.length - 2);
    }

    public IRubyObject unlink(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            RubyString filename = RubyString.stringValue(args[i]);
            filename.checkSafeString();
            JRubyFile lToDelete = JRubyFile.create(this.getRuntime().getCurrentDirectory(), filename.toString());
            if (!lToDelete.exists()) {
                throw this.getRuntime().newErrnoENOENTError(" No such file or directory - \"" + filename + "\"");
            }
            if (lToDelete.delete()) continue;
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newFixnum(args.length);
    }

    private IOModes getModes(IRubyObject object) {
        if (object instanceof RubyString) {
            return new IOModes(this.getRuntime(), ((RubyString)object).toString());
        }
        if (object instanceof RubyFixnum) {
            return new IOModes(this.getRuntime(), ((RubyFixnum)object).getLongValue());
        }
        throw this.getRuntime().newTypeError("Invalid type for modes");
    }

    protected class FileMeta
    extends AbstractMetaClass.Meta {
        protected FileMeta() {
        }

        protected void initializeClass() {
            Ruby runtime = FileMetaClass.this.getRuntime();
            RubyString separator = runtime.newString("/");
            separator.freeze();
            FileMetaClass.this.defineConstant("SEPARATOR", separator);
            FileMetaClass.this.defineConstant("Separator", separator);
            RubyString altSeparator = runtime.newString(File.separatorChar == '/' ? "\\" : "/");
            altSeparator.freeze();
            FileMetaClass.this.defineConstant("ALT_SEPARATOR", altSeparator);
            RubyString pathSeparator = runtime.newString(File.pathSeparator);
            pathSeparator.freeze();
            FileMetaClass.this.defineConstant("PATH_SEPARATOR", pathSeparator);
            FileMetaClass.this.setConstant("BINARY", runtime.newFixnum(4096L));
            FileMetaClass.this.setConstant("FNM_NOESCAPE", runtime.newFixnum(1L));
            FileMetaClass.this.setConstant("FNM_CASEFOLD", runtime.newFixnum(8L));
            FileMetaClass.this.setConstant("FNM_DOTMATCH", runtime.newFixnum(4L));
            FileMetaClass.this.setConstant("FNM_PATHNAME", runtime.newFixnum(2L));
            FileMetaClass.this.setConstant("RDONLY", runtime.newFixnum(0L));
            FileMetaClass.this.setConstant("WRONLY", runtime.newFixnum(1L));
            FileMetaClass.this.setConstant("RDWR", runtime.newFixnum(2L));
            FileMetaClass.this.setConstant("CREAT", runtime.newFixnum(64L));
            FileMetaClass.this.setConstant("EXCL", runtime.newFixnum(128L));
            FileMetaClass.this.setConstant("NOCTTY", runtime.newFixnum(256L));
            FileMetaClass.this.setConstant("TRUNC", runtime.newFixnum(512L));
            FileMetaClass.this.setConstant("APPEND", runtime.newFixnum(1024L));
            FileMetaClass.this.setConstant("NONBLOCK", runtime.newFixnum(2048L));
            FileMetaClass.this.setConstant("LOCK_SH", runtime.newFixnum(1L));
            FileMetaClass.this.setConstant("LOCK_EX", runtime.newFixnum(2L));
            FileMetaClass.this.setConstant("LOCK_NB", runtime.newFixnum(4L));
            FileMetaClass.this.setConstant("LOCK_UN", runtime.newFixnum(8L));
            RubyModule constants = FileMetaClass.this.defineModuleUnder("Constants");
            constants.setConstant("BINARY", runtime.newFixnum(32768L));
            constants.setConstant("FNM_NOESCAPE", runtime.newFixnum(1L));
            constants.setConstant("FNM_CASEFOLD", runtime.newFixnum(8L));
            constants.setConstant("FNM_DOTMATCH", runtime.newFixnum(4L));
            constants.setConstant("FNM_PATHNAME", runtime.newFixnum(2L));
            constants.setConstant("RDONLY", runtime.newFixnum(0L));
            constants.setConstant("WRONLY", runtime.newFixnum(1L));
            constants.setConstant("RDWR", runtime.newFixnum(2L));
            constants.setConstant("CREAT", runtime.newFixnum(64L));
            constants.setConstant("EXCL", runtime.newFixnum(128L));
            constants.setConstant("NOCTTY", runtime.newFixnum(256L));
            constants.setConstant("TRUNC", runtime.newFixnum(512L));
            constants.setConstant("APPEND", runtime.newFixnum(1024L));
            constants.setConstant("NONBLOCK", runtime.newFixnum(2048L));
            constants.setConstant("LOCK_SH", runtime.newFixnum(1L));
            constants.setConstant("LOCK_EX", runtime.newFixnum(2L));
            constants.setConstant("LOCK_NB", runtime.newFixnum(4L));
            constants.setConstant("LOCK_UN", runtime.newFixnum(8L));
            FileMetaClass.this.extendObject(runtime.getModule("FileTest"));
            FileMetaClass.this.defineFastSingletonMethod("basename", Arity.optional());
            FileMetaClass.this.defineFastSingletonMethod("chmod", Arity.required(2));
            FileMetaClass.this.defineFastSingletonMethod("chown", Arity.required(2));
            FileMetaClass.this.defineFastSingletonMethod("delete", Arity.optional(), "unlink");
            FileMetaClass.this.defineFastSingletonMethod("dirname", Arity.singleArgument());
            FileMetaClass.this.defineFastSingletonMethod("expand_path", Arity.optional());
            FileMetaClass.this.defineFastSingletonMethod("extname", Arity.singleArgument());
            FileMetaClass.this.defineFastSingletonMethod("fnmatch", Arity.optional());
            FileMetaClass.this.defineFastSingletonMethod("fnmatch?", Arity.optional(), "fnmatch");
            FileMetaClass.this.defineFastSingletonMethod("join", Arity.optional());
            FileMetaClass.this.defineFastSingletonMethod("lstat", Arity.singleArgument());
            FileMetaClass.this.defineFastSingletonMethod("mtime", Arity.singleArgument());
            FileMetaClass.this.defineFastSingletonMethod("ctime", Arity.singleArgument());
            FileMetaClass.this.defineSingletonMethod("open", Arity.optional());
            FileMetaClass.this.defineFastSingletonMethod("rename", Arity.twoArguments());
            FileMetaClass.this.defineFastSingletonMethod("size?", Arity.singleArgument(), "size_p");
            FileMetaClass.this.defineFastSingletonMethod("split", Arity.singleArgument());
            FileMetaClass.this.defineFastSingletonMethod("stat", Arity.singleArgument(), "lstat");
            FileMetaClass.this.defineFastSingletonMethod("symlink?", Arity.singleArgument(), "symlink_p");
            FileMetaClass.this.defineFastSingletonMethod("truncate", Arity.twoArguments());
            FileMetaClass.this.defineFastSingletonMethod("utime", Arity.optional());
            FileMetaClass.this.defineFastSingletonMethod("unlink", Arity.optional());
            FileMetaClass.this.defineFastMethod("chmod", Arity.required(1));
            FileMetaClass.this.defineFastMethod("chown", Arity.required(1));
            FileMetaClass.this.defineFastMethod("ctime", Arity.noArguments());
            FileMetaClass.this.defineMethod("initialize", Arity.optional());
            FileMetaClass.this.defineFastMethod("path", Arity.noArguments());
            FileMetaClass.this.defineFastMethod("stat", Arity.noArguments());
            FileMetaClass.this.defineFastMethod("truncate", Arity.singleArgument());
            FileMetaClass.this.defineFastMethod("flock", Arity.singleArgument());
            RubyFileStat.createFileStatClass(runtime);
        }
    }
}

