/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.runtime.Arity;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public abstract class AbstractMetaClass
extends RubyClass {
    protected Class builtinClass;
    protected MethodFactory mfactory = MethodFactory.createFactory();

    protected Meta getMeta() {
        return null;
    }

    protected AbstractMetaClass(Ruby runtime, RubyClass metaClass, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef, String name, Class builtinClass) {
        super(runtime, metaClass, superClass, allocator, parentCRef, name);
        this.builtinClass = builtinClass;
    }

    protected AbstractMetaClass(String name, Class builtinClass, RubyClass superClass, ObjectAllocator allocator) {
        this(name, builtinClass, superClass, allocator, superClass.getRuntime().getClass("Object").getCRef(), true);
    }

    protected AbstractMetaClass(String name, Class builtinClass, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        this(name, builtinClass, superClass, allocator, parentCRef, false);
    }

    protected AbstractMetaClass(String name, Class builtinClass, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef, boolean init) {
        super(superClass.getRuntime(), superClass.getRuntime().getClass("Class"), superClass, allocator, parentCRef, name);
        assert (name != null);
        assert (builtinClass != null);
        assert (superClass != null);
        this.builtinClass = builtinClass;
        this.makeMetaClass(superClass.getMetaClass(), superClass.getRuntime().getCurrentContext().peekCRef());
        this.inheritedBy(superClass);
        if (name != null) {
            ((RubyModule)parentCRef.getValue()).setConstant(name, this);
        }
        if (init) {
            this.getMeta().initializeClass();
        }
    }

    public AbstractMetaClass(Ruby runtime, RubyClass metaClass, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef, String name) {
        super(runtime, metaClass, superClass, allocator, parentCRef, name);
    }

    public void defineMethod(String name, Arity arity) {
        this.defineMethod(name, arity, name);
    }

    public void defineMethod(String name, Arity arity, String java_name) {
        assert (name != null);
        assert (arity != null);
        assert (java_name != null);
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, this.mfactory.getFullMethod(this, this.builtinClass, java_name, arity, visibility));
    }

    public void definePrivateMethod(String name, Arity arity) {
        this.addMethod(name, this.mfactory.getFullMethod(this, this.builtinClass, name, arity, Visibility.PRIVATE));
    }

    public void definePrivateMethod(String name, Arity arity, String java_name) {
        this.addMethod(name, this.mfactory.getFullMethod(this, this.builtinClass, java_name, arity, Visibility.PRIVATE));
    }

    public void defineFastMethod(String name, Arity arity) {
        this.defineFastMethod(name, arity, name);
    }

    public void defineFastMethod(String name, Arity arity, String java_name) {
        assert (name != null);
        assert (arity != null);
        assert (java_name != null);
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, this.mfactory.getSimpleMethod(this, this.builtinClass, java_name, arity, visibility));
    }

    public void defineFastPrivateMethod(String name, Arity arity) {
        this.addMethod(name, this.mfactory.getSimpleMethod(this, this.builtinClass, name, arity, Visibility.PRIVATE));
    }

    public void defineFastPrivateMethod(String name, Arity arity, String java_name) {
        this.addMethod(name, this.mfactory.getSimpleMethod(this, this.builtinClass, java_name, arity, Visibility.PRIVATE));
    }

    public void defineSingletonMethod(String name, Arity arity) {
        this.defineSingletonMethod(name, arity, name);
    }

    public void defineSingletonMethod(String name, Arity arity, String java_name) {
        assert (name != null);
        assert (arity != null);
        assert (java_name != null);
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.getSingletonClass().addMethod(name, this.mfactory.getFullMethod(this, this.getClass(), java_name, arity, visibility));
    }

    public void defineFastSingletonMethod(String name, Arity arity) {
        this.defineFastSingletonMethod(name, arity, name);
    }

    public void defineFastSingletonMethod(String name, Arity arity, String java_name) {
        assert (name != null);
        assert (arity != null);
        assert (java_name != null);
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.getSingletonClass().addMethod(name, this.mfactory.getSimpleMethod(this, this.getClass(), java_name, arity, visibility));
    }

    public void initializeBootstrapClass() {
        this.getMeta().initializeClass();
    }

    protected abstract class Meta {
        protected Meta() {
        }

        protected abstract void initializeClass();

        protected Object[][] getPublicMethods() {
            return new Object[0][];
        }

        protected Object[][] getDefineConstants() {
            return new Object[0][];
        }

        protected Object[][] getSetConstants() {
            return new Object[0][];
        }

        protected Object[][] getSingletonMethods() {
            return new Object[0][];
        }

        protected String[][] getAliases() {
            return new String[0][];
        }

        protected Object[][] getPrivateMethods() {
            return new Object[0][];
        }

        protected String[] getIncludedModules() {
            return new String[0];
        }

        protected String[] getUndefineMethods() {
            return new String[0];
        }

        protected String[] getUndefineSingletonMethods() {
            return new String[0];
        }

        public void undefineMethods(String[] undefineMethods, boolean singleton) {
            for (int i = 0; i < undefineMethods.length; ++i) {
                if (singleton) {
                    AbstractMetaClass.this.getSingletonClass().undefineMethod(undefineMethods[i]);
                    continue;
                }
                AbstractMetaClass.this.undefineMethod(undefineMethods[i]);
            }
        }

        public void defineConstants(Object[][] constants, boolean singleton) {
            for (int i = 0; i < constants.length; ++i) {
                if (singleton) {
                    AbstractMetaClass.this.getSingletonClass().defineConstant((String)constants[i][0], (IRubyObject)constants[i][1]);
                    continue;
                }
                AbstractMetaClass.this.defineConstant((String)constants[i][0], (IRubyObject)constants[i][1]);
            }
        }

        public void setConstants(Object[][] constants, boolean singleton) {
            for (int i = 0; i < constants.length; ++i) {
                if (singleton) {
                    AbstractMetaClass.this.getSingletonClass().setConstant((String)constants[i][0], (IRubyObject)constants[i][1]);
                    continue;
                }
                AbstractMetaClass.this.setConstant((String)constants[i][0], (IRubyObject)constants[i][1]);
            }
        }

        public void includeModules(String[] includedModules) {
            for (int i = 0; i < includedModules.length; ++i) {
                AbstractMetaClass.this.includeModule(AbstractMetaClass.this.getRuntime().getModule(includedModules[i]));
            }
        }

        public void defineAliases(Object[][] aliases) {
            for (int i = 0; i < aliases.length; ++i) {
                AbstractMetaClass.this.defineAlias((String)aliases[i][0], (String)aliases[i][1]);
            }
        }
    }
}

