/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class JavaProxyClass
extends JavaProxyReflectionObject {
    static ThreadLocal runtimeTLS = new ThreadLocal();
    private final Class proxyClass;
    private ArrayList methods = new ArrayList();

    JavaProxyClass(Class proxyClass) {
        super(JavaProxyClass.getThreadLocalRuntime(), JavaProxyClass.getThreadLocalRuntime().getModule("Java").getClass("JavaProxyClass"));
        this.proxyClass = proxyClass;
    }

    public Object getValue() {
        return this;
    }

    private static Ruby getThreadLocalRuntime() {
        return (Ruby)runtimeTLS.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaProxyClass getProxyClass(Ruby runtime, Class superClass, Class[] interfaces) throws InvocationTargetException {
        Object save = runtimeTLS.get();
        runtimeTLS.set(runtime);
        try {
            ClassLoader loader = runtime.getJavaSupport().getJavaClassLoader();
            JavaProxyClass javaProxyClass = JavaProxyClassFactory.newProxyClass(loader, null, superClass, interfaces);
            return javaProxyClass;
        }
        finally {
            runtimeTLS.set(save);
        }
    }

    public static Object newProxyInstance(Ruby runtime, Class superClass, Class[] interfaces, Class[] constructorParameters, Object[] constructorArgs, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        JavaProxyClass jpc = JavaProxyClass.getProxyClass(runtime, superClass, interfaces);
        JavaProxyConstructor cons = jpc.getConstructor(constructorParameters == null ? new Class[]{} : constructorParameters);
        return cons.newInstance(constructorArgs, handler);
    }

    public Class getSuperclass() {
        return this.proxyClass.getSuperclass();
    }

    public Class[] getInterfaces() {
        Class<?>[] ifaces = this.proxyClass.getInterfaces();
        Class[] result = new Class[ifaces.length - 1];
        int pos = 0;
        for (int i = 0; i < ifaces.length; ++i) {
            if (ifaces[i] == InternalJavaProxy.class) continue;
            result[pos++] = ifaces[i];
        }
        return result;
    }

    public JavaProxyConstructor[] getConstructors() {
        Constructor<?>[] cons = this.proxyClass.getConstructors();
        JavaProxyConstructor[] result = new JavaProxyConstructor[cons.length];
        for (int i = 0; i < cons.length; ++i) {
            result[i] = new JavaProxyConstructor(this.getRuntime(), this, cons[i]);
        }
        return result;
    }

    public JavaProxyConstructor getConstructor(Class[] args) throws SecurityException, NoSuchMethodException {
        Class[] realArgs = new Class[args.length + 1];
        System.arraycopy(args, 0, realArgs, 0, args.length);
        realArgs[args.length] = JavaProxyInvocationHandler.class;
        Constructor constructor = this.proxyClass.getConstructor(realArgs);
        return new JavaProxyConstructor(this.getRuntime(), this, constructor);
    }

    public JavaProxyMethod[] getMethods() {
        return this.methods.toArray(new JavaProxyMethod[this.methods.size()]);
    }

    public JavaProxyMethod getMethod(String name, Class[] parameterTypes) throws NoSuchMethodException {
        JavaProxyMethod[] all = this.getMethods();
        for (int i = 0; i < all.length; ++i) {
            ProxyMethodImpl jpm = (ProxyMethodImpl)all[i];
            if (!jpm.matches(name, parameterTypes)) continue;
            return jpm;
        }
        throw new NoSuchMethodException();
    }

    Class getProxyClass() {
        return this.proxyClass;
    }

    JavaProxyMethod initMethod(String name, String desc, boolean hasSuper) {
        Class proxy = this.proxyClass;
        try {
            Class[] parms = JavaProxyClass.parse(proxy.getClassLoader(), desc);
            Method m = proxy.getDeclaredMethod(name, parms);
            Method sm = null;
            if (hasSuper) {
                sm = proxy.getDeclaredMethod("__super$" + name, parms);
            }
            ProxyMethodImpl jpm = new ProxyMethodImpl(this.getRuntime(), this, m, sm);
            this.methods.add(jpm);
            return jpm;
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
        catch (SecurityException e) {
            throw new InternalError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static Class[] parse(final ClassLoader loader, String desc) throws ClassNotFoundException {
        ArrayList<Class<Byte>> al = new ArrayList<Class<Byte>>();
        int idx = 1;
        while (desc.charAt(idx) != ')') {
            Class type;
            int arr = 0;
            while (desc.charAt(idx) == '[') {
                ++idx;
                ++arr;
            }
            switch (desc.charAt(idx)) {
                case 'L': {
                    int semi = desc.indexOf(59, idx);
                    final String name = desc.substring(idx + 1, semi);
                    idx = semi;
                    try {
                        type = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws ClassNotFoundException {
                                return Class.forName(name.replace('/', '.'), false, loader);
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException e) {
                        throw (ClassNotFoundException)e.getException();
                    }
                }
                case 'B': {
                    type = Byte.TYPE;
                    break;
                }
                case 'C': {
                    type = Character.TYPE;
                    break;
                }
                case 'Z': {
                    type = Boolean.TYPE;
                    break;
                }
                case 'S': {
                    type = Short.TYPE;
                    break;
                }
                case 'I': {
                    type = Integer.TYPE;
                    break;
                }
                case 'J': {
                    type = Long.TYPE;
                    break;
                }
                case 'F': {
                    type = Float.TYPE;
                    break;
                }
                case 'D': {
                    type = Double.TYPE;
                    break;
                }
                default: {
                    throw new InternalError("cannot parse " + desc + "[" + idx + "]");
                }
            }
            ++idx;
            if (arr != 0) {
                type = Array.newInstance(type, new int[arr]).getClass();
            }
            al.add(type);
        }
        return al.toArray(new Class[al.size()]);
    }

    public static RubyClass createJavaProxyClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaProxyClass", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaProxyClass.class);
        JavaProxyReflectionObject.registerRubyMethods(runtime, result);
        result.defineFastMethod("constructors", callbackFactory.getFastMethod("constructors"));
        result.defineFastMethod("superclass", callbackFactory.getFastMethod("superclass"));
        result.defineFastMethod("interfaces", callbackFactory.getFastMethod("interfaces"));
        result.defineFastMethod("methods", callbackFactory.getFastMethod("methods"));
        result.getMetaClass().defineFastMethod("get", callbackFactory.getFastSingletonMethod("get", JavaClass.class));
        result.defineFastMethod("define_instance_methods_for_proxy", callbackFactory.getFastMethod("define_instance_methods_for_proxy", IRubyObject.class));
        return result;
    }

    public static RubyObject get(IRubyObject recv, JavaClass type) {
        try {
            return JavaProxyClass.getProxyClass(recv.getRuntime(), (Class)type.getValue(), new Class[0]);
        }
        catch (Error e) {
            RaiseException ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + type.getValue());
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            RaiseException ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + type.getValue());
            ex.initCause(e);
            throw ex;
        }
    }

    public RubyObject superclass() {
        return JavaClass.get(this.getRuntime(), this.getSuperclass());
    }

    public RubyArray methods() {
        return this.buildRubyArray(this.getMethods());
    }

    public RubyArray interfaces() {
        Class[] interfaces = this.getInterfaces();
        return this.buildRubyArray(interfaces);
    }

    public RubyArray constructors() {
        return this.buildRubyArray(this.getConstructors());
    }

    public static void createJavaProxyModule(Ruby runtime) {
        RubyModule javaProxyModule = runtime.getModule("Java");
        JavaProxyClass.createJavaProxyClassClass(runtime, javaProxyModule);
        ProxyMethodImpl.createJavaProxyMethodClass(runtime, javaProxyModule);
        JavaProxyConstructor.createJavaProxyConstructorClass(runtime, javaProxyModule);
    }

    public String nameOnInspection() {
        return "[Proxy:" + this.getSuperclass().getName() + "]";
    }

    public IRubyObject define_instance_methods_for_proxy(IRubyObject arg) {
        assert (arg instanceof RubyClass);
        Map aliasesClump = this.getPropertysClumped();
        Map methodsClump = this.getMethodsClumped(false);
        RubyClass proxy = (RubyClass)arg;
        for (String name : methodsClump.keySet()) {
            RubyArray methods = (RubyArray)methodsClump.get(name);
            ArrayList<String> aliases = (ArrayList<String>)aliasesClump.get(name);
            if (aliases == null) {
                aliases = new ArrayList<String>();
            }
            aliases.add(name);
            this.define_instance_method_for_proxy(proxy, aliases, methods);
        }
        return this.getRuntime().getNil();
    }

    private Map getMethodsClumped(boolean isStatic) {
        HashMap<String, RubyArray> map = new HashMap<String, RubyArray>();
        JavaProxyMethod[] methods = this.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (isStatic != Modifier.isStatic(methods[i].getModifiers())) continue;
            String key = methods[i].getName();
            RubyArray methodsWithName = (RubyArray)map.get(key);
            if (methodsWithName == null) {
                methodsWithName = this.getRuntime().newArray();
                map.put(key, methodsWithName);
            }
            methodsWithName.append(methods[i]);
        }
        return map;
    }

    private Map getPropertysClumped() {
        BeanInfo info;
        HashMap map = new HashMap();
        try {
            info = Introspector.getBeanInfo(this.proxyClass);
        }
        catch (IntrospectionException e) {
            return map;
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            Method writeMethod;
            Method readMethod = descriptors[i].getReadMethod();
            if (readMethod != null) {
                String key = readMethod.getName();
                ArrayList<String> aliases = (ArrayList<String>)map.get(key);
                if (aliases == null) {
                    aliases = new ArrayList<String>();
                    map.put(key, aliases);
                }
                if (readMethod.getReturnType() == Boolean.class || readMethod.getReturnType() == Boolean.TYPE) {
                    aliases.add(descriptors[i].getName() + "?");
                }
                aliases.add(descriptors[i].getName());
            }
            if ((writeMethod = descriptors[i].getWriteMethod()) == null) continue;
            String key = writeMethod.getName();
            ArrayList<String> aliases = (ArrayList<String>)map.get(key);
            if (aliases == null) {
                aliases = new ArrayList<String>();
                map.put(key, aliases);
            }
            aliases.add(descriptors[i].getName() + "=");
        }
        return map;
    }

    private void define_instance_method_for_proxy(final RubyClass proxy, List names, final RubyArray methods) {
        final RubyModule javaUtilities = this.getRuntime().getModule("JavaUtilities");
        Callback method = new Callback(){

            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                IRubyObject[] argsArray = new IRubyObject[args.length + 1];
                argsArray[0] = self.callMethod(JavaProxyClass.this.getRuntime().getCurrentContext(), "java_object");
                RubyArray argsAsArray = JavaProxyClass.this.getRuntime().newArray();
                for (int j = 0; j < args.length; ++j) {
                    argsArray[j + 1] = args[j];
                    argsAsArray.append(Java.ruby_to_java(proxy, argsArray[j + 1], Block.NULL_BLOCK));
                }
                IRubyObject[] mmArgs = new IRubyObject[]{methods, argsAsArray};
                IRubyObject result = javaUtilities.callMethod(JavaProxyClass.this.getRuntime().getCurrentContext(), "matching_method", mmArgs);
                return Java.java_to_ruby(self, result.callMethod(JavaProxyClass.this.getRuntime().getCurrentContext(), "invoke", argsArray), Block.NULL_BLOCK);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        };
        for (String methodName : names) {
            if (methodName.equals("class")) continue;
            proxy.defineMethod(methodName, method);
            String rubyCasedName = JavaClass.getRubyCasedName(methodName);
            if (rubyCasedName == null) continue;
            proxy.defineAlias(rubyCasedName, methodName);
        }
    }

    public static class ProxyMethodImpl
    extends JavaProxyReflectionObject
    implements JavaProxyMethod {
        private final Method m;
        private Object state;
        private final Method sm;
        private final JavaProxyClass clazz;

        public ProxyMethodImpl(Ruby runtime, JavaProxyClass clazz, Method m, Method sm) {
            super(runtime, runtime.getModule("Java").getClass("JavaProxyMethod"));
            this.m = m;
            this.sm = sm;
            this.clazz = clazz;
        }

        public Method getMethod() {
            return this.m;
        }

        public Method getSuperMethod() {
            return this.sm;
        }

        public int getModifiers() {
            return this.m.getModifiers();
        }

        public String getName() {
            return this.m.getName();
        }

        public Class[] getExceptionTypes() {
            return this.m.getExceptionTypes();
        }

        public Class[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        public Object getState() {
            return this.state;
        }

        public boolean hasSuperImplementation() {
            return this.sm != null;
        }

        public Object invoke(Object proxy, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (!this.hasSuperImplementation()) {
                throw new NoSuchMethodException();
            }
            return this.sm.invoke(proxy, args);
        }

        public void setState(Object state) {
            this.state = state;
        }

        public String toString() {
            return this.m.toString();
        }

        public Object defaultResult() {
            Class<?> rt = this.m.getReturnType();
            if (rt == Void.TYPE) {
                return null;
            }
            if (rt == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (rt == Byte.TYPE) {
                return new Byte(0);
            }
            if (rt == Short.TYPE) {
                return new Short(0);
            }
            if (rt == Integer.TYPE) {
                return new Integer(0);
            }
            if (rt == Long.TYPE) {
                return new Long(0L);
            }
            if (rt == Float.TYPE) {
                return new Float(0.0f);
            }
            if (rt == Double.TYPE) {
                return new Double(0.0);
            }
            return null;
        }

        public boolean matches(String name, Class[] parameterTypes) {
            return this.m.getName().equals(name) && Arrays.equals(this.m.getParameterTypes(), parameterTypes);
        }

        public Class getReturnType() {
            return this.m.getReturnType();
        }

        public static RubyClass createJavaProxyMethodClass(Ruby runtime, RubyModule javaProxyModule) {
            RubyClass result = javaProxyModule.defineClassUnder("JavaProxyMethod", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            CallbackFactory callbackFactory = runtime.callbackFactory(ProxyMethodImpl.class);
            JavaProxyReflectionObject.registerRubyMethods(runtime, result);
            result.defineFastMethod("argument_types", callbackFactory.getFastMethod("argument_types"));
            result.defineFastMethod("declaring_class", callbackFactory.getFastMethod("getDeclaringClass"));
            result.defineFastMethod("super?", callbackFactory.getFastMethod("super_p"));
            result.defineFastMethod("arity", callbackFactory.getFastMethod("arity"));
            result.defineFastMethod("name", callbackFactory.getFastMethod("name"));
            result.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
            result.defineFastMethod("invoke", callbackFactory.getFastOptMethod("do_invoke"));
            return result;
        }

        public RubyObject name() {
            return this.getRuntime().newString(this.getName());
        }

        public JavaProxyClass getDeclaringClass() {
            return this.clazz;
        }

        public RubyArray argument_types() {
            return this.buildRubyArray(this.getParameterTypes());
        }

        public IRubyObject super_p() {
            return this.hasSuperImplementation() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public RubyFixnum arity() {
            return this.getRuntime().newFixnum(this.getArity());
        }

        protected String nameOnInspection() {
            return this.getDeclaringClass().nameOnInspection() + "/" + this.getName();
        }

        public IRubyObject inspect() {
            StringBuffer result = new StringBuffer();
            result.append(this.nameOnInspection());
            result.append("(");
            Class[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                result.append(parameterTypes[i].getName());
                if (i >= parameterTypes.length - 1) continue;
                result.append(',');
            }
            result.append(")>");
            return this.getRuntime().newString(result.toString());
        }

        public IRubyObject do_invoke(IRubyObject[] nargs) {
            if (nargs.length != 1 + this.getArity()) {
                throw this.getRuntime().newArgumentError(nargs.length, 1 + this.getArity());
            }
            IRubyObject invokee = nargs[0];
            if (!(invokee instanceof JavaObject)) {
                throw this.getRuntime().newTypeError("invokee not a java object");
            }
            Object receiver_value = ((JavaObject)invokee).getValue();
            Object[] arguments = new Object[nargs.length - 1];
            System.arraycopy(nargs, 1, arguments, 0, arguments.length);
            Class[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = JavaUtil.convertRubyToJava((IRubyObject)arguments[i], parameterTypes[i]);
            }
            try {
                Object javaResult = this.sm.invoke(receiver_value, arguments);
                return JavaUtil.convertJavaToRuby(this.getRuntime(), javaResult, this.getReturnType());
            }
            catch (IllegalArgumentException e) {
                throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect());
            }
            catch (IllegalAccessException iae) {
                throw this.getRuntime().newTypeError("illegal access on '" + this.sm.getName() + "': " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                ite.getTargetException().printStackTrace();
                this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
                return this.getRuntime().getNil();
            }
        }

        private int getArity() {
            return this.getParameterTypes().length;
        }
    }
}

