/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class JavaUtil {
    public static Object convertRubyToJava(IRubyObject rubyObject) {
        return JavaUtil.convertRubyToJava(rubyObject, null);
    }

    public static Object convertRubyToJava(IRubyObject rubyObject, Class javaClass) {
        if (rubyObject == null || rubyObject.isNil()) {
            return null;
        }
        ThreadContext context = rubyObject.getRuntime().getCurrentContext();
        if (rubyObject.respondsTo("java_object")) {
            rubyObject = rubyObject.callMethod(context, "java_object");
        }
        if (rubyObject instanceof JavaObject) {
            Object value = ((JavaObject)rubyObject).getValue();
            return JavaUtil.convertArgument(value, javaClass);
        }
        if ((javaClass == Object.class || javaClass == null) && (javaClass = rubyObject.getJavaClass()) == IRubyObject.class) {
            javaClass = String.class;
        }
        if (javaClass.isInstance(rubyObject)) {
            return rubyObject;
        }
        if (javaClass.isPrimitive()) {
            String cName = javaClass.getName();
            if (cName == "boolean") {
                return rubyObject.isTrue();
            }
            if (cName == "float") {
                if (rubyObject.respondsTo("to_f")) {
                    return new Float(((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue());
                }
                return new Float(0.0);
            }
            if (cName == "double") {
                if (rubyObject.respondsTo("to_f")) {
                    return new Double(((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue());
                }
                return new Double(0.0);
            }
            if (cName == "long") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Long(((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue());
                }
                return new Long(0L);
            }
            if (cName == "int") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Integer((int)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue());
                }
                return new Integer(0);
            }
            if (cName == "short") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Short((short)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue());
                }
                return new Short(0);
            }
            if (cName == "byte") {
                if (rubyObject.respondsTo("to_i")) {
                    return new Byte((byte)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue());
                }
                return new Byte(0);
            }
            String s = ((RubyString)rubyObject.callMethod(context, "to_s")).toString();
            if (s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return new Character('\u0000');
        }
        if (javaClass == String.class) {
            return ((RubyString)rubyObject.callMethod(context, "to_s")).toString();
        }
        if (javaClass == ByteList.class) {
            return rubyObject.convertToString().getByteList();
        }
        if (javaClass == BigInteger.class) {
            if (rubyObject instanceof RubyBignum) {
                return ((RubyBignum)rubyObject).getValue();
            }
            if (rubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)rubyObject).getLongValue());
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyNumeric rubyNumeric = (RubyNumeric)rubyObject.callMethod(context, "to_f");
                return BigInteger.valueOf(rubyNumeric.getLongValue());
            }
        } else if (javaClass == BigDecimal.class && !(rubyObject instanceof JavaObject) && rubyObject.respondsTo("to_f")) {
            double double_value = ((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue();
            return new BigDecimal(double_value);
        }
        try {
            return ((JavaObject)rubyObject).getValue();
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static IRubyObject[] convertJavaArrayToRuby(Ruby runtime, Object[] objects) {
        IRubyObject[] rubyObjects = new IRubyObject[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            rubyObjects[i] = JavaUtil.convertJavaToRuby(runtime, objects[i]);
        }
        return rubyObjects;
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, Object object) {
        if (object == null) {
            return runtime.getNil();
        }
        return JavaUtil.convertJavaToRuby(runtime, object, object.getClass());
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, Object object, Class javaClass) {
        if (object == null) {
            return runtime.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        if (javaClass.isPrimitive()) {
            String cName = javaClass.getName();
            if (cName == "boolean") {
                return RubyBoolean.newBoolean(runtime, (Boolean)object);
            }
            if (cName == "float" || cName == "double") {
                return RubyFloat.newFloat(runtime, ((Number)object).doubleValue());
            }
            if (cName == "char") {
                return runtime.newFixnum(((Character)object).charValue());
            }
            return runtime.newFixnum(((Number)object).longValue());
        }
        if (javaClass == Boolean.class) {
            return RubyBoolean.newBoolean(runtime, (Boolean)object);
        }
        if (javaClass == Float.class || javaClass == Double.class) {
            return RubyFloat.newFloat(runtime, ((Number)object).doubleValue());
        }
        if (javaClass == Character.class) {
            return runtime.newFixnum(((Character)object).charValue());
        }
        if (Number.class.isAssignableFrom(javaClass) && javaClass != BigDecimal.class) {
            return runtime.newFixnum(((Number)object).longValue());
        }
        if (javaClass == String.class) {
            return runtime.newString(object.toString());
        }
        if (javaClass == ByteList.class) {
            return RubyString.newString(runtime, (ByteList)object);
        }
        if (IRubyObject.class.isAssignableFrom(javaClass)) {
            return (IRubyObject)object;
        }
        if (javaClass == BigInteger.class) {
            return RubyBignum.newBignum(runtime, (BigInteger)object);
        }
        if (javaClass == BigDecimal.class) {
            return JavaObject.wrap(runtime, object);
        }
        return JavaObject.wrap(runtime, object);
    }

    public static Class primitiveToWrapper(Class type) {
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    public static Object convertArgument(Object argument, Class parameterType) {
        if (argument instanceof JavaObject && (argument = ((JavaObject)argument).getValue()) == null) {
            return null;
        }
        Class type = JavaUtil.primitiveToWrapper(parameterType);
        if (type == Void.class) {
            return null;
        }
        if (argument instanceof Number) {
            Number number = (Number)argument;
            if (type == Long.class) {
                return new Long(number.longValue());
            }
            if (type == Integer.class) {
                return new Integer(number.intValue());
            }
            if (type == Short.class) {
                return new Short(number.shortValue());
            }
            if (type == Byte.class) {
                return new Byte(number.byteValue());
            }
            if (type == Character.class) {
                return new Character((char)number.intValue());
            }
            if (type == Double.class) {
                return new Double(number.doubleValue());
            }
            if (type == Float.class) {
                return new Float(number.floatValue());
            }
        }
        return argument;
    }
}

