/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaArray
extends JavaObject {
    public JavaArray(Ruby runtime, Object array) {
        super(runtime, runtime.getModule("Java").getClass("JavaArray"), array);
        assert (array.getClass().isArray());
    }

    public static RubyClass createJavaArrayClass(Ruby runtime, RubyModule javaModule) {
        return javaModule.defineClassUnder("JavaArray", javaModule.getClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
    }

    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.getLength());
    }

    private int getLength() {
        return Array.getLength(this.getValue());
    }

    public IRubyObject aref(IRubyObject index) {
        if (!(index instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(index, this.getRuntime().getClass("Integer"));
        }
        int intIndex = (int)((RubyInteger)index).getLongValue();
        if (intIndex < 0 || intIndex >= this.getLength()) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        Object result = Array.get(this.getValue(), intIndex);
        if (result == null) {
            return this.getRuntime().getNil();
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }

    public IRubyObject aset(IRubyObject index, IRubyObject value) {
        if (!(index instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(index, this.getRuntime().getClass("Integer"));
        }
        int intIndex = (int)((RubyInteger)index).getLongValue();
        if (!(value instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value);
        }
        Object javaObject = ((JavaObject)value).getValue();
        try {
            Array.set(this.getValue(), intIndex, javaObject);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException e) {
            throw this.getRuntime().newArgumentError("wrong element type " + javaObject.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
        return value;
    }

    public IRubyObject afill(IRubyObject beginIndex, IRubyObject endIndex, IRubyObject value) {
        int intIndex;
        if (!(beginIndex instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(beginIndex, this.getRuntime().getClass("Integer"));
        }
        if (!(endIndex instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(endIndex, this.getRuntime().getClass("Integer"));
        }
        int intEndIndex = (int)((RubyInteger)endIndex).getLongValue();
        if (!(value instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value);
        }
        Object javaObject = ((JavaObject)value).getValue();
        Object self = this.getValue();
        try {
            for (intIndex = (int)((RubyInteger)beginIndex).getLongValue(); intIndex < intEndIndex; ++intIndex) {
                Array.set(self, intIndex, javaObject);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException e) {
            throw this.getRuntime().newArgumentError("wrong element type " + javaObject.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
        return value;
    }
}

