/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class FullFunctionReflectedMethod
extends DynamicMethod {
    private Method method;
    private Class type;
    private String methodName;
    private Arity arity;

    public FullFunctionReflectedMethod(RubyModule implementationClass, Class type, String methodName, Arity arity, Visibility visibility) {
        block10: {
            Object[] parameterTypes;
            super(implementationClass, visibility);
            this.type = type;
            this.methodName = methodName;
            this.arity = arity;
            assert (type != null);
            assert (methodName != null);
            assert (arity != null);
            if (arity.isFixed()) {
                parameterTypes = new Class[arity.getValue() + 1];
                Arrays.fill(parameterTypes, IRubyObject.class);
                parameterTypes[arity.getValue()] = Block.class;
            } else {
                parameterTypes = new Class[]{IRubyObject[].class, Block.class};
            }
            try {
                this.method = type.getMethod(methodName, (Class<?>[])parameterTypes);
            }
            catch (NoSuchMethodException e) {
                assert (false) : e;
            }
            catch (SecurityException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)e);
            }
        }
        assert (this.method != null);
    }

    public void preMethod(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preReflectedMethodInternalCall(this.implementationClass, klazz, self, name, args, noSuper, block);
    }

    public void postMethod(ThreadContext context) {
        context.postReflectedMethodInternalCall();
    }

    public IRubyObject internalCall(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        Object[] methodArgs;
        Ruby runtime = context.getRuntime();
        this.arity.checkArity(runtime, args);
        assert (self != null);
        assert (args != null);
        assert (this.method != null);
        if (!this.arity.isFixed()) {
            methodArgs = new Object[]{args, block};
        } else {
            methodArgs = new Object[args.length + 1];
            System.arraycopy(args, 0, methodArgs, 0, args.length);
            methodArgs[args.length] = block;
        }
        try {
            return (IRubyObject)this.method.invoke((Object)self, methodArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RaiseException) {
                throw (RaiseException)e.getTargetException();
            }
            if (e.getTargetException() instanceof JumpException) {
                throw (JumpException)e.getTargetException();
            }
            if (e.getTargetException() instanceof ThreadKill) {
                throw (ThreadKill)e.getTargetException();
            }
            if (e.getTargetException() instanceof Exception) {
                if (e.getTargetException() instanceof MainExitException) {
                    throw (RuntimeException)e.getTargetException();
                }
                runtime.getJavaSupport().handleNativeException(e.getTargetException());
                return runtime.getNil();
            }
            throw (Error)e.getTargetException();
        }
        catch (IllegalAccessException e) {
            StringBuffer message = new StringBuffer();
            message.append(e.getMessage());
            message.append(':');
            message.append(" methodName=").append(this.methodName);
            message.append(" recv=").append(self.toString());
            message.append(" type=").append(this.type.getName());
            message.append(" methodArgs=[");
            for (int i = 0; i < methodArgs.length; ++i) {
                message.append(methodArgs[i]);
                message.append(' ');
            }
            message.append(']');
            assert (false) : message.toString();
            return null;
        }
        catch (IllegalArgumentException e) {
            assert (false) : e;
            return null;
        }
    }

    public DynamicMethod dup() {
        FullFunctionReflectedMethod newMethod = new FullFunctionReflectedMethod(this.getImplementationClass(), this.type, this.methodName, this.arity, this.getVisibility());
        newMethod.method = this.method;
        return newMethod;
    }

    public Arity getArity() {
        return this.arity;
    }
}

