/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.CreateJumpTargetVisitor;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public final class DefaultMethod
extends DynamicMethod {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private SinglyLinkedList cref;
    private boolean hasBeenTargeted = false;
    private int callCount = 0;
    private static final int COMPILE_COUNT = 50;
    private Script jitCompiledScript;
    private static final boolean JIT_ENABLED = Boolean.getBoolean("jruby.jit.enabled");

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, SinglyLinkedList cref) {
        super(implementationClass, visibility);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.cref = cref;
        assert (argsNode != null);
    }

    public void preMethod(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preDefMethodInternalCall(clazz, name, self, args, block, noSuper, this.cref, this.staticScope);
    }

    public void postMethod(ThreadContext context) {
        context.postDefMethodInternalCall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        if (this.jitCompiledScript != null) {
            try {
                context.preCompiledMethod(this.implementationClass, this.cref);
                IRubyObject iRubyObject = this.jitCompiledScript.run(context, self, args, Block.NULL_BLOCK);
                return iRubyObject;
            }
            finally {
                context.postCompiledMethod();
            }
        }
        return super.call(context, self, clazz, name, args, noSuper, block);
    }

    public IRubyObject internalCall(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        IRubyObject blockArg;
        assert (args != null);
        if (JIT_ENABLED && this.jitCompiledScript != null) {
            return this.jitCompiledScript.run(context, self, args, Block.NULL_BLOCK);
        }
        Ruby runtime = context.getRuntime();
        if (!this.hasBeenTargeted) {
            CreateJumpTargetVisitor.setJumpTarget(this, this.body);
            this.hasBeenTargeted = true;
        }
        if (this.argsNode.getBlockArgNode() != null && block.isGiven()) {
            if (block.getProcObject() != null) {
                blockArg = block.getProcObject();
            } else {
                blockArg = runtime.newProc(false, block);
                blockArg.getBlock().isLambda = block.isLambda;
            }
            context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), blockArg, 0);
        }
        try {
            this.prepareArguments(context, runtime, args);
            this.getArity().checkArity(runtime, args);
            this.traceCall(context, runtime, self, name);
            if (JIT_ENABLED) {
                this.runJIT(runtime, name);
            }
            blockArg = EvaluationState.eval(runtime, context, this.body, self, block);
            return blockArg;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump && je.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)je.getValue();
                return iRubyObject;
            }
            throw je;
        }
        finally {
            this.traceReturn(context, runtime, self, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJIT(Ruby runtime, String name) {
        if (this.callCount >= 0 && this.getArity().isFixed()) {
            ++this.callCount;
            if (this.callCount >= 50) {
                try {
                    String cleanName = this.cleanJavaIdentifier(name);
                    StandardASMCompiler compiler = new StandardASMCompiler(cleanName + this.hashCode(), this.body.getPosition().getFile());
                    compiler.startScript();
                    Object methodToken = compiler.beginMethod("__file__", this.getArity().getValue(), this.staticScope.getNumberOfVariables());
                    NodeCompilerFactory.getCompiler(this.body).compile(this.body, compiler);
                    compiler.endMethod(methodToken);
                    compiler.endScript();
                    Class sourceClass = compiler.loadClass(runtime);
                    this.jitCompiledScript = (Script)sourceClass.newInstance();
                    String className = this.getImplementationClass().getBaseName();
                    if (className == null) {
                        className = "<anon class>";
                    }
                    System.out.println("compiled: " + className + "." + name);
                }
                catch (Exception exception) {
                }
                finally {
                    this.callCount = -1;
                }
            }
        }
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        boolean hasOptArgs;
        int expectedArgsCount = this.argsNode.getArgsCount();
        int restArg = this.argsNode.getRestArg();
        boolean bl = hasOptArgs = this.argsNode.getOptArgs() != null;
        if (expectedArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + expectedArgsCount + ")");
        }
        if (expectedArgsCount > 0) {
            context.getCurrentScope().setArgValues(args, expectedArgsCount);
        }
        if (hasOptArgs || restArg != -1) {
            args = this.prepareOptOrRestArgs(context, runtime, args, expectedArgsCount, restArg, hasOptArgs);
        }
        context.setFrameArgs(args);
    }

    private IRubyObject[] prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject[] args, int expectedArgsCount, int restArg, boolean hasOptArgs) {
        int i;
        int opt;
        if (restArg == -1 && hasOptArgs && (opt = expectedArgsCount + this.argsNode.getOptArgs().size()) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + opt + ")");
        }
        int count = expectedArgsCount;
        if (this.argsNode.getOptArgs() != null) {
            count += this.argsNode.getOptArgs().size();
        }
        ArrayList<IRubyObject> allArgs = new ArrayList<IRubyObject>();
        for (i = 0; i < count && i < args.length; ++i) {
            allArgs.add(args[i]);
        }
        if (hasOptArgs) {
            ListNode optArgs = this.argsNode.getOptArgs();
            Iterator iter = optArgs.iterator();
            for (int i2 = expectedArgsCount; i2 < args.length && iter.hasNext(); ++i2) {
                AssignmentVisitor.assign(runtime, context, context.getFrameSelf(), (Node)iter.next(), args[i2], Block.NULL_BLOCK, true);
                ++expectedArgsCount;
            }
            while (iter.hasNext()) {
                allArgs.add(EvaluationState.eval(runtime, context, (Node)iter.next(), context.getFrameSelf(), Block.NULL_BLOCK));
            }
        }
        if (restArg != -1) {
            for (i = expectedArgsCount; i < args.length; ++i) {
                allArgs.add(args[i]);
            }
            if (restArg >= 0) {
                RubyArray array = runtime.newArray(args.length - expectedArgsCount);
                for (int i3 = expectedArgsCount; i3 < args.length; ++i3) {
                    array.append(args[i3]);
                }
                context.getCurrentScope().setValue(restArg, array, 0);
            }
        }
        args = allArgs.toArray(new IRubyObject[allArgs.size()]);
        return args;
    }

    private void traceReturn(ThreadContext context, Ruby runtime, IRubyObject self, String name) {
        if (runtime.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callTraceFunction(context, "return", position, self, name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, IRubyObject self, String name) {
        if (runtime.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = this.body != null ? this.body.getPosition() : context.getPosition();
        runtime.callTraceFunction(context, "call", position, self, name, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.cref);
    }

    private String cleanJavaIdentifier(String name) {
        char[] characters = name.toCharArray();
        StringBuffer cleanBuffer = new StringBuffer();
        boolean prevWasReplaced = false;
        block14: for (int i = 0; i < characters.length; ++i) {
            if (Character.isJavaIdentifierStart(characters[i])) {
                cleanBuffer.append(characters[i]);
                prevWasReplaced = false;
                continue;
            }
            if (!prevWasReplaced) {
                cleanBuffer.append("_");
            }
            prevWasReplaced = true;
            switch (characters[i]) {
                case '?': {
                    cleanBuffer.append("p_");
                    continue block14;
                }
                case '!': {
                    cleanBuffer.append("b_");
                    continue block14;
                }
                case '<': {
                    cleanBuffer.append("lt_");
                    continue block14;
                }
                case '>': {
                    cleanBuffer.append("gt_");
                    continue block14;
                }
                case '=': {
                    cleanBuffer.append("equal_");
                    continue block14;
                }
                case '[': {
                    if (i + 1 < characters.length && characters[i + 1] == ']') {
                        cleanBuffer.append("aref_");
                        ++i;
                        continue block14;
                    }
                    cleanBuffer.append("lbracket_");
                    continue block14;
                }
                case ']': {
                    cleanBuffer.append("rbracket_");
                    continue block14;
                }
                case '+': {
                    cleanBuffer.append("plus_");
                    continue block14;
                }
                case '-': {
                    cleanBuffer.append("minus_");
                    continue block14;
                }
                case '*': {
                    cleanBuffer.append("times_");
                    continue block14;
                }
                case '/': {
                    cleanBuffer.append("div_");
                    continue block14;
                }
                case '&': {
                    cleanBuffer.append("and_");
                    continue block14;
                }
                default: {
                    cleanBuffer.append(Integer.toHexString(characters[i])).append("_");
                }
            }
        }
        return cleanBuffer.toString();
    }
}

