/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyTCPSocket
extends RubyIPSocket {
    private static ObjectAllocator TCPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyTCPSocket(runtime, klass);
        }
    };

    static void createTCPSocket(Ruby runtime) {
        RubyClass rb_cTCPSocket = runtime.defineClass("TCPSocket", runtime.getClass("IPSocket"), TCPSOCKET_ALLOCATOR);
        CallbackFactory cfact = runtime.callbackFactory(RubyTCPSocket.class);
        rb_cTCPSocket.includeModule(runtime.getClass("Socket").getConstant("Constants"));
        rb_cTCPSocket.defineFastMethod("initialize", cfact.getFastMethod("initialize", IRubyObject.class, IRubyObject.class));
        rb_cTCPSocket.defineFastMethod("setsockopt", cfact.getFastOptMethod("setsockopt"));
        rb_cTCPSocket.getMetaClass().defineFastMethod("gethostbyname", cfact.getFastSingletonMethod("gethostbyname", IRubyObject.class));
        rb_cTCPSocket.getMetaClass().defineMethod("open", cfact.getOptSingletonMethod("open"));
        runtime.getObject().setConstant("TCPsocket", rb_cTCPSocket);
    }

    public RubyTCPSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject initialize(IRubyObject arg1, IRubyObject port) {
        try {
            InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(arg1.convertToString().toString()), RubyNumeric.fix2int(port));
            SocketChannel channel = SocketChannel.open(addr);
            channel.finishConnect();
            this.setChannel(channel);
        }
        catch (ConnectException e) {
            throw this.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw RubyTCPSocket.sockerr(this, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw RubyTCPSocket.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    public IRubyObject setsockopt(IRubyObject[] args) {
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyTCPSocket sock = (RubyTCPSocket)recv.callMethod(recv.getRuntime().getCurrentContext(), "new", args);
        if (!block.isGiven()) {
            return sock;
        }
        try {
            IRubyObject iRubyObject = recv.getRuntime().getCurrentContext().yield(sock, block);
            return iRubyObject;
        }
        finally {
            if (sock.isOpen()) {
                sock.close();
            }
        }
    }

    public static IRubyObject gethostbyname(IRubyObject recv, IRubyObject hostname) {
        try {
            IRubyObject[] ret = new IRubyObject[4];
            Ruby r = recv.getRuntime();
            InetAddress addr = InetAddress.getByName(hostname.convertToString().toString());
            ret[0] = r.newString(addr.getCanonicalHostName());
            ret[1] = r.newArray();
            ret[2] = r.newFixnum(2L);
            ret[3] = r.newString(addr.getHostAddress());
            return r.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubyTCPSocket.sockerr(recv, "gethostbyname: name or service not known");
        }
    }
}

