/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.methods.MultiStub;
import org.jruby.internal.runtime.methods.MultiStubMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class Generator {
    public static void createGenerator(Ruby runtime) throws IOException {
        RubyClass cGen = runtime.defineClass("Generator", runtime.getObject(), runtime.getObject().getAllocator());
        cGen.includeModule(runtime.getModule("Enumerable"));
        GenStub0 gstub = new GenStub0();
        gstub.gen_new = new MultiStubMethod(gstub, 0, cGen, Arity.optional(), Visibility.PUBLIC);
        gstub.gen_initialize = new MultiStubMethod(gstub, 1, cGen, Arity.optional(), Visibility.PUBLIC);
        gstub.gen_yield = new MultiStubMethod(gstub, 2, cGen, Arity.singleArgument(), Visibility.PUBLIC);
        gstub.gen_end_p = new MultiStubMethod(gstub, 3, cGen, Arity.noArguments(), Visibility.PUBLIC);
        gstub.gen_next_p = new MultiStubMethod(gstub, 4, cGen, Arity.noArguments(), Visibility.PUBLIC);
        gstub.gen_index = new MultiStubMethod(gstub, 5, cGen, Arity.noArguments(), Visibility.PUBLIC);
        gstub.gen_next = new MultiStubMethod(gstub, 6, cGen, Arity.noArguments(), Visibility.PUBLIC);
        gstub.gen_current = new MultiStubMethod(gstub, 7, cGen, Arity.noArguments(), Visibility.PUBLIC);
        gstub.gen_rewind = new MultiStubMethod(gstub, 8, cGen, Arity.noArguments(), Visibility.PUBLIC);
        gstub.gen_each = new MultiStubMethod(gstub, 9, cGen, Arity.noArguments(), Visibility.PUBLIC);
        cGen.getMetaClass().addMethod("new", gstub.gen_new);
        cGen.addMethod("initialize", gstub.gen_initialize);
        cGen.addMethod("yield", gstub.gen_yield);
        cGen.addMethod("end?", gstub.gen_end_p);
        cGen.addMethod("next?", gstub.gen_next_p);
        cGen.addMethod("index", gstub.gen_index);
        cGen.defineAlias("pos", "index");
        cGen.addMethod("next", gstub.gen_next);
        cGen.addMethod("current", gstub.gen_current);
        cGen.addMethod("rewind", gstub.gen_rewind);
        cGen.addMethod("each", gstub.gen_each);
    }

    public static class GenStub0
    implements MultiStub {
        public MultiStubMethod gen_new;
        public MultiStubMethod gen_initialize;
        public MultiStubMethod gen_yield;
        public MultiStubMethod gen_end_p;
        public MultiStubMethod gen_next_p;
        public MultiStubMethod gen_index;
        public MultiStubMethod gen_next;
        public MultiStubMethod gen_current;
        public MultiStubMethod gen_rewind;
        public MultiStubMethod gen_each;

        public IRubyObject method0(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            RubyObject result = new RubyObject(self.getRuntime(), (RubyClass)self);
            result.dataWrapStruct(new GeneratorData(result));
            result.callInit(args, block);
            return result;
        }

        public IRubyObject method1(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            GeneratorData d = (GeneratorData)self.dataGetStruct();
            self.setInstanceVariable("@queue", self.getRuntime().newArray());
            self.setInstanceVariable("@index", self.getRuntime().newFixnum(0L));
            if (self.checkArgumentCount(args, 0, 1) == 1) {
                d.setEnum(args[0]);
            } else {
                d.setProc(self.getRuntime().newProc(false, Block.NULL_BLOCK));
            }
            return self;
        }

        public IRubyObject method2(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            self.getInstanceVariable("@queue").callMethod(context, "<<", args[0]);
            GeneratorData d = (GeneratorData)self.dataGetStruct();
            d.doWait();
            return self;
        }

        public IRubyObject method3(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            GeneratorData d = (GeneratorData)self.dataGetStruct();
            return d.isEnd() ? self.getRuntime().getTrue() : self.getRuntime().getFalse();
        }

        public IRubyObject method4(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            GeneratorData d = (GeneratorData)self.dataGetStruct();
            return !d.isEnd() ? self.getRuntime().getTrue() : self.getRuntime().getFalse();
        }

        public IRubyObject method5(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            return self.getInstanceVariable("@index");
        }

        public IRubyObject method6(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            GeneratorData d = (GeneratorData)self.dataGetStruct();
            if (d.isEnd()) {
                throw self.getRuntime().newEOFError();
            }
            d.generate();
            self.setInstanceVariable("@index", self.getInstanceVariable("@index").callMethod(context, "+", self.getRuntime().newFixnum(1L)));
            return self.getInstanceVariable("@queue").callMethod(context, "shift");
        }

        public IRubyObject method7(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            if (self.getInstanceVariable("@queue").callMethod(context, "empty?").isTrue()) {
                throw self.getRuntime().newEOFError();
            }
            return self.getInstanceVariable("@queue").callMethod(context, "first");
        }

        public IRubyObject method8(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            if (self.getInstanceVariable("@index").callMethod(context, "nonzero?").isTrue()) {
                GeneratorData d = (GeneratorData)self.dataGetStruct();
                self.setInstanceVariable("@queue", self.getRuntime().newArray());
                self.setInstanceVariable("@index", self.getRuntime().newFixnum(0L));
                d.start();
            }
            return self;
        }

        public IRubyObject method9(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            self.callMethod(context, "rewind");
            while (self.callMethod(context, "next?").isTrue()) {
                context.yield(self.callMethod(context, "next"), block);
            }
            return self;
        }
    }

    static class GeneratorData
    implements Runnable {
        private IRubyObject gen;
        private Object mutex = new Object();
        private IRubyObject enm;
        private RubyProc proc;
        private Thread t;
        private boolean end;
        private IterBlockCallback ibc;
        private boolean available = false;

        public GeneratorData(IRubyObject gen) {
            this.gen = gen;
        }

        public void setEnum(IRubyObject enm) {
            this.proc = null;
            this.enm = enm;
            this.start();
        }

        public void setProc(RubyProc proc) {
            this.proc = proc;
            this.enm = null;
            this.start();
        }

        public void start() {
            this.end = false;
            this.ibc = new IterBlockCallback();
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.t.start();
            this.generate();
        }

        public boolean isEnd() {
            return this.end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWait() {
            this.available = true;
            if (this.proc != null) {
                boolean inter = true;
                Object object = this.mutex;
                synchronized (object) {
                    this.mutex.notifyAll();
                    while (inter) {
                        try {
                            this.mutex.wait();
                            inter = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generate() {
            if (this.proc == null) {
                boolean inter = true;
                Object object = this.mutex;
                synchronized (object) {
                    while (!this.ibc.haveValue() && !this.end) {
                        this.mutex.notifyAll();
                        inter = true;
                        while (inter) {
                            try {
                                this.mutex.wait();
                                inter = false;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (!this.end && this.proc == null) {
                        this.gen.callMethod(this.gen.getRuntime().getCurrentContext(), "yield", this.ibc.pop());
                    }
                }
            }
            Object object = this.mutex;
            synchronized (object) {
                while (!this.available && !this.end) {
                    boolean inter = true;
                    this.mutex.notifyAll();
                    while (inter) {
                        try {
                            this.mutex.wait(20L);
                            inter = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.available = false;
            }
        }

        public void run() {
            if (this.enm != null) {
                ThreadContext context = this.gen.getRuntime().getCurrentContext();
                this.enm.callMethod(context, "each", new CallBlock(this.enm, this.enm.getMetaClass().getRealClass(), Arity.noArguments(), this.ibc, context));
            } else {
                this.proc.call(new IRubyObject[]{this.gen});
            }
            this.end = true;
        }

        private class IterBlockCallback
        implements BlockCallback {
            private IRubyObject obj;

            private IterBlockCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext context, IRubyObject[] iargs, IRubyObject iself, Block block) {
                boolean inter = true;
                Object object = GeneratorData.this.mutex;
                synchronized (object) {
                    GeneratorData.this.mutex.notifyAll();
                    while (inter) {
                        try {
                            GeneratorData.this.mutex.wait();
                            inter = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.obj = iargs.length > 1 ? GeneratorData.this.gen.getRuntime().newArrayNoCopy(iargs) : iargs[0];
                    GeneratorData.this.mutex.notifyAll();
                    return GeneratorData.this.gen.getRuntime().getNil();
                }
            }

            public boolean haveValue() {
                return this.obj != null;
            }

            public IRubyObject pop() {
                IRubyObject a = this.obj;
                this.obj = null;
                return a;
            }
        }
    }

    public static class Service
    implements Library {
        public void load(Ruby runtime) throws IOException {
            Generator.createGenerator(runtime);
        }
    }
}

