/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class EvaluationState {
    public static IRubyObject eval(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        try {
            return EvaluationState.evalInternal(runtime, context, node, self, block);
        }
        catch (StackOverflowError sfe) {
            throw runtime.newSystemStackError("stack level too deep");
        }
    }

    private static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime) {
        SinglyLinkedList cref = context.peekCRef();
        RubyModule rubyClass = (RubyModule)cref.getValue();
        if (rubyClass.isSingleton()) {
            cref = cref.getNext();
            rubyClass = (RubyModule)cref.getValue();
            if (cref.getNext() == null) {
                runtime.getWarnings().warn("class variable access from toplevel singleton method");
            }
        }
        return rubyClass;
    }

    /*
     * Exception decompiling
     */
    private static IRubyObject evalInternal(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 187[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getArgumentDefinition(Ruby runtime, ThreadContext context, Node node, String type, IRubyObject self, Block block) {
        if (node == null) {
            return type;
        }
        if (node instanceof ArrayNode) {
            Iterator iter = ((ArrayNode)node).iterator();
            while (iter.hasNext()) {
                if (EvaluationState.getDefinitionInner(runtime, context, (Node)iter.next(), self, block) != null) continue;
                return null;
            }
        } else if (EvaluationState.getDefinitionInner(runtime, context, node, self, block) == null) {
            return null;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefinition(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        try {
            context.setWithinDefined(true);
            String string = EvaluationState.getDefinitionInner(runtime, context, node, self, aBlock);
            return string;
        }
        finally {
            context.setWithinDefined(false);
        }
    }

    private static String getDefinitionInner(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return "expression";
        }
        switch (node.nodeId) {
            case 102: {
                AttrAssignNode iVisited = (AttrAssignNode)node;
                if (EvaluationState.getDefinitionInner(runtime, context, iVisited.getReceiverNode(), self, aBlock) != null) {
                    try {
                        IRubyObject receiver = EvaluationState.eval(runtime, context, iVisited.getReceiverNode(), self, aBlock);
                        RubyClass metaClass = receiver.getMetaClass();
                        DynamicMethod method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (!visibility.isPrivate() && (!visibility.isProtected() || self.isKindOf(metaClass.getRealClass())) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return EvaluationState.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "assignment", self, aBlock);
                        }
                    }
                    catch (JumpException receiver) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 7: {
                return "$" + ((BackRefNode)node).getType();
            }
            case 15: {
                CallNode iVisited = (CallNode)node;
                if (EvaluationState.getDefinitionInner(runtime, context, iVisited.getReceiverNode(), self, aBlock) != null) {
                    try {
                        IRubyObject receiver = EvaluationState.eval(runtime, context, iVisited.getReceiverNode(), self, aBlock);
                        RubyClass metaClass = receiver.getMetaClass();
                        DynamicMethod method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (!visibility.isPrivate() && (!visibility.isProtected() || self.isKindOf(metaClass.getRealClass())) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return EvaluationState.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "method", self, aBlock);
                        }
                    }
                    catch (JumpException receiver) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 43: 
            case 52: 
            case 58: 
            case 66: 
            case 68: {
                return "assignment";
            }
            case 20: {
                ClassVarNode iVisited = (ClassVarNode)node;
                if (context.getRubyClass() == null && self.getMetaClass().isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                if (!context.getRubyClass().isSingleton() && context.getRubyClass().isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                RubyModule module = (RubyModule)context.getRubyClass().getInstanceVariable("__attached__");
                if (module != null && module.isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                return null;
            }
            case 21: {
                Colon2Node iVisited = (Colon2Node)node;
                try {
                    IRubyObject left = EvaluationState.eval(runtime, context, iVisited.getLeftNode(), self, aBlock);
                    if (left instanceof RubyModule && ((RubyModule)left).getConstantAt(iVisited.getName()) != null) {
                        return "constant";
                    }
                    if (left.getMetaClass().isMethodBound(iVisited.getName(), true)) {
                        return "method";
                    }
                }
                catch (JumpException left) {
                    // empty catch block
                }
                return null;
            }
            case 24: {
                if (context.getConstantDefined(((ConstNode)node).getName())) {
                    return "constant";
                }
                return null;
            }
            case 33: {
                return "local-variable(in-block)";
            }
            case 37: {
                return "false";
            }
            case 38: {
                FCallNode iVisited = (FCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return EvaluationState.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "method", self, aBlock);
                }
                return null;
            }
            case 44: {
                if (runtime.getGlobalVariables().isDefined(((GlobalVarNode)node).getName())) {
                    return "global-variable";
                }
                return null;
            }
            case 48: {
                if (self.getInstanceVariable(((InstVarNode)node).getName()) != null) {
                    return "instance-variable";
                }
                return null;
            }
            case 53: {
                return "local-variable";
            }
            case 54: 
            case 55: {
                return "method";
            }
            case 61: {
                return "nil";
            }
            case 64: {
                return "$" + ((NthRefNode)node).getMatchNumber();
            }
            case 80: {
                return "state.getSelf()";
            }
            case 84: {
                SuperNode iVisited = (SuperNode)node;
                String name = context.getFrameName();
                RubyModule klazz = context.getFrameKlazz();
                if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
                    return EvaluationState.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "super", self, aBlock);
                }
                return null;
            }
            case 88: {
                return "true";
            }
            case 92: {
                VCallNode iVisited = (VCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return "method";
                }
                return null;
            }
            case 96: {
                return aBlock.isGiven() ? "yield" : null;
            }
            case 99: {
                String name = context.getFrameName();
                RubyModule klazz = context.getFrameKlazz();
                if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
                    return "super";
                }
                return null;
            }
        }
        try {
            EvaluationState.eval(runtime, context, node, self, aBlock);
            return "expression";
        }
        catch (JumpException jumpException) {
            return null;
        }
    }

    private static IRubyObject aryToAry(Ruby runtime, IRubyObject value) {
        if (value instanceof RubyArray) {
            return value;
        }
        if (value.respondsTo("to_ary")) {
            return value.convertToType("Array", "to_ary", false);
        }
        return runtime.newArray(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalClassDefinitionBody(Ruby runtime, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type, IRubyObject self, Block block) {
        context.preClassEval(scope, type);
        try {
            if (EvaluationState.isTrace(runtime)) {
                EvaluationState.callTraceFunction(runtime, context, "class", type);
            }
            IRubyObject iRubyObject = EvaluationState.evalInternal(runtime, context, bodyNode, type, block);
            return iRubyObject;
        }
        finally {
            context.postClassEval();
            if (EvaluationState.isTrace(runtime)) {
                EvaluationState.callTraceFunction(runtime, context, "end", null);
            }
        }
    }

    private static boolean isTrace(Ruby runtime) {
        return runtime.getTraceFunction() != null;
    }

    private static void callTraceFunction(Ruby runtime, ThreadContext context, String event, IRubyObject zelf) {
        String name = context.getFrameName();
        RubyModule type = context.getFrameKlazz();
        runtime.callTraceFunction(context, event, context.getPosition(), zelf, name, type);
    }

    public static IRubyObject splatValue(Ruby runtime, IRubyObject value) {
        if (value.isNil()) {
            return runtime.newArray(value);
        }
        return EvaluationState.arrayValue(runtime, value);
    }

    public static IRubyObject aValueSplat(Ruby runtime, IRubyObject value) {
        if (!(value instanceof RubyArray) || ((RubyArray)value).length().getLongValue() == 0L) {
            return runtime.getNil();
        }
        RubyArray array = (RubyArray)value;
        return array.getLength() == 1 ? array.first(IRubyObject.NULL_ARRAY) : array;
    }

    public static RubyArray arrayValue(Ruby runtime, IRubyObject value) {
        IRubyObject newValue = value.convertToType("Array", "to_ary", false);
        if (newValue.isNil()) {
            if (value.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime.getKernel()) {
                newValue = value.convertToType("Array", "to_a", false);
                if (newValue.getType() != runtime.getClass("Array")) {
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
            } else {
                newValue = runtime.newArray(value);
            }
        }
        return (RubyArray)newValue;
    }

    private static IRubyObject[] setupArgs(Ruby runtime, ThreadContext context, Node node, IRubyObject self) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            ISourcePosition position = context.getPosition();
            int size = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size];
            for (int i = 0; i < size; ++i) {
                argsArray[i] = EvaluationState.evalInternal(runtime, context, argsArrayNode.get(i), self, Block.NULL_BLOCK);
            }
            context.setPosition(position);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(EvaluationState.evalInternal(runtime, context, node, self, Block.NULL_BLOCK));
    }

    private static RubyModule getEnclosingModule(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        RubyModule enclosingModule = null;
        if (node instanceof Colon2Node) {
            IRubyObject result = EvaluationState.evalInternal(runtime, context, ((Colon2Node)node).getLeftNode(), self, block);
            if (result != null && !result.isNil()) {
                enclosingModule = (RubyModule)result;
            }
        } else if (node instanceof Colon3Node) {
            enclosingModule = runtime.getObject();
        }
        if (enclosingModule == null) {
            enclosingModule = (RubyModule)context.peekCRef().getValue();
        }
        return enclosingModule;
    }

    private static boolean isRescueHandled(Ruby runtime, ThreadContext context, RubyException currentException, ListNode exceptionNodes, IRubyObject self) {
        if (exceptionNodes == null) {
            return currentException.isKindOf(runtime.getClass("StandardError"));
        }
        IRubyObject[] args = EvaluationState.setupArgs(runtime, context, exceptionNodes, self);
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].isKindOf(runtime.getClass("Module"))) {
                throw runtime.newTypeError("class or module required for rescue clause");
            }
            if (!args[i].callMethod(context, "===", currentException).isTrue()) continue;
            return true;
        }
        return false;
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            IterNode iterNode = (IterNode)blockNode;
            return Block.createBlock(context, iterNode.getVarNode(), new DynamicScope(iterNode.getScope(), context.getCurrentScope()), iterNode.getCallable(), self);
        }
        if (blockNode instanceof BlockPassNode) {
            RubyProc procObject;
            BlockPassNode blockPassNode = (BlockPassNode)blockNode;
            IRubyObject proc = EvaluationState.evalInternal(runtime, context, blockPassNode.getBodyNode(), self, currentBlock);
            if (proc.isNil()) {
                return Block.NULL_BLOCK;
            }
            if (!(proc instanceof RubyProc) && !((proc = proc.convertToType("Proc", "to_proc", false)) instanceof RubyProc)) {
                throw runtime.newTypeError("wrong argument type " + proc.getMetaClass().getName() + " (expected Proc)");
            }
            if (currentBlock.isGiven() && (procObject = currentBlock.getProcObject()) != null && procObject == proc) {
                return currentBlock;
            }
            return ((RubyProc)proc).getBlock();
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }
}

