/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.StarNode;
import org.jruby.evaluator.EvaluationState;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AssignmentVisitor {
    public static IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block, boolean check) {
        IRubyObject result = null;
        switch (node.nodeId) {
            case 102: {
                CallType callType;
                AttrAssignNode iVisited = (AttrAssignNode)node;
                IRubyObject receiver = EvaluationState.eval(runtime, context, iVisited.getReceiverNode(), self, block);
                CallType callType2 = callType = receiver == self ? CallType.VARIABLE : CallType.NORMAL;
                if (iVisited.getArgsNode() == null) {
                    receiver.callMethod(context, iVisited.getName(), new IRubyObject[]{value}, callType);
                    break;
                }
                RubyArray args = (RubyArray)EvaluationState.eval(runtime, context, iVisited.getArgsNode(), self, block);
                args.append(value);
                receiver.callMethod(context, iVisited.getName(), args.toJavaArray(), callType);
                break;
            }
            case 15: {
                CallNode iVisited = (CallNode)node;
                IRubyObject receiver = EvaluationState.eval(runtime, context, iVisited.getReceiverNode(), self, block);
                if (iVisited.getArgsNode() == null) {
                    receiver.callMethod(context, iVisited.getName(), new IRubyObject[]{value}, CallType.NORMAL);
                    break;
                }
                RubyArray args = (RubyArray)EvaluationState.eval(runtime, context, iVisited.getArgsNode(), self, block);
                args.append(value);
                receiver.callMethod(context, iVisited.getName(), args.toJavaArray(), CallType.NORMAL);
                break;
            }
            case 18: {
                ClassVarAsgnNode iVisited = (ClassVarAsgnNode)node;
                context.getRubyClass().setClassVar(iVisited.getName(), value);
                break;
            }
            case 19: {
                ClassVarDeclNode iVisited = (ClassVarDeclNode)node;
                if (runtime.getVerbose().isTrue() && context.getRubyClass().isSingleton()) {
                    runtime.getWarnings().warn(iVisited.getPosition(), "Declaring singleton class variable.");
                }
                context.getRubyClass().setClassVar(iVisited.getName(), value);
                break;
            }
            case 23: {
                IRubyObject module;
                ConstDeclNode iVisited = (ConstDeclNode)node;
                Node constNode = iVisited.getConstNode();
                if (constNode == null) {
                    if (context.getRubyClass() == null) {
                        throw runtime.newTypeError("no class/module to define constant");
                    }
                    module = (RubyModule)context.peekCRef().getValue();
                } else {
                    module = constNode instanceof Colon2Node ? EvaluationState.eval(runtime, context, ((Colon2Node)iVisited.getConstNode()).getLeftNode(), self, block) : runtime.getObject();
                }
                ((RubyModule)module).setConstant(iVisited.getName(), value);
                break;
            }
            case 25: {
                DAsgnNode iVisited = (DAsgnNode)node;
                context.getCurrentScope().setValue(iVisited.getIndex(), value, iVisited.getDepth());
                break;
            }
            case 43: {
                GlobalAsgnNode iVisited = (GlobalAsgnNode)node;
                runtime.getGlobalVariables().set(iVisited.getName(), value);
                break;
            }
            case 47: {
                InstAsgnNode iVisited = (InstAsgnNode)node;
                self.setInstanceVariable(iVisited.getName(), value);
                break;
            }
            case 52: {
                LocalAsgnNode iVisited = (LocalAsgnNode)node;
                context.getCurrentScope().setValue(iVisited.getIndex(), value, iVisited.getDepth());
                break;
            }
            case 58: {
                MultipleAsgnNode iVisited = (MultipleAsgnNode)node;
                if (!(value instanceof RubyArray)) {
                    value = RubyArray.newArray(runtime, value);
                }
                result = AssignmentVisitor.multiAssign(runtime, context, self, iVisited, (RubyArray)value, check);
                break;
            }
            default: {
                throw new RuntimeException("Invalid node encountered in interpreter: \"" + node.getClass().getName() + "\", please report this at www.jruby.org");
            }
        }
        return result;
    }

    public static IRubyObject multiAssign(Ruby runtime, ThreadContext context, IRubyObject self, MultipleAsgnNode node, RubyArray value, boolean callAsProc) {
        int valueLen = value.getLength();
        int varLen = node.getHeadNode() == null ? 0 : node.getHeadNode().size();
        Iterator iter = node.getHeadNode() != null ? node.getHeadNode().iterator() : Collections.EMPTY_LIST.iterator();
        for (int i = 0; i < valueLen && iter.hasNext(); ++i) {
            Node lNode = (Node)iter.next();
            AssignmentVisitor.assign(runtime, context, self, lNode, value.eltInternal(i), Block.NULL_BLOCK, callAsProc);
        }
        if (callAsProc && iter.hasNext()) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        Node argsNode = node.getArgsNode();
        if (argsNode != null) {
            if (!(argsNode instanceof StarNode)) {
                if (varLen < valueLen) {
                    ArrayList newList = new ArrayList(value.getList().subList(varLen, valueLen));
                    AssignmentVisitor.assign(runtime, context, self, argsNode, runtime.newArray(newList), Block.NULL_BLOCK, callAsProc);
                } else {
                    AssignmentVisitor.assign(runtime, context, self, argsNode, runtime.newArray(0), Block.NULL_BLOCK, callAsProc);
                }
            }
        } else if (callAsProc && valueLen < varLen) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        while (iter.hasNext()) {
            AssignmentVisitor.assign(runtime, context, self, (Node)iter.next(), runtime.getNil(), Block.NULL_BLOCK, callAsProc);
        }
        return value;
    }
}

