/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.FCallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.runtime.Arity;

public class FCallNodeCompiler
implements NodeCompiler {
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        FCallNode fcallNode = (FCallNode)node;
        if (fcallNode.getIterNode() == null) {
            if (fcallNode.getArgsNode() != null) {
                NodeCompiler argsCompiler = NodeCompilerFactory.getArgumentsCompiler(fcallNode.getArgsNode());
                argsCompiler.compile(fcallNode.getArgsNode(), context);
                context.invokeDynamic(fcallNode.getName(), false, true, null);
            } else {
                context.invokeDynamic(fcallNode.getName(), false, false, null);
            }
        } else {
            final IterNode iterNode = (IterNode)fcallNode.getIterNode();
            final ClosureCallback closureBody = new ClosureCallback(){

                public void compile(Compiler context) {
                    NodeCompilerFactory.getCompiler(iterNode.getBodyNode()).compile(iterNode.getBodyNode(), context);
                }
            };
            ClosureCallback closureArg = new ClosureCallback(){

                public void compile(Compiler context) {
                    context.createNewClosure(iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody);
                }
            };
            if (fcallNode.getArgsNode() != null) {
                NodeCompiler argsCompiler = NodeCompilerFactory.getArgumentsCompiler(fcallNode.getArgsNode());
                argsCompiler.compile(fcallNode.getArgsNode(), context);
                context.invokeDynamic(fcallNode.getName(), false, true, closureArg);
            } else {
                context.invokeDynamic(fcallNode.getName(), false, false, closureArg);
            }
        }
    }
}

