/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.CallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.runtime.Arity;

public class CallNodeCompiler
implements NodeCompiler {
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        CallNode callNode = (CallNode)node;
        if (callNode.getIterNode() == null) {
            NodeCompilerFactory.getCompiler(callNode.getReceiverNode()).compile(callNode.getReceiverNode(), context);
            if (callNode.getArgsNode() != null) {
                NodeCompiler argsCompiler = NodeCompilerFactory.getArgumentsCompiler(callNode.getArgsNode());
                argsCompiler.compile(callNode.getArgsNode(), context);
                context.invokeDynamic(callNode.getName(), true, true, null);
            } else {
                context.invokeDynamic(callNode.getName(), true, false, null);
            }
        } else {
            final IterNode iterNode = (IterNode)callNode.getIterNode();
            final ClosureCallback closureBody = new ClosureCallback(){

                public void compile(Compiler context) {
                    NodeCompilerFactory.getCompiler(iterNode.getBodyNode()).compile(iterNode.getBodyNode(), context);
                }
            };
            ClosureCallback closureArg = new ClosureCallback(){

                public void compile(Compiler context) {
                    context.createNewClosure(iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody);
                }
            };
            NodeCompilerFactory.getCompiler(callNode.getReceiverNode()).compile(callNode.getReceiverNode(), context);
            if (callNode.getArgsNode() != null) {
                NodeCompiler argsCompiler = NodeCompilerFactory.getArgumentsCompiler(callNode.getArgsNode());
                argsCompiler.compile(callNode.getArgsNode(), context);
                context.invokeDynamic(callNode.getName(), true, true, closureArg);
            } else {
                context.invokeDynamic(callNode.getName(), true, false, closureArg);
            }
        }
    }
}

