/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyStringIO
extends RubyObject {
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyStringIO(runtime, klass);
        }
    };
    private long pos = 0L;
    private int lineno = 0;
    private boolean eof = false;
    private ByteList internal;
    private boolean closedRead = false;
    private boolean closedWrite = false;
    private static final ByteList NEWLINE_BL = new ByteList(new byte[]{10}, false);

    public static RubyClass createStringIOClass(Ruby runtime) {
        RubyClass stringIOClass = runtime.defineClass("StringIO", runtime.getObject(), STRINGIO_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyStringIO.class);
        stringIOClass.getMetaClass().defineMethod("open", callbackFactory.getOptSingletonMethod("open"));
        stringIOClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        stringIOClass.defineFastMethod("<<", callbackFactory.getFastMethod("append", RubyKernel.IRUBY_OBJECT));
        stringIOClass.defineFastMethod("binmode", callbackFactory.getFastMethod("binmode"));
        stringIOClass.defineFastMethod("close", callbackFactory.getFastMethod("close"));
        stringIOClass.defineFastMethod("closed?", callbackFactory.getFastMethod("closed_p"));
        stringIOClass.defineFastMethod("close_read", callbackFactory.getFastMethod("close_read"));
        stringIOClass.defineFastMethod("closed_read?", callbackFactory.getFastMethod("closed_read_p"));
        stringIOClass.defineFastMethod("close_write", callbackFactory.getFastMethod("close_write"));
        stringIOClass.defineFastMethod("closed_write?", callbackFactory.getFastMethod("closed_write_p"));
        stringIOClass.defineMethod("each", callbackFactory.getOptMethod("each"));
        stringIOClass.defineMethod("each_byte", callbackFactory.getMethod("each_byte"));
        stringIOClass.defineMethod("each_line", callbackFactory.getMethod("each_line"));
        stringIOClass.defineFastMethod("eof", callbackFactory.getFastMethod("eof"));
        stringIOClass.defineFastMethod("eof?", callbackFactory.getFastMethod("eof_p"));
        stringIOClass.defineFastMethod("fcntl", callbackFactory.getFastMethod("fcntl"));
        stringIOClass.defineFastMethod("fileno", callbackFactory.getFastMethod("fileno"));
        stringIOClass.defineFastMethod("flush", callbackFactory.getFastMethod("flush"));
        stringIOClass.defineFastMethod("fsync", callbackFactory.getFastMethod("fsync"));
        stringIOClass.defineFastMethod("getc", callbackFactory.getFastMethod("getc"));
        stringIOClass.defineFastMethod("gets", callbackFactory.getFastOptMethod("gets"));
        stringIOClass.defineFastMethod("isatty", callbackFactory.getFastMethod("isatty"));
        stringIOClass.defineFastMethod("tty?", callbackFactory.getFastMethod("tty_p"));
        stringIOClass.defineFastMethod("length", callbackFactory.getFastMethod("length"));
        stringIOClass.defineFastMethod("lineno", callbackFactory.getFastMethod("lineno"));
        stringIOClass.defineFastMethod("lineno=", callbackFactory.getFastMethod("set_lineno", RubyFixnum.class));
        stringIOClass.defineFastMethod("path", callbackFactory.getFastMethod("path"));
        stringIOClass.defineFastMethod("pid", callbackFactory.getFastMethod("pid"));
        stringIOClass.defineFastMethod("pos", callbackFactory.getFastMethod("pos"));
        stringIOClass.defineFastMethod("tell", callbackFactory.getFastMethod("tell"));
        stringIOClass.defineFastMethod("pos=", callbackFactory.getFastMethod("set_pos", RubyFixnum.class));
        stringIOClass.defineFastMethod("print", callbackFactory.getFastOptMethod("print"));
        stringIOClass.defineFastMethod("printf", callbackFactory.getFastOptMethod("printf"));
        stringIOClass.defineFastMethod("putc", callbackFactory.getFastMethod("putc", RubyKernel.IRUBY_OBJECT));
        stringIOClass.defineFastMethod("puts", callbackFactory.getFastOptMethod("puts"));
        stringIOClass.defineFastMethod("read", callbackFactory.getFastOptMethod("read"));
        stringIOClass.defineFastMethod("readchar", callbackFactory.getFastMethod("readchar"));
        stringIOClass.defineFastMethod("readline", callbackFactory.getFastOptMethod("readline"));
        stringIOClass.defineFastMethod("readlines", callbackFactory.getFastOptMethod("readlines"));
        stringIOClass.defineFastMethod("reopen", callbackFactory.getFastMethod("reopen", RubyKernel.IRUBY_OBJECT));
        stringIOClass.defineFastMethod("rewind", callbackFactory.getFastMethod("rewind"));
        stringIOClass.defineFastMethod("seek", callbackFactory.getFastOptMethod("seek"));
        stringIOClass.defineFastMethod("size", callbackFactory.getFastMethod("size"));
        stringIOClass.defineFastMethod("string", callbackFactory.getFastMethod("string"));
        stringIOClass.defineFastMethod("string=", callbackFactory.getFastMethod("set_string", RubyString.class));
        stringIOClass.defineFastMethod("sync", callbackFactory.getFastMethod("sync"));
        stringIOClass.defineFastMethod("sync=", callbackFactory.getFastMethod("set_sync", RubyKernel.IRUBY_OBJECT));
        stringIOClass.defineFastMethod("syswrite", callbackFactory.getFastMethod("syswrite", RubyKernel.IRUBY_OBJECT));
        stringIOClass.defineFastMethod("truncate", callbackFactory.getFastMethod("truncate", RubyFixnum.class));
        stringIOClass.defineFastMethod("ungetc", callbackFactory.getFastMethod("ungetc", RubyFixnum.class));
        stringIOClass.defineFastMethod("write", callbackFactory.getFastMethod("write", RubyKernel.IRUBY_OBJECT));
        return stringIOClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyStringIO strio;
        RubyString str = recv.getRuntime().newString("");
        IRubyObject mode = recv.getRuntime().getNil();
        if (args.length > 0) {
            str = args[0].convertToString();
            if (args.length > 1) {
                mode = args[1];
            }
        }
        IRubyObject val = strio = (RubyStringIO)((RubyClass)recv).newInstance(new IRubyObject[]{str, mode}, Block.NULL_BLOCK);
        ThreadContext tc = recv.getRuntime().getCurrentContext();
        if (block.isGiven()) {
            try {
                val = tc.yield(strio, block);
            }
            finally {
                strio.close();
            }
        }
        return val;
    }

    protected RubyStringIO(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        this.internal = this.checkArgumentCount(args, 0, 2) > 0 ? args[0].convertToString().getByteList() : new ByteList();
        return this;
    }

    public IRubyObject append(IRubyObject obj) {
        ByteList val = ((RubyString)obj.callMethod(obj.getRuntime().getCurrentContext(), "to_s")).getByteList();
        int left = this.internal.length() - (int)this.pos;
        this.internal.replace((int)this.pos, Math.min(val.length(), left), val);
        this.pos += (long)val.length();
        return this;
    }

    public IRubyObject binmode() {
        return this.getRuntime().getTrue();
    }

    public IRubyObject close() {
        this.closedRead = true;
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    public IRubyObject closed_p() {
        return this.closedRead && this.closedWrite ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject close_read() {
        this.closedRead = true;
        return this.getRuntime().getNil();
    }

    public IRubyObject closed_read_p() {
        return this.closedRead ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject close_write() {
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    public IRubyObject closed_write_p() {
        return this.closedWrite ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject each(IRubyObject[] args, Block block) {
        IRubyObject line = this.gets(args);
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (!line.isNil()) {
            context.yield(line, block);
            line = this.gets(args);
        }
        return this;
    }

    public IRubyObject each_byte(Block block) {
        RubyString.newString(this.getRuntime(), new ByteList(this.internal, (int)this.pos, this.internal.length())).each_byte(block);
        return this;
    }

    public IRubyObject each_line(Block block) {
        return this.each(new RubyObject[0], block);
    }

    public IRubyObject eof() {
        return this.pos >= (long)this.internal.length() || this.eof ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject eof_p() {
        return this.pos >= (long)this.internal.length() || this.eof ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject fcntl() {
        throw this.getRuntime().newNotImplementedError("fcntl not implemented");
    }

    public IRubyObject fileno() {
        return this.getRuntime().getNil();
    }

    public IRubyObject flush() {
        return this;
    }

    public IRubyObject fsync() {
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject getc() {
        return this.getRuntime().newFixnum(this.internal.get((int)this.pos++) & 0xFF);
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        if (this.pos < (long)this.internal.length() && !this.eof) {
            String sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getValue().toString();
            if (args.length > 0) {
                if (args[0].isNil()) {
                    ByteList buf = new ByteList(this.internal, (int)this.pos, this.internal.length() - (int)this.pos);
                    this.pos += (long)buf.length();
                    return RubyString.newString(this.getRuntime(), buf);
                }
                sep = args[0].toString();
            }
            String ss = RubyString.byteListToString(this.internal);
            int ix = ss.indexOf(sep, (int)this.pos);
            String add = sep;
            if (-1 == ix) {
                ix = this.internal.length();
                add = "";
            }
            ByteList line = new ByteList(this.internal, (int)this.pos, ix - (int)this.pos);
            line.append(RubyString.stringToBytes(add));
            this.pos = ix + add.length();
            ++this.lineno;
            return RubyString.newString(this.getRuntime(), line);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject gets(IRubyObject[] args) {
        IRubyObject result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().getCurrentContext().setLastline(result);
        }
        return result;
    }

    public IRubyObject isatty() {
        return this.getRuntime().getNil();
    }

    public IRubyObject tty_p() {
        return this.getRuntime().getNil();
    }

    public IRubyObject length() {
        return this.getRuntime().newFixnum(this.internal.length());
    }

    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.lineno);
    }

    public IRubyObject set_lineno(RubyFixnum val) {
        this.lineno = (int)val.getLongValue();
        return this.getRuntime().getNil();
    }

    public IRubyObject path() {
        return this.getRuntime().getNil();
    }

    public IRubyObject pid() {
        return this.getRuntime().getNil();
    }

    public IRubyObject pos() {
        return this.getRuntime().newFixnum(this.pos);
    }

    public IRubyObject tell() {
        return this.getRuntime().newFixnum(this.pos);
    }

    public IRubyObject set_pos(RubyFixnum val) {
        this.pos = (int)val.getLongValue();
        return this.getRuntime().getNil();
    }

    public IRubyObject print(IRubyObject[] args) {
        IRubyObject sep;
        if (args.length != 0) {
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                this.append(args[i]);
            }
        }
        if (!(sep = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
            this.append(sep);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject printf(IRubyObject[] args) {
        this.append(RubyKernel.sprintf(this, args));
        return this.getRuntime().getNil();
    }

    public IRubyObject putc(IRubyObject obj) {
        this.append(obj);
        return obj;
    }

    public IRubyObject puts(IRubyObject[] obj) {
        if (obj.length == 0) {
            this.append(RubyString.newString(this.getRuntime(), NEWLINE_BL));
        }
        int j = obj.length;
        for (int i = 0; i < j; ++i) {
            this.append(obj[i]);
            this.internal.unsafeReplace((int)this.pos++, 0, NEWLINE_BL);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject read(IRubyObject[] args) {
        ByteList buf = null;
        if (this.pos < (long)this.internal.length() && !this.eof) {
            int len;
            int end;
            buf = args.length > 0 && !args[0].isNil() ? ((end = (int)this.pos + (len = RubyNumeric.fix2int(args[0]))) > this.internal.length() ? new ByteList(this.internal, (int)this.pos, this.internal.length() - (int)this.pos) : new ByteList(this.internal, (int)this.pos, len)) : new ByteList(this.internal, (int)this.pos, this.internal.length() - (int)this.pos);
            this.pos += (long)buf.length();
        }
        RubyString ret = null;
        if (buf == null) {
            if (args.length > 0) {
                return this.getRuntime().getNil();
            }
            return this.getRuntime().newString("");
        }
        if (args.length > 1) {
            ret = args[1].convertToString();
            ret.setValue(buf);
        } else {
            ret = RubyString.newString(this.getRuntime(), buf);
        }
        return ret;
    }

    public IRubyObject readchar() {
        return this.getc();
    }

    public IRubyObject readline(IRubyObject[] args) {
        return this.gets(args);
    }

    public IRubyObject readlines(IRubyObject[] arg) {
        ArrayList<IRubyObject> lns = new ArrayList<IRubyObject>();
        while (this.pos < (long)this.internal.length() && !this.eof) {
            lns.add(this.gets(arg));
        }
        return this.getRuntime().newArray(lns);
    }

    public IRubyObject reopen(IRubyObject str) {
        if (str instanceof RubyStringIO) {
            this.pos = ((RubyStringIO)str).pos;
            this.lineno = ((RubyStringIO)str).lineno;
            this.eof = ((RubyStringIO)str).eof;
            this.closedRead = ((RubyStringIO)str).closedRead;
            this.closedWrite = ((RubyStringIO)str).closedWrite;
            this.internal = new ByteList(((RubyStringIO)str).internal);
        } else {
            this.pos = 0L;
            this.lineno = 0;
            this.eof = false;
            this.closedRead = false;
            this.closedWrite = false;
            this.internal = new ByteList();
            this.internal.append(str.convertToString().getByteList());
        }
        return this;
    }

    public IRubyObject rewind() {
        this.pos = 0L;
        this.lineno = 0;
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject seek(IRubyObject[] args) {
        long amount = ((RubyNumeric)args[0]).getLongValue();
        int whence = 0;
        if (args.length > 1) {
            whence = (int)((RubyNumeric)args[1]).getLongValue();
        }
        this.pos = whence == 1 ? (this.pos += amount) : (whence == 2 ? (long)this.internal.length() + amount : amount);
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.internal.length());
    }

    public IRubyObject string() {
        return RubyString.newString(this.getRuntime(), this.internal);
    }

    public IRubyObject set_string(RubyString arg) {
        return this.reopen(arg);
    }

    public IRubyObject sync() {
        return this.getRuntime().getTrue();
    }

    public IRubyObject set_sync(IRubyObject args) {
        return args;
    }

    public IRubyObject syswrite(IRubyObject args) {
        return this.write(args);
    }

    public IRubyObject truncate(RubyFixnum args) {
        int len = (int)args.getLongValue();
        this.internal.length(len);
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject ungetc(RubyFixnum args) {
        this.internal.insert((int)this.pos, (int)args.getLongValue());
        return this.getRuntime().getNil();
    }

    public IRubyObject write(IRubyObject args) {
        String obj = args.toString();
        this.append(args);
        return this.getRuntime().newFixnum(obj.length());
    }
}

