/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.Pack;
import org.jruby.util.PrintfFormat;

public class RubyString
extends RubyObject {
    private static final String DEFAULT_RS = "\n";
    public static final byte OP_PLUS_SWITCHVALUE = 1;
    public static final byte OP_LT_SWITCHVALUE = 2;
    public static final byte AREF_SWITCHVALUE = 3;
    public static final byte ASET_SWITCHVALUE = 4;
    public static final byte NIL_P_SWITCHVALUE = 5;
    public static final byte EQUALEQUAL_SWITCHVALUE = 6;
    public static final byte OP_GE_SWITCHVALUE = 7;
    public static final byte OP_LSHIFT_SWITCHVALUE = 8;
    public static final byte EMPTY_P_SWITCHVALUE = 9;
    private ByteList value;
    private int hash;
    private RubyFixnum r_hash;
    private boolean validHash = false;
    private String stringValue;

    private RubyString(Ruby runtime, CharSequence value) {
        this(runtime, runtime.getString(), value);
    }

    private RubyString(Ruby runtime, byte[] value) {
        this(runtime, runtime.getString(), value);
    }

    private RubyString(Ruby runtime, ByteList value) {
        this(runtime, runtime.getString(), value);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, CharSequence value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = new ByteList(ByteList.plain(value), false);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, byte[] value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = new ByteList(value);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, ByteList value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = value;
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, byte switchvalue, String name, IRubyObject[] args, CallType callType, Block block) {
        switch (switchvalue) {
            case 1: {
                Arity.singleArgument().checkArity(context.getRuntime(), args);
                return this.op_plus(args[0]);
            }
            case 2: {
                Arity.singleArgument().checkArity(context.getRuntime(), args);
                return this.op_lt(args[0]);
            }
            case 3: {
                Arity.optional().checkArity(context.getRuntime(), args);
                return this.aref(args);
            }
            case 4: {
                Arity.optional().checkArity(context.getRuntime(), args);
                return this.aset(args);
            }
            case 5: {
                Arity.noArguments().checkArity(context.getRuntime(), args);
                return this.nil_p();
            }
            case 6: {
                Arity.singleArgument().checkArity(context.getRuntime(), args);
                return this.eql(args[0]);
            }
            case 7: {
                Arity.singleArgument().checkArity(context.getRuntime(), args);
                return this.op_ge(args[0]);
            }
            case 8: {
                Arity.singleArgument().checkArity(context.getRuntime(), args);
                return this.concat(args[0]);
            }
            case 9: {
                Arity.noArguments().checkArity(context.getRuntime(), args);
                return this.empty();
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public int getNativeTypeIndex() {
        return 4;
    }

    public Class getJavaClass() {
        return String.class;
    }

    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = new String(ByteList.plain(this.value.bytes), 0, this.value.realSize);
        }
        return this.stringValue;
    }

    private void stringMutated() {
        this.stringValue = null;
        this.validHash = false;
        this.taint();
    }

    public static String bytesToString(byte[] bytes, int beg, int len) {
        return new String(ByteList.plain(bytes), beg, len);
    }

    public static String byteListToString(ByteList bytes) {
        return RubyString.bytesToString(bytes.unsafeBytes(), 0, bytes.length());
    }

    public static String bytesToString(byte[] bytes) {
        return RubyString.bytesToString(bytes, 0, bytes.length);
    }

    public static byte[] stringToBytes(String string) {
        return ByteList.plain(string);
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isUpper(int c) {
        return c >= 65 && c <= 90;
    }

    public static boolean isLower(int c) {
        return c >= 97 && c <= 122;
    }

    public static boolean isLetter(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c);
    }

    public static boolean isAlnum(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c) || RubyString.isDigit(c);
    }

    public static boolean isPrint(int c) {
        return c >= 32 && c <= 126;
    }

    public IRubyObject checkStringType() {
        return this;
    }

    public IRubyObject to_s() {
        return this;
    }

    public IRubyObject op_cmp(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newFixnum(this.cmp((RubyString)other));
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject eql(IRubyObject other) {
        Ruby runtime = this.getRuntime();
        if (other == this) {
            return runtime.getTrue();
        }
        if (!(other instanceof RubyString)) {
            if (other.respondsTo("to_str")) {
                return other.callMethod(runtime.getCurrentContext(), "==", this);
            }
            return runtime.getFalse();
        }
        return runtime.newBoolean(this.value.equals(((RubyString)other).value));
    }

    public IRubyObject op_plus(IRubyObject other) {
        RubyString str = RubyString.stringValue(other);
        ByteList newValue = new ByteList(this.value);
        newValue.append(str.value);
        return (RubyString)RubyString.newString(this.getRuntime(), newValue).infectBy(str);
    }

    public IRubyObject op_mul(IRubyObject other) {
        RubyInteger otherInteger = (RubyInteger)other.convertType(RubyInteger.class, "Integer", "to_i");
        long len = otherInteger.getLongValue();
        if (len < 0L) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        if (len > 0L && Integer.MAX_VALUE / len < (long)this.value.length()) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        ByteList newBytes = new ByteList(this.value.length() * (int)len);
        int i = 0;
        while ((long)i < len) {
            newBytes.append(this.value);
            ++i;
        }
        RubyString newString = RubyString.newString(this.getRuntime(), newBytes);
        newString.setTaint(this.isTaint());
        return newString;
    }

    public IRubyObject format(IRubyObject arg) {
        Object[] args;
        IRubyObject[] rargs = null;
        if (arg instanceof RubyArray) {
            rargs = ((RubyArray)arg).getList().toArray(new IRubyObject[0]);
            args = new Object[rargs.length];
            for (int i = 0; i < rargs.length; ++i) {
                args[i] = JavaUtil.convertRubyToJava(rargs[i]);
            }
        } else {
            args = new Object[]{JavaUtil.convertRubyToJava(arg)};
            rargs = new IRubyObject[]{arg};
        }
        return this.getRuntime().newString(new PrintfFormat(Locale.US, this.toString()).sprintf(args, rargs));
    }

    public RubyFixnum hash() {
        this.hashCode();
        return this.r_hash;
    }

    public int hashCode() {
        if (!this.validHash) {
            this.hash = this.value.hashCode();
            this.r_hash = this.getRuntime().newFixnum(this.hash);
            this.validHash = true;
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RubyString) {
            RubyString string = (RubyString)other;
            if (string.value.equals(this.value)) {
                return true;
            }
        }
        return false;
    }

    private boolean sameAs(RubyString other) {
        return this.value.equals(other.value);
    }

    public static RubyString objAsString(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject str = obj.callMethod(obj.getRuntime().getCurrentContext(), "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)obj.anyToString();
        }
        if (obj.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public int cmp(RubyString other) {
        return this.value.cmp(other.value);
    }

    public String asSymbol() {
        return this.toString();
    }

    public RubyString newString(CharSequence s) {
        return new RubyString(this.getRuntime(), this.getType(), s);
    }

    public RubyString newString(ByteList s) {
        return new RubyString(this.getRuntime(), this.getType(), s);
    }

    public static RubyString newString(Ruby runtime, CharSequence str) {
        return new RubyString(runtime, str);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes) {
        return new RubyString(runtime, bytes);
    }

    public static RubyString newString(Ruby runtime, ByteList bytes) {
        return new RubyString(runtime, bytes);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes, int start, int length) {
        byte[] bytes2 = new byte[length];
        System.arraycopy(bytes, start, bytes2, 0, length);
        return new RubyString(runtime, bytes2);
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), (ByteList)this.value.clone());
    }

    public RubyString cat(byte[] str) {
        this.value.append(str);
        this.stringMutated();
        return this;
    }

    public RubyString cat(ByteList str) {
        this.value.append(str);
        this.stringMutated();
        return this;
    }

    public RubyString cat(byte ch) {
        this.value.append(ch);
        this.stringMutated();
        return this;
    }

    public IRubyObject to_str() {
        if (this.getMetaClass().getRealClass() != this.getRuntime().getString()) {
            return RubyString.newString(this.getRuntime(), this.value.bytes());
        }
        return this;
    }

    public RubyString replace(IRubyObject other) {
        this.testFrozen("String");
        RubyString newValue = RubyString.stringValue(other);
        if (this == other || this.sameAs(newValue)) {
            return this;
        }
        this.value.replace(newValue.value.bytes());
        this.stringMutated();
        return (RubyString)this.infectBy(newValue);
    }

    public RubyString reverse() {
        return RubyString.newString(this.getRuntime(), (ByteList)this.value.clone()).reverse_bang();
    }

    public RubyString reverse_bang() {
        for (int i = 0; i < this.value.length() / 2; ++i) {
            byte b = (byte)this.value.get(i);
            this.value.set(i, this.value.get(this.value.length() - i - 1));
            this.value.set(this.value.length() - i - 1, b);
        }
        this.stringMutated();
        return this;
    }

    public static RubyString newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString newString = recv.getRuntime().newString("");
        newString.setMetaClass((RubyClass)recv);
        newString.callInit(args, block);
        return newString;
    }

    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        if (this.checkArgumentCount(args, 0, 1) == 1) {
            this.replace(args[0]);
        }
        return this;
    }

    public IRubyObject casecmp(IRubyObject other) {
        int compare = this.toString().compareToIgnoreCase(RubyString.stringValue(other).toString());
        return RubyFixnum.newFixnum(this.getRuntime(), compare == 0 ? 0L : (long)(compare < 0 ? -1 : 1));
    }

    public IRubyObject match(IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).match(this);
        }
        if (other instanceof RubyString) {
            throw this.getRuntime().newTypeError("type mismatch: String given");
        }
        return other.callMethod(this.getRuntime().getCurrentContext(), "=~", this);
    }

    public IRubyObject match2() {
        return RubyRegexp.newRegexp(this, 0, null).match2();
    }

    public IRubyObject match3(IRubyObject pattern) {
        if (pattern instanceof RubyRegexp) {
            return ((RubyRegexp)pattern).search2(this.toString());
        }
        if (pattern instanceof RubyString) {
            RubyRegexp regexp = RubyRegexp.newRegexp((RubyString)pattern, 0, null);
            return regexp.search2(this.toString());
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject capitalize() {
        RubyString result = (RubyString)this.dup();
        result.capitalize_bang();
        return result;
    }

    public IRubyObject capitalize_bang() {
        if (this.isEmpty()) {
            return this.getRuntime().getNil();
        }
        char capital = this.value.charAt(0);
        boolean changed = false;
        if (Character.isLetter(capital) && Character.isLowerCase(capital)) {
            this.value.set(0, (byte)Character.toUpperCase(capital));
            changed = true;
        }
        for (int i = 1; i < this.value.length(); ++i) {
            capital = this.value.charAt(i);
            if (!Character.isLetter(capital) || !Character.isUpperCase(capital)) continue;
            this.value.set(i, (byte)Character.toLowerCase(capital));
            changed = true;
        }
        if (changed) {
            this.stringMutated();
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject op_ge(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.cmp((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(this, other);
    }

    public IRubyObject op_gt(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.cmp((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(this, other);
    }

    public IRubyObject op_le(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.cmp((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(this, other);
    }

    public IRubyObject op_lt(IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.cmp((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(this, other);
    }

    public IRubyObject op_eql(IRubyObject other) {
        return this.equals(other) ? other.getRuntime().getTrue() : other.getRuntime().getFalse();
    }

    public RubyString upcase() {
        return this.newString(this.toString().toUpperCase());
    }

    public IRubyObject upcase_bang() {
        boolean changed = false;
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            this.value.set(i, (byte)Character.toUpperCase(c));
            changed = true;
        }
        if (changed) {
            this.stringMutated();
            return this;
        }
        return this.getRuntime().getNil();
    }

    public RubyString downcase() {
        return this.newString(this.toString().toLowerCase());
    }

    public IRubyObject downcase_bang() {
        boolean changed = false;
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            this.value.set(i, (byte)Character.toLowerCase(c));
            changed = true;
        }
        if (changed) {
            this.stringMutated();
            return this;
        }
        return this.getRuntime().getNil();
    }

    public RubyString swapcase() {
        RubyString newString = RubyString.newString(this.getRuntime(), (ByteList)this.value.clone());
        IRubyObject swappedString = newString.swapcase_bang();
        return swappedString.isNil() ? newString : swappedString;
    }

    public IRubyObject swapcase_bang() {
        boolean changesMade = false;
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (!Character.isLetter(c)) continue;
            if (Character.isLowerCase(c)) {
                changesMade = true;
                this.value.set(i, (byte)Character.toUpperCase(c));
                continue;
            }
            changesMade = true;
            this.value.set(i, (byte)Character.toLowerCase(c));
        }
        if (changesMade) {
            this.stringMutated();
            return this;
        }
        return this.getRuntime().getNil();
    }

    public RubyString dump() {
        return this.inspect(true);
    }

    public IRubyObject insert(IRubyObject indexArg, IRubyObject stringArg) {
        int index = (int)indexArg.convertToInteger().getLongValue();
        if (index < 0) {
            index += this.value.length() + 1;
        }
        if (index < 0 || index > this.value.length()) {
            throw this.getRuntime().newIndexError("index " + index + " out of range");
        }
        ByteList insert = stringArg.convertToString().value;
        this.value.unsafeReplace(index, 0, insert);
        this.stringMutated();
        return this;
    }

    public IRubyObject inspect() {
        return this.inspect(false);
    }

    private RubyString inspect(boolean dump) {
        int length = this.value.length();
        Ruby runtime = this.getRuntime();
        StringBuffer sb = new StringBuffer(length + 2 + length / 100);
        sb.append('\"');
        for (int i = 0; i < length; ++i) {
            int c = this.value.get(i) & 0xFF;
            if (RubyString.isAlnum(c)) {
                sb.append((char)c);
                continue;
            }
            if (runtime.getKCode() == KCode.UTF8 && c == 239) {
                sb.append((char)c);
                sb.append((char)(this.value.get(++i) & 0xFF));
                sb.append((char)(this.value.get(++i) & 0xFF));
                continue;
            }
            if (c == 34 || c == 92) {
                sb.append('\\').append((char)c);
                continue;
            }
            if (dump && c == 35) {
                sb.append('\\').append((char)c);
                continue;
            }
            if (RubyString.isPrint(c)) {
                sb.append((char)c);
                continue;
            }
            if (c == 10) {
                sb.append('\\').append('n');
                continue;
            }
            if (c == 13) {
                sb.append('\\').append('r');
                continue;
            }
            if (c == 9) {
                sb.append('\\').append('t');
                continue;
            }
            if (c == 12) {
                sb.append('\\').append('f');
                continue;
            }
            if (c == 11) {
                sb.append('\\').append('v');
                continue;
            }
            if (c == 7) {
                sb.append('\\').append('a');
                continue;
            }
            if (c == 8) {
                sb.append('\\').append('b');
                continue;
            }
            if (c == 27) {
                sb.append('\\').append('e');
                continue;
            }
            sb.append(new PrintfFormat("\\%.3o").sprintf((char)c));
        }
        sb.append('\"');
        return this.getRuntime().newString(sb.toString());
    }

    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.length());
    }

    public RubyBoolean empty() {
        return this.getRuntime().newBoolean(this.isEmpty());
    }

    private boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject other) {
        this.infectBy(other);
        return this.cat(RubyString.stringValue((IRubyObject)other).value);
    }

    public RubyString concat(IRubyObject other) {
        if (other instanceof RubyFixnum && ((RubyFixnum)other).getLongValue() < 256L) {
            return this.cat((byte)((RubyFixnum)other).getLongValue());
        }
        return this.append(other);
    }

    public RubyString crypt(IRubyObject other) {
        String salt = RubyString.stringValue(other).getValue().toString();
        if (salt.length() < 2) {
            throw this.getRuntime().newArgumentError("salt too short(need >=2 bytes)");
        }
        salt = salt.substring(0, 2);
        return this.getRuntime().newString(JavaCrypt.crypt(salt, this.toString()));
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertType(RubyString.class, "String", "to_str"));
    }

    public IRubyObject sub(IRubyObject[] args, Block block) {
        return this.sub(args, false, block);
    }

    public IRubyObject sub_bang(IRubyObject[] args, Block block) {
        return this.sub(args, true, block);
    }

    private IRubyObject sub(IRubyObject[] args, boolean bang, Block block) {
        boolean utf8;
        IRubyObject repl = this.getRuntime().getNil();
        boolean iter = false;
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (args.length == 1 && block.isGiven()) {
            iter = true;
        } else if (args.length == 2) {
            repl = args[1];
        } else {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        RubyRegexp pat = RubyRegexp.regexpValue(args[0]);
        String intern = this.toString();
        boolean bl = utf8 = pat.getCode() == KCode.UTF8;
        if (utf8) {
            try {
                intern = new String(ByteList.plain(intern), "UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pat.search(intern, 0) >= 0) {
            RubyMatchData match = (RubyMatchData)tc.getBackref();
            RubyString newStr = match.pre_match();
            newStr.append(iter ? tc.yield(match.group(0L), block) : pat.regsub(repl, match));
            newStr.append(match.post_match());
            newStr.setTaint(this.isTaint() || repl.isTaint());
            if (utf8) {
                try {
                    newStr.setValue(new String(ByteList.plain(newStr.toString().getBytes("UTF8"))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bang) {
                this.value = newStr.value;
                this.stringMutated();
                return this;
            }
            return newStr;
        }
        return bang ? this.getRuntime().getNil() : this;
    }

    public IRubyObject gsub(IRubyObject[] args, Block block) {
        return this.gsub(args, false, block);
    }

    public IRubyObject gsub_bang(IRubyObject[] args, Block block) {
        return this.gsub(args, true, block);
    }

    private IRubyObject gsub(IRubyObject[] args, boolean bang, Block block) {
        IRubyObject repl = this.getRuntime().getNil();
        boolean iter = false;
        if (args.length == 1 && block.isGiven()) {
            iter = true;
        } else if (args.length == 2) {
            repl = args[1];
        } else {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        boolean taint = repl.isTaint();
        RubyRegexp pat = RubyRegexp.regexpValue(args[0]);
        String str = this.toString();
        int beg = pat.search(str, 0);
        if (beg < 0) {
            return bang ? this.getRuntime().getNil() : this.dup();
        }
        ByteList sbuf = new ByteList(this.value.length());
        int offset = 0;
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (iter) {
            while (beg >= 0) {
                RubyMatchData match = (RubyMatchData)tc.getBackref();
                sbuf.append(this.value, offset, beg - offset);
                IRubyObject newStr = tc.yield(match.group(0L), block);
                taint |= newStr.isTaint();
                sbuf.append(newStr.objAsString().getByteList());
                offset = match.matchEndPosition();
                beg = pat.search(str, offset == beg ? beg + 1 : offset);
            }
        } else {
            RubyString r = RubyString.stringValue(repl);
            while (beg >= 0) {
                RubyMatchData match = (RubyMatchData)tc.getBackref();
                sbuf.append(this.value, offset, beg - offset);
                pat.regsub(r, match, sbuf);
                offset = match.matchEndPosition();
                beg = pat.search(str, offset == beg ? beg + 1 : offset);
            }
        }
        sbuf.append(this.value, offset, this.value.length() - offset);
        if (bang) {
            this.setTaint(this.isTaint() || taint);
            this.setValue(sbuf);
            return this;
        }
        RubyString result = this.newString(sbuf);
        result.setTaint(this.isTaint() || taint);
        return result;
    }

    public IRubyObject index(IRubyObject[] args) {
        return this.index(args, false);
    }

    public IRubyObject rindex(IRubyObject[] args) {
        return this.index(args, true);
    }

    private IRubyObject index(IRubyObject[] args, boolean reverse) {
        int pos = 0;
        if (reverse) {
            pos = this.value.length();
        }
        if (this.checkArgumentCount(args, 1, 2) == 2) {
            pos = RubyNumeric.fix2int(args[1]);
        }
        if (pos < 0 && (pos += this.value.length()) < 0) {
            return this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyRegexp) {
            int doNotLookPastIfReverse = pos;
            int dummy = pos = ((RubyRegexp)args[0]).search(this.toString(), reverse ? 0 : pos);
            while (reverse && dummy > -1 && dummy <= doNotLookPastIfReverse) {
                pos = dummy;
                dummy = ((RubyRegexp)args[0]).search(this.toString(), pos + 1);
            }
        } else if (args[0] instanceof RubyString) {
            String sub = ((RubyString)args[0]).toString();
            StringBuffer sb = new StringBuffer(this.toString());
            pos = reverse ? sb.lastIndexOf(sub, pos) : sb.indexOf(sub, pos);
        } else if (args[0] instanceof RubyFixnum) {
            char c = (char)((RubyFixnum)args[0]).getLongValue();
            pos = reverse ? this.toString().lastIndexOf(c, pos) : this.toString().indexOf(c, pos);
        } else {
            throw this.getRuntime().newArgumentError("wrong type of argument");
        }
        return pos == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(pos);
    }

    public IRubyObject substr(int beg, int len) {
        int length = this.value.length();
        if (len < 0 || beg > length) {
            return this.getRuntime().getNil();
        }
        if (beg < 0 && (beg += length) < 0) {
            return this.getRuntime().getNil();
        }
        int end = Math.min(length, beg + len);
        ByteList newValue = new ByteList(this.value, beg, end - beg);
        return RubyString.newString(this.getRuntime(), newValue).infectBy(this);
    }

    public IRubyObject replace(int beg, int len, RubyString replaceWith) {
        if (beg + len >= this.value.length()) {
            len = this.value.length() - beg;
        }
        this.value.unsafeReplace(beg, len, replaceWith.value);
        this.stringMutated();
        return this.infectBy(replaceWith);
    }

    public IRubyObject aref(IRubyObject[] args) {
        if (this.checkArgumentCount(args, 1, 2) == 2) {
            if (args[0] instanceof RubyRegexp) {
                IRubyObject match = RubyRegexp.regexpValue(args[0]).match(this.toString(), 0);
                long idx = args[1].convertToInteger().getLongValue();
                this.getRuntime().getCurrentContext().setBackref(match);
                return RubyRegexp.nth_match((int)idx, match);
            }
            return this.substr(RubyNumeric.fix2int(args[0]), RubyNumeric.fix2int(args[1]));
        }
        if (args[0] instanceof RubyRegexp) {
            return RubyRegexp.regexpValue(args[0]).search(this.toString(), 0) >= 0 ? RubyRegexp.last_match(this.getRuntime().getCurrentContext().getBackref()) : this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyString) {
            return this.toString().indexOf(RubyString.stringValue(args[0]).toString()) != -1 ? args[0] : this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.value.length(), true, false);
            return begLen == null ? this.getRuntime().getNil() : this.substr((int)begLen[0], (int)begLen[1]);
        }
        int idx = (int)args[0].convertToInteger().getLongValue();
        if (idx < 0) {
            idx += this.value.length();
        }
        if (idx < 0 || idx >= this.value.length()) {
            return this.getRuntime().getNil();
        }
        RubyFixnum result = this.getRuntime().newFixnum(this.value.get(idx) & 0xFF);
        return result;
    }

    private void subpatSet(RubyRegexp regexp, int nth, IRubyObject repl) {
        int found = regexp.search(this.toString(), 0);
        if (found == -1) {
            throw this.getRuntime().newIndexError("regexp not matched");
        }
        RubyMatchData match = (RubyMatchData)this.getRuntime().getCurrentContext().getBackref();
        if ((long)nth >= match.getSize()) {
            throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
        }
        if (nth < 0) {
            if ((long)(-nth) >= match.getSize()) {
                throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
            }
            nth = (int)((long)nth + match.getSize());
        }
        IRubyObject group = match.group(nth);
        if (this.getRuntime().getNil().equals(group)) {
            throw this.getRuntime().newIndexError("regexp group " + nth + " not matched");
        }
        int beg = (int)match.begin(nth);
        int len = (int)(match.end(nth) - (long)beg);
        this.replace(beg, len, RubyString.stringValue(repl));
    }

    public IRubyObject aset(IRubyObject[] args) {
        this.testFrozen("class");
        int strLen = this.value.length();
        if (this.checkArgumentCount(args, 2, 3) == 3) {
            if (args[0] instanceof RubyFixnum) {
                RubyString repl = RubyString.stringValue(args[2]);
                int beg = RubyNumeric.fix2int(args[0]);
                int len = RubyNumeric.fix2int(args[1]);
                if (len < 0) {
                    throw this.getRuntime().newIndexError("negative length");
                }
                if (beg < 0) {
                    beg += strLen;
                }
                if (beg < 0 || beg > 0 && beg >= strLen) {
                    throw this.getRuntime().newIndexError("string index out of bounds");
                }
                if (beg + len > strLen) {
                    len = strLen - beg;
                }
                this.replace(beg, len, repl);
                return repl;
            }
            if (args[0] instanceof RubyRegexp) {
                RubyString repl = RubyString.stringValue(args[2]);
                int nth = RubyNumeric.fix2int(args[1]);
                this.subpatSet((RubyRegexp)args[0], nth, repl);
                return repl;
            }
        }
        if (args[0] instanceof RubyFixnum) {
            int idx = RubyNumeric.fix2int(args[0]);
            if (idx < 0) {
                idx += this.value.length();
            }
            if (idx < 0 || idx >= this.value.length()) {
                throw this.getRuntime().newIndexError("string index out of bounds");
            }
            if (args[1] instanceof RubyFixnum) {
                this.value.set(idx, (byte)RubyNumeric.fix2int(args[1]));
                this.stringMutated();
            } else {
                this.replace(idx, 1, RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRegexp) {
            this.sub_bang(args, null);
            return args[1];
        }
        if (args[0] instanceof RubyString) {
            RubyString orig = RubyString.stringValue(args[0]);
            int beg = this.toString().indexOf(orig.toString());
            if (beg != -1) {
                this.replace(beg, orig.value.length(), RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRange) {
            long[] idxs = ((RubyRange)args[0]).getBeginLength(this.value.length(), true, true);
            this.replace((int)idxs[0], (int)idxs[1], RubyString.stringValue(args[1]));
            return args[1];
        }
        throw this.getRuntime().newTypeError("wrong argument type");
    }

    public IRubyObject slice_bang(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 1, 2);
        IRubyObject[] newArgs = new IRubyObject[argc + 1];
        newArgs[0] = args[0];
        if (argc > 1) {
            newArgs[1] = args[1];
        }
        newArgs[argc] = this.newString("");
        IRubyObject result = this.aref(args);
        if (result.isNil()) {
            return result;
        }
        this.aset(newArgs);
        return result;
    }

    public IRubyObject succ() {
        return ((RubyString)this.dup()).succ_bang();
    }

    public IRubyObject succ_bang() {
        int i;
        if (this.value.length() == 0) {
            return this;
        }
        boolean alnumSeen = false;
        int pos = -1;
        int c = 0;
        int n = 0;
        for (i = this.value.length() - 1; i >= 0; --i) {
            c = this.value.get(i) & 0xFF;
            if (!RubyString.isAlnum(c)) continue;
            alnumSeen = true;
            if (RubyString.isDigit(c) && c < 57 || RubyString.isLower(c) && c < 122 || RubyString.isUpper(c) && c < 90) {
                this.value.set(i, (byte)(c + 1));
                pos = -1;
                break;
            }
            pos = i;
            n = RubyString.isDigit(c) ? 48 : (RubyString.isLower(c) ? 97 : 65);
            this.value.set(i, (byte)n);
        }
        if (!alnumSeen) {
            for (i = this.value.length() - 1; i >= 0; --i) {
                c = this.value.get(i);
                if (c < 255) {
                    this.value.set(i, (byte)(c + 1));
                    pos = -1;
                    break;
                }
                pos = i;
                n = 1;
                this.value.set(i, 0);
            }
        }
        if (pos > -1) {
            this.value.prepend((byte)(RubyString.isDigit(c) ? 49 : (RubyString.isLower(c) ? 97 : 65)));
        }
        this.stringMutated();
        return this;
    }

    public IRubyObject upto(IRubyObject str, Block block) {
        return this.upto(str, false, block);
    }

    public IRubyObject upto(IRubyObject str, boolean excl, Block block) {
        RubyString beg = this;
        RubyString end = RubyString.stringValue(str);
        int n = beg.cmp(end);
        if (n > 0 || excl && n == 0) {
            return beg;
        }
        RubyString afterEnd = RubyString.stringValue(end.succ());
        RubyString current = beg;
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (!current.equals(afterEnd)) {
            context.yield(current, block);
            if (!excl && current.equals(end)) break;
            current = (RubyString)current.succ();
            if ((!excl || !current.equals(end)) && current.length().getLongValue() <= end.length().getLongValue()) continue;
            break;
        }
        return beg;
    }

    public RubyBoolean include(IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            int c = RubyNumeric.fix2int(obj);
            for (int i = 0; i < this.value.length(); ++i) {
                if (this.value.get(i) != (byte)c) continue;
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }
        String str = RubyString.stringValue(obj).toString();
        return this.getRuntime().newBoolean(new StringBuffer(this.toString()).indexOf(str) != -1);
    }

    public IRubyObject to_i(IRubyObject[] args) {
        long base = this.checkArgumentCount(args, 0, 1) == 0 ? 10L : ((RubyInteger)args[0].convertType(RubyInteger.class, "Integer", "to_i")).getLongValue();
        return RubyNumeric.str2inum(this.getRuntime(), this, (int)base);
    }

    public IRubyObject oct() {
        int pos;
        if (this.isEmpty()) {
            return this.getRuntime().newFixnum(0L);
        }
        int base = 8;
        String str = this.toString().trim();
        int n = pos = str.charAt(0) == '-' || str.charAt(0) == '+' ? 1 : 0;
        if (str.indexOf("0x") == pos || str.indexOf("0X") == pos) {
            base = 16;
        } else if (str.indexOf("0b") == pos || str.indexOf("0B") == pos) {
            base = 2;
        }
        return RubyNumeric.str2inum(this.getRuntime(), this, base);
    }

    public IRubyObject hex() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 16);
    }

    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    public RubyArray split(IRubyObject[] args) {
        RubyRegexp pattern;
        boolean isWhitespace = false;
        if (args.length == 0) {
            isWhitespace = true;
            pattern = RubyRegexp.newRegexp(this.getRuntime(), "\\s+", 0, null);
        } else if (args[0] instanceof RubyRegexp) {
            pattern = RubyRegexp.regexpValue(args[0]);
        } else {
            String stringPattern = RubyString.stringValue(args[0]).toString();
            if (stringPattern.equals(" ")) {
                isWhitespace = true;
                pattern = RubyRegexp.newRegexp(this.getRuntime(), "\\s+", 0, null);
            } else {
                pattern = RubyRegexp.newRegexp(this.getRuntime(), RubyRegexp.escapeSpecialChars(stringPattern), 0, null);
            }
        }
        int limit = RubyString.getLimit(args);
        String[] result = null;
        String splitee = this.toString();
        boolean unicodeSuccess = false;
        if (this.getRuntime().getKCode() == KCode.UTF8) {
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            try {
                splitee = decoder.decode(ByteBuffer.wrap(this.value.bytes())).toString();
                unicodeSuccess = true;
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        if (limit == 1) {
            result = new String[]{splitee};
        } else {
            ArrayList<String> list = new ArrayList<String>();
            int numberOfHits = 0;
            int stringLength = splitee.length();
            Pattern pat = pattern.getPattern();
            Matcher matt = pat.matcher(splitee);
            int startOfCurrentHit = 0;
            int endOfCurrentHit = 0;
            String group = null;
            if (matt.find()) {
                int groupIndex;
                endOfCurrentHit = matt.start();
                if (endOfCurrentHit != 0 || !isWhitespace) {
                    ++numberOfHits;
                    if (matt.end() != 0) {
                        list.add(splitee.substring(startOfCurrentHit, endOfCurrentHit));
                        for (groupIndex = 1; groupIndex <= matt.groupCount(); ++groupIndex) {
                            group = matt.group(groupIndex);
                            list.add(group);
                        }
                    }
                }
                startOfCurrentHit = matt.end();
                if (numberOfHits + 1 != limit) {
                    while (matt.find()) {
                        endOfCurrentHit = matt.start();
                        ++numberOfHits;
                        list.add(splitee.substring(startOfCurrentHit, endOfCurrentHit));
                        for (groupIndex = 1; groupIndex <= matt.groupCount(); ++groupIndex) {
                            group = matt.group(groupIndex);
                            list.add(group);
                        }
                        startOfCurrentHit = matt.end();
                    }
                }
            }
            if (numberOfHits == 0) {
                list.add(splitee);
            } else if (startOfCurrentHit <= stringLength) {
                list.add(splitee.substring(startOfCurrentHit, stringLength));
            }
            if (limit == 0 && list.size() > 0) {
                for (int size = list.size() - 1; size >= 0 && ((String)list.get(size)).length() == 0; --size) {
                    list.remove(size);
                }
            }
            result = list.toArray(new String[list.size()]);
        }
        RubyArray resultArray = this.getRuntime().newArray(result.length);
        for (int i = 0; i < result.length; ++i) {
            RubyString string = this.getRuntime().newString(result[i]);
            if (unicodeSuccess && this.getRuntime().getKCode() == KCode.UTF8) {
                string.setUnicodeValue(result[i]);
            }
            resultArray.append(string);
        }
        return resultArray;
    }

    private static int getLimit(IRubyObject[] args) {
        if (args.length == 2) {
            return RubyNumeric.fix2int(args[1]);
        }
        return 0;
    }

    public IRubyObject scan(IRubyObject arg, Block block) {
        RubyRegexp pattern = RubyRegexp.regexpValue(arg);
        int start = 0;
        ThreadContext tc = this.getRuntime().getCurrentContext();
        String toString = this.toString();
        if (!block.isGiven()) {
            RubyArray ary = this.getRuntime().newArray();
            while (pattern.search(toString, start) != -1) {
                RubyMatchData md = (RubyMatchData)tc.getBackref();
                ary.append(md.getSize() == 1L ? md.group(0L) : md.subseq(1L, md.getSize()));
                if (md.matchEndPosition() == md.matchStartPosition()) {
                    ++start;
                    continue;
                }
                start = md.matchEndPosition();
            }
            return ary;
        }
        while (pattern.search(toString, start) != -1) {
            RubyMatchData md = (RubyMatchData)tc.getBackref();
            tc.yield(md.getSize() == 1L ? md.group(0L) : md.subseq(1L, md.getSize()), block);
            if (md.matchEndPosition() == md.matchStartPosition()) {
                ++start;
                continue;
            }
            start = md.matchEndPosition();
        }
        return this;
    }

    private IRubyObject justify(IRubyObject[] args, boolean leftJustify) {
        String paddingArg;
        this.checkArgumentCount(args, 1, 2);
        int length = RubyNumeric.fix2int(args[0]);
        if (length <= this.value.length()) {
            return this.dup();
        }
        if (args.length == 2) {
            paddingArg = args[1].convertToString().toString();
            if (paddingArg.length() == 0) {
                throw this.getRuntime().newArgumentError("zero width padding");
            }
        } else {
            paddingArg = " ";
        }
        StringBuffer sbuf = new StringBuffer(length);
        String thisStr = this.toString();
        if (leftJustify) {
            sbuf.append(thisStr);
        }
        int whole = (length - thisStr.length()) / paddingArg.length();
        for (int w = 0; w < whole; ++w) {
            sbuf.append(paddingArg);
        }
        int fractionalLength = (length - thisStr.length()) % paddingArg.length();
        if (fractionalLength > 0) {
            sbuf.append(paddingArg.substring(0, fractionalLength));
        }
        if (!leftJustify) {
            sbuf.append(thisStr);
        }
        RubyString ret = this.newString(sbuf.toString());
        if (args.length == 2) {
            ret.infectBy(args[1]);
        }
        return ret;
    }

    public IRubyObject ljust(IRubyObject[] args) {
        return this.justify(args, true);
    }

    public IRubyObject rjust(IRubyObject[] args) {
        return this.justify(args, false);
    }

    public IRubyObject center(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, 2);
        int len = RubyNumeric.fix2int(args[0]);
        String pad = args.length == 2 ? args[1].convertToString().toString() : " ";
        int strLen = this.value.length();
        int padLen = pad.length();
        if (padLen == 0) {
            throw this.getRuntime().newArgumentError("zero width padding");
        }
        if (len <= strLen) {
            return this.dup();
        }
        StringBuffer sbuf = new StringBuffer(len);
        int lead = (len - strLen) / 2;
        for (int i = 0; i < lead; ++i) {
            sbuf.append(pad.charAt(i % padLen));
        }
        sbuf.append(this.getValue());
        int remaining = len - (lead + strLen);
        for (int i = 0; i < remaining; ++i) {
            sbuf.append(pad.charAt(i % padLen));
        }
        return this.newString(sbuf.toString());
    }

    public IRubyObject chop() {
        RubyString newString = (RubyString)this.dup();
        newString.chop_bang();
        return newString;
    }

    public IRubyObject chop_bang() {
        int end = this.value.length() - 1;
        if (end < 0) {
            return this.getRuntime().getNil();
        }
        if ((this.value.get(end) & 0xFF) == 10 && end > 0 && (this.value.get(end - 1) & 0xFF) == 13) {
            --end;
        }
        this.value.length(end);
        this.stringMutated();
        return this;
    }

    public RubyString chomp(IRubyObject[] args) {
        RubyString result = (RubyString)this.dup();
        result.chomp_bang(args);
        return result;
    }

    public IRubyObject chomp_bang(IRubyObject[] args) {
        String separator;
        if (this.isEmpty()) {
            return this.getRuntime().getNil();
        }
        String string = separator = args.length == 0 ? this.getRuntime().getGlobalVariables().get("$/").asSymbol() : args[0].asSymbol();
        if (separator.equals(DEFAULT_RS)) {
            int end = this.value.length() - 1;
            int removeCount = 0;
            if (end < 0) {
                return this.getRuntime().getNil();
            }
            if ((this.value.get(end) & 0xFF) == 10) {
                ++removeCount;
                if (end > 0 && (this.value.get(end - 1) & 0xFF) == 13) {
                    ++removeCount;
                }
            } else if ((this.value.get(end) & 0xFF) == 13) {
                ++removeCount;
            }
            if (removeCount == 0) {
                return this.getRuntime().getNil();
            }
            this.value.length(end - removeCount + 1);
            this.stringMutated();
            return this;
        }
        if (separator.length() == 0) {
            int end = this.value.length() - 1;
            int removeCount = 0;
            while (end - removeCount >= 0 && (this.value.get(end - removeCount) & 0xFF) == 10) {
                if (end - ++removeCount < 0 || (this.value.get(end - removeCount) & 0xFF) != 13) continue;
                ++removeCount;
            }
            if (removeCount == 0) {
                return this.getRuntime().getNil();
            }
            this.value.length(end - removeCount + 1);
            this.stringMutated();
            return this;
        }
        if (this.toString().endsWith(separator)) {
            this.value.length(this.value.length() - separator.length());
            this.stringMutated();
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject lstrip() {
        return RubyString.newString(this.getRuntime(), this.lstripInternal());
    }

    public ByteList lstripInternal() {
        int i;
        int length = this.value.length();
        for (i = 0; i < length && Character.isWhitespace(this.value.charAt(i)); ++i) {
        }
        return new ByteList(this.value, i, this.value.length() - i);
    }

    public IRubyObject lstrip_bang() {
        ByteList newBytes = this.lstripInternal();
        if (this.value.equals(newBytes)) {
            return this.getRuntime().getNil();
        }
        this.value = newBytes;
        this.stringMutated();
        return this;
    }

    public IRubyObject rstrip() {
        return RubyString.newString(this.getRuntime(), this.rstripInternal());
    }

    public ByteList rstripInternal() {
        int i;
        for (i = this.value.length() - 1; i >= 0 && Character.isWhitespace(this.value.charAt(i)); --i) {
        }
        return new ByteList(this.value, 0, i + 1);
    }

    public IRubyObject rstrip_bang() {
        ByteList newBytes = this.rstripInternal();
        if (this.value.equals(newBytes)) {
            return this.getRuntime().getNil();
        }
        this.value = newBytes;
        this.stringMutated();
        return this;
    }

    public IRubyObject strip() {
        if (this.isEmpty()) {
            return this.dup();
        }
        ByteList bytes = this.stripInternal();
        if (bytes == null) {
            return RubyString.newString(this.getRuntime(), (ByteList)this.value.clone());
        }
        return RubyString.newString(this.getRuntime(), bytes);
    }

    public IRubyObject strip_bang() {
        if (this.isEmpty()) {
            return this.getRuntime().getNil();
        }
        ByteList bytes = this.stripInternal();
        if (bytes == null) {
            return this.getRuntime().getNil();
        }
        this.value = bytes;
        this.stringMutated();
        return this;
    }

    public ByteList stripInternal() {
        int tail;
        int head;
        for (head = 0; head < this.value.length() && Character.isWhitespace(this.value.charAt(head)); ++head) {
        }
        for (tail = this.value.length() - 1; tail > head && Character.isWhitespace(this.value.charAt(tail)); --tail) {
        }
        if (head == 0 && tail == this.value.length() - 1) {
            return null;
        }
        if (head <= tail) {
            return new ByteList(this.value, head, tail - head + 1);
        }
        if (head > tail) {
            return new ByteList();
        }
        return null;
    }

    private static String expandTemplate(String spec, boolean invertOK) {
        int pos;
        int len = spec.length();
        if (len <= 1) {
            return spec;
        }
        StringBuffer sbuf = new StringBuffer();
        int n = pos = invertOK && spec.charAt(0) == '^' ? 1 : 0;
        while (pos < len) {
            int c1 = spec.charAt(pos);
            if (pos + 2 < len && spec.charAt(pos + 1) == '-') {
                char c2 = spec.charAt(pos + 2);
                if (c2 > c1) {
                    for (int i = c1; i <= c2; ++i) {
                        sbuf.append((char)i);
                    }
                }
                pos += 3;
                continue;
            }
            sbuf.append((char)c1);
            ++pos;
        }
        return sbuf.toString();
    }

    private String setupTable(String[] specs) {
        int[] table = new int[256];
        int numSets = 0;
        for (int i = 0; i < specs.length; ++i) {
            String template = RubyString.expandTemplate(specs[i], true);
            boolean invert = specs[i].length() > 1 && specs[i].charAt(0) == '^';
            for (int j = 0; j < 256; ++j) {
                if (template.indexOf(j) == -1) continue;
                int n = j;
                table[n] = table[n] + (invert ? -1 : 1);
            }
            numSets += invert ? 0 : 1;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int k = 0; k < 256; ++k) {
            if (table[k] != numSets) continue;
            sbuf.append((char)k);
        }
        return sbuf.toString();
    }

    public IRubyObject count(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 1, -1);
        String[] specs = new String[argc];
        for (int i = 0; i < argc; ++i) {
            specs[i] = RubyString.stringValue(args[i]).toString();
        }
        String table = this.setupTable(specs);
        int count = 0;
        for (int j = 0; j < this.value.length(); ++j) {
            if (table.indexOf(this.value.get(j) & 0xFF) == -1) continue;
            ++count;
        }
        return this.getRuntime().newFixnum(count);
    }

    private ByteList getDelete(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 1, -1);
        String[] specs = new String[argc];
        for (int i = 0; i < argc; ++i) {
            specs[i] = RubyString.stringValue(args[i]).toString();
        }
        String table = this.setupTable(specs);
        int strLen = this.value.length();
        StringBuffer sbuf = new StringBuffer(strLen);
        for (int j = 0; j < strLen; ++j) {
            int c = this.value.get(j) & 0xFF;
            if (table.indexOf(c) != -1) continue;
            sbuf.append((char)c);
        }
        return new ByteList(RubyString.stringToBytes(sbuf.toString()));
    }

    public IRubyObject delete(IRubyObject[] args) {
        return RubyString.newString(this.getRuntime(), this.getDelete(args)).infectBy(this);
    }

    public IRubyObject delete_bang(IRubyObject[] args) {
        ByteList newStr = this.getDelete(args);
        if (this.value.equals(newStr)) {
            return this.getRuntime().getNil();
        }
        this.value = newStr;
        this.stringMutated();
        return this;
    }

    private ByteList getSqueeze(IRubyObject[] args) {
        int argc = args.length;
        String[] specs = null;
        if (argc > 0) {
            specs = new String[argc];
            for (int i = 0; i < argc; ++i) {
                specs[i] = RubyString.stringValue(args[i]).toString();
            }
        }
        String table = specs == null ? null : this.setupTable(specs);
        int strLen = this.value.length();
        if (strLen <= 1) {
            return this.value;
        }
        StringBuffer sbuf = new StringBuffer(strLen);
        int c1 = this.value.get(0) & 0xFF;
        sbuf.append((char)c1);
        for (int j = 1; j < strLen; ++j) {
            int c2 = this.value.get(j) & 0xFF;
            if (c2 == c1 && (table == null || table.indexOf(c2) != -1)) continue;
            sbuf.append((char)c2);
            c1 = c2;
        }
        return new ByteList(RubyString.stringToBytes(sbuf.toString()));
    }

    public IRubyObject squeeze(IRubyObject[] args) {
        return RubyString.newString(this.getRuntime(), this.getSqueeze(args)).infectBy(this);
    }

    public IRubyObject squeeze_bang(IRubyObject[] args) {
        ByteList newStr = this.getSqueeze(args);
        if (this.value.equals(newStr)) {
            return this.getRuntime().getNil();
        }
        this.value = newStr;
        this.stringMutated();
        return this;
    }

    private ByteList tr(IRubyObject search, IRubyObject replace, boolean squeeze) {
        String srchSpec = search.convertToString().toString();
        String srch = RubyString.expandTemplate(srchSpec, true);
        if (srchSpec.startsWith("^")) {
            StringBuffer sbuf = new StringBuffer(256);
            for (int i = 0; i < 256; ++i) {
                char c = (char)i;
                if (srch.indexOf(c) != -1) continue;
                sbuf.append(c);
            }
            srch = sbuf.toString();
        }
        String repl = RubyString.expandTemplate(replace.convertToString().toString(), false);
        int strLen = this.value.length();
        if (strLen == 0 || srch.length() == 0) {
            return this.value;
        }
        int repLen = repl.length();
        StringBuffer sbuf = new StringBuffer(strLen);
        int n = -1;
        for (int i = 0; i < strLen; ++i) {
            char c;
            int cs = this.value.get(i) & 0xFF;
            int pos = srch.indexOf(cs);
            if (pos == -1) {
                sbuf.append((char)cs);
                c = '\uffffffff';
                continue;
            }
            if (repLen <= 0) continue;
            char cr = repl.charAt(Math.min(pos, repLen - 1));
            if (squeeze && cr == c) continue;
            sbuf.append(cr);
            c = cr;
        }
        return new ByteList(RubyString.stringToBytes(sbuf.toString()));
    }

    public IRubyObject tr(IRubyObject search, IRubyObject replace) {
        return RubyString.newString(this.getRuntime(), this.tr(search, replace, false)).infectBy(this);
    }

    public IRubyObject tr_bang(IRubyObject search, IRubyObject replace) {
        ByteList newStr = this.tr(search, replace, false);
        if (this.value.equals(newStr)) {
            return this.getRuntime().getNil();
        }
        this.value = newStr;
        this.stringMutated();
        return this;
    }

    public IRubyObject tr_s(IRubyObject search, IRubyObject replace) {
        return RubyString.newString(this.getRuntime(), this.tr(search, replace, true)).infectBy(this);
    }

    public IRubyObject tr_s_bang(IRubyObject search, IRubyObject replace) {
        ByteList newStr = this.tr(search, replace, true);
        if (this.value.equals(newStr)) {
            return this.getRuntime().getNil();
        }
        this.value = newStr;
        this.stringMutated();
        return this;
    }

    public IRubyObject each_line(IRubyObject[] args, Block block) {
        int strLen = this.value.length();
        if (strLen == 0) {
            return this;
        }
        String sep = this.checkArgumentCount(args, 0, 1) == 1 ? RubyRegexp.escapeSpecialChars(RubyString.stringValue(args[0]).toString()) : RubyRegexp.escapeSpecialChars(this.getRuntime().getGlobalVariables().get("$/").asSymbol());
        if (sep == null) {
            sep = "(?:\\n|\\r\\n?)";
        } else if (sep.length() == 0) {
            sep = "(?:\\n|\\r\\n?){2,}";
        }
        RubyRegexp pat = RubyRegexp.newRegexp(this.getRuntime(), ".*?" + sep, 4, null);
        int start = 0;
        ThreadContext tc = this.getRuntime().getCurrentContext();
        String toString = this.toString();
        while (pat.search(toString, start) != -1) {
            RubyMatchData md = (RubyMatchData)tc.getBackref();
            tc.yield(md.group(0L), block);
            start = md.matchEndPosition();
        }
        if (start < strLen) {
            tc.yield(this.substr(start, strLen - start), block);
        }
        return this;
    }

    public RubyString each_byte(Block block) {
        int lLength = this.value.length();
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < lLength; ++i) {
            context.yield(this.getRuntime().newFixnum(this.value.get(i) & 0xFF), block);
        }
        return this;
    }

    public RubySymbol intern() {
        String s = this.toString();
        if (s.equals("")) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        if (s.indexOf(0) >= 0) {
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return RubySymbol.newSymbol(this.getRuntime(), this.toString());
    }

    public RubySymbol to_sym() {
        return this.intern();
    }

    public RubyInteger sum(IRubyObject[] args) {
        long bitSize = 16L;
        if (args.length > 0) {
            bitSize = ((RubyInteger)args[0].convertType(RubyInteger.class, "Integer", "to_i")).getLongValue();
        }
        long result = 0L;
        for (int i = 0; i < this.value.length(); ++i) {
            result += (long)(this.value.get(i) & 0xFF);
        }
        return this.getRuntime().newFixnum(bitSize == 0L ? result : result % (long)Math.pow(2.0, bitSize));
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyString result = RubyString.newString(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result);
        return result;
    }

    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    public void setValue(CharSequence value) {
        this.value.replace(ByteList.plain(value));
        this.stringMutated();
    }

    public void setValue(ByteList value) {
        this.value = value;
        this.stringMutated();
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public String getUnicodeValue() {
        try {
            return new String(this.value.bytes, 0, this.value.realSize, "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException("Something's seriously broken with encodings", e);
        }
    }

    public void setUnicodeValue(String newValue) {
        try {
            this.value.replace(newValue.getBytes("UTF8"));
            this.stringMutated();
        }
        catch (Exception e) {
            throw new RuntimeException("Something's seriously broken with encodings", e);
        }
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    public static class JavaCrypt {
        private static Random r_gen = new Random();
        private static final char[] theBaseSalts = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '/', '.'};
        private static final int ITERATIONS = 16;
        private static final int[] con_salt = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 0, 0, 0, 0};
        private static final boolean[] shifts2 = new boolean[]{false, false, true, true, true, true, true, true, false, true, true, true, true, true, true, false};
        private static final int[][] skb = new int[][]{{0, 16, 0x20000000, 0x20000010, 65536, 65552, 0x20010000, 0x20010010, 2048, 2064, 0x20000800, 536872976, 67584, 67600, 536938496, 536938512, 32, 48, 0x20000020, 0x20000030, 65568, 65584, 0x20010020, 536936496, 2080, 2096, 0x20000820, 536873008, 67616, 67632, 536938528, 536938544, 524288, 524304, 0x20080000, 537395216, 589824, 589840, 0x20090000, 537460752, 526336, 526352, 0x20080800, 537397264, 591872, 591888, 537462784, 537462800, 524320, 524336, 0x20080020, 537395248, 589856, 589872, 0x20090020, 537460784, 526368, 526384, 0x20080820, 537397296, 591904, 591920, 537462816, 537462832}, {0, 0x2000000, 8192, 0x2002000, 0x200000, 0x2200000, 0x202000, 0x2202000, 4, 0x2000004, 8196, 0x2002004, 0x200004, 0x2200004, 0x202004, 0x2202004, 1024, 0x2000400, 9216, 0x2002400, 0x200400, 0x2200400, 0x202400, 0x2202400, 1028, 0x2000404, 9220, 0x2002404, 0x200404, 0x2200404, 0x202404, 0x2202404, 0x10000000, 0x12000000, 0x10002000, 0x12002000, 0x10200000, 0x12200000, 0x10202000, 0x12202000, 0x10000004, 301989892, 268443652, 301998084, 270532612, 304087044, 270540804, 304095236, 0x10000400, 301990912, 268444672, 301999104, 270533632, 304088064, 270541824, 304096256, 0x10000404, 301990916, 268444676, 301999108, 270533636, 304088068, 270541828, 304096260}, {0, 1, 262144, 262145, 0x1000000, 0x1000001, 0x1040000, 0x1040001, 2, 3, 262146, 262147, 0x1000002, 0x1000003, 17039362, 17039363, 512, 513, 262656, 262657, 0x1000200, 0x1000201, 17039872, 17039873, 514, 515, 262658, 262659, 0x1000202, 16777731, 17039874, 17039875, 0x8000000, 0x8000001, 0x8040000, 134479873, 0x9000000, 0x9000001, 0x9040000, 151257089, 0x8000002, 0x8000003, 134479874, 134479875, 0x9000002, 0x9000003, 151257090, 151257091, 0x8000200, 134218241, 134480384, 134480385, 0x9000200, 150995457, 151257600, 151257601, 0x8000202, 134218243, 134480386, 134480387, 0x9000202, 150995459, 151257602, 151257603}, {0, 0x100000, 256, 0x100100, 8, 0x100008, 264, 0x100108, 4096, 0x101000, 4352, 0x101100, 4104, 0x101008, 4360, 0x101108, 0x4000000, 0x4100000, 0x4000100, 0x4100100, 0x4000008, 68157448, 67109128, 68157704, 0x4001000, 0x4101000, 0x4001100, 0x4101100, 67112968, 68161544, 67113224, 68161800, 131072, 0x120000, 131328, 0x120100, 131080, 1179656, 131336, 1179912, 135168, 0x121000, 135424, 0x121100, 135176, 1183752, 135432, 1184008, 0x4020000, 68288512, 67240192, 68288768, 67239944, 68288520, 67240200, 68288776, 67244032, 68292608, 67244288, 68292864, 67244040, 68292616, 67244296, 68292872}, {0, 0x10000000, 65536, 0x10010000, 4, 0x10000004, 65540, 0x10010004, 0x20000000, 0x30000000, 0x20010000, 0x30010000, 0x20000004, 0x30000004, 536936452, 805371908, 0x100000, 0x10100000, 0x110000, 0x10110000, 0x100004, 0x10100004, 0x110004, 0x10110004, 0x20100000, 0x30100000, 0x20110000, 0x30110000, 537919492, 806354948, 537985028, 806420484, 4096, 0x10001000, 69632, 0x10011000, 4100, 0x10001004, 69636, 0x10011004, 0x20001000, 0x30001000, 0x20011000, 0x30011000, 536875012, 805310468, 536940548, 805376004, 0x101000, 0x10101000, 0x111000, 0x10111000, 0x101004, 0x10101004, 0x111004, 0x10111004, 0x20101000, 0x30101000, 0x20111000, 0x30111000, 537923588, 806359044, 537989124, 806424580}, {0, 0x8000000, 8, 0x8000008, 1024, 0x8000400, 1032, 0x8000408, 131072, 0x8020000, 131080, 0x8020008, 132096, 134349824, 132104, 134349832, 1, 0x8000001, 9, 0x8000009, 1025, 134218753, 1033, 134218761, 131073, 134348801, 131081, 134348809, 132097, 134349825, 132105, 134349833, 0x2000000, 0xA000000, 0x2000008, 0xA000008, 0x2000400, 0xA000400, 33555464, 167773192, 0x2020000, 0xA020000, 0x2020008, 167903240, 0x2020400, 167904256, 33686536, 167904264, 0x2000001, 0xA000001, 0x2000009, 0xA000009, 33555457, 167773185, 33555465, 167773193, 0x2020001, 167903233, 0x2020009, 167903241, 33686529, 167904257, 33686537, 167904265}, {0, 256, 524288, 524544, 0x1000000, 0x1000100, 0x1080000, 0x1080100, 16, 272, 524304, 524560, 0x1000010, 0x1000110, 0x1080010, 0x1080110, 0x200000, 0x200100, 0x280000, 2621696, 0x1200000, 0x1200100, 19398656, 19398912, 0x200010, 0x200110, 2621456, 2621712, 0x1200010, 0x1200110, 19398672, 19398928, 512, 768, 524800, 525056, 0x1000200, 0x1000300, 17302016, 17302272, 528, 784, 524816, 525072, 0x1000210, 0x1000310, 17302032, 17302288, 0x200200, 0x200300, 0x280200, 2622208, 0x1200200, 18875136, 19399168, 19399424, 0x200210, 2097936, 2621968, 2622224, 0x1200210, 18875152, 19399184, 19399440}, {0, 0x4000000, 262144, 0x4040000, 2, 0x4000002, 262146, 0x4040002, 8192, 0x4002000, 270336, 0x4042000, 8194, 0x4002002, 270338, 0x4042002, 32, 0x4000020, 262176, 0x4040020, 34, 0x4000022, 262178, 0x4040022, 8224, 0x4002020, 270368, 0x4042020, 8226, 0x4002022, 270370, 0x4042022, 2048, 0x4000800, 264192, 0x4040800, 2050, 67110914, 264194, 67373058, 10240, 67119104, 272384, 67381248, 10242, 67119106, 272386, 67381250, 2080, 67110944, 264224, 67373088, 2082, 67110946, 264226, 67373090, 10272, 67119136, 272416, 67381280, 10274, 67119138, 272418, 67381282}};
        private static final int[][] SPtrans = new int[][]{{0x820200, 131072, -2139095040, -2138963456, 0x800000, -2147352064, -2147352576, -2139095040, -2147352064, 0x820200, 0x820000, -2147483136, -2139094528, 0x800000, 0, -2147352576, 131072, Integer.MIN_VALUE, 0x800200, 131584, -2138963456, 0x820000, -2147483136, 0x800200, Integer.MIN_VALUE, 512, 131584, -2138963968, 512, -2139094528, -2138963968, 0, 0, -2138963456, 0x800200, -2147352576, 0x820200, 131072, -2147483136, 0x800200, -2138963968, 512, 131584, -2139095040, -2147352064, Integer.MIN_VALUE, -2139095040, 0x820000, -2138963456, 131584, 0x820000, -2139094528, 0x800000, -2147483136, -2147352576, 0, 131072, 0x800000, -2139094528, 0x820200, Integer.MIN_VALUE, -2138963968, 512, -2147352064}, {268705796, 0, 270336, 0x10040000, 0x10000004, 8196, 0x10002000, 270336, 8192, 0x10040004, 4, 0x10002000, 262148, 268705792, 0x10040000, 4, 262144, 268443652, 0x10040004, 8192, 270340, 0x10000000, 0, 262148, 268443652, 270340, 268705792, 0x10000004, 0x10000000, 262144, 8196, 268705796, 262148, 268705792, 0x10002000, 270340, 268705796, 262148, 0x10000004, 0, 0x10000000, 8196, 262144, 0x10040004, 8192, 0x10000000, 270340, 268443652, 268705792, 8192, 0, 0x10000004, 4, 268705796, 270336, 0x10040000, 0x10040004, 262144, 8196, 0x10002000, 268443652, 4, 0x10040000, 270336}, {0x41000000, 0x1010040, 64, 0x41000040, 0x40010000, 0x1000000, 0x41000040, 65600, 0x1000040, 65536, 0x1010000, 0x40000000, 0x41010040, 0x40000040, 0x40000000, 0x41010000, 0, 0x40010000, 0x1010040, 64, 0x40000040, 0x41010040, 65536, 0x41000000, 0x41010000, 0x1000040, 0x40010040, 0x1010000, 65600, 0, 0x1000000, 0x40010040, 0x1010040, 64, 0x40000000, 65536, 0x40000040, 0x40010000, 0x1010000, 0x41000040, 0, 0x1010040, 65600, 0x41010000, 0x40010000, 0x1000000, 0x41010040, 0x40000000, 0x40010040, 0x41000000, 0x1000000, 0x41010040, 65536, 0x1000040, 0x41000040, 65600, 0x1000040, 0, 0x41010000, 0x40000040, 0x41000000, 0x40010040, 64, 0x1010000}, {1049602, 0x4000400, 2, 68158466, 0, 0x4100000, 0x4000402, 0x100002, 0x4100400, 0x4000002, 0x4000000, 1026, 0x4000002, 1049602, 0x100000, 0x4000000, 68157442, 0x100400, 1024, 2, 0x100400, 0x4000402, 0x4100000, 1024, 1026, 0, 0x100002, 0x4100400, 0x4000400, 68157442, 68158466, 0x100000, 68157442, 1026, 0x100000, 0x4000002, 0x100400, 0x4000400, 2, 0x4100000, 0x4000402, 0, 1024, 0x100002, 0, 68157442, 0x4100400, 1024, 0x4000000, 68158466, 1049602, 0x100000, 68158466, 2, 0x4000400, 1049602, 0x100002, 0x100400, 0x4100000, 0x4000402, 1026, 0x4000000, 0x4000002, 0x4100400}, {0x2000000, 16384, 256, 33571080, 33570824, 0x2000100, 16648, 0x2004000, 16384, 8, 0x2000008, 16640, 33554696, 33570824, 33571072, 0, 16640, 0x2000000, 16392, 264, 0x2000100, 16648, 0, 0x2000008, 8, 33554696, 33571080, 16392, 0x2004000, 256, 264, 33571072, 33571072, 33554696, 16392, 0x2004000, 16384, 8, 0x2000008, 0x2000100, 0x2000000, 16640, 33571080, 0, 16648, 0x2000000, 256, 16392, 33554696, 256, 0, 33571080, 33570824, 33571072, 264, 16384, 16640, 33570824, 0x2000100, 264, 8, 16648, 0x2004000, 0x2000008}, {0x20000010, 524304, 0, 0x20080800, 524304, 2048, 536872976, 524288, 2064, 537397264, 526336, 0x20000000, 0x20000800, 0x20000010, 0x20080000, 526352, 524288, 536872976, 537395216, 0, 2048, 16, 0x20080800, 537395216, 537397264, 0x20080000, 0x20000000, 2064, 16, 526336, 526352, 0x20000800, 2064, 0x20000000, 0x20000800, 526352, 0x20080800, 524304, 0, 0x20000800, 0x20000000, 2048, 537395216, 524288, 524304, 537397264, 526336, 16, 537397264, 526336, 524288, 536872976, 0x20000010, 0x20080000, 526352, 0, 2048, 0x20000010, 536872976, 0x20080800, 0x20080000, 2064, 16, 537395216}, {4096, 128, 0x400080, 0x400001, 4198529, 4097, 4224, 0, 0x400000, 4194433, 129, 0x401000, 1, 4198528, 0x401000, 129, 4194433, 4096, 4097, 4198529, 0, 0x400080, 0x400001, 4224, 0x401001, 4225, 4198528, 1, 4225, 0x401001, 128, 0x400000, 4225, 0x401000, 0x401001, 129, 4096, 128, 0x400000, 0x401001, 4194433, 4225, 4224, 0, 128, 0x400001, 1, 0x400080, 0, 4194433, 0x400080, 4224, 129, 4096, 4198529, 0x400000, 4198528, 1, 4097, 4198529, 0x400001, 4198528, 0x401000, 4097}, {0x8200020, 0x8208000, 32800, 0, 0x8008000, 0x200020, 0x8200000, 0x8208020, 32, 0x8000000, 0x208000, 32800, 0x208020, 0x8008020, 0x8000020, 0x8200000, 32768, 0x208020, 0x200020, 0x8008000, 0x8208020, 0x8000020, 0, 0x208000, 0x8000000, 0x200000, 0x8008020, 0x8200020, 0x200000, 32768, 0x8208000, 32, 0x200000, 32768, 0x8000020, 0x8208020, 32800, 0x8000000, 0, 0x208000, 0x8200020, 0x8008020, 0x8008000, 0x200020, 0x8208000, 32, 0x200020, 0x8008000, 0x8208020, 0x200000, 0x8200000, 0x8000020, 0x208000, 32800, 0x8008020, 0x8200000, 32, 0x8208000, 0x208020, 0, 0x8000000, 0x8200020, 32768, 0x208020}};
        private static final int[] cov_2char = new int[]{46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

        private static final int byteToUnsigned(byte b) {
            return b & 0xFF;
        }

        private static int fourBytesToInt(byte[] b, int offset) {
            int value = JavaCrypt.byteToUnsigned(b[offset++]);
            value |= JavaCrypt.byteToUnsigned(b[offset++]) << 8;
            value |= JavaCrypt.byteToUnsigned(b[offset++]) << 16;
            return value |= JavaCrypt.byteToUnsigned(b[offset++]) << 24;
        }

        private static final void intToFourBytes(int iValue, byte[] b, int offset) {
            b[offset++] = (byte)(iValue & 0xFF);
            b[offset++] = (byte)(iValue >>> 8 & 0xFF);
            b[offset++] = (byte)(iValue >>> 16 & 0xFF);
            b[offset++] = (byte)(iValue >>> 24 & 0xFF);
        }

        private static final void PERM_OP(int a, int b, int n, int m, int[] results) {
            int t = (a >>> n ^ b) & m;
            results[0] = a ^= t << n;
            results[1] = b ^= t;
        }

        private static final int HPERM_OP(int a, int n, int m) {
            int t = (a << 16 - n ^ a) & m;
            a = a ^ t ^ t >>> 16 - n;
            return a;
        }

        private static int[] des_set_key(byte[] key) {
            int[] schedule = new int[32];
            int c = JavaCrypt.fourBytesToInt(key, 0);
            int d = JavaCrypt.fourBytesToInt(key, 4);
            int[] results = new int[2];
            JavaCrypt.PERM_OP(d, c, 4, 0xF0F0F0F, results);
            d = results[0];
            c = results[1];
            c = JavaCrypt.HPERM_OP(c, -2, -859045888);
            d = JavaCrypt.HPERM_OP(d, -2, -859045888);
            JavaCrypt.PERM_OP(d, c, 1, 0x55555555, results);
            d = results[0];
            c = results[1];
            JavaCrypt.PERM_OP(c, d, 8, 0xFF00FF, results);
            c = results[0];
            d = results[1];
            JavaCrypt.PERM_OP(d, c, 1, 0x55555555, results);
            d = results[0];
            c = results[1];
            d = (d & 0xFF) << 16 | d & 0xFF00 | (d & 0xFF0000) >>> 16 | (c & 0xF0000000) >>> 4;
            c &= 0xFFFFFFF;
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                if (shifts2[i]) {
                    c = c >>> 2 | c << 26;
                    d = d >>> 2 | d << 26;
                } else {
                    c = c >>> 1 | c << 27;
                    d = d >>> 1 | d << 27;
                }
                int s = skb[0][(c &= 0xFFFFFFF) & 0x3F] | skb[1][c >>> 6 & 3 | c >>> 7 & 0x3C] | skb[2][c >>> 13 & 0xF | c >>> 14 & 0x30] | skb[3][c >>> 20 & 1 | c >>> 21 & 6 | c >>> 22 & 0x38];
                int t = skb[4][(d &= 0xFFFFFFF) & 0x3F] | skb[5][d >>> 7 & 3 | d >>> 8 & 0x3C] | skb[6][d >>> 15 & 0x3F] | skb[7][d >>> 21 & 0xF | d >>> 22 & 0x30];
                schedule[j++] = (t << 16 | s & 0xFFFF) & 0xFFFFFFFF;
                s = s >>> 16 | t & 0xFFFF0000;
                s = s << 4 | s >>> 28;
                schedule[j++] = s & 0xFFFFFFFF;
            }
            return schedule;
        }

        private static final int D_ENCRYPT(int L, int R, int S, int E0, int E1, int[] s) {
            int v = R ^ R >>> 16;
            int u = v & E0;
            u = u ^ u << 16 ^ R ^ s[S];
            int t = (v &= E1) ^ v << 16 ^ R ^ s[S + 1];
            t = t >>> 4 | t << 28;
            return L ^= SPtrans[1][t & 0x3F] | SPtrans[3][t >>> 8 & 0x3F] | SPtrans[5][t >>> 16 & 0x3F] | SPtrans[7][t >>> 24 & 0x3F] | SPtrans[0][u & 0x3F] | SPtrans[2][u >>> 8 & 0x3F] | SPtrans[4][u >>> 16 & 0x3F] | SPtrans[6][u >>> 24 & 0x3F];
        }

        private static final int[] body(int[] schedule, int Eswap0, int Eswap1) {
            int left = 0;
            int right = 0;
            int t = 0;
            for (int j = 0; j < 25; ++j) {
                for (int i = 0; i < 32; i += 4) {
                    left = JavaCrypt.D_ENCRYPT(left, right, i, Eswap0, Eswap1, schedule);
                    right = JavaCrypt.D_ENCRYPT(right, left, i + 2, Eswap0, Eswap1, schedule);
                }
                t = left;
                left = right;
                right = t;
            }
            t = right;
            right = left >>> 1 | left << 31;
            left = t >>> 1 | t << 31;
            int[] results = new int[2];
            JavaCrypt.PERM_OP(right &= 0xFFFFFFFF, left &= 0xFFFFFFFF, 1, 0x55555555, results);
            right = results[0];
            left = results[1];
            JavaCrypt.PERM_OP(left, right, 8, 0xFF00FF, results);
            left = results[0];
            right = results[1];
            JavaCrypt.PERM_OP(right, left, 2, 0x33333333, results);
            right = results[0];
            left = results[1];
            JavaCrypt.PERM_OP(left, right, 16, 65535, results);
            left = results[0];
            right = results[1];
            JavaCrypt.PERM_OP(right, left, 4, 0xF0F0F0F, results);
            right = results[0];
            left = results[1];
            int[] out = new int[]{left, right};
            return out;
        }

        public static final String crypt(String salt, String original) {
            int i;
            while (salt.length() < 2) {
                salt = salt + JavaCrypt.getSaltChar();
            }
            StringBuffer buffer = new StringBuffer("             ");
            char charZero = salt.charAt(0);
            char charOne = salt.charAt(1);
            buffer.setCharAt(0, charZero);
            buffer.setCharAt(1, charOne);
            int Eswap0 = con_salt[charZero];
            int Eswap1 = con_salt[charOne] << 4;
            byte[] key = new byte[8];
            for (i = 0; i < key.length; ++i) {
                key[i] = 0;
            }
            for (i = 0; i < key.length && i < original.length(); ++i) {
                char iChar = original.charAt(i);
                key[i] = (byte)(iChar << 1);
            }
            int[] schedule = JavaCrypt.des_set_key(key);
            int[] out = JavaCrypt.body(schedule, Eswap0, Eswap1);
            byte[] b = new byte[9];
            JavaCrypt.intToFourBytes(out[0], b, 0);
            JavaCrypt.intToFourBytes(out[1], b, 4);
            b[8] = 0;
            int y = 0;
            int u = 128;
            for (int i2 = 2; i2 < 13; ++i2) {
                int c = 0;
                for (int j = 0; j < 6; ++j) {
                    c <<= 1;
                    if ((b[y] & u) != 0) {
                        c |= 1;
                    }
                    if ((u >>>= 1) == 0) {
                        ++y;
                        u = 128;
                    }
                    buffer.setCharAt(i2, (char)cov_2char[c]);
                }
            }
            return buffer.toString();
        }

        private static String getSaltChar() {
            return JavaCrypt.getSaltChar(1);
        }

        private static String getSaltChar(int amount) {
            StringBuffer sb = new StringBuffer();
            for (int i = amount; i > 0; --i) {
                sb.append(theBaseSalts[Math.abs(r_gen.nextInt()) % 64]);
            }
            return sb.toString();
        }

        public static boolean check(String theClear, String theCrypt) {
            String theTest = JavaCrypt.crypt(theCrypt.substring(0, 2), theClear);
            return theTest.equals(theCrypt);
        }

        public static String crypt(String theClear) {
            return JavaCrypt.crypt(JavaCrypt.getSaltChar(2), theClear);
        }
    }
}

