/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyProc
extends RubyObject {
    private Block block = Block.NULL_BLOCK;
    private RubyModule wrapper = null;
    private boolean isLambda = false;

    public RubyProc(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public Block getBlock() {
        return this.block;
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public static RubyProc newProc(Ruby runtime, boolean isLambda) {
        RubyProc newProc = new RubyProc(runtime, runtime.getClass("Proc"));
        newProc.isLambda = isLambda;
        return newProc;
    }

    public IRubyObject initialize(IRubyObject[] args, Block procBlock) {
        if (procBlock == null) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (!this.isLambda || procBlock == null) {
            // empty if block
        }
        this.block = procBlock.cloneBlock();
        this.wrapper = this.getRuntime().getCurrentContext().getWrapper();
        this.block.isLambda = this.isLambda;
        this.block.setProcObject(this);
        return this;
    }

    protected IRubyObject doClone() {
        RubyProc newProc = new RubyProc(this.getRuntime(), this.getRuntime().getClass("Proc"));
        newProc.block = this.getBlock();
        newProc.wrapper = this.getWrapper();
        return newProc;
    }

    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block);
    }

    public IRubyObject call(IRubyObject[] args) {
        return this.call(args, null, Block.NULL_BLOCK);
    }

    public IRubyObject call(IRubyObject[] args, Block unusedBlock) {
        return this.call(args, null, Block.NULL_BLOCK);
    }

    public IRubyObject call(IRubyObject[] args, IRubyObject self, Block unusedBlock) {
        assert (args != null);
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyModule oldWrapper = context.getWrapper();
        context.setWrapper(this.wrapper);
        try {
            if (this.block.isLambda) {
                this.block.arity().checkArity(this.getRuntime(), args);
            }
            IRubyObject iRubyObject = this.block.call(context, args, self);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                if (this.block.isLambda) {
                    IRubyObject iRubyObject = (IRubyObject)je.getValue();
                    return iRubyObject;
                }
                throw this.getRuntime().newLocalJumpError("unexpected return");
            }
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                Object target = je.getTarget();
                if (target == this || this.block.isLambda) {
                    IRubyObject iRubyObject = (IRubyObject)je.getValue();
                    return iRubyObject;
                }
                if (target == null) {
                    throw this.getRuntime().newLocalJumpError("unexpected return");
                }
                throw je;
            }
            throw je;
        }
        finally {
            context.setWrapper(oldWrapper);
        }
    }

    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    public RubyProc to_proc() {
        return this;
    }
}

