/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.IdUtil;
import org.jruby.util.PrintfFormat;
import org.jruby.util.collections.SinglyLinkedList;

public class RubyObject
implements Cloneable,
IRubyObject {
    private RubyClass metaClass;
    protected Map instanceVariables;
    private boolean frozen;
    private boolean taint;
    private transient Object dataStruct;

    public RubyObject(Ruby runtime, RubyClass metaClass) {
        this(runtime, metaClass, runtime.isObjectSpaceEnabled());
    }

    public RubyObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        this.frozen = false;
        this.taint = false;
        if (useObjectSpace && !this.isImmediate()) {
            runtime.getObjectSpace().add(this);
        }
        this.taint |= runtime.getSafeLevel() >= 3;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    public int getNativeTypeIndex() {
        return 14;
    }

    public boolean isImmediate() {
        return false;
    }

    public RubyClass makeMetaClass(RubyClass superClass, SinglyLinkedList parentCRef) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass, this.getMetaClass().getAllocator(), parentCRef);
        this.setMetaClass(klass);
        klass.setInstanceVariable("__attached__", this);
        if (this instanceof RubyClass && this.isSingleton()) {
            klass.setMetaClass(klass);
            klass.setSuperClass(((RubyClass)this).getSuperClass().getRealClass().getMetaClass());
        } else {
            klass.setMetaClass(superClass.getRealClass().getMetaClass());
        }
        klass.index = superClass.index;
        return klass;
    }

    public boolean isSingleton() {
        return false;
    }

    public Class getJavaClass() {
        return IRubyObject.class;
    }

    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && this.callMethod(this.getRuntime().getCurrentContext(), "==", (IRubyObject)other).isTrue();
    }

    public String toString() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_s").toString();
    }

    public Ruby getRuntime() {
        return this.metaClass.getRuntime();
    }

    public boolean safeHasInstanceVariables() {
        return this.instanceVariables != null && this.instanceVariables.size() > 0;
    }

    public Map safeGetInstanceVariables() {
        return this.instanceVariables == null ? null : this.getInstanceVariablesSnapshot();
    }

    public IRubyObject removeInstanceVariable(String name) {
        return (IRubyObject)this.getInstanceVariables().remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getInstanceVariablesSnapshot() {
        Map map = this.getInstanceVariables();
        synchronized (map) {
            return Collections.unmodifiableMap(new HashMap(this.getInstanceVariables()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getInstanceVariables() {
        if (this.instanceVariables == null) {
            RubyObject rubyObject = this;
            synchronized (rubyObject) {
                if (this.instanceVariables == null) {
                    this.instanceVariables = Collections.synchronizedMap(new HashMap());
                }
            }
        }
        return this.instanceVariables;
    }

    public void setInstanceVariables(Map instanceVariables) {
        this.instanceVariables = Collections.synchronizedMap(instanceVariables);
    }

    public RubyClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    protected void testFrozen(String message) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message + this.getMetaClass().getName());
        }
    }

    protected void checkFrozen() {
        this.testFrozen("can't modify frozen ");
    }

    public boolean isTaint() {
        return this.taint;
    }

    public void setTaint(boolean taint) {
        this.taint = taint;
    }

    public boolean isNil() {
        return false;
    }

    public boolean isTrue() {
        return !this.isNil();
    }

    public boolean isFalse() {
        return this.isNil();
    }

    public boolean respondsTo(String name) {
        return this.getMetaClass().isMethodBound(name, false);
    }

    public int checkArgumentCount(IRubyObject[] args, int min, int max) {
        if (args.length < min) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for " + min + ")");
        }
        if (max > -1 && args.length > max) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for " + max + ")");
        }
        return args.length;
    }

    public boolean isKindOf(RubyModule type) {
        return this.getMetaClass().hasModuleInHierarchy(type);
    }

    public RubyClass getSingletonClass() {
        RubyClass klass = this.getMetaClass().isSingleton() && this.getMetaClass().getInstanceVariable("__attached__") == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass(), this.getMetaClass().getCRef());
        klass.setTaint(this.isTaint());
        klass.setFrozen(this.isFrozen());
        return klass;
    }

    public RubyClass getSingletonClassClone() {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone = new MetaClass(this.getRuntime(), klass.getSuperClass(), this.getMetaClass().getAllocator(), this.getMetaClass().getCRef());
        clone.setFrozen(klass.isFrozen());
        clone.setTaint(klass.isTaint());
        if (this instanceof RubyClass) {
            clone.setMetaClass(clone);
        } else {
            clone.setMetaClass(klass.getSingletonClassClone());
        }
        if (klass.safeHasInstanceVariables()) {
            clone.setInstanceVariables(new HashMap(klass.getInstanceVariables()));
        }
        klass.cloneMethods(clone);
        clone.getMetaClass().setInstanceVariable("__attached__", clone);
        return clone;
    }

    public void defineSingletonMethod(String name, Callback method) {
        this.getSingletonClass().defineMethod(name, method);
    }

    public void initCopy(IRubyObject original) {
        assert (original != null);
        assert (!this.isFrozen()) : "frozen object (" + this.getMetaClass().getName() + ") allocated";
        this.setInstanceVariables(new HashMap(original.getInstanceVariables()));
        this.callMethod(this.getRuntime().getCurrentContext(), "initialize_copy", original);
    }

    public IRubyObject infectBy(IRubyObject obj) {
        this.setTaint(this.isTaint() || obj.isTaint());
        return this;
    }

    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, Block block) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, CallType.FUNCTIONAL, block);
    }

    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, callType, Block.NULL_BLOCK);
    }

    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, CallType callType, Block block) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, callType, block);
    }

    public IRubyObject callMethod(ThreadContext context, byte methodIndex, String name, IRubyObject arg) {
        return this.callMethod(context, methodIndex, name, new IRubyObject[]{arg}, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    public IRubyObject callMethod(ThreadContext context, byte methodIndex, String name, IRubyObject[] args) {
        return this.callMethod(context, methodIndex, name, args, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    public IRubyObject callMethod(ThreadContext context, byte methodIndex, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, methodIndex, name, args, callType, Block.NULL_BLOCK);
    }

    public IRubyObject callMethod(ThreadContext context, byte methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        RubyClass module = this.getMetaClass();
        if (module.index != 0) {
            return this.callMethod(context, module, this.getRuntime().getSelectorTable().table[module.index][methodIndex], name, args, callType, block);
        }
        return this.callMethod(context, (RubyModule)module, name, args, callType, block);
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, byte switchvalue, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, rubyclass, name, args, callType, Block.NULL_BLOCK);
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, byte switchvalue, String name, IRubyObject[] args, CallType callType, Block block) {
        return this.callMethod(context, rubyclass, name, args, callType, block);
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, String name, IRubyObject[] args, CallType callType, Block block) {
        assert (args != null);
        DynamicMethod method = null;
        method = rubyclass.searchMethod(name);
        if (method.isUndefined() || !name.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), callType)) {
            if (callType == CallType.SUPER) {
                throw this.getRuntime().newNameError("super: no superclass method '" + name + "'", name);
            }
            context.setLastCallStatus(method.getVisibility(), callType);
            if (name.equals("method_missing")) {
                return RubyKernel.method_missing(this, args, block);
            }
            IRubyObject[] newArgs = new IRubyObject[args.length + 1];
            System.arraycopy(args, 0, newArgs, 1, args.length);
            newArgs[0] = RubySymbol.newSymbol(this.getRuntime(), name);
            return this.callMethod(context, "method_missing", newArgs, block);
        }
        RubyModule implementer = null;
        implementer = method.needsImplementer() ? rubyclass.findImplementer(method.getImplementationClass()) : method.getImplementationClass();
        String originalName = method.getOriginalName();
        if (originalName != null) {
            name = originalName;
        }
        return method.call(context, this, implementer, name, args, false, block);
    }

    public IRubyObject callMethod(ThreadContext context, String name) {
        return this.callMethod(context, name, IRubyObject.NULL_ARRAY, null, Block.NULL_BLOCK);
    }

    public IRubyObject callMethod(ThreadContext context, String name, Block block) {
        return this.callMethod(context, name, IRubyObject.NULL_ARRAY, null, block);
    }

    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject arg) {
        return this.callMethod(context, name, new IRubyObject[]{arg});
    }

    public IRubyObject instance_variable_get(IRubyObject var) {
        String varName = var.asSymbol();
        if (!IdUtil.isInstanceVariable(varName)) {
            throw this.getRuntime().newNameError("`" + varName + "' is not allowable as an instance variable name", varName);
        }
        IRubyObject variable = this.getInstanceVariable(varName);
        return variable == null ? this.getRuntime().getNil() : variable;
    }

    public IRubyObject getInstanceVariable(String name) {
        return (IRubyObject)this.getInstanceVariables().get(name);
    }

    public IRubyObject instance_variable_set(IRubyObject var, IRubyObject value) {
        String varName = var.asSymbol();
        if (!IdUtil.isInstanceVariable(varName)) {
            throw this.getRuntime().newNameError("`" + varName + "' is not allowable as an instance variable name", varName);
        }
        return this.setInstanceVariable(var.asSymbol(), value);
    }

    public IRubyObject setInstanceVariable(String name, IRubyObject value, String taintError, String freezeError) {
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError(taintError);
        }
        this.testFrozen(freezeError);
        this.getInstanceVariables().put(name, value);
        return value;
    }

    public IRubyObject setInstanceVariable(String name, IRubyObject value) {
        return this.setInstanceVariable(name, value, "Insecure: can't modify instance variable", "");
    }

    public Iterator instanceVariableNames() {
        return this.getInstanceVariables().keySet().iterator();
    }

    public IRubyObject eval(Node n) {
        return EvaluationState.eval(this.getRuntime(), this.getRuntime().getCurrentContext(), n, this, Block.NULL_BLOCK);
    }

    public void callInit(IRubyObject[] args, Block block) {
        this.callMethod(this.getRuntime().getCurrentContext(), "initialize", args, block);
    }

    public void extendObject(RubyModule module) {
        this.getSingletonClass().includeModule(module);
    }

    public String asSymbol() {
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a symbol");
    }

    public IRubyObject convertToTypeWithCheck(String targetType, String convertMethod) {
        if (targetType.equals(this.getMetaClass().getName())) {
            return this;
        }
        IRubyObject value = this.convertToType(targetType, convertMethod, false);
        if (value.isNil()) {
            return value;
        }
        if (!targetType.equals(value.getMetaClass().getName())) {
            throw this.getRuntime().newTypeError(value.getMetaClass().getName() + "#" + convertMethod + "should return " + targetType);
        }
        return value;
    }

    public IRubyObject convertToType(String targetType, String convertMethod, boolean raise) {
        if (targetType.equals(this.getMetaClass().getName())) {
            return this;
        }
        if (!this.respondsTo(convertMethod)) {
            if (raise) {
                throw this.getRuntime().newTypeError("can't convert " + RubyObject.trueFalseNil(this.getMetaClass().getName()) + " into " + RubyObject.trueFalseNil(targetType));
            }
            return this.getRuntime().getNil();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), convertMethod);
    }

    public static String trueFalseNil(IRubyObject v) {
        return RubyObject.trueFalseNil(v.getMetaClass().getName());
    }

    public static String trueFalseNil(String v) {
        if ("TrueClass".equals(v)) {
            return "true";
        }
        if ("FalseClass".equals(v)) {
            return "false";
        }
        if ("NilClass".equals(v)) {
            return "nil";
        }
        return v;
    }

    public RubyArray convertToArray() {
        return (RubyArray)this.convertToType("Array", "to_ary", true);
    }

    public RubyFloat convertToFloat() {
        return (RubyFloat)this.convertToType("Float", "to_f", true);
    }

    public RubyInteger convertToInteger() {
        return (RubyInteger)this.convertToType("Integer", "to_int", true);
    }

    public RubyString convertToString() {
        return (RubyString)this.convertToType("String", "to_str", true);
    }

    public RubyString objAsString() {
        if (this instanceof RubyString) {
            return (RubyString)this;
        }
        IRubyObject str = this.callMethod(this.getRuntime().getCurrentContext(), "to_s");
        if (!(str instanceof RubyString)) {
            str = this.anyToString();
        }
        return (RubyString)str;
    }

    public IRubyObject convertType(Class type, String targetType, String convertMethod) {
        if (type.isAssignableFrom(this.getClass())) {
            return this;
        }
        IRubyObject result = this.convertToType(targetType, convertMethod, true);
        if (!type.isAssignableFrom(result.getClass())) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#" + convertMethod + " should return " + targetType + ".");
        }
        return result;
    }

    public IRubyObject checkStringType() {
        IRubyObject str = this.convertToTypeWithCheck("String", "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = this.getRuntime().newString("");
        }
        return str;
    }

    public IRubyObject checkArrayType() {
        return this.convertToTypeWithCheck("Array", "to_ary");
    }

    public void checkSafeString() {
        if (this.getRuntime().getSafeLevel() > 0 && this.isTaint()) {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            if (tc.getFrameName() != null) {
                throw this.getRuntime().newSecurityError("Insecure operation - " + tc.getFrameName());
            }
            throw this.getRuntime().newSecurityError("Insecure operation: -r");
        }
        this.getRuntime().secure(4);
        if (!(this instanceof RubyString)) {
            throw this.getRuntime().newTypeError("wrong argument type " + this.getMetaClass().getName() + " (expected String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject specificEval(RubyModule mod, IRubyObject[] args, Block block) {
        if (block.isGiven()) {
            if (args.length > 0) {
                throw this.getRuntime().newArgumentError(args.length, 0);
            }
            return this.yieldUnder(mod, block);
        }
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (args.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (args.length > 3) {
            String lastFuncName = tc.getFrameName();
            throw this.getRuntime().newArgumentError("wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        args[0].convertToString();
        IRubyObject file = args.length > 1 ? args[1] : this.getRuntime().newString("(eval)");
        IRubyObject line = args.length > 2 ? args[2] : RubyFixnum.one(this.getRuntime());
        Visibility savedVisibility = tc.getCurrentVisibility();
        tc.setCurrentVisibility(Visibility.PUBLIC);
        try {
            IRubyObject iRubyObject = this.evalUnder(mod, args[0], file, line);
            return iRubyObject;
        }
        finally {
            tc.setCurrentVisibility(savedVisibility);
        }
    }

    public IRubyObject evalUnder(RubyModule under, IRubyObject src, IRubyObject file, IRubyObject line) {
        return under.executeUnder(new Callback(){

            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                IRubyObject source = args[1];
                IRubyObject filename = args[2];
                return args[0].evalSimple(source.getRuntime().getCurrentContext(), source, ((RubyString)filename).toString());
            }

            public Arity getArity() {
                return Arity.optional();
            }
        }, new IRubyObject[]{this, src, file, line}, Block.NULL_BLOCK);
    }

    private IRubyObject yieldUnder(RubyModule under, Block block) {
        return under.executeUnder(new Callback(){

            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                ThreadContext context = RubyObject.this.getRuntime().getCurrentContext();
                Visibility savedVisibility = block.getVisibility();
                block.setVisibility(Visibility.PUBLIC);
                try {
                    IRubyObject valueInYield = args[0];
                    IRubyObject selfInYield = args[0];
                    IRubyObject iRubyObject = block.yield(context, valueInYield, selfInYield, context.getRubyClass(), false);
                    return iRubyObject;
                }
                catch (JumpException je) {
                    if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                        IRubyObject iRubyObject = (IRubyObject)je.getValue();
                        return iRubyObject;
                    }
                    throw je;
                }
                finally {
                    block.setVisibility(savedVisibility);
                }
            }

            public Arity getArity() {
                return Arity.optional();
            }
        }, new IRubyObject[]{this}, block);
    }

    public IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, IRubyObject scope, String file) {
        assert (!scope.isNil());
        assert (file != null);
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        ISourcePosition savedPosition = threadContext.getPosition();
        IRubyObject result = this.getRuntime().getNil();
        IRubyObject newSelf = null;
        if (!(scope instanceof RubyBinding)) {
            if (scope instanceof RubyProc) {
                scope = ((RubyProc)scope).binding();
            } else {
                throw this.getRuntime().newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Proc/Binding)");
            }
        }
        Block blockOfBinding = ((RubyBinding)scope).getBlock();
        try {
            threadContext.preEvalWithBinding(blockOfBinding);
            newSelf = threadContext.getFrameSelf();
            result = EvaluationState.eval(this.getRuntime(), threadContext, this.getRuntime().parse(src.toString(), file, blockOfBinding.getDynamicScope()), newSelf, blockOfBinding);
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                throw this.getRuntime().newLocalJumpError("unexpected return");
            }
            if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                throw this.getRuntime().newLocalJumpError("unexpected break");
            }
            throw je;
        }
        finally {
            threadContext.postEvalWithBinding();
            threadContext.setPosition(savedPosition);
        }
        return result;
    }

    public IRubyObject evalSimple(ThreadContext context, IRubyObject src, String file) {
        assert (file != null);
        ISourcePosition savedPosition = context.getPosition();
        try {
            IRubyObject iRubyObject = EvaluationState.eval(this.getRuntime(), context, this.getRuntime().parse(src.toString(), file, context.getCurrentScope()), this, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump) {
                throw this.getRuntime().newLocalJumpError("unexpected return");
            }
            if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                throw this.getRuntime().newLocalJumpError("unexpected break");
            }
            throw je;
        }
        finally {
            context.setPosition(savedPosition);
        }
    }

    public IRubyObject obj_equal(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject same(IRubyObject other) {
        return this == other ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    public RubyBoolean respond_to(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, 2);
        String name = args[0].asSymbol();
        boolean includePrivate = args.length > 1 ? args[1].isTrue() : false;
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name, !includePrivate));
    }

    public synchronized RubyFixnum id() {
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    public synchronized RubyFixnum id_deprecated() {
        this.getRuntime().getWarnings().warn("Object#id will be deprecated; use Object#object_id");
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(System.identityHashCode(this));
    }

    public int hashCode() {
        IRubyObject hashValue = this.callMethod(this.getRuntime().getCurrentContext(), "hash");
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return System.identityHashCode(this);
    }

    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn("Object#type is deprecated; use Object#class");
        return this.type();
    }

    public IRubyObject rbClone() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't clone " + this.getMetaClass().getName());
        }
        IRubyObject clone = this.doClone();
        clone.setMetaClass(this.getSingletonClassClone());
        clone.setTaint(this.isTaint());
        clone.initCopy(this);
        clone.setFrozen(this.isFrozen());
        return clone;
    }

    protected IRubyObject doClone() {
        RubyClass realClass = this.getMetaClass().getRealClass();
        return realClass.getAllocator().allocate(this.getRuntime(), realClass);
    }

    public IRubyObject display(IRubyObject[] args) {
        IRubyObject port = args.length == 0 ? this.getRuntime().getGlobalVariables().get("$>") : args[0];
        port.callMethod(this.getRuntime().getCurrentContext(), "write", this);
        return this.getRuntime().getNil();
    }

    public IRubyObject dup() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject dup = this.doClone();
        dup.setMetaClass(this.type());
        dup.setFrozen(false);
        dup.setTaint(this.isTaint());
        dup.initCopy(this);
        return dup;
    }

    public RubyBoolean tainted() {
        return this.getRuntime().newBoolean(this.isTaint());
    }

    public IRubyObject taint() {
        this.getRuntime().secure(4);
        if (!this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(true);
        }
        return this;
    }

    public IRubyObject untaint() {
        this.getRuntime().secure(3);
        if (this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(false);
        }
        return this;
    }

    public IRubyObject freeze() {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't freeze object");
        }
        this.setFrozen(true);
        return this;
    }

    public RubyBoolean frozen() {
        return this.getRuntime().newBoolean(this.isFrozen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject inspect() {
        if (!this.isImmediate() && !(this instanceof RubyClass) && this != this.getRuntime().getObject() && this != this.getRuntime().getClass("Module") && !(this instanceof RubyModule) && this.safeHasInstanceVariables()) {
            StringBuffer part = new StringBuffer();
            String cname = this.getMetaClass().getRealClass().getName();
            part.append("#<").append(cname).append(":0x");
            part.append(Integer.toHexString(System.identityHashCode(this)));
            if (!this.getRuntime().registerInspecting(this)) {
                part.append(" ...>");
                return this.getRuntime().newString(part.toString());
            }
            try {
                String sep = "";
                Map iVars = this.getInstanceVariablesSnapshot();
                for (String name : iVars.keySet()) {
                    if (!IdUtil.isInstanceVariable(name)) continue;
                    part.append(sep);
                    part.append(" ");
                    part.append(name);
                    part.append("=");
                    part.append(((IRubyObject)iVars.get(name)).callMethod(this.getRuntime().getCurrentContext(), "inspect"));
                    sep = ",";
                }
                part.append(">");
                RubyString rubyString = this.getRuntime().newString(part.toString());
                return rubyString;
            }
            finally {
                this.getRuntime().unregisterInspecting(this);
            }
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_s");
    }

    public RubyBoolean instance_of(IRubyObject type) {
        return this.getRuntime().newBoolean(this.type() == type);
    }

    public RubyArray instance_variables() {
        ArrayList<RubyString> names = new ArrayList<RubyString>();
        for (String name : this.getInstanceVariablesSnapshot().keySet()) {
            if (!IdUtil.isInstanceVariable(name)) continue;
            names.add(this.getRuntime().newString(name));
        }
        return this.getRuntime().newArray(names);
    }

    public RubyBoolean kind_of(IRubyObject type) {
        if (!type.isKindOf(this.getRuntime().getClass("Module"))) {
            throw this.getRuntime().newTypeError(type, this.getRuntime().getClass("Module"));
        }
        return this.getRuntime().newBoolean(this.isKindOf((RubyModule)type));
    }

    public IRubyObject methods(IRubyObject[] args) {
        this.checkArgumentCount(args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().instance_methods(args);
    }

    public IRubyObject public_methods(IRubyObject[] args) {
        return this.getMetaClass().public_instance_methods(args);
    }

    public IRubyObject protected_methods() {
        return this.getMetaClass().protected_instance_methods(new IRubyObject[]{this.getRuntime().getTrue()});
    }

    public IRubyObject private_methods() {
        return this.getMetaClass().private_instance_methods(new IRubyObject[]{this.getRuntime().getTrue()});
    }

    public RubyArray singleton_methods(IRubyObject[] args) {
        boolean all = true;
        if (this.checkArgumentCount(args, 0, 1) == 1) {
            all = args[0].isTrue();
        }
        RubyArray result = this.getRuntime().newArray();
        for (RubyClass type = this.getMetaClass(); type != null && (type instanceof MetaClass || all && type.isIncluded()); type = type.getSuperClass()) {
            for (Map.Entry entry : type.getMethods().entrySet()) {
                DynamicMethod method = (DynamicMethod)entry.getValue();
                if (method.getImplementationClass() != type && (!all || !type.isIncluded())) continue;
                RubyString methodName = this.getRuntime().newString((String)entry.getKey());
                if (!method.getVisibility().isPublic() || result.includes(methodName)) continue;
                result.append(methodName);
            }
        }
        return result;
    }

    public IRubyObject method(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asSymbol(), true);
    }

    public IRubyObject anyToString() {
        String cname = this.getMetaClass().getRealClass().getName();
        RubyString str = this.getRuntime().newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    public IRubyObject to_s() {
        return this.anyToString();
    }

    public IRubyObject instance_eval(IRubyObject[] args, Block block) {
        return this.specificEval(this.getSingletonClass(), args, block);
    }

    public IRubyObject extend(IRubyObject[] args) {
        int i;
        this.checkArgumentCount(args, 1, -1);
        RubyClass module = this.getRuntime().getClass("Module");
        for (i = 0; i < args.length; ++i) {
            if (args[i].isKindOf(module)) continue;
            throw this.getRuntime().newTypeError(args[i], module);
        }
        for (i = 0; i < args.length; ++i) {
            args[i].callMethod(this.getRuntime().getCurrentContext(), "extend_object", this);
            args[i].callMethod(this.getRuntime().getCurrentContext(), "extended", this);
        }
        return this;
    }

    public IRubyObject inherited(IRubyObject arg, Block block) {
        return this.getRuntime().getNil();
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        return this.getRuntime().getNil();
    }

    public IRubyObject method_missing(IRubyObject[] args, Block block) {
        if (args.length == 0) {
            throw this.getRuntime().newArgumentError("no id given");
        }
        String name = args[0].asSymbol();
        String description = null;
        description = "inspect".equals(name) || "to_s".equals(name) ? this.anyToString().toString() : this.inspect().toString();
        boolean noClass = description.length() > 0 && description.charAt(0) == '#';
        ThreadContext tc = this.getRuntime().getCurrentContext();
        Visibility lastVis = tc.getLastVisibility();
        if (null == lastVis) {
            lastVis = Visibility.PUBLIC;
        }
        CallType lastCallType = tc.getLastCallType();
        String format = lastVis.errorMessageFormat(lastCallType, name);
        String msg = new PrintfFormat(format).sprintf(new Object[]{name, description, noClass ? "" : ":", noClass ? "" : this.getType().getName()}, null);
        if (lastCallType == CallType.VARIABLE) {
            throw this.getRuntime().newNameError(msg, name);
        }
        throw this.getRuntime().newNoMethodError(msg, name);
    }

    public IRubyObject send(IRubyObject[] args, Block block) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("no method name given");
        }
        String name = args[0].asSymbol();
        IRubyObject[] newArgs = new IRubyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return this.callMethod(this.getRuntime().getCurrentContext(), name, newArgs, CallType.FUNCTIONAL, block);
    }

    public IRubyObject nil_p() {
        return this.getRuntime().getFalse();
    }

    public IRubyObject match(IRubyObject arg) {
        return this.getRuntime().getFalse();
    }

    public IRubyObject remove_instance_variable(IRubyObject name, Block block) {
        String id = name.asSymbol();
        if (!IdUtil.isInstanceVariable(id)) {
            throw this.getRuntime().newNameError("wrong instance variable name " + id, id);
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove instance variable");
        }
        this.testFrozen("class/module");
        IRubyObject variable = this.removeInstanceVariable(id);
        if (variable != null) {
            return variable;
        }
        throw this.getRuntime().newNameError("instance variable " + id + " not defined", id);
    }

    public RubyClass getType() {
        return this.type();
    }

    public IRubyObject[] scanArgs(IRubyObject[] args, int required, int optional) {
        int total = required + optional;
        int real = this.checkArgumentCount(args, required, total);
        IRubyObject[] narr = new IRubyObject[total];
        System.arraycopy(args, 0, narr, 0, real);
        for (int i = real; i < total; ++i) {
            narr[i] = this.getRuntime().getNil();
        }
        return narr;
    }

    public synchronized void dataWrapStruct(Object obj) {
        this.dataStruct = obj;
    }

    public synchronized Object dataGetStruct() {
        return this.dataStruct;
    }

    public IRubyObject equal(IRubyObject other) {
        if (this == other || this.callMethod(this.getRuntime().getCurrentContext(), "==", other).isTrue()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    public final IRubyObject equalInternal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        return this.callMethod(context, "==", other);
    }
}

