/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;

public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby runtime) {
        RubyModule module = runtime.defineModule("Marshal");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMarshal.class);
        module.defineSingletonMethod("dump", callbackFactory.getOptSingletonMethod("dump"));
        module.defineSingletonMethod("load", callbackFactory.getOptSingletonMethod("load"));
        module.defineSingletonMethod("restore", callbackFactory.getOptSingletonMethod("load"));
        module.defineConstant("MAJOR_VERSION", runtime.newFixnum(4L));
        module.defineConstant("MINOR_VERSION", runtime.newFixnum(8L));
        return module;
    }

    public static IRubyObject dump(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        if (args.length < 1) {
            throw recv.getRuntime().newArgumentError("wrong # of arguments(at least 1)");
        }
        IRubyObject objectToDump = args[0];
        RubyIO io = null;
        int depthLimit = -1;
        if (args.length >= 2) {
            if (args[1] instanceof RubyIO) {
                io = (RubyIO)args[1];
            } else if (args[1] instanceof RubyFixnum) {
                depthLimit = (int)((RubyFixnum)args[1]).getLongValue();
            }
            if (args.length == 3) {
                depthLimit = (int)((RubyFixnum)args[2]).getLongValue();
            }
        }
        try {
            if (io != null) {
                RubyMarshal.dumpToStream(objectToDump, io.getOutStream(), depthLimit);
                return io;
            }
            ByteArrayOutputStream stringOutput = new ByteArrayOutputStream();
            RubyMarshal.dumpToStream(objectToDump, stringOutput, depthLimit);
            return RubyString.newString(recv.getRuntime(), new ByteList(stringOutput.toByteArray(), false));
        }
        catch (IOException ioe) {
            throw recv.getRuntime().newIOErrorFromException(ioe);
        }
    }

    public static IRubyObject load(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        try {
            InputStream rawInput;
            if (args.length < 1) {
                throw recv.getRuntime().newArgumentError("wrong number of arguments (0 for 1)");
            }
            if (args.length > 2) {
                throw recv.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 2)");
            }
            IRubyObject in = null;
            IRubyObject proc = null;
            switch (args.length) {
                case 2: {
                    proc = args[1];
                }
                case 1: {
                    in = args[0];
                }
            }
            if (in instanceof RubyIO) {
                rawInput = ((RubyIO)in).getInStream();
            } else if (in.respondsTo("to_str")) {
                RubyString inString = (RubyString)in.callMethod(recv.getRuntime().getCurrentContext(), "to_str");
                rawInput = new ByteArrayInputStream(inString.getBytes());
            } else {
                throw recv.getRuntime().newTypeError("instance of IO needed");
            }
            UnmarshalStream input = new UnmarshalStream(recv.getRuntime(), rawInput, proc);
            return input.unmarshalObject();
        }
        catch (EOFException ee) {
            throw recv.getRuntime().newEOFError();
        }
        catch (IOException ioe) {
            throw recv.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static void dumpToStream(IRubyObject object, OutputStream rawOutput, int depthLimit) throws IOException {
        MarshalStream output = new MarshalStream(object.getRuntime(), rawOutput, depthLimit);
        output.dumpObject(object);
    }
}

