/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyHash
extends RubyObject
implements Map {
    private Map valueMap;
    private IRubyObject capturedDefaultProc;
    private static final Callback NIL_DEFAULT_VALUE = new Callback(){

        public IRubyObject execute(IRubyObject recv, IRubyObject[] args, Block block) {
            return recv.getRuntime().getNil();
        }

        public Arity getArity() {
            return Arity.optional();
        }
    };
    private Callback defaultValueCallback;
    private boolean isRehashing = false;

    public RubyHash(Ruby runtime) {
        this(runtime, runtime.getNil());
    }

    public RubyHash(Ruby runtime, IRubyObject defaultValue) {
        super(runtime, runtime.getClass("Hash"));
        this.valueMap = new HashMap();
        this.capturedDefaultProc = runtime.getNil();
        this.setDefaultValue(defaultValue);
    }

    public RubyHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
        super(runtime, runtime.getClass("Hash"));
        this.valueMap = new HashMap(valueMap);
        this.capturedDefaultProc = runtime.getNil();
        this.setDefaultValue(defaultValue);
    }

    public int getNativeTypeIndex() {
        return 10;
    }

    public IRubyObject getDefaultValue(IRubyObject[] args, Block unusedBlock) {
        if (this.defaultValueCallback == null || args.length == 0 && !this.capturedDefaultProc.isNil()) {
            return this.getRuntime().getNil();
        }
        return this.defaultValueCallback.execute(this, args, Block.NULL_BLOCK);
    }

    public IRubyObject setDefaultValue(final IRubyObject defaultValue) {
        this.capturedDefaultProc = this.getRuntime().getNil();
        this.defaultValueCallback = defaultValue == this.getRuntime().getNil() ? NIL_DEFAULT_VALUE : new Callback(){

            public IRubyObject execute(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
                return defaultValue;
            }

            public Arity getArity() {
                return Arity.optional();
            }
        };
        return defaultValue;
    }

    public void setDefaultProc(final RubyProc newProc) {
        final RubyHash self = this;
        this.capturedDefaultProc = newProc;
        this.defaultValueCallback = new Callback(){

            public IRubyObject execute(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
                IRubyObject[] iRubyObjectArray;
                if (args.length == 0) {
                    IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray2;
                    iRubyObjectArray2[0] = self;
                } else {
                    IRubyObject[] iRubyObjectArray3 = new IRubyObject[2];
                    iRubyObjectArray3[0] = self;
                    iRubyObjectArray = iRubyObjectArray3;
                    iRubyObjectArray3[1] = args[0];
                }
                IRubyObject[] nargs = iRubyObjectArray;
                return newProc.call(nargs);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        };
    }

    public IRubyObject default_proc(Block unusedBlock) {
        return this.capturedDefaultProc;
    }

    public Map getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(Map valueMap) {
        this.valueMap = valueMap;
    }

    private Iterator keyIterator() {
        return new ArrayList(this.valueMap.keySet()).iterator();
    }

    private Iterator valueIterator() {
        return new ArrayList(this.valueMap.values()).iterator();
    }

    private Iterator modifiableEntryIterator() {
        return this.valueMap.entrySet().iterator();
    }

    private Iterator entryIterator() {
        return new ArrayList(this.valueMap.entrySet()).iterator();
    }

    public void modify() {
        this.testFrozen("Hash");
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify hash");
        }
    }

    private int length() {
        return this.valueMap.size();
    }

    public static RubyHash newHash(Ruby runtime) {
        return new RubyHash(runtime);
    }

    public static RubyHash newHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
        assert (defaultValue != null);
        return new RubyHash(runtime, valueMap, defaultValue);
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (block.isGiven()) {
            this.setDefaultProc(this.getRuntime().newProc(false, block));
        } else if (args.length > 0) {
            this.modify();
            this.setDefaultValue(args[0]);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject inspect() {
        if (!this.getRuntime().registerInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            String sep = ", ";
            String arrow = "=>";
            StringBuffer sb = new StringBuffer("{");
            boolean firstEntry = true;
            ThreadContext context = this.getRuntime().getCurrentContext();
            for (Map.Entry entry : this.valueMap.entrySet()) {
                IRubyObject key = (IRubyObject)entry.getKey();
                IRubyObject value = (IRubyObject)entry.getValue();
                if (!firstEntry) {
                    sb.append(", ");
                }
                sb.append(key.callMethod(context, "inspect")).append("=>");
                sb.append(value.callMethod(context, "inspect"));
                firstEntry = false;
            }
            sb.append("}");
            RubyString rubyString = this.getRuntime().newString(sb.toString());
            return rubyString;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    public RubyFixnum rb_size() {
        return this.getRuntime().newFixnum(this.length());
    }

    public RubyBoolean empty_p() {
        return this.length() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyArray to_a() {
        Ruby runtime = this.getRuntime();
        RubyArray result = RubyArray.newArray(runtime, this.length());
        for (Map.Entry entry : this.valueMap.entrySet()) {
            result.append(RubyArray.newArray(runtime, (IRubyObject)entry.getKey(), (IRubyObject)entry.getValue()));
        }
        return result;
    }

    public IRubyObject to_s() {
        if (!this.getRuntime().registerInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            IRubyObject iRubyObject = this.to_a().to_s();
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    public RubyHash rehash() {
        this.modify();
        try {
            this.isRehashing = true;
            this.valueMap = new HashMap(this.valueMap);
        }
        finally {
            this.isRehashing = false;
        }
        return this;
    }

    public RubyHash to_hash() {
        return this;
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        this.modify();
        if (!(key instanceof RubyString) || this.valueMap.get(key) != null) {
            this.valueMap.put(key, value);
        } else {
            IRubyObject realKey = key.dup();
            realKey.setFrozen(true);
            this.valueMap.put(realKey, value);
        }
        return value;
    }

    public IRubyObject aref(IRubyObject key) {
        IRubyObject value = (IRubyObject)this.valueMap.get(key);
        return value != null ? value : this.callMethod(this.getRuntime().getCurrentContext(), "default", new IRubyObject[]{key});
    }

    public IRubyObject fetch(IRubyObject[] args, Block block) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError(args.length, 1);
        }
        IRubyObject key = args[0];
        IRubyObject result = (IRubyObject)this.valueMap.get(key);
        if (result == null) {
            if (args.length > 1) {
                return args[1];
            }
            if (block.isGiven()) {
                return this.getRuntime().getCurrentContext().yield(key, block);
            }
            throw this.getRuntime().newIndexError("key not found");
        }
        return result;
    }

    public RubyBoolean has_key(IRubyObject key) {
        return this.getRuntime().newBoolean(this.valueMap.containsKey(key));
    }

    public RubyBoolean has_value(IRubyObject value) {
        return this.getRuntime().newBoolean(this.valueMap.containsValue(value));
    }

    public RubyHash each(Block block) {
        return this.eachInternal(false, block);
    }

    public RubyHash each_pair(Block block) {
        return this.eachInternal(true, block);
    }

    protected RubyHash eachInternal(boolean aValue, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        Iterator iter = this.entryIterator();
        while (iter.hasNext()) {
            this.checkRehashing();
            Map.Entry entry = (Map.Entry)iter.next();
            block.yield(context, this.getRuntime().newArray((IRubyObject)entry.getKey(), (IRubyObject)entry.getValue()), null, null, aValue);
        }
        return this;
    }

    private void checkRehashing() {
        if (this.isRehashing) {
            throw this.getRuntime().newIndexError("rehash occured during iteration");
        }
    }

    public RubyHash each_value(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        Iterator iter = this.valueIterator();
        while (iter.hasNext()) {
            this.checkRehashing();
            IRubyObject value = (IRubyObject)iter.next();
            context.yield(value, block);
        }
        return this;
    }

    public RubyHash each_key(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        Iterator iter = this.keyIterator();
        while (iter.hasNext()) {
            this.checkRehashing();
            IRubyObject key = (IRubyObject)iter.next();
            context.yield(key, block);
        }
        return this;
    }

    public RubyArray sort(Block block) {
        return this.to_a().sort_bang(block);
    }

    public IRubyObject index(IRubyObject value) {
        for (Object key : this.valueMap.keySet()) {
            if (!value.equals(this.valueMap.get(key))) continue;
            return (IRubyObject)key;
        }
        return this.getRuntime().getNil();
    }

    public RubyArray indices(IRubyObject[] indices) {
        RubyArray values = RubyArray.newArray(this.getRuntime(), indices.length);
        for (int i = 0; i < indices.length; ++i) {
            values.append(this.aref(indices[i]));
        }
        return values;
    }

    public RubyArray keys() {
        return RubyArray.newArray(this.getRuntime(), this.valueMap.keySet());
    }

    public RubyArray rb_values() {
        return RubyArray.newArray(this.getRuntime(), this.valueMap.values());
    }

    public IRubyObject equal(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyHash)) {
            return this.getRuntime().getFalse();
        }
        if (this.length() != ((RubyHash)other).length()) {
            return this.getRuntime().getFalse();
        }
        Iterator iter = this.modifiableEntryIterator();
        while (iter.hasNext()) {
            this.checkRehashing();
            Map.Entry entry = (Map.Entry)iter.next();
            Object value = ((RubyHash)other).valueMap.get(entry.getKey());
            if (value != null && entry.getValue().equals(value)) continue;
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public RubyArray shift() {
        this.modify();
        Iterator iter = this.modifiableEntryIterator();
        Map.Entry entry = (Map.Entry)iter.next();
        iter.remove();
        return RubyArray.newArray(this.getRuntime(), (IRubyObject)entry.getKey(), (IRubyObject)entry.getValue());
    }

    public IRubyObject delete(IRubyObject key, Block block) {
        this.modify();
        IRubyObject result = (IRubyObject)this.valueMap.remove(key);
        if (result != null) {
            return result;
        }
        if (block.isGiven()) {
            return this.getRuntime().getCurrentContext().yield(key, block);
        }
        return this.getDefaultValue(new IRubyObject[]{key}, null);
    }

    public RubyHash delete_if(Block block) {
        this.reject_bang(block);
        return this;
    }

    public RubyHash reject(Block block) {
        RubyHash result = (RubyHash)this.dup();
        result.reject_bang(block);
        return result;
    }

    public IRubyObject reject_bang(Block block) {
        this.modify();
        boolean isModified = false;
        ThreadContext context = this.getRuntime().getCurrentContext();
        Iterator iter = this.keyIterator();
        while (iter.hasNext()) {
            IRubyObject key = (IRubyObject)iter.next();
            IRubyObject value = (IRubyObject)this.valueMap.get(key);
            IRubyObject shouldDelete = block.yield(context, this.getRuntime().newArray(key, value), null, null, true);
            if (!shouldDelete.isTrue()) continue;
            this.valueMap.remove(key);
            isModified = true;
        }
        return isModified ? this : this.getRuntime().getNil();
    }

    public RubyHash rb_clear() {
        this.modify();
        this.valueMap.clear();
        return this;
    }

    public RubyHash invert() {
        RubyHash result = RubyHash.newHash(this.getRuntime());
        Iterator iter = this.modifiableEntryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            result.aset((IRubyObject)entry.getValue(), (IRubyObject)entry.getKey());
        }
        return result;
    }

    public RubyHash update(IRubyObject freshElements, Block block) {
        this.modify();
        RubyHash freshElementsHash = (RubyHash)freshElements.convertType(RubyHash.class, "Hash", "to_hash");
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        if (block.isGiven()) {
            Map other = freshElementsHash.valueMap;
            for (IRubyObject key : other.keySet()) {
                IRubyObject oval = (IRubyObject)this.valueMap.get(key);
                if (null == oval) {
                    this.valueMap.put(key, other.get(key));
                    continue;
                }
                this.valueMap.put(key, ctx.yield(this.getRuntime().newArrayNoCopy(new IRubyObject[]{key, oval, (IRubyObject)other.get(key)}), block));
            }
        } else {
            this.valueMap.putAll(freshElementsHash.valueMap);
        }
        return this;
    }

    public RubyHash merge(IRubyObject freshElements, Block block) {
        return ((RubyHash)this.dup()).update(freshElements, block);
    }

    public RubyHash replace(IRubyObject replacement) {
        this.modify();
        RubyHash replacementHash = (RubyHash)replacement.convertType(RubyHash.class, "Hash", "to_hash");
        this.valueMap.clear();
        this.valueMap.putAll(replacementHash.valueMap);
        this.defaultValueCallback = replacementHash.defaultValueCallback;
        return this;
    }

    public RubyArray values_at(IRubyObject[] argv) {
        RubyArray result = RubyArray.newArray(this.getRuntime());
        for (int i = 0; i < argv.length; ++i) {
            result.append(this.aref(argv[i]));
        }
        return result;
    }

    public boolean hasNonProcDefault() {
        return this.defaultValueCallback != NIL_DEFAULT_VALUE;
    }

    public static void marshalTo(RubyHash hash, MarshalStream output) throws IOException {
        output.writeInt(hash.getValueMap().size());
        Iterator iter = hash.entryIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            output.dumpObject((IRubyObject)entry.getKey());
            output.dumpObject((IRubyObject)entry.getValue());
        }
        if (hash.hasNonProcDefault()) {
            output.dumpObject(hash.defaultValueCallback.execute(null, NULL_ARRAY, null));
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream input, boolean defaultValue) throws IOException {
        RubyHash result = RubyHash.newHash(input.getRuntime());
        input.registerLinkTarget(result);
        int size = input.unmarshalInt();
        for (int i = 0; i < size; ++i) {
            IRubyObject key = input.unmarshalObject();
            IRubyObject value = input.unmarshalObject();
            result.aset(key, value);
        }
        if (defaultValue) {
            result.setDefaultValue(input.unmarshalObject());
        }
        return result;
    }

    public Class getJavaClass() {
        return Map.class;
    }

    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    public boolean containsValue(Object value) {
        IRubyObject element = JavaUtil.convertJavaToRuby(this.getRuntime(), value);
        Iterator iter = this.valueMap.values().iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(element)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        return JavaUtil.convertRubyToJava((IRubyObject)this.valueMap.get(JavaUtil.convertJavaToRuby(this.getRuntime(), key)));
    }

    public Object put(Object key, Object value) {
        return this.valueMap.put(JavaUtil.convertJavaToRuby(this.getRuntime(), key), JavaUtil.convertJavaToRuby(this.getRuntime(), value));
    }

    public Object remove(Object key) {
        return this.valueMap.remove(JavaUtil.convertJavaToRuby(this.getRuntime(), key));
    }

    public void putAll(Map map) {
        for (Object key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    public Set entrySet() {
        return new ConversionMapEntrySet(this.getRuntime(), this.valueMap.entrySet());
    }

    public int size() {
        return this.valueMap.size();
    }

    public void clear() {
        this.valueMap.clear();
    }

    public Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return new IteratorAdapter(RubyHash.this.entrySet().iterator()){

                    public Object next() {
                        return ((Map.Entry)super.next()).getValue();
                    }
                };
            }

            public int size() {
                return RubyHash.this.size();
            }

            public boolean contains(Object v) {
                return RubyHash.this.containsValue(v);
            }
        };
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new IteratorAdapter(RubyHash.this.entrySet().iterator()){

                    public Object next() {
                        return ((Map.Entry)super.next()).getKey();
                    }
                };
            }

            public int size() {
                return RubyHash.this.size();
            }
        };
    }

    private static class ConversionMapEntry
    implements Map.Entry {
        private Map.Entry entry;
        private Ruby runtime;

        public ConversionMapEntry(Ruby runtime, Map.Entry entry) {
            this.entry = entry;
            this.runtime = runtime;
        }

        public Object getKey() {
            IRubyObject rubyObject = (IRubyObject)this.entry.getKey();
            return JavaUtil.convertRubyToJava(rubyObject, Object.class);
        }

        public Object getValue() {
            IRubyObject rubyObject = (IRubyObject)this.entry.getValue();
            return JavaUtil.convertRubyToJava(rubyObject, Object.class);
        }

        public Object setValue(Object value) {
            return this.entry.setValue(JavaUtil.convertJavaToRuby(this.runtime, value));
        }
    }

    private static class ConversionMapEntryIterator
    implements Iterator {
        private Iterator iterator;
        private Ruby runtime;

        public ConversionMapEntryIterator(Ruby runtime, Iterator iterator) {
            this.iterator = iterator;
            this.runtime = runtime;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return new ConversionMapEntry(this.runtime, (Map.Entry)this.iterator.next());
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private static class ConversionMapEntrySet
    extends AbstractSet {
        protected Set mapEntrySet;
        protected Ruby runtime;

        public ConversionMapEntrySet(Ruby runtime, Set mapEntrySet) {
            this.mapEntrySet = mapEntrySet;
            this.runtime = runtime;
        }

        public Iterator iterator() {
            return new ConversionMapEntryIterator(this.runtime, this.mapEntrySet.iterator());
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.mapEntrySet.contains(this.getRubifiedMapEntry((Map.Entry)o));
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.mapEntrySet.remove(this.getRubifiedMapEntry((Map.Entry)o));
        }

        public int size() {
            return this.mapEntrySet.size();
        }

        public void clear() {
            this.mapEntrySet.clear();
        }

        private Map.Entry getRubifiedMapEntry(final Map.Entry mapEntry) {
            return new Map.Entry(){

                public Object getKey() {
                    return JavaUtil.convertJavaToRuby(ConversionMapEntrySet.this.runtime, mapEntry.getKey());
                }

                public Object getValue() {
                    return JavaUtil.convertJavaToRuby(ConversionMapEntrySet.this.runtime, mapEntry.getValue());
                }

                public Object setValue(Object arg0) {
                    throw new UnsupportedOperationException("unexpected call in this context");
                }
            };
        }
    }

    private static class IteratorAdapter
    implements Iterator {
        private Iterator iterator;

        public IteratorAdapter(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

