/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Convert;

public class RubyFixnum
extends RubyInteger {
    private long value;
    private static final int BIT_SIZE = 64;
    private static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final byte OP_PLUS_SWITCHVALUE = 1;
    public static final byte OP_MINUS_SWITCHVALUE = 2;
    public static final byte OP_LT_SWITCHVALUE = 3;

    public static RubyClass createFixnumClass(Ruby runtime) {
        RubyClass fixnum = runtime.defineClass("Fixnum", runtime.getClass("Integer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        fixnum.index = 1;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFixnum.class);
        fixnum.includeModule(runtime.getModule("Precision"));
        fixnum.getMetaClass().defineFastMethod("induced_from", callbackFactory.getFastSingletonMethod("induced_from", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("to_s", callbackFactory.getFastOptMethod("to_s"));
        fixnum.defineFastMethod("id2name", callbackFactory.getFastMethod("id2name"));
        fixnum.defineFastMethod("to_sym", callbackFactory.getFastMethod("to_sym"));
        fixnum.defineFastMethod("-@", callbackFactory.getFastMethod("uminus"));
        fixnum.defineFastMethod("+", callbackFactory.getFastMethod("plus", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("-", callbackFactory.getFastMethod("minus", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("*", callbackFactory.getFastMethod("mul", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("/", callbackFactory.getFastMethod("div_slash", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("div", callbackFactory.getFastMethod("div_div", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("%", callbackFactory.getFastMethod("mod", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("modulo", callbackFactory.getFastMethod("mod", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("divmod", callbackFactory.getFastMethod("divmod", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("quo", callbackFactory.getFastMethod("quo", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("**", callbackFactory.getFastMethod("pow", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("abs", callbackFactory.getFastMethod("abs"));
        fixnum.defineFastMethod("==", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("<=>", callbackFactory.getFastMethod("cmp", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod(">", callbackFactory.getFastMethod("gt", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod(">=", callbackFactory.getFastMethod("ge", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("<", callbackFactory.getFastMethod("lt", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("<=", callbackFactory.getFastMethod("le", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("~", callbackFactory.getFastMethod("rev"));
        fixnum.defineFastMethod("&", callbackFactory.getFastMethod("and", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("|", callbackFactory.getFastMethod("or", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("^", callbackFactory.getFastMethod("xor", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("[]", callbackFactory.getFastMethod("aref", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("<<", callbackFactory.getFastMethod("lshift", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod(">>", callbackFactory.getFastMethod("rshift", RubyKernel.IRUBY_OBJECT));
        fixnum.defineFastMethod("to_f", callbackFactory.getFastMethod("to_f"));
        fixnum.defineFastMethod("size", callbackFactory.getFastMethod("size"));
        fixnum.defineFastMethod("zero?", callbackFactory.getFastMethod("zero_p"));
        return fixnum;
    }

    public RubyFixnum(Ruby runtime) {
        this(runtime, 0L);
    }

    public RubyFixnum(Ruby runtime, long value) {
        super(runtime, runtime.getFixnum());
        this.value = value;
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, byte switchvalue, String name, IRubyObject[] args, CallType callType, Block block) {
        switch (switchvalue) {
            case 1: {
                Arity.singleArgument().checkArity(context.getRuntime(), args);
                return this.plus(args[0]);
            }
            case 2: {
                Arity.singleArgument().checkArity(context.getRuntime(), args);
                return this.minus(args[0]);
            }
            case 3: {
                Arity.singleArgument().checkArity(context.getRuntime(), args);
                return this.lt(args[0]);
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public int getNativeTypeIndex() {
        return 1;
    }

    public boolean isImmediate() {
        return true;
    }

    public Class getJavaClass() {
        return Long.TYPE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum newFixnum(Ruby runtime, long value) {
        RubyFixnum fixnum;
        RubyFixnum[] fixnumCache = runtime.getFixnumCache();
        if (value >= 0L && value < (long)fixnumCache.length) {
            fixnum = fixnumCache[(int)value];
            if (fixnum == null) {
                fixnumCache[(int)value] = fixnum = new RubyFixnum(runtime, value);
            }
        } else {
            fixnum = new RubyFixnum(runtime, value);
        }
        return fixnum;
    }

    public RubyFixnum newFixnum(long newValue) {
        return RubyFixnum.newFixnum(this.getRuntime(), newValue);
    }

    public static RubyFixnum zero(Ruby runtime) {
        return RubyFixnum.newFixnum(runtime, 0L);
    }

    public static RubyFixnum one(Ruby runtime) {
        return RubyFixnum.newFixnum(runtime, 1L);
    }

    public static RubyFixnum minus_one(Ruby runtime) {
        return RubyFixnum.newFixnum(runtime, -1L);
    }

    public RubyFixnum hash() {
        return this.newFixnum(this.hashCode());
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >> 32);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum num = (RubyFixnum)other;
            if (num.value == this.value) {
                return true;
            }
        }
        return false;
    }

    public RubyString to_s(IRubyObject[] args) {
        int base;
        this.checkArgumentCount(args, 0, 1);
        int n = base = args.length == 0 ? 10 : RubyFixnum.num2int(args[0]);
        if (base < 2 || base > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return this.getRuntime().newString(Convert.longToByteList(this.value, base));
    }

    public IRubyObject id2name() {
        String symbol = RubySymbol.getSymbol(this.getRuntime(), this.value);
        if (symbol != null) {
            return this.getRuntime().newString(symbol);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject to_sym() {
        String symbol = RubySymbol.getSymbol(this.getRuntime(), this.value);
        if (symbol != null) {
            return RubySymbol.newSymbol(this.getRuntime(), symbol);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject uminus() {
        if (this.value == Long.MIN_VALUE) {
            return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
    }

    public IRubyObject plus(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            long result = this.value + otherValue;
            if (((this.value ^ otherValue ^ 0xFFFFFFFFFFFFFFFFL) & (this.value ^ result) & Long.MIN_VALUE) != 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).plus(other);
            }
            return this.newFixnum(result);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).plus(this);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value + ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("+", other);
    }

    public IRubyObject minus(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            long result = this.value - otherValue;
            if (((this.value ^ (otherValue ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (this.value ^ result) & Long.MIN_VALUE) != 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).minus(other);
            }
            return this.newFixnum(result);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).minus(other);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value - ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("-", other);
    }

    public IRubyObject mul(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            if (this.value == 0L) {
                return RubyFixnum.zero(this.getRuntime());
            }
            long result = this.value * otherValue;
            RubyFixnum r = RubyFixnum.newFixnum(this.getRuntime(), result);
            if (RubyNumeric.fix2long(r) != result || result / this.value != otherValue) {
                return (RubyNumeric)RubyBignum.newBignum(this.getRuntime(), this.value).mul(other);
            }
            return r;
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).mul(this);
        }
        if (other instanceof RubyFloat) {
            return this.getRuntime().newFloat((double)this.value * ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin("*", other);
    }

    public IRubyObject div_div(IRubyObject other) {
        return this.idiv(other, "div");
    }

    public IRubyObject div_slash(IRubyObject other) {
        return this.idiv(other, "/");
    }

    public IRubyObject idiv(IRubyObject other, String method) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            if (y == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long div = x / y;
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div;
            }
            return this.getRuntime().newFixnum(div);
        }
        return this.coerceBin(method, other);
    }

    public IRubyObject mod(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            if (y == 0L) {
                throw this.getRuntime().newZeroDivisionError();
            }
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                mod += y;
            }
            return this.getRuntime().newFixnum(mod);
        }
        return this.coerceBin("%", other);
    }

    public IRubyObject divmod(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long x = this.value;
            long y = ((RubyFixnum)other).value;
            Ruby runtime = this.getRuntime();
            if (y == 0L) {
                throw runtime.newZeroDivisionError();
            }
            long div = x / y;
            long mod = x % y;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div;
                mod += y;
            }
            RubyFixnum fixDiv = RubyFixnum.newFixnum(this.getRuntime(), div);
            RubyFixnum fixMod = RubyFixnum.newFixnum(this.getRuntime(), mod);
            return RubyArray.newArray(runtime, fixDiv, fixMod);
        }
        return this.coerceBin("divmod", other);
    }

    public IRubyObject quo(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyFloat.newFloat(this.getRuntime(), (double)this.value / (double)((RubyFixnum)other).value);
        }
        return this.coerceBin("quo", other);
    }

    public IRubyObject pow(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long b = ((RubyFixnum)other).value;
            if (b == 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            if (b == 1L) {
                return this;
            }
            if (b > 0L) {
                return RubyBignum.newBignum(this.getRuntime(), this.value).pow(other);
            }
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, b));
        }
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyFloat)other).getDoubleValue()));
        }
        return this.coerceBin("**", other);
    }

    public IRubyObject abs() {
        if (this.value < 0L) {
            return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
        }
        return this;
    }

    public IRubyObject equal(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyFixnum)other).value);
        }
        return super.equal(other);
    }

    public IRubyObject cmp(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            if (this.value == otherValue) {
                return RubyFixnum.zero(this.getRuntime());
            }
            if (this.value > otherValue) {
                return RubyFixnum.one(this.getRuntime());
            }
            return RubyFixnum.minus_one(this.getRuntime());
        }
        return this.coerceCmp("<=>", other);
    }

    public IRubyObject gt(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value > ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(">", other);
    }

    public IRubyObject ge(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value >= ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(">=", other);
    }

    public IRubyObject lt(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value < ((RubyFixnum)other).value);
        }
        return this.coerceRelOp("<", other);
    }

    public IRubyObject le(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(this.getRuntime(), this.value <= ((RubyFixnum)other).value);
        }
        return this.coerceRelOp("<=", other);
    }

    public IRubyObject rev() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public IRubyObject and(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).and(this);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value & RubyFixnum.num2long(other));
    }

    public IRubyObject or(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.newFixnum(this.value | ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).or(this);
        }
        if (other instanceof RubyNumeric) {
            return this.newFixnum(this.value | ((RubyNumeric)other).getLongValue());
        }
        return this.or(RubyFixnum.newFixnum(this.getRuntime(), RubyFixnum.num2long(other)));
    }

    public IRubyObject xor(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.newFixnum(this.value ^ ((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).xor(this);
        }
        if (other instanceof RubyNumeric) {
            return this.newFixnum(this.value ^ ((RubyNumeric)other).getLongValue());
        }
        return this.xor(RubyFixnum.newFixnum(this.getRuntime(), RubyFixnum.num2long(other)));
    }

    public IRubyObject aref(IRubyObject other) {
        long otherValue;
        if (other instanceof RubyBignum) {
            RubyBignum big = (RubyBignum)other;
            RubyInteger tryFix = RubyBignum.bignorm(this.getRuntime(), big.getValue());
            if (!(tryFix instanceof RubyFixnum)) {
                if (big.getValue().signum() == 0 || this.value >= 0L) {
                    return RubyFixnum.zero(this.getRuntime());
                }
                return RubyFixnum.one(this.getRuntime());
            }
        }
        if ((otherValue = RubyFixnum.num2long(other)) < 0L) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (63L < otherValue) {
            if (this.value < 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            return RubyFixnum.zero(this.getRuntime());
        }
        return (this.value & 1L << (int)otherValue) == 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
    }

    public IRubyObject lshift(IRubyObject other) {
        long width = RubyFixnum.num2long(other);
        if (width < 0L) {
            return this.rshift(RubyFixnum.newFixnum(this.getRuntime(), -width));
        }
        if (width == 0L) {
            return this;
        }
        if (width > 63L || (-1L << (int)(64L - width - 1L) & this.value) != 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).lshift(other);
        }
        return this.newFixnum(this.value << (int)width);
    }

    public IRubyObject rshift(IRubyObject other) {
        long width = RubyFixnum.num2long(other);
        if (width < 0L) {
            return this.lshift(RubyFixnum.newFixnum(this.getRuntime(), -width));
        }
        if (width == 0L) {
            return this;
        }
        if (width >= 63L) {
            if (this.value < 0L) {
                return RubyFixnum.minus_one(this.getRuntime());
            }
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.newFixnum(this.value >> (int)width);
    }

    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value);
    }

    public IRubyObject size() {
        return this.newFixnum(8L);
    }

    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0L);
    }

    public RubyFixnum id() {
        return this.newFixnum(this.value * 2L + 1L);
    }

    public IRubyObject taint() {
        return this;
    }

    public IRubyObject freeze() {
        return this;
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return input.getRuntime().newFixnum(input.unmarshalInt());
    }

    public static IRubyObject induced_from(IRubyObject recv, IRubyObject other) {
        return RubyNumeric.num2fix(other);
    }
}

