/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamLexerSource
extends LexerSource {
    private static final int INITIAL_PUSHBACK_SIZE = 100;
    private final InputStream in;
    private char[] buf = new char[100];
    private int bufLength = -1;
    private int oneAgo = 10;
    private int twoAgo = 0;

    public InputStreamLexerSource(String sourceName, InputStream in, List<String> list2, int line, boolean extraPositionInformation) {
        super(sourceName, list2, line, extraPositionInformation);
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int c;
        if (this.bufLength >= 0) {
            c = this.buf[this.bufLength--];
        } else {
            c = this.wrappedRead();
            if (c == -1) {
                return -1;
            }
        }
        this.advance(c);
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    @Override
    public void unread(int c) {
        if (c == -1) {
            return;
        }
        this.retreat();
        if (c == 10) {
            --this.line;
        }
        this.buf[++this.bufLength] = (char)c;
        this.growBuf();
    }

    @Override
    public boolean peek(int to) throws IOException {
        int captureTwoAgo = this.twoAgo;
        int c = this.read();
        this.unread(c);
        this.twoAgo = captureTwoAgo;
        return c == to;
    }

    private void advance(int c) {
        this.twoAgo = this.oneAgo;
        this.oneAgo = c;
        ++this.offset;
    }

    private int carriageReturn(int c) throws IOException {
        c = this.in.read();
        if (c != 10) {
            this.unread((char)c);
        } else {
            ++this.offset;
        }
        return c;
    }

    private void growBuf() {
        if (this.bufLength + 1 == this.buf.length) {
            char[] newBuf = new char[this.buf.length + 100];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    private void retreat() {
        --this.offset;
        this.oneAgo = this.twoAgo;
        this.twoAgo = 0;
    }

    private int wrappedRead() throws IOException {
        int c = this.in.read();
        if (c == 13) {
            c = this.carriageReturn(c);
        }
        this.captureFeature(c);
        return c;
    }

    @Override
    public ByteList readLineBytes() throws IOException {
        ByteList bytelist = new ByteList(80);
        int c = this.read();
        while (c != 10 && c != -1) {
            bytelist.append(c);
            c = this.read();
        }
        return bytelist;
    }

    @Override
    public int skipUntil(int marker) throws IOException {
        int c = this.read();
        while (c != marker && c != -1) {
            c = this.read();
        }
        return c;
    }

    @Override
    public void unreadMany(CharSequence buffer) {
        int length2 = buffer.length();
        for (int i2 = length2 - 1; i2 >= 0; --i2) {
            this.unread(buffer.charAt(i2));
        }
    }

    @Override
    public boolean matchMarker(ByteList match2, boolean indent, boolean checkNewline) throws IOException {
        int length2 = match2.length();
        ByteList buffer = new ByteList(length2 + 1);
        if (indent) {
            this.indentLoop(buffer);
        }
        if (!this.matches(match2, buffer, length2)) {
            return false;
        }
        return this.finishMarker(checkNewline, buffer);
    }

    private void indentLoop(ByteList buffer) throws IOException {
        int c;
        while ((c = this.read()) != -1) {
            if (!Character.isWhitespace(c) || c == 10) {
                this.unread(c);
                break;
            }
            buffer.append(c);
        }
    }

    private boolean matches(ByteList match2, ByteList buffer, int length2) throws IOException {
        for (int i2 = 0; i2 < length2; ++i2) {
            int c = this.read();
            buffer.append(c);
            if (match2.charAt(i2) == c) continue;
            this.unreadMany(buffer);
            return false;
        }
        return true;
    }

    private boolean finishMarker(boolean checkNewline, ByteList buffer) throws IOException {
        if (!checkNewline) {
            return true;
        }
        int c = this.read();
        if (c == -1 || c == 10) {
            return true;
        }
        buffer.append(c);
        this.unreadMany(buffer);
        return false;
    }

    @Override
    public boolean wasBeginOfLine() {
        return this.twoAgo == 10;
    }

    @Override
    public boolean lastWasBeginOfLine() {
        return this.oneAgo == 10;
    }

    public String toString() {
        try {
            int i2;
            ByteList buffer = new ByteList(20);
            buffer.append(this.twoAgo);
            buffer.append(this.oneAgo);
            buffer.append(new byte[]{45, 62});
            for (i2 = 0; i2 < 20; ++i2) {
                int c = this.read();
                if (c == 0) {
                    --i2;
                    break;
                }
                buffer.append(c);
            }
            while (i2 >= 0) {
                this.unread(buffer.charAt(i2));
                ++i2;
            }
            buffer.append(new byte[]{32, 46, 46, 46});
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ByteList readUntil(char marker) throws IOException {
        ByteList list2 = new ByteList(20);
        int c = this.read();
        while (c != marker && c != -1) {
            list2.append(c);
            c = this.read();
        }
        if (c == -1) {
            return null;
        }
        this.unread(c);
        return list2;
    }

    @Override
    public InputStream getRemainingAsStream() throws IOException {
        return this.bufferEntireStream(this.in);
    }

    private InputStream bufferEntireStream(InputStream stream) throws IOException {
        byte[] allBytes = new byte[]{};
        byte[] b = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = stream.read(b)) != -1) {
            byte[] newbuf = new byte[allBytes.length + bytesRead];
            System.arraycopy(allBytes, 0, newbuf, 0, allBytes.length);
            System.arraycopy(b, 0, newbuf, allBytes.length, bytesRead);
            allBytes = newbuf;
        }
        return new ByteArrayInputStream(allBytes);
    }
}

