/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.jline.style.StyleColor;
import org.jline.style.StyleSource;
import org.jline.utils.AttributedStyle;

public class StyleResolver {
    private static final Logger log = Logger.getLogger(StyleResolver.class.getName());
    private final StyleSource source;
    private final String group;

    public StyleResolver(StyleSource source, String group) {
        this.source = Objects.requireNonNull(source);
        this.group = Objects.requireNonNull(group);
    }

    @Nullable
    private static Integer color(String name) {
        int flags = 0;
        if ((name = name.toLowerCase(Locale.US)).charAt(0) == '!') {
            name = name.substring(1, name.length());
            flags = 8;
        } else if (name.startsWith("bright-")) {
            name = name.substring(7, name.length());
            flags = 8;
        } else if (name.charAt(0) == '~') {
            try {
                name = name.substring(1, name.length());
                StyleColor color = StyleColor.valueOf(name);
                return color.code;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warning("Invalid style-color name: " + name);
                return null;
            }
        }
        switch (name) {
            case "k": 
            case "black": {
                return flags + 0;
            }
            case "r": 
            case "red": {
                return flags + 1;
            }
            case "g": 
            case "green": {
                return flags + 2;
            }
            case "yellow": 
            case "y": {
                return flags + 3;
            }
            case "b": 
            case "blue": {
                return flags + 4;
            }
            case "m": 
            case "magenta": {
                return flags + 5;
            }
            case "c": 
            case "cyan": {
                return flags + 6;
            }
            case "w": 
            case "white": {
                return flags + 7;
            }
        }
        return null;
    }

    public StyleSource getSource() {
        return this.source;
    }

    public String getGroup() {
        return this.group;
    }

    public AttributedStyle resolve(String spec) {
        int i;
        Objects.requireNonNull(spec);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Resolve: " + spec);
        }
        if ((i = spec.indexOf(":-")) != -1) {
            String[] parts = spec.split(":-");
            return this.resolve(parts[0].trim(), parts[1].trim());
        }
        return this.apply(AttributedStyle.DEFAULT, spec);
    }

    public AttributedStyle resolve(String spec, @Nullable String defaultSpec) {
        AttributedStyle style;
        Objects.requireNonNull(spec);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Resolve: %s; default: %s", spec, defaultSpec));
        }
        if ((style = this.apply(AttributedStyle.DEFAULT, spec)) == AttributedStyle.DEFAULT && defaultSpec != null) {
            style = this.apply(style, defaultSpec);
        }
        return style;
    }

    private AttributedStyle apply(AttributedStyle style, String spec) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply: " + spec);
        }
        String[] stringArray = spec.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (!(item = item.trim()).isEmpty()) {
                style = item.startsWith(".") ? this.applyReference(style, item) : (item.contains(":") ? this.applyColor(style, item) : this.applyNamed(style, item));
            }
            ++n2;
        }
        return style;
    }

    private AttributedStyle applyReference(AttributedStyle style, String spec) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-reference: " + spec);
        }
        if (spec.length() == 1) {
            log.warning("Invalid style-reference; missing discriminator: " + spec);
        } else {
            String name = spec.substring(1, spec.length());
            String resolvedSpec = this.source.get(this.group, name);
            if (resolvedSpec != null) {
                return this.apply(style, resolvedSpec);
            }
        }
        return style;
    }

    private AttributedStyle applyNamed(AttributedStyle style, String name) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Apply-named: " + name);
        }
        switch (name.toLowerCase(Locale.US)) {
            case "default": {
                return AttributedStyle.DEFAULT;
            }
            case "bold": {
                return style.bold();
            }
            case "faint": {
                return style.faint();
            }
            case "italic": {
                return style.italic();
            }
            case "underline": {
                return style.underline();
            }
            case "blink": {
                return style.blink();
            }
            case "inverse": {
                return style.inverse();
            }
            case "inverse-neg": 
            case "inverseneg": {
                return style.inverseNeg();
            }
            case "conceal": {
                return style.conceal();
            }
            case "crossed-out": 
            case "crossedout": {
                return style.crossedOut();
            }
            case "hidden": {
                return style.hidden();
            }
        }
        log.warning("Unknown style: " + name);
        return style;
    }

    private AttributedStyle applyColor(AttributedStyle style, String spec) {
        block20: {
            Integer color;
            String colorMode;
            block19: {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Apply-color: " + spec);
                }
                String[] parts = spec.split(":", 2);
                colorMode = parts[0].trim();
                String colorName = parts[1].trim();
                color = StyleResolver.color(colorName);
                if (color != null) break block19;
                log.warning("Invalid color-name: " + colorName);
                break block20;
            }
            switch (colorMode.toLowerCase(Locale.US)) {
                case "f": 
                case "fg": 
                case "foreground": {
                    return style.foreground(color.intValue());
                }
                case "background": 
                case "b": 
                case "bg": {
                    return style.background(color.intValue());
                }
            }
            log.warning("Invalid color-mode: " + colorMode);
        }
        return style;
    }
}

