/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.jline.builtins.Nano;
import org.jline.builtins.Styles;
import org.jline.console.CmdDesc;
import org.jline.console.CmdLine;
import org.jline.console.ScriptEngine;
import org.jline.groovy.Utils;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.script.PackageHelper;
import org.jline.utils.AttributedString;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;
import org.jline.utils.StyleResolver;

public class GroovyEngine
implements ScriptEngine {
    public static final String CANONICAL_NAMES = "canonicalNames";
    public static final String NANORC_SYNTAX = "nanorcSyntax";
    public static final String NANORC_VALUE = "nanorcValue";
    public static final String GROOVY_COLORS = "GROOVY_COLORS";
    private static final String VAR_GROOVY_OPTIONS = "GROOVY_OPTIONS";
    private static final String REGEX_SYSTEM_VAR = "[A-Z]+[A-Z_]*";
    private static final String REGEX_VAR = "[a-zA-Z_]+[a-zA-Z0-9_]*";
    private static final Pattern PATTERN_FUNCTION_DEF = Pattern.compile("^def\\s+([a-zA-Z_]+[a-zA-Z0-9_]*)\\s*\\(([a-zA-Z0-9_ ,]*)\\)\\s*\\{(.*)?\\}(|\n)$", 32);
    private static final Pattern PATTERN_CLASS_DEF = Pattern.compile("^class\\s+([a-zA-Z_]+[a-zA-Z0-9_]*)\\ .*?\\{.*?\\}(|\n)$", 32);
    private GroovyShell shell;
    protected Binding sharedData;
    private Map<String, String> imports = new HashMap<String, String>();
    private Map<String, String> methods = new HashMap<String, String>();
    private Map<String, Class<?>> nameClass = new HashMap();
    private Cloner objectCloner = new ObjectCloner();

    public GroovyEngine() {
        this.sharedData = new Binding();
        this.shell = new GroovyShell(this.sharedData);
    }

    public Completer getScriptCompleter() {
        return this.compileCompleter();
    }

    public boolean hasVariable(String name) {
        return this.sharedData.hasVariable(name);
    }

    public void put(String name, Object value) {
        this.sharedData.setProperty(name, value);
    }

    public Object get(String name) {
        return this.sharedData.hasVariable(name) ? this.sharedData.getVariable(name) : null;
    }

    public Map<String, Object> find(String name) {
        HashMap<String, Object> out = new HashMap();
        if (name == null) {
            out = this.sharedData.getVariables();
        } else {
            for (String v : this.internalFind(name)) {
                out.put(v, this.get(v));
            }
        }
        return out;
    }

    public List<String> getSerializationFormats() {
        return Arrays.asList(Format.JSON.toString(), Format.NONE.toString());
    }

    public List<String> getDeserializationFormats() {
        return Arrays.asList(Format.JSON.toString(), Format.GROOVY.toString(), Format.NONE.toString());
    }

    public Object deserialize(String value, String formatStr) {
        Object out;
        block16: {
            Format format;
            out = value;
            Format format2 = format = formatStr != null && !formatStr.isEmpty() ? Format.valueOf(formatStr.toUpperCase()) : null;
            if (format != Format.NONE) {
                if (format == Format.JSON) {
                    out = Utils.toObject(value);
                } else {
                    if (format == Format.GROOVY) {
                        try {
                            out = this.execute(value);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                    }
                    boolean hasCurly = (value = value.trim()).contains("{") && value.contains("}");
                    try {
                        if (value.startsWith("[") && value.endsWith("]")) {
                            try {
                                if (hasCurly) {
                                    out = Utils.toObject(value);
                                    break block16;
                                }
                                out = this.execute(value);
                            }
                            catch (Exception e) {
                                if (hasCurly) {
                                    try {
                                        out = this.execute(value);
                                    }
                                    catch (Exception exception) {}
                                    break block16;
                                }
                                out = Utils.toObject(value);
                            }
                            break block16;
                        }
                        if (value.startsWith("{") && value.endsWith("}")) {
                            out = Utils.toObject(value);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return out;
    }

    public void persist(Path file, Object object) {
        this.persist(file, object, this.getSerializationFormats().get(0));
    }

    public void persist(Path file, Object object, String format) {
        Utils.persist(file, object, Format.valueOf(format.toUpperCase()));
    }

    public Object execute(File script, Object[] args) throws Exception {
        this.sharedData.setProperty("_args", (Object)args);
        Script s = this.shell.parse(script);
        return s.run();
    }

    void addToNameClass(String classname) {
        block6: {
            try {
                if (classname.endsWith(".*")) {
                    List<Class<?>> classes = PackageHelper.getClassesForPackage(classname);
                    for (Class<?> c : classes) {
                        this.nameClass.put(c.getSimpleName(), c);
                    }
                    break block6;
                }
                int idx = classname.lastIndexOf(".");
                String name = classname.substring(idx + 1);
                try {
                    this.nameClass.put(name, Class.forName(classname));
                }
                catch (ClassNotFoundException ex) {
                    String innerclass = classname.substring(0, idx) + "$" + name;
                    this.nameClass.put(name, Class.forName(innerclass));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object execute(String statement) throws Exception {
        Object out = null;
        if (statement.startsWith("import ")) {
            this.shell.evaluate(statement);
            String[] p = statement.split("\\s+", 2);
            String classname = p[1].replaceAll(";", "");
            this.imports.put(classname, statement);
            this.addToNameClass(classname);
        } else if (statement.equals("import")) {
            out = new ArrayList<String>(this.imports.keySet());
        } else if (!this.functionDef(statement)) {
            if (statement.equals("def")) {
                out = this.methods;
            } else if (statement.matches("def\\s+[a-zA-Z_]+[a-zA-Z0-9_]*")) {
                String name = statement.split("\\s+")[1];
                if (this.methods.containsKey(name)) {
                    out = "def " + name + this.methods.get(name);
                }
            } else {
                String e = "";
                for (Map.Entry<String, String> entry : this.imports.entrySet()) {
                    e = e + entry.getValue() + "\n";
                }
                e = e + statement;
                if (this.classDef(statement)) {
                    e = e + "; null";
                }
                out = this.shell.evaluate(e);
            }
        }
        return out;
    }

    public Object execute(Object closure, Object ... args) {
        if (!(closure instanceof Closure)) {
            throw new IllegalArgumentException();
        }
        return ((Closure)closure).call(args);
    }

    public String getEngineName() {
        return this.getClass().getSimpleName();
    }

    public List<String> getExtensions() {
        return Arrays.asList("groovy");
    }

    private List<String> internalFind(String var) {
        ArrayList<String> out = new ArrayList<String>();
        if (!var.contains(".") && var.contains("*")) {
            var = var.replaceAll("\\*", ".*");
        }
        for (String v : this.sharedData.getVariables().keySet()) {
            if (!v.matches(var)) continue;
            out.add(v);
        }
        return out;
    }

    private boolean functionDef(String statement) throws Exception {
        boolean out = false;
        Matcher m = PATTERN_FUNCTION_DEF.matcher(statement);
        if (m.matches()) {
            out = true;
            this.put(m.group(1), this.execute("{" + m.group(2) + "->" + m.group(3) + "}"));
            this.methods.put(m.group(1), "(" + m.group(2) + "){" + m.group(3) + "}");
        }
        return out;
    }

    private boolean classDef(String statement) throws Exception {
        return PATTERN_CLASS_DEF.matcher(statement).matches();
    }

    private void refreshNameClass() {
        this.nameClass.clear();
        for (String name : this.imports.keySet()) {
            this.addToNameClass(name);
        }
    }

    private void del(String var) {
        if (var == null) {
            return;
        }
        if (this.imports.containsKey(var)) {
            this.imports.remove(var);
            if (var.endsWith(".*")) {
                this.refreshNameClass();
            } else {
                this.nameClass.remove(var.substring(var.lastIndexOf(46) + 1));
            }
        } else if (this.sharedData.hasVariable(var)) {
            this.sharedData.getVariables().remove(var);
            if (this.methods.containsKey(var)) {
                this.methods.remove(var);
            }
        } else if (!var.contains(".") && var.contains("*")) {
            for (String v : this.internalFind(var)) {
                if (!this.sharedData.hasVariable(v) || v.equals("_") || v.matches(REGEX_SYSTEM_VAR)) continue;
                this.sharedData.getVariables().remove(v);
                if (!this.methods.containsKey(v)) continue;
                this.methods.remove(v);
            }
        }
    }

    public void del(String ... vars) {
        if (vars == null) {
            return;
        }
        for (String s : vars) {
            this.del(s);
        }
    }

    public String toJson(Object obj) {
        return Utils.toJson(obj);
    }

    public String toString(Object obj) {
        return Utils.toString(obj);
    }

    public Map<String, Object> toMap(Object obj) {
        return Utils.toMap(obj);
    }

    public void setObjectCloner(Cloner objectCloner) {
        this.objectCloner = objectCloner;
    }

    public Cloner getObjectCloner() {
        return this.objectCloner;
    }

    public CmdDesc scriptDescription(CmdLine line) {
        return new Inspector(this).scriptDescription(line);
    }

    private Map<String, Object> groovyOptions() {
        return this.hasVariable(VAR_GROOVY_OPTIONS) ? (Map)this.get(VAR_GROOVY_OPTIONS) : new HashMap();
    }

    protected <T> T groovyOption(String option, T defval) {
        Object out = defval;
        try {
            out = this.groovyOptions().getOrDefault(option, defval);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private Completer compileCompleter() {
        ArrayList<Object> completers = new ArrayList<Object>();
        completers.add(new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"class", "print", "println"}), NullCompleter.INSTANCE}));
        Completer[] completerArray = new Completer[3];
        completerArray[0] = new StringsCompleter(new String[]{"def"});
        completerArray[1] = new StringsCompleter(this.methods::keySet);
        completerArray[2] = NullCompleter.INSTANCE;
        completers.add(new ArgumentCompleter(completerArray));
        completers.add(new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"import"}), new PackageCompleter(CandidateType.PACKAGE), NullCompleter.INSTANCE}));
        completers.add(new MethodCompleter(this));
        return new AggregateCompleter(completers);
    }

    private static class Brackets {
        static final List<Character> DELIMS = Arrays.asList(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('='), Character.valueOf('/'));
        static char[] quote = new char[]{'\"', '\''};
        Deque<Integer> roundOpen = new ArrayDeque<Integer>();
        Deque<Integer> curlyOpen = new ArrayDeque<Integer>();
        Map<Integer, Integer> lastComma = new HashMap<Integer, Integer>();
        int lastRoundClose = -1;
        int lastCurlyClose = -1;
        int lastSemicolon = -1;
        int lastBlanck = -1;
        int lastDelim = -1;
        int quoteId = -1;
        int round = 0;
        int curly = 0;
        int rounds = 0;
        int curlies = 0;

        public Brackets(String line) {
            int pos = -1;
            char prevChar = ' ';
            for (char ch : line.toCharArray()) {
                ++pos;
                if (this.quoteId < 0) {
                    for (int i = 0; i < quote.length; ++i) {
                        if (ch != quote[i]) continue;
                        this.quoteId = i;
                        break;
                    }
                } else {
                    if (ch != quote[this.quoteId]) continue;
                    this.quoteId = -1;
                    continue;
                }
                if (this.quoteId >= 0) continue;
                if (ch == '(') {
                    ++this.round;
                    this.roundOpen.add(pos);
                } else if (ch == ')') {
                    ++this.rounds;
                    --this.round;
                    this.lastComma.remove(this.roundOpen.getLast());
                    this.roundOpen.removeLast();
                    this.lastRoundClose = pos;
                } else if (ch == '{') {
                    ++this.curly;
                    this.curlyOpen.add(pos);
                } else if (ch == '}') {
                    ++this.curlies;
                    --this.curly;
                    this.curlyOpen.removeLast();
                    this.lastCurlyClose = pos;
                } else if (ch == ',' && !this.roundOpen.isEmpty()) {
                    this.lastComma.put(this.roundOpen.getLast(), pos);
                } else if (ch == ';' || ch == '\n' || ch == '>' && prevChar == '-') {
                    this.lastSemicolon = pos;
                } else if (ch == ' ' && this.round == 0 && String.valueOf(prevChar).matches("\\w")) {
                    this.lastBlanck = pos;
                } else if (DELIMS.contains(Character.valueOf(ch))) {
                    this.lastDelim = pos;
                }
                prevChar = ch;
                if (this.round >= 0 && this.curly >= 0) continue;
                throw new IllegalArgumentException();
            }
        }

        public static int indexOfOpeningRound(String line) {
            int out = -1;
            if (!line.endsWith(")")) {
                return out;
            }
            int quoteId = -1;
            int round = 0;
            int curly = 0;
            char[] chars = line.toCharArray();
            for (int i = line.length() - 1; i >= 0; --i) {
                char ch = chars[i];
                if (quoteId < 0) {
                    for (int j = 0; j < quote.length; ++j) {
                        if (ch != quote[j]) continue;
                        quoteId = j;
                        break;
                    }
                } else {
                    if (ch != quote[quoteId]) continue;
                    quoteId = -1;
                    continue;
                }
                if (quoteId >= 0) continue;
                if (ch == '(') {
                    ++round;
                } else if (ch == ')') {
                    --round;
                } else if (ch == '{') {
                    ++curly;
                } else if (ch == '}') {
                    --curly;
                }
                if (curly != 0 || round != 0) continue;
                out = i;
                break;
            }
            return out;
        }

        public boolean openRound() {
            return this.round > 0;
        }

        public boolean openCurly() {
            return this.curly > 0;
        }

        public int numberOfRounds() {
            return this.rounds;
        }

        public int lastOpenRound() {
            return !this.roundOpen.isEmpty() ? this.roundOpen.getLast() : -1;
        }

        public int lastCloseRound() {
            return this.lastRoundClose;
        }

        public int lastOpenCurly() {
            return !this.curlyOpen.isEmpty() ? this.curlyOpen.getLast() : -1;
        }

        public int lastCloseCurly() {
            return this.lastCurlyClose;
        }

        public int lastComma() {
            int last = this.lastOpenRound();
            return this.lastComma.containsKey(last) ? this.lastComma.get(last) : -1;
        }

        public int lastSemicolon() {
            return this.lastSemicolon;
        }

        public int lastDelim() {
            return this.lastDelim;
        }

        public boolean openQuote() {
            return this.quoteId != -1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("rounds: ").append(this.rounds).append("\n");
            sb.append("curlies: ").append(this.curlies).append("\n");
            sb.append("lastOpenRound: ").append(this.lastOpenRound()).append("\n");
            sb.append("lastCloseRound: ").append(this.lastRoundClose).append("\n");
            sb.append("lastComma: ").append(this.lastComma()).append("\n");
            return sb.toString();
        }
    }

    private static class ObjectCloner
    implements Cloner {
        Map<String, Object> cache = new HashMap<String, Object>();
        Set<String> marked = new HashSet<String>();

        @Override
        public Object clone(Object obj) {
            if (obj == null || obj instanceof String || obj instanceof Integer || obj instanceof Exception || obj instanceof Closure) {
                return obj;
            }
            Object out = null;
            String key = this.cacheKey(obj);
            try {
                if (this.cache.containsKey(key)) {
                    this.marked.remove(key);
                    out = this.cache.get(key);
                } else {
                    Class<?> clazz = obj.getClass();
                    Method clone = clazz.getDeclaredMethod("clone", new Class[0]);
                    out = clone.invoke(obj, new Object[0]);
                    this.cache.put(key, out);
                }
            }
            catch (Exception e) {
                out = obj;
                this.cache.put(key, out);
            }
            return out;
        }

        @Override
        public void markCache() {
            this.marked = new HashSet<String>(this.cache.keySet());
        }

        @Override
        public void purgeCache() {
            for (String k : this.marked) {
                this.cache.remove(k);
            }
        }

        private String cacheKey(Object obj) {
            return obj.getClass().getCanonicalName() + ":" + obj.hashCode();
        }
    }

    private static class Inspector {
        static final Pattern PATTERN_FOR = Pattern.compile("^for\\s*\\((.*?);.*");
        static final Pattern PATTERN_FOR_EACH = Pattern.compile("^for\\s*\\((.*?):(.*?)\\).*");
        static final Pattern LAMBDA_PATTERN = Pattern.compile(".*\\([\\(]*(.*?)[\\)]*->.*");
        static final Pattern PATTERN_FUNCTION_BODY = Pattern.compile("^\\s*\\(([a-zA-Z0-9_ ,]*)\\)\\s*\\{(.*)?\\}(|\n)$", 32);
        static final String DEFAULT_NANORC_SYNTAX = "classpath:/org/jline/groovy/java.nanorc";
        static final String DEFAULT_GROOVY_COLORS = "ti=1;34:me=31";
        private GroovyShell shell;
        protected Binding sharedData = new Binding();
        private Map<String, String> imports = new HashMap<String, String>();
        private Map<String, Class<?>> nameClass = new HashMap();
        private PrintStream nullstream;
        private boolean canonicalNames = false;
        private String[] equationLines;
        private int cuttedSize;
        private String nanorcSyntax;
        private String groovyColors;

        public Inspector(GroovyEngine groovyEngine) {
            this.imports = groovyEngine.imports;
            this.nameClass = groovyEngine.nameClass;
            this.canonicalNames = groovyEngine.groovyOption(GroovyEngine.CANONICAL_NAMES, this.canonicalNames);
            this.nanorcSyntax = groovyEngine.groovyOption(GroovyEngine.NANORC_SYNTAX, DEFAULT_NANORC_SYNTAX);
            String gc = groovyEngine.groovyOption(GroovyEngine.GROOVY_COLORS, null);
            this.groovyColors = gc != null && Styles.isAnsiStylePattern((String)gc) ? gc : DEFAULT_GROOVY_COLORS;
            groovyEngine.getObjectCloner().markCache();
            for (Map.Entry entry : groovyEngine.find().entrySet()) {
                Object obj = groovyEngine.getObjectCloner().clone(entry.getValue());
                this.sharedData.setVariable((String)entry.getKey(), obj);
            }
            groovyEngine.getObjectCloner().purgeCache();
            this.shell = new GroovyShell(this.sharedData);
            try {
                FileOutputStream fileOutputStream;
                File file = OSUtils.IS_WINDOWS ? new File("NUL") : new File("/dev/null");
                FileOutputStream outputStream = fileOutputStream = new FileOutputStream(file);
                this.nullstream = new PrintStream(outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Map.Entry entry : groovyEngine.methods.entrySet()) {
                Matcher m = PATTERN_FUNCTION_BODY.matcher((CharSequence)entry.getValue());
                if (!m.matches()) continue;
                this.sharedData.setVariable((String)entry.getKey(), this.execute("{" + m.group(1) + "->" + m.group(2) + "}"));
            }
        }

        public Class<?> evaluateClass(String objectStatement) {
            Class<Object> out = null;
            try {
                out = this.execute(objectStatement).getClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (out == null || out == Class.class) {
                    out = !objectStatement.contains(".") ? (Class<Object>)this.execute(objectStatement + ".class") : Class.forName(objectStatement);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        private Object execute(String statement) {
            PrintStream origOut = System.out;
            PrintStream origErr = System.err;
            if (this.nullstream != null) {
                System.setOut(this.nullstream);
                System.setErr(this.nullstream);
            }
            Object out = null;
            try {
                String e = "";
                for (Map.Entry<String, String> entry : this.imports.entrySet()) {
                    e = e + entry.getValue() + "\n";
                }
                e = e + statement;
                out = this.shell.evaluate(e);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                System.setOut(origOut);
                System.setErr(origErr);
            }
            return out;
        }

        public void loadStatementVars(String line) {
            for (String s : line.split("\\r?\\n")) {
                String statement = s.trim();
                try {
                    Matcher forEachMatcher = PATTERN_FOR_EACH.matcher(statement);
                    Matcher forMatcher = PATTERN_FOR.matcher(statement);
                    Matcher lambdaMatcher = LAMBDA_PATTERN.matcher(statement);
                    if (statement.matches("^(if|while)\\s*\\(.*") || statement.matches("(\\}\\s*|^)else(\\s*\\{|$)") || statement.matches("(\\}\\s*|^)else\\s+if\\s*\\(.*") || statement.matches("^break[;]{1,}") || statement.matches("^case\\s+.*:") || statement.matches("^default\\s+:") || statement.matches("(\\{|\\})") || statement.length() == 0) continue;
                    if (forEachMatcher.matches()) {
                        statement = forEachMatcher.group(1).trim();
                        if (statement.matches("\\w+\\s+\\w+.*")) {
                            int idx = statement.indexOf(32);
                            statement = statement.substring(idx + 1);
                        }
                        statement = statement + "=" + forEachMatcher.group(2) + "[0]";
                    } else if (forMatcher.matches()) {
                        statement = forMatcher.group(1).trim();
                        if (statement.matches("\\w+\\s+\\w+.*")) {
                            int idx = statement.indexOf(32);
                            statement = statement.substring(idx + 1);
                        }
                        if (!statement.contains("=")) {
                            statement = statement + " = null";
                        }
                    } else if (lambdaMatcher.matches()) {
                        String[] vars = lambdaMatcher.group(1).split(",");
                        statement = "";
                        for (String v : vars) {
                            statement = statement + v + " = null; ";
                        }
                    } else if (statement.matches("\\w+\\s+.*=.*")) {
                        int idx = statement.indexOf(32);
                        statement = statement.substring(idx + 1);
                    }
                    Brackets br = new Brackets(statement);
                    if (!statement.contains("=") || br.openRound() || br.openCurly()) continue;
                    this.execute(statement);
                }
                catch (Exception e) {
                    if (!Log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
            }
        }

        public Map<String, Class<?>> nameClass() {
            return this.nameClass;
        }

        public Set<String> variables() {
            return this.sharedData.getVariables().keySet();
        }

        public boolean hasVariable(String name) {
            return this.sharedData.hasVariable(name);
        }

        public Object getVariable(String name) {
            return this.sharedData.hasVariable(name) ? this.sharedData.getVariable(name) : null;
        }

        public CmdDesc scriptDescription(CmdLine line) {
            CmdDesc out;
            block7: {
                out = null;
                try {
                    switch (line.getDescriptionType()) {
                        case COMMAND: {
                            break;
                        }
                        case METHOD: {
                            out = this.methodDescription(line);
                            break;
                        }
                        case SYNTAX: {
                            out = this.checkSyntax(line);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!Log.isDebugEnabled()) break block7;
                    e.printStackTrace();
                }
            }
            return out;
        }

        private String trimName(String name) {
            String out = name;
            int idx = name.lastIndexOf(40);
            if (idx > 0) {
                out = name.substring(0, idx);
            }
            return out;
        }

        private CmdDesc methodDescription(CmdLine line) throws Exception {
            CmdDesc out = new CmdDesc();
            List args = line.getArgs();
            boolean constructor = false;
            Class<?> clazz = null;
            String methodName = null;
            if (args.size() == 2 && ((String)args.get(0)).matches("(new|\\w+=new)") || args.size() > 2 && Helpers.constructorStatement((String)args.get(args.size() - 2))) {
                constructor = true;
                clazz = this.evaluateClass(this.trimName((String)args.get(args.size() - 1)));
            } else {
                String buffer = line.getHead();
                String wordbuffer = this.trimName((String)args.get(args.size() - 1));
                Constructor<?>[] brackets = new Brackets(buffer);
                int varsep = wordbuffer.lastIndexOf(46);
                int eqsep = Helpers.statementBegin(buffer, wordbuffer, (Brackets)brackets);
                if (varsep > 0 && varsep > eqsep) {
                    this.loadStatementVars(buffer);
                    methodName = wordbuffer.substring(varsep + 1);
                    clazz = this.evaluateClass(wordbuffer.substring(eqsep + 1, varsep));
                }
            }
            ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
            if (clazz != null) {
                Nano.SyntaxHighlighter java = Nano.SyntaxHighlighter.build((String)this.nanorcSyntax);
                mainDesc.add(java.highlight(clazz.toString()));
                if (constructor) {
                    for (Constructor<?> m : clazz.getConstructors()) {
                        StringBuilder sb = new StringBuilder();
                        String name = m.getName();
                        if (!this.canonicalNames) {
                            int idx = name.lastIndexOf(46);
                            name = name.substring(idx + 1);
                        }
                        sb.append(name);
                        sb.append("(");
                        boolean first = true;
                        for (Class<?> p : m.getParameterTypes()) {
                            if (!first) {
                                sb.append(", ");
                            }
                            sb.append(this.canonicalNames ? p.getTypeName() : p.getSimpleName());
                            first = false;
                        }
                        sb.append(")");
                        first = true;
                        for (Class<?> e : m.getExceptionTypes()) {
                            if (first) {
                                sb.append(" throws ");
                            } else {
                                sb.append(", ");
                            }
                            sb.append(this.canonicalNames ? e.getCanonicalName() : e.getSimpleName());
                            first = false;
                        }
                        mainDesc.add(java.highlight(this.trimMethodDescription(sb)));
                    }
                } else {
                    ArrayList<String> addedMethods = new ArrayList<String>();
                    do {
                        for (Method m : clazz.getMethods()) {
                            if (!m.getName().equals(methodName)) continue;
                            StringBuilder sb = new StringBuilder();
                            if (Modifier.isFinal(m.getModifiers())) {
                                sb.append("final ");
                            }
                            if (Modifier.isStatic(m.getModifiers())) {
                                sb.append("static ");
                            }
                            sb.append(this.canonicalNames ? m.getReturnType().getCanonicalName() : m.getReturnType().getSimpleName());
                            sb.append(" ");
                            sb.append(methodName);
                            sb.append("(");
                            boolean first = true;
                            for (Class<?> p : m.getParameterTypes()) {
                                if (!first) {
                                    sb.append(", ");
                                }
                                sb.append(this.canonicalNames ? p.getTypeName() : p.getSimpleName());
                                first = false;
                            }
                            sb.append(")");
                            first = true;
                            for (Class<?> e : m.getExceptionTypes()) {
                                if (first) {
                                    sb.append(" throws ");
                                } else {
                                    sb.append(", ");
                                }
                                sb.append(this.canonicalNames ? e.getCanonicalName() : e.getSimpleName());
                                first = false;
                            }
                            if (addedMethods.contains(sb.toString())) continue;
                            addedMethods.add(sb.toString());
                            mainDesc.add(java.highlight(this.trimMethodDescription(sb)));
                        }
                    } while ((clazz = clazz.getSuperclass()) != null);
                }
                out.setMainDesc(mainDesc);
            }
            return out;
        }

        private String trimMethodDescription(StringBuilder sb) {
            String out = sb.toString();
            if (this.canonicalNames) {
                out = out.replaceAll("java.lang.", "");
            }
            return out;
        }

        private CmdDesc checkSyntax(CmdLine line) {
            CmdDesc out = new CmdDesc();
            int openingRound = Brackets.indexOfOpeningRound(line.getHead());
            if (openingRound == -1) {
                return out;
            }
            this.loadStatementVars(line.getHead());
            Brackets brackets = new Brackets(line.getHead().substring(0, openingRound));
            int eqsep = Helpers.statementBegin(brackets);
            int end = line.getHead().length();
            if (eqsep > 0 && Helpers.constructorStatement(line.getHead().substring(0, eqsep))) {
                eqsep = line.getHead().substring(0, eqsep).lastIndexOf("new") - 1;
            } else if (line.getHead().substring(eqsep + 1).matches("\\s*for\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*while\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*else\\s+if\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*if\\s*\\(.*")) {
                eqsep = openingRound;
                --end;
            } else if (line.getHead().substring(eqsep + 1).matches("\\s*switch\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*catch\\s*\\(.*")) {
                return out;
            }
            ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
            String objEquation = line.getHead().substring(eqsep + 1, end);
            this.equationLines = objEquation.split("\\r?\\n");
            this.cuttedSize = eqsep + 1;
            if (objEquation != null && !objEquation.matches("\\(\\s*\\w+\\s*[,\\s*\\w+\\s*]*\\)")) {
                try {
                    this.execute(objEquation);
                }
                catch (MissingPropertyException e) {
                    mainDesc.addAll(this.doExceptionMessage((Exception)((Object)e)));
                    out.setErrorPattern(Pattern.compile("\\b" + e.getProperty() + "\\b"));
                }
                catch (PatternSyntaxException e) {
                    mainDesc.addAll(this.doExceptionMessage(e));
                    int idx = line.getHead().lastIndexOf(e.getPattern());
                    if (idx >= 0) {
                        out.setErrorIndex(idx + e.getIndex());
                    }
                }
                catch (MultipleCompilationErrorsException e) {
                    SyntaxErrorMessage sem;
                    if (e.getErrorCollector().getErrors() != null) {
                        for (Object o : e.getErrorCollector().getErrors()) {
                            if (!(o instanceof SyntaxErrorMessage)) continue;
                            sem = (SyntaxErrorMessage)o;
                            out.setErrorIndex(this.errorIndex(e.getMessage(), sem.getCause()));
                        }
                    }
                    if (e.getErrorCollector().getWarnings() != null) {
                        for (Object o : e.getErrorCollector().getWarnings()) {
                            if (!(o instanceof SyntaxErrorMessage)) continue;
                            sem = (SyntaxErrorMessage)o;
                            out.setErrorIndex(this.errorIndex(e.getMessage(), sem.getCause()));
                        }
                    }
                    mainDesc.addAll(this.doExceptionMessage((Exception)((Object)e)));
                }
                catch (NullPointerException e) {
                }
                catch (Exception e) {
                    mainDesc.addAll(this.doExceptionMessage(e));
                }
            }
            out.setMainDesc(mainDesc);
            return out;
        }

        private List<AttributedString> doExceptionMessage(Exception exception) {
            ArrayList<AttributedString> out = new ArrayList<AttributedString>();
            Nano.SyntaxHighlighter java = Nano.SyntaxHighlighter.build((String)this.nanorcSyntax);
            StyleResolver resolver = Inspector.style(this.groovyColors);
            Pattern header = Pattern.compile("^[a-zA-Z() ]{3,}:(\\s+|$)");
            out.add(java.highlight(exception.getClass().getCanonicalName()));
            if (exception.getMessage() != null) {
                for (String s : exception.getMessage().split("\\r?\\n")) {
                    if (s.trim().length() == 0) continue;
                    if (s.length() > 80) {
                        boolean doHeader = true;
                        int start = 0;
                        for (int i = 80; i < s.length(); ++i) {
                            if ((s.charAt(i) != ' ' || i - start <= 80) && i - start <= 100) continue;
                            AttributedString as = new AttributedString((CharSequence)s.substring(start, i), resolver.resolve(".me"));
                            if (doHeader) {
                                as = as.styleMatches(header, resolver.resolve(".ti"));
                                doHeader = false;
                            }
                            out.add(as);
                            start = i;
                            if (s.length() - start >= 80) continue;
                            out.add(new AttributedString((CharSequence)s.substring(start), resolver.resolve(".me")));
                            break;
                        }
                        if (!doHeader) continue;
                        AttributedString as = new AttributedString((CharSequence)s, resolver.resolve(".me"));
                        as = as.styleMatches(header, resolver.resolve(".ti"));
                        out.add(as);
                        continue;
                    }
                    AttributedString as = new AttributedString((CharSequence)s, resolver.resolve(".me"));
                    as = as.styleMatches(header, resolver.resolve(".ti"));
                    out.add(as);
                }
            }
            return out;
        }

        private int errorIndex(String message, SyntaxException se) {
            int out = -1;
            String line = null;
            String[] mlines = message.split("\n");
            for (int i = 0; i < mlines.length; ++i) {
                if (!mlines[i].matches(".*Script[0-9]+.groovy: .*")) continue;
                line = mlines[i + 1].trim();
                break;
            }
            int tot = 0;
            if (line != null) {
                for (String l : this.equationLines) {
                    if (l.contains(line)) break;
                    tot += l.length() + 1;
                }
            }
            out = this.cuttedSize + tot + se.getStartColumn() - 1;
            return out;
        }

        private static StyleResolver style(String style) {
            Map<String, String> colors = Arrays.stream(style.split(":")).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
            return new StyleResolver(colors::get);
        }
    }

    private static class MethodCompleter
    implements Completer {
        private static List<String> KEY_WORDS = Arrays.asList("print", "println");
        private GroovyEngine groovyEngine;
        Inspector inspector;

        public MethodCompleter(GroovyEngine engine) {
            this.groovyEngine = engine;
        }

        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            assert (commandLine != null);
            assert (candidates != null);
            String wordbuffer = commandLine.word();
            String buffer = commandLine.line().substring(0, commandLine.cursor());
            Brackets brackets = null;
            try {
                brackets = new Brackets(buffer);
            }
            catch (Exception e) {
                return;
            }
            if (brackets.openQuote() || commandLine.wordIndex() > 0 && !((String)commandLine.words().get(0)).matches("(new|\\w+=new)") && brackets.numberOfRounds() == 0 && !brackets.openRound() && !brackets.openCurly()) {
                return;
            }
            this.inspector = new Inspector(this.groovyEngine);
            this.inspector.loadStatementVars(buffer);
            int eqsep = Helpers.statementBegin(brackets);
            if (brackets.numberOfRounds() > 0 && brackets.lastCloseRound() > eqsep) {
                int varsep = buffer.lastIndexOf(46);
                if (varsep > 0 && varsep > brackets.lastCloseRound()) {
                    Class<?> clazz = this.inspector.evaluateClass(buffer.substring(eqsep + 1, varsep));
                    int vs = wordbuffer.lastIndexOf(46);
                    String curBuf = wordbuffer.substring(0, vs + 1);
                    String hint = wordbuffer.substring(vs + 1);
                    this.doMethodCandidates(candidates, clazz, curBuf, hint);
                }
            } else if (!wordbuffer.contains("(") && (commandLine.wordIndex() == 1 && ((String)commandLine.words().get(0)).matches("(new|\\w+=new)") || commandLine.wordIndex() > 1 && Helpers.constructorStatement((String)commandLine.words().get(commandLine.wordIndex() - 1)))) {
                if (wordbuffer.matches("[a-z]+.*")) {
                    int idx = wordbuffer.lastIndexOf(46);
                    if (idx > 0 && wordbuffer.substring(idx + 1).matches("[A-Z]+.*")) {
                        try {
                            Class.forName(wordbuffer);
                            Helpers.doCandidates(candidates, Arrays.asList("("), wordbuffer, "(", CandidateType.OTHER);
                        }
                        catch (Exception e) {
                            String param = wordbuffer.substring(0, idx + 1);
                            Helpers.doCandidates(candidates, Helpers.nextDomain(param, CandidateType.CONSTRUCTOR), param, wordbuffer.substring(idx + 1), CandidateType.CONSTRUCTOR);
                        }
                    } else {
                        new PackageCompleter(CandidateType.CONSTRUCTOR).complete(reader, commandLine, candidates);
                    }
                } else {
                    Helpers.doCandidates(candidates, this.retrieveConstructors(), "", wordbuffer, CandidateType.CONSTRUCTOR);
                }
            } else {
                boolean addKeyWords = eqsep == brackets.lastSemicolon() || eqsep == brackets.lastOpenCurly();
                int varsep = wordbuffer.lastIndexOf(46);
                eqsep = Helpers.statementBegin(buffer, wordbuffer, brackets);
                String param = wordbuffer.substring(eqsep + 1);
                if (varsep < 0 || varsep < eqsep) {
                    String curBuf = wordbuffer.substring(0, eqsep + 1);
                    if (param.trim().length() == 0) {
                        Helpers.doCandidates(candidates, Arrays.asList(""), curBuf, param, CandidateType.OTHER);
                    } else {
                        if (addKeyWords) {
                            Helpers.doCandidates(candidates, KEY_WORDS, curBuf, param, CandidateType.METHOD);
                        }
                        Helpers.doCandidates(candidates, this.inspector.variables(), curBuf, param, CandidateType.OTHER);
                        Helpers.doCandidates(candidates, this.retrieveClassesWithStaticMethods(), curBuf, param, CandidateType.STATIC_METHOD);
                    }
                } else {
                    boolean firstMethod = param.indexOf(46) == param.lastIndexOf(46);
                    String var = param.substring(0, param.indexOf(46));
                    String curBuf = wordbuffer.substring(0, varsep + 1);
                    String p = wordbuffer.substring(varsep + 1);
                    if (this.inspector.nameClass().containsKey(var)) {
                        if (firstMethod) {
                            this.doStaticMethodCandidates(candidates, this.inspector.nameClass().get(var), curBuf, p);
                        } else {
                            Class<?> clazz = this.inspector.evaluateClass(wordbuffer.substring(eqsep + 1, varsep));
                            this.doMethodCandidates(candidates, clazz, curBuf, p);
                        }
                    } else if (this.inspector.hasVariable(var)) {
                        if (firstMethod) {
                            this.doMethodCandidates(candidates, this.inspector.getVariable(var).getClass(), curBuf, p);
                        } else {
                            Class<?> clazz = this.inspector.evaluateClass(wordbuffer.substring(eqsep + 1, varsep));
                            this.doMethodCandidates(candidates, clazz, curBuf, p);
                        }
                    } else {
                        try {
                            param = wordbuffer.substring(eqsep + 1, varsep);
                            this.doStaticMethodCandidates(candidates, Class.forName(param), curBuf, p);
                        }
                        catch (Exception e) {
                            param = wordbuffer.substring(eqsep + 1, varsep + 1);
                            Helpers.doCandidates(candidates, Helpers.nextDomain(param, CandidateType.STATIC_METHOD), curBuf, p, CandidateType.STATIC_METHOD);
                        }
                    }
                }
            }
        }

        private void doMethodCandidates(List<Candidate> candidates, Class<?> clazz, String curBuf, String hint) {
            if (clazz == null) {
                return;
            }
            Helpers.doCandidates(candidates, Helpers.getMethods(clazz), curBuf, hint, CandidateType.METHOD);
            Helpers.doCandidates(candidates, Helpers.getFields(clazz), curBuf, hint, CandidateType.OTHER);
        }

        private void doStaticMethodCandidates(List<Candidate> candidates, Class<?> clazz, String curBuf, String hint) {
            if (clazz == null) {
                return;
            }
            Helpers.doCandidates(candidates, Helpers.getStaticMethods(clazz), curBuf, hint, CandidateType.METHOD);
            Helpers.doCandidates(candidates, Helpers.getStaticFields(clazz), curBuf, hint, CandidateType.OTHER);
        }

        private Set<String> retrieveConstructors() {
            HashSet<String> out = new HashSet<String>();
            for (Map.Entry<String, Class<?>> entry : this.inspector.nameClass().entrySet()) {
                Class<?> c = entry.getValue();
                if (c.getConstructors().length == 0 || Modifier.isAbstract(c.getModifiers())) continue;
                out.add(entry.getKey());
            }
            return out;
        }

        private Set<String> retrieveClassesWithStaticMethods() {
            HashSet<String> out = new HashSet<String>();
            for (Map.Entry<String, Class<?>> entry : this.inspector.nameClass().entrySet()) {
                Class<?> c = entry.getValue();
                if (Helpers.getStaticMethods(c).size() == 0 && Helpers.getStaticFields(c).size() == 0) continue;
                out.add(entry.getKey());
            }
            return out;
        }
    }

    private static class PackageCompleter
    implements Completer {
        private CandidateType type;

        public PackageCompleter(CandidateType type) {
            this.type = type;
        }

        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            String buffer;
            assert (commandLine != null);
            assert (candidates != null);
            String param = buffer = commandLine.word().substring(0, commandLine.wordCursor());
            String curBuf = "";
            int lastDelim = buffer.lastIndexOf(46);
            if (lastDelim > -1) {
                param = buffer.substring(lastDelim + 1);
                curBuf = buffer.substring(0, lastDelim + 1);
            }
            Helpers.doCandidates(candidates, Helpers.nextDomain(curBuf, this.type), curBuf, param, this.type);
        }
    }

    private static class Helpers {
        private Helpers() {
        }

        private static Set<String> loadedPackages() {
            HashSet<String> out = new HashSet<String>();
            for (Package p : Package.getPackages()) {
                out.add(p.getName());
            }
            return out;
        }

        private static Set<String> names(String domain) {
            HashSet<String> out = new HashSet<String>();
            for (String p : Helpers.loadedPackages()) {
                if (!p.startsWith(domain)) continue;
                int idx = p.indexOf(46, domain.length());
                if (idx < 0) {
                    idx = p.length();
                }
                out.add(p.substring(domain.length(), idx));
            }
            return out;
        }

        public static Set<String> getMethods(Class<?> clazz) {
            return Helpers.getMethods(clazz, false);
        }

        public static Set<String> getStaticMethods(Class<?> clazz) {
            return Helpers.getMethods(clazz, true);
        }

        private static Set<String> getMethods(Class<?> clazz, boolean statc) {
            HashSet<String> out = new HashSet<String>();
            try {
                for (Method method : clazz.getMethods()) {
                    if ((!statc || !Modifier.isStatic(method.getModifiers())) && (statc || Modifier.isStatic(method.getModifiers()))) continue;
                    out.add(method.getName());
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return out;
        }

        public static Set<String> getFields(Class<?> clazz) {
            return Helpers.getFields(clazz, false);
        }

        public static Set<String> getStaticFields(Class<?> clazz) {
            return Helpers.getFields(clazz, true);
        }

        private static Set<String> getFields(Class<?> clazz, boolean statc) {
            HashSet<String> out = new HashSet<String>();
            for (Field field : clazz.getFields()) {
                if ((!statc || !Modifier.isStatic(field.getModifiers())) && (statc || Modifier.isStatic(field.getModifiers()))) continue;
                out.add(field.getName());
            }
            return out;
        }

        public static Set<String> nextDomain(String domain, CandidateType type) {
            Set<String> out = new HashSet<String>();
            if (domain.isEmpty()) {
                for (String p : Helpers.loadedPackages()) {
                    out.add(p.split("\\.")[0]);
                }
            } else if (domain.split("\\.").length < 2) {
                out = Helpers.names(domain);
            } else {
                try {
                    List<Class<?>> classes = PackageHelper.getClassesForPackage(domain);
                    for (Class<?> c : classes) {
                        if (!Modifier.isPublic(c.getModifiers()) || c.getName().contains("$") || type == CandidateType.CONSTRUCTOR && (c.getConstructors().length == 0 || Modifier.isAbstract(c.getModifiers())) || type == CandidateType.STATIC_METHOD && Helpers.getStaticMethods(c).size() == 0 && Helpers.getStaticFields(c).size() == 0) continue;
                        try {
                            String name = c.getCanonicalName();
                            int idx = name.indexOf(46, domain.length());
                            if (idx < 0) {
                                idx = name.length();
                            }
                            out.add(name.substring(domain.length(), idx));
                        }
                        catch (NoClassDefFoundError e) {
                            if (!Log.isDebugEnabled()) continue;
                            e.printStackTrace();
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (Log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    out = Helpers.names(domain);
                }
            }
            return out;
        }

        public static void doCandidates(List<Candidate> candidates, Collection<String> fields, String curBuf, String hint, CandidateType type) {
            if (fields == null) {
                return;
            }
            for (String s : fields) {
                if (s == null || !s.startsWith(hint)) continue;
                String postFix = "";
                if (type == CandidateType.CONSTRUCTOR) {
                    if (s.matches("[a-z]+.*")) {
                        postFix = ".";
                    } else if (s.matches("[A-Z]+.*")) {
                        postFix = "(";
                    }
                } else if (type == CandidateType.STATIC_METHOD) {
                    postFix = ".";
                } else if (type == CandidateType.PACKAGE) {
                    if (s.matches("[a-z]+.*")) {
                        postFix = ".";
                    }
                } else if (type == CandidateType.METHOD) {
                    postFix = "(";
                }
                candidates.add(new Candidate(AttributedString.stripAnsi((String)(curBuf + s + postFix)), s, null, null, null, null, false));
            }
        }

        public static int statementBegin(String buffer, String wordbuffer, Brackets brackets) {
            int out = -1;
            int idx = buffer.lastIndexOf(wordbuffer);
            if (idx > -1) {
                out = Helpers.statementBegin(brackets.lastDelim() - idx, brackets.lastOpenRound() - idx, brackets.lastComma() - idx, brackets.lastOpenCurly() - idx, brackets.lastCloseCurly() - idx, brackets.lastSemicolon() - idx);
            }
            return out;
        }

        public static int statementBegin(Brackets brackets) {
            return Helpers.statementBegin(brackets.lastDelim(), brackets.lastOpenRound(), brackets.lastComma(), brackets.lastOpenCurly(), brackets.lastCloseCurly(), brackets.lastSemicolon());
        }

        private static int statementBegin(int lastDelim, int openRound, int comma, int openCurly, int closeCurly, int semicolon) {
            int out = lastDelim;
            if (openRound > out) {
                out = openRound;
            }
            if (comma > out) {
                out = comma;
            }
            if (openCurly > out) {
                out = openCurly;
            }
            if (closeCurly > out) {
                out = closeCurly;
            }
            if (semicolon > out) {
                out = semicolon;
            }
            return Math.max(out, -1);
        }

        public static boolean constructorStatement(String fragment) {
            return fragment.matches("(.*\\s+new|.*\\(new|.*\\{new|.*=new|.*,new|new)");
        }
    }

    private static enum CandidateType {
        CONSTRUCTOR,
        STATIC_METHOD,
        PACKAGE,
        METHOD,
        OTHER;

    }

    public static interface Cloner {
        public Object clone(Object var1);

        public void markCache();

        public void purgeCache();
    }

    public static enum Format {
        JSON,
        GROOVY,
        NONE;

    }
}

