/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.groovy.Utils;
import org.jline.reader.ScriptEngine;

public class GroovyEngine
implements ScriptEngine {
    private static final String REGEX_SYSTEM_VAR = "[A-Z]+[A-Z_]*";
    private static final String REGEX_VAR = "[a-zA-Z_]+[a-zA-Z0-9_]*";
    private static final Pattern PATTERN_FUNCTION_DEF = Pattern.compile("^def\\s+([a-zA-Z_]+[a-zA-Z0-9_]*)\\s*\\(([a-zA-Z0-9_ ,]*)\\)\\s*\\{(.*)?\\}(|\n)$", 32);
    private static final Pattern PATTERN_CLASS_DEF = Pattern.compile("^class\\s+([a-zA-Z_]+[a-zA-Z0-9_]*)\\ .*?\\{.*?\\}(|\n)$", 32);
    private GroovyShell shell;
    private Binding sharedData;
    private Map<String, String> imports = new HashMap<String, String>();
    private Map<String, String> methods = new HashMap<String, String>();

    public GroovyEngine() {
        this.sharedData = new Binding();
        this.shell = new GroovyShell(this.sharedData);
    }

    public boolean hasVariable(String name) {
        return this.sharedData.hasVariable(name);
    }

    public void put(String name, Object value) {
        this.sharedData.setProperty(name, value);
    }

    public Object get(String name) {
        return this.sharedData.hasVariable(name) ? this.sharedData.getVariable(name) : null;
    }

    public Map<String, Object> find(String name) {
        HashMap<String, Object> out = new HashMap();
        if (name == null) {
            out = this.sharedData.getVariables();
        } else {
            for (String v : this.internalFind(name)) {
                out.put(v, this.get(v));
            }
        }
        return out;
    }

    public List<String> getSerializationFormats() {
        return Arrays.asList(Format.JSON.toString(), Format.NONE.toString());
    }

    public List<String> getDeserializationFormats() {
        return Arrays.asList(Format.JSON.toString(), Format.GROOVY.toString(), Format.NONE.toString());
    }

    public Object deserialize(String value, String formatStr) {
        Object out;
        block16: {
            Format format;
            out = value;
            Format format2 = format = formatStr != null && !formatStr.isEmpty() ? Format.valueOf(formatStr.toUpperCase()) : null;
            if (format != Format.NONE) {
                if (format == Format.JSON) {
                    out = Utils.toObject(value);
                } else {
                    if (format == Format.GROOVY) {
                        try {
                            out = this.execute(value);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                    }
                    boolean hasCurly = (value = value.trim()).contains("{") && value.contains("}");
                    try {
                        if (value.startsWith("[") && value.endsWith("]")) {
                            try {
                                if (hasCurly) {
                                    out = Utils.toObject(value);
                                    break block16;
                                }
                                out = this.execute(value);
                            }
                            catch (Exception e) {
                                if (hasCurly) {
                                    try {
                                        out = this.execute(value);
                                    }
                                    catch (Exception exception) {}
                                    break block16;
                                }
                                out = Utils.toObject(value);
                            }
                            break block16;
                        }
                        if (value.startsWith("{") && value.endsWith("}")) {
                            out = Utils.toObject(value);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return out;
    }

    public void persist(Path file, Object object) {
        this.persist(file, object, this.getSerializationFormats().get(0));
    }

    public void persist(Path file, Object object, String format) {
        Utils.persist(file, object, Format.valueOf(format.toUpperCase()));
    }

    public Object execute(File script, Object[] args) throws Exception {
        this.sharedData.setProperty("_args", (Object)args);
        Script s = this.shell.parse(script);
        return s.run();
    }

    public Object execute(String statement) throws Exception {
        Object out = null;
        if (statement.startsWith("import ")) {
            this.shell.evaluate(statement);
            String[] p = statement.split("\\s+", 2);
            this.imports.put(p[1].replaceAll(";", ""), statement);
        } else if (statement.equals("import")) {
            out = new ArrayList<String>(this.imports.keySet());
        } else if (!this.functionDef(statement)) {
            if (statement.equals("def")) {
                out = this.methods;
            } else if (statement.matches("def\\s+[a-zA-Z_]+[a-zA-Z0-9_]*")) {
                String name = statement.split("\\s+")[1];
                if (this.methods.containsKey(name)) {
                    out = "def " + name + this.methods.get(name);
                }
            } else {
                String e = "";
                for (Map.Entry<String, String> entry : this.imports.entrySet()) {
                    e = e + entry.getValue() + "\n";
                }
                e = e + statement;
                if (this.classDef(statement)) {
                    e = e + "; null";
                }
                out = this.shell.evaluate(e);
            }
        }
        return out;
    }

    public Object execute(Object closure, Object ... args) {
        if (!(closure instanceof Closure)) {
            throw new IllegalArgumentException();
        }
        return ((Closure)closure).call(args);
    }

    public String getEngineName() {
        return this.getClass().getSimpleName();
    }

    public List<String> getExtensions() {
        return Arrays.asList("groovy");
    }

    private List<String> internalFind(String var) {
        ArrayList<String> out = new ArrayList<String>();
        if (!var.contains(".") && var.contains("*")) {
            var = var.replaceAll("\\*", ".*");
        }
        for (String v : this.sharedData.getVariables().keySet()) {
            if (!v.matches(var)) continue;
            out.add(v);
        }
        return out;
    }

    private boolean functionDef(String statement) throws Exception {
        boolean out = false;
        Matcher m = PATTERN_FUNCTION_DEF.matcher(statement);
        if (m.matches()) {
            out = true;
            this.put(m.group(1), this.execute("{" + m.group(2) + "->" + m.group(3) + "}"));
            this.methods.put(m.group(1), "(" + m.group(2) + "){" + m.group(3) + "}");
        }
        return out;
    }

    private boolean classDef(String statement) throws Exception {
        return PATTERN_CLASS_DEF.matcher(statement).matches();
    }

    private void del(String var) {
        if (var == null) {
            return;
        }
        if (this.imports.containsKey(var)) {
            this.imports.remove(var);
        } else if (this.sharedData.hasVariable(var)) {
            this.sharedData.getVariables().remove(var);
            if (this.methods.containsKey(var)) {
                this.methods.remove(var);
            }
        } else if (!var.contains(".") && var.contains("*")) {
            for (String v : this.internalFind(var)) {
                if (!this.sharedData.hasVariable(v) || v.equals("_") || v.matches(REGEX_SYSTEM_VAR)) continue;
                this.sharedData.getVariables().remove(v);
                if (!this.methods.containsKey(v)) continue;
                this.methods.remove(v);
            }
        }
    }

    public void del(String ... vars) {
        if (vars == null) {
            return;
        }
        for (String s : vars) {
            this.del(s);
        }
    }

    public String toJson(Object obj) {
        return Utils.toJson(obj);
    }

    public String toString(Object obj) {
        return Utils.toString(obj);
    }

    public Map<String, Object> toMap(Object obj) {
        return Utils.toMap(obj);
    }

    public static enum Format {
        JSON,
        GROOVY,
        NONE;

    }
}

