/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jline.builtins.Builtins;
import org.jline.builtins.Completers;
import org.jline.builtins.ConsoleEngine;
import org.jline.builtins.ConsoleEngineImpl;
import org.jline.builtins.JlineCommandRegistry;
import org.jline.builtins.Options;
import org.jline.builtins.SystemRegistryImpl;
import org.jline.builtins.Widgets;
import org.jline.console.CommandInput;
import org.jline.console.CommandMethods;
import org.jline.console.CommandRegistry;
import org.jline.console.ConfigurationPath;
import org.jline.console.Printer;
import org.jline.console.ScriptEngine;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.script.GroovyCommand;
import org.jline.script.GroovyEngine;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;
import org.jline.utils.OSUtils;

public class Repl {
    private static Path workDir() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public static void main(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            parser.setEofOnUnclosedBracket(new DefaultParser.Bracket[]{DefaultParser.Bracket.CURLY, DefaultParser.Bracket.ROUND, DefaultParser.Bracket.SQUARE});
            parser.setEofOnUnclosedQuote(true);
            parser.setEscapeChars(null);
            parser.setRegexCommand("[:]{0,1}[a-zA-Z!]{1,}\\S*");
            Terminal terminal = TerminalBuilder.builder().build();
            Thread executeThread = Thread.currentThread();
            terminal.handle(Terminal.Signal.INT, signal -> executeThread.interrupt());
            File file = new File(Repl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            String root = file.getCanonicalPath().replace("classes", "").replaceAll("\\\\", "/");
            GroovyEngine scriptEngine = new GroovyEngine();
            scriptEngine.put("ROOT", (Object)root);
            ConfigurationPath configPath = new ConfigurationPath(Paths.get(root, new String[0]), Paths.get(root, new String[0]));
            ConsoleEngineImpl consoleEngine = new ConsoleEngineImpl((ScriptEngine)scriptEngine, Repl::workDir, configPath);
            Builtins builtins = new Builtins(Repl::workDir, configPath, fun -> new ConsoleEngine.WidgetCreator((ConsoleEngine)consoleEngine, fun));
            MyCommands myCommands = new MyCommands(Repl::workDir);
            SystemRegistryImpl systemRegistry = new SystemRegistryImpl((Parser)parser, terminal, Repl::workDir, configPath);
            systemRegistry.register("groovy", (CommandRegistry)new GroovyCommand(scriptEngine, (Printer)consoleEngine));
            systemRegistry.setCommandRegistries(new CommandRegistry[]{consoleEngine, builtins, myCommands});
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).variable("secondary-prompt-pattern", (Object)"%M%P > ").variable("indentation", (Object)2).variable("list-max", (Object)100).variable("history-file", (Object)Paths.get(root, "history")).option(LineReader.Option.INSERT_BRACKET, true).option(LineReader.Option.EMPTY_WORD_OPTIONS, false).option(LineReader.Option.USE_FORWARD_SLASH, true).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).build();
            if (OSUtils.IS_WINDOWS) {
                reader.setVariable("blink-matching-paren", (Object)0);
            }
            consoleEngine.setLineReader(reader);
            builtins.setLineReader(reader);
            myCommands.setLineReader(reader);
            new Widgets.TailTipWidgets(reader, arg_0 -> ((SystemRegistryImpl)systemRegistry).commandDescription(arg_0), 5, Widgets.TailTipWidgets.TipType.COMPLETER);
            KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
            keyMap.bind((Object)new Reference("tailtip-toggle"), (CharSequence)KeyMap.alt((String)"s"));
            systemRegistry.initialize(Paths.get(root, "init.jline").toFile());
            consoleEngine.println((Object)(terminal.getName() + ": " + terminal.getType()));
            while (true) {
                try {
                    while (true) {
                        systemRegistry.cleanUp();
                        String line = reader.readLine("groovy-repl> ");
                        line = parser.getCommand(line).startsWith("!") ? line.replaceFirst("!", "! ") : line;
                        Object result = systemRegistry.execute(line);
                        consoleEngine.println(result);
                    }
                }
                catch (UserInterruptException line) {
                    continue;
                }
                catch (EndOfFileException e) {
                }
                catch (Exception e) {
                    systemRegistry.trace(e);
                    continue;
                }
                break;
            }
            systemRegistry.close();
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            boolean groovyRunning = false;
            for (Thread t : threadSet) {
                if (!t.getName().startsWith("AWT-Shut")) continue;
                groovyRunning = true;
                break;
            }
            if (groovyRunning) {
                consoleEngine.println((Object)"Please, close Groovy Consoles/Object Browsers!");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }

    protected static class MyCommands
    extends JlineCommandRegistry
    implements CommandRegistry {
        private LineReader reader;
        private Supplier<Path> workDir;

        public MyCommands(Supplier<Path> workDir) {
            this.workDir = workDir;
            HashMap<String, CommandMethods> commandExecute = new HashMap<String, CommandMethods>();
            commandExecute.put("tput", new CommandMethods(this::tput, this::tputCompleter));
            commandExecute.put("testkey", new CommandMethods(this::testkey, arg_0 -> ((MyCommands)this).defaultCompleter(arg_0)));
            commandExecute.put("clear", new CommandMethods(this::clear, arg_0 -> ((MyCommands)this).defaultCompleter(arg_0)));
            commandExecute.put("!", new CommandMethods(this::shell, arg_0 -> ((MyCommands)this).defaultCompleter(arg_0)));
            commandExecute.put("objarg", new CommandMethods(this::objarg, arg_0 -> ((MyCommands)this).defaultCompleter(arg_0)));
            this.registerCommands(commandExecute);
        }

        public void setLineReader(LineReader reader) {
            this.reader = reader;
        }

        private Terminal terminal() {
            return this.reader.getTerminal();
        }

        private Object objarg(CommandInput input) {
            String[] usage = new String[]{"objarg -  manage correctly object parameters", "         parse input.xargs, return opt.argObjects[0]", "Usage: objarg [OBJECT]", "  -? --help                       Displays command help"};
            Object out = null;
            try {
                Options opt = this.parseOptions(usage, input.xargs());
                List xargs = opt.argObjects();
                out = xargs.size() > 0 ? xargs.get(0) : null;
            }
            catch (Exception e) {
                this.saveException(e);
            }
            return out;
        }

        private void tput(CommandInput input) {
            String[] usage = new String[]{"tput -  put terminal capability", "Usage: tput [CAPABILITY]", "  -? --help                       Displays command help"};
            try {
                Options opt = this.parseOptions(usage, input.args());
                List argv = opt.args();
                if (argv.size() == 1) {
                    InfoCmp.Capability vcap = InfoCmp.Capability.byName((String)((String)argv.get(0)));
                    if (vcap != null) {
                        this.terminal().puts(vcap, new Object[0]);
                    } else {
                        this.terminal().writer().println("Unknown capability");
                    }
                } else {
                    this.terminal().writer().println("Usage: tput [CAPABILITY]");
                }
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private void testkey(CommandInput input) {
            String[] usage = new String[]{"testkey -  display the key events", "Usage: testkey", "  -? --help                       Displays command help"};
            try {
                int c;
                this.parseOptions(usage, input.args());
                this.terminal().writer().write("Input the key event(Enter to complete): ");
                this.terminal().writer().flush();
                StringBuilder sb = new StringBuilder();
                while ((c = ((LineReaderImpl)this.reader).readCharacter()) != 10 && c != 13) {
                    sb.append(new String(Character.toChars(c)));
                }
                this.terminal().writer().println(KeyMap.display((String)sb.toString()));
                this.terminal().writer().flush();
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private void clear(CommandInput input) {
            String[] usage = new String[]{"clear -  clear terminal", "Usage: clear", "  -? --help                       Displays command help"};
            try {
                this.parseOptions(usage, input.args());
                this.terminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
                this.terminal().flush();
            }
            catch (Exception e) {
                this.saveException(e);
            }
        }

        private void executeCmnd(List<String> args) throws Exception {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            ArrayList<String> _args = new ArrayList<String>();
            if (OSUtils.IS_WINDOWS) {
                _args.add("cmd.exe");
                _args.add("/c");
            } else {
                _args.add("sh");
                _args.add("-c");
            }
            _args.add(args.stream().collect(Collectors.joining(" ")));
            builder.command(_args);
            builder.directory(this.workDir.get().toFile());
            Process process = builder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
            new Thread(streamGobbler).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new Exception("Failed to execute: " + String.join((CharSequence)" ", args.subList(2, args.size())));
            }
        }

        private void shell(CommandInput input) {
            String[] usage = new String[]{"!<command> -  execute shell command", "Usage: !<command>", "  -? --help                       Displays command help"};
            if (input.args().length == 1 && (input.args()[0].equals("-?") || input.args()[0].equals("--help"))) {
                try {
                    this.parseOptions(usage, input.args());
                }
                catch (Exception e) {
                    this.saveException(e);
                }
            } else {
                ArrayList<String> argv = new ArrayList<String>();
                argv.addAll(Arrays.asList(input.args()));
                if (!argv.isEmpty()) {
                    try {
                        this.executeCmnd(argv);
                    }
                    catch (Exception e) {
                        this.saveException(e);
                    }
                }
            }
        }

        private Set<String> capabilities() {
            return InfoCmp.getCapabilitiesByName().keySet();
        }

        private List<Completer> tputCompleter(String command) {
            ArrayList<Completer> completers = new ArrayList<Completer>();
            completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new StringsCompleter(this::capabilities), arg_0 -> ((MyCommands)this).commandOptions(arg_0), 1)}));
            return completers;
        }
    }
}

