/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jline.builtins.Builtins;
import org.jline.builtins.CommandRegistry;
import org.jline.builtins.Completers;
import org.jline.builtins.ConsoleEngine;
import org.jline.builtins.ConsoleEngineImpl;
import org.jline.builtins.Options;
import org.jline.builtins.SystemRegistry;
import org.jline.builtins.SystemRegistryImpl;
import org.jline.builtins.Widgets;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.ConfigurationPath;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.ScriptEngine;
import org.jline.reader.UserInterruptException;
import org.jline.reader.Widget;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.script.GroovyEngine;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;
import org.jline.utils.OSUtils;

public class Repl {
    public static void main(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            parser.setEofOnUnclosedBracket(new DefaultParser.Bracket[]{DefaultParser.Bracket.CURLY, DefaultParser.Bracket.ROUND, DefaultParser.Bracket.SQUARE});
            parser.setEofOnUnclosedQuote(true);
            parser.setEscapeChars(null);
            Terminal terminal = TerminalBuilder.builder().build();
            File file = new File(Repl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            String root = file.getCanonicalPath().replace("classes", "").replaceAll("\\\\", "/");
            GroovyEngine scriptEngine = new GroovyEngine();
            scriptEngine.put("ROOT", (Object)root);
            ConfigurationPath configPath = new ConfigurationPath(Paths.get(root, new String[0]), Paths.get(root, new String[0]));
            ConsoleEngineImpl consoleEngine = new ConsoleEngineImpl((ScriptEngine)scriptEngine, () -> Paths.get("", new String[0]), configPath);
            Builtins builtins = new Builtins(Paths.get("", new String[0]), configPath, arg_0 -> Repl.lambda$main$1((ConsoleEngine)consoleEngine, arg_0));
            MyCommands myCommands = new MyCommands();
            SystemRegistryImpl systemRegistry = new SystemRegistryImpl((Parser)parser, terminal, configPath);
            systemRegistry.setCommandRegistries(new CommandRegistry[]{consoleEngine, builtins, myCommands});
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).variable("secondary-prompt-pattern", (Object)"%M%P > ").variable("indentation", (Object)2).variable("list-max", (Object)100).variable("history-file", (Object)Paths.get(root, "history")).option(LineReader.Option.INSERT_BRACKET, true).option(LineReader.Option.EMPTY_WORD_OPTIONS, false).option(LineReader.Option.USE_FORWARD_SLASH, true).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).build();
            if (OSUtils.IS_WINDOWS) {
                reader.setVariable("blink-matching-paren", (Object)0);
            }
            consoleEngine.setLineReader(reader);
            builtins.setLineReader(reader);
            myCommands.setLineReader(reader);
            Widgets.TailTipWidgets ttw = new Widgets.TailTipWidgets(reader, arg_0 -> ((SystemRegistry)systemRegistry).commandDescription(arg_0), 5, Widgets.TailTipWidgets.TipType.COMPLETER);
            ttw.setDescriptionCache(false);
            KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
            keyMap.bind((Object)new Reference("tailtip-toggle"), (CharSequence)KeyMap.alt((String)"s"));
            systemRegistry.initialize(Paths.get(root, "init.jline").toFile());
            consoleEngine.println((Object)(terminal.getName() + ": " + terminal.getType()));
            while (true) {
                try {
                    while (true) {
                        systemRegistry.cleanUp();
                        String line = reader.readLine("groovy-repl> ");
                        Object result = systemRegistry.execute(line);
                        consoleEngine.println(result);
                    }
                }
                catch (UserInterruptException line) {
                    continue;
                }
                catch (EndOfFileException e) {
                }
                catch (Exception e) {
                    systemRegistry.trace(e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static /* synthetic */ Widget lambda$main$1(ConsoleEngine consoleEngine, String fun) {
        return new ConsoleEngine.WidgetCreator(consoleEngine, fun);
    }

    private static class MyCommands
    implements CommandRegistry {
        private LineReader reader;
        private final Map<String, Builtins.CommandMethods> commandExecute = new HashMap<String, Builtins.CommandMethods>();
        private Map<String, String> aliasCommand = new HashMap<String, String>();
        private Exception exception;

        public MyCommands() {
            this.commandExecute.put("tput", new Builtins.CommandMethods(this::tput, this::tputCompleter));
            this.commandExecute.put("testkey", new Builtins.CommandMethods(this::testkey, this::defaultCompleter));
            this.commandExecute.put("clear", new Builtins.CommandMethods(this::clear, this::defaultCompleter));
        }

        public void setLineReader(LineReader reader) {
            this.reader = reader;
        }

        private Terminal terminal() {
            return this.reader.getTerminal();
        }

        public Set<String> commandNames() {
            return this.commandExecute.keySet();
        }

        public Map<String, String> commandAliases() {
            return this.aliasCommand;
        }

        public boolean hasCommand(String command) {
            return this.commandExecute.containsKey(command) || this.aliasCommand.containsKey(command);
        }

        private String command(String name) {
            if (this.commandExecute.containsKey(name)) {
                return name;
            }
            if (this.aliasCommand.containsKey(name)) {
                return this.aliasCommand.get(name);
            }
            return null;
        }

        public Completers.SystemCompleter compileCompleters() {
            Completers.SystemCompleter out = new Completers.SystemCompleter();
            for (String c : this.commandExecute.keySet()) {
                out.add(c, (List)this.commandExecute.get(c).compileCompleter().apply(c));
            }
            out.addAliases(this.aliasCommand);
            return out;
        }

        public Object execute(CommandRegistry.CommandSession session, String command, String[] args) throws Exception {
            this.exception = null;
            this.commandExecute.get(this.command(command)).execute().accept(new Builtins.CommandInput(args, session));
            if (this.exception != null) {
                throw this.exception;
            }
            return null;
        }

        private void tput(Builtins.CommandInput input) {
            String[] usage = new String[]{"tput -  put terminal capability", "Usage: tput [CAPABILITY]", "  -? --help                       Displays command help"};
            Options opt = Options.compile((String[])usage).parse((Object[])input.args());
            if (opt.isSet("help")) {
                this.exception = new Options.HelpException(opt.usage());
                return;
            }
            List argv = opt.args();
            try {
                if (argv.size() == 1) {
                    InfoCmp.Capability vcap = InfoCmp.Capability.byName((String)((String)argv.get(0)));
                    if (vcap != null) {
                        this.terminal().puts(vcap, new Object[0]);
                    } else {
                        this.terminal().writer().println("Unknown capability");
                    }
                } else {
                    this.terminal().writer().println("Usage: tput [CAPABILITY]");
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private void testkey(Builtins.CommandInput input) {
            String[] usage = new String[]{"testkey -  display the key events", "Usage: testkey", "  -? --help                       Displays command help"};
            Options opt = Options.compile((String[])usage).parse((Object[])input.args());
            if (opt.isSet("help")) {
                this.exception = new Options.HelpException(opt.usage());
                return;
            }
            try {
                int c;
                this.terminal().writer().write("Input the key event(Enter to complete): ");
                this.terminal().writer().flush();
                StringBuilder sb = new StringBuilder();
                while ((c = ((LineReaderImpl)this.reader).readCharacter()) != 10 && c != 13) {
                    sb.append(new String(Character.toChars(c)));
                }
                this.terminal().writer().println(KeyMap.display((String)sb.toString()));
                this.terminal().writer().flush();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private void clear(Builtins.CommandInput input) {
            String[] usage = new String[]{"clear -  clear terminal", "Usage: clear", "  -? --help                       Displays command help"};
            Options opt = Options.compile((String[])usage).parse((Object[])input.args());
            if (opt.isSet("help")) {
                this.exception = new Options.HelpException(opt.usage());
                return;
            }
            try {
                this.terminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
                this.terminal().flush();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private List<Completers.OptDesc> commandOptions(String command) {
            try {
                this.execute(new CommandRegistry.CommandSession(), command, new String[]{"--help"});
            }
            catch (Options.HelpException e) {
                return Builtins.compileCommandOptions((String)e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private List<Completer> defaultCompleter(String command) {
            ArrayList<Completer> completers = new ArrayList<Completer>();
            completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)}));
            return completers;
        }

        private Set<String> capabilities() {
            return InfoCmp.getCapabilitiesByName().keySet();
        }

        private List<Completer> tputCompleter(String command) {
            ArrayList<Completer> completers = new ArrayList<Completer>();
            completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new StringsCompleter(this::capabilities), this::commandOptions, 1)}));
            return completers;
        }
    }
}

